/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import com.digitprop.tonic.InternalFrameTitlePane;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalInternalFrameUI;

public class InternalFrameUI
extends MetalInternalFrameUI {
    private InternalFrameTitlePane titlePane;
    private static final PropertyChangeListener metalPropertyChangeListener = new MetalPropertyChangeHandler();
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    protected static String IS_PALETTE = "JInternalFrame.isPalette";
    private static String FRAME_TYPE = "JInternalFrame.frameType";
    private static String NORMAL_FRAME = "normal";
    private static String PALETTE_FRAME = "palette";
    private static String OPTION_DIALOG = "optionDialog";

    public InternalFrameUI(JInternalFrame b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent c) {
        return new InternalFrameUI((JInternalFrame)c);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        Object paletteProp = c.getClientProperty(IS_PALETTE);
        if (paletteProp != null) {
            this.setPalette((Boolean)paletteProp);
        }
        Container content = this.frame.getContentPane();
        this.stripContentBorder(content);
    }

    public void uninstallUI(JComponent c) {
        JComponent content;
        this.frame = (JInternalFrame)c;
        Container cont = ((JInternalFrame)c).getContentPane();
        if (cont instanceof JComponent && (content = (JComponent)cont).getBorder() == handyEmptyBorder) {
            content.setBorder(null);
        }
        super.uninstallUI(c);
    }

    protected void installListeners() {
        super.installListeners();
        this.frame.addPropertyChangeListener(metalPropertyChangeListener);
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(metalPropertyChangeListener);
        super.uninstallListeners();
    }

    protected void uninstallComponents() {
        this.titlePane = null;
        super.uninstallComponents();
    }

    private void stripContentBorder(Object c) {
        JComponent contentComp;
        Border contentBorder;
        if (c instanceof JComponent && ((contentBorder = (contentComp = (JComponent)c).getBorder()) == null || contentBorder instanceof UIResource)) {
            contentComp.setBorder(handyEmptyBorder);
        }
    }

    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new InternalFrameTitlePane(w);
        return this.titlePane;
    }

    private void setFrameType(String frameType) {
        if (frameType.equals(OPTION_DIALOG)) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.optionDialogBorder");
            this.titlePane.setPalette(false);
        } else if (frameType.equals(PALETTE_FRAME)) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.paletteBorder");
            this.titlePane.setPalette(true);
        } else {
            LookAndFeel.installBorder(this.frame, "InternalFrame.border");
            this.titlePane.setPalette(false);
        }
    }

    public void setPalette(boolean isPalette) {
        if (isPalette) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.paletteBorder");
        } else {
            LookAndFeel.installBorder(this.frame, "InternalFrame.border");
        }
        this.titlePane.setPalette(isPalette);
    }

    private static class MetalPropertyChangeHandler
    implements PropertyChangeListener {
        MetalPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            JInternalFrame jif = (JInternalFrame)e.getSource();
            if (!(jif.getUI() instanceof InternalFrameUI)) {
                return;
            }
            InternalFrameUI ui = (InternalFrameUI)jif.getUI();
            if (name.equals(FRAME_TYPE)) {
                if (e.getNewValue() instanceof String) {
                    ui.setFrameType((String)e.getNewValue());
                }
            } else if (name.equals(IS_PALETTE)) {
                if (e.getNewValue() != null) {
                    ui.setPalette((Boolean)e.getNewValue());
                } else {
                    ui.setPalette(false);
                }
            } else if (name.equals("contentPane")) {
                ui.stripContentBorder(e.getNewValue());
            }
        }
    }
}

