/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.library;

import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.ValuesDialog;
import it.businesslogic.ireport.gui.docking.GenericDragTargetListener;
import it.businesslogic.ireport.gui.event.ReportSubDatasetChangedEvent;
import it.businesslogic.ireport.gui.event.ReportSubDatasetChangedListener;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedEvent;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedListener;
import it.businesslogic.ireport.gui.library.AbstractLibraryObject;
import it.businesslogic.ireport.gui.library.LibraryTreeCellRenderer;
import it.businesslogic.ireport.gui.library.TreeTransfertHandler;
import it.businesslogic.ireport.gui.library.objects.DateObject;
import it.businesslogic.ireport.gui.library.objects.PageNumberObject;
import it.businesslogic.ireport.gui.library.objects.PageXYObject;
import it.businesslogic.ireport.gui.library.objects.PercentageObject;
import it.businesslogic.ireport.gui.library.objects.TotalObject;
import it.businesslogic.ireport.gui.library.objects.TotalPagesObject;
import it.businesslogic.ireport.gui.subdataset.SubDatasetDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LibraryPanel
extends JPanel
implements LanguageChangedListener,
SubDatasetObjectChangedListener,
ReportSubDatasetChangedListener {
    DefaultMutableTreeNode fieldsNode = null;
    DefaultMutableTreeNode variablesNode = null;
    DefaultMutableTreeNode parametersNode = null;
    DefaultMutableTreeNode systemObjectsNode = null;
    JReportFrame jrf;
    private JTree jLibraryTree;
    private JMenu jMenuAdd;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemCut;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemEdit;
    private JMenuItem jMenuItemNewField;
    private JMenuItem jMenuItemNewSubDataset;
    private JMenuItem jMenuItemNewVariable;
    private JMenuItem jMenuItemParameter;
    private JMenuItem jMenuItemPaste;
    private JMenuItem jMenuItemRefresh;
    private JPopupMenu jPopupMenuFields;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;

    public LibraryPanel() {
        this.initComponents();
        this.jLibraryTree.setCellRenderer(new LibraryTreeCellRenderer());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Libs");
        DefaultTreeModel dtm = new DefaultTreeModel(root);
        this.jLibraryTree.setModel(dtm);
        this.jLibraryTree.setDragEnabled(true);
        this.jLibraryTree.setRootVisible(false);
        this.jLibraryTree.setTransferHandler(new TreeTransfertHandler());
        this.jLibraryTree.setDropTarget(new DropTarget(this, new GenericDragTargetListener()));
        this.jLibraryTree.expandPath(new TreePath(root));
        this.fieldsNode = new DefaultMutableTreeNode("Fields", true);
        root.add(this.fieldsNode);
        this.variablesNode = new DefaultMutableTreeNode("Variables", true);
        root.add(this.variablesNode);
        this.parametersNode = new DefaultMutableTreeNode("Parameters", true);
        root.add(this.parametersNode);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("F5"), "refresh");
        this.getActionMap().put("refresh", new AbstractAction("refresh"){

            public void actionPerformed(ActionEvent evt) {
                LibraryPanel.this.setJReportFrame(LibraryPanel.this.jrf);
            }
        });
        I18n.addOnLanguageChangedListener(this);
        this.loadSystemObjects();
        this.loadCustomObjects();
        this.updateReportObjects();
        this.languageChanged(null);
    }

    private void initComponents() {
        this.jPopupMenuFields = new JPopupMenu();
        this.jMenuItemEdit = new JMenuItem();
        this.jMenuAdd = new JMenu();
        this.jMenuItemNewField = new JMenuItem();
        this.jMenuItemNewVariable = new JMenuItem();
        this.jMenuItemParameter = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.jMenuItemNewSubDataset = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItemCut = new JMenuItem();
        this.jMenuItemCopy = new JMenuItem();
        this.jMenuItemPaste = new JMenuItem();
        this.jMenuItemDelete = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.jMenuItemRefresh = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.jLibraryTree = new JTree();
        this.jPopupMenuFields.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                LibraryPanel.this.jPopupMenuFieldsPopupMenuWillBecomeVisible(evt);
            }
        });
        this.jMenuItemEdit.setIcon(new ImageIcon(""));
        this.jMenuItemEdit.setText(I18n.getString("edit", "Edit"));
        this.jMenuItemEdit.setEnabled(false);
        this.jMenuItemEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LibraryPanel.this.jMenuItemEditActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemEdit);
        this.jMenuAdd.setText(I18n.getString("add", "Add"));
        this.jMenuItemNewField.setIcon(new ImageIcon(""));
        this.jMenuItemNewField.setText("Field");
        this.jMenuItemNewField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LibraryPanel.this.jMenuItemNewFieldActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemNewField);
        this.jMenuItemNewVariable.setIcon(new ImageIcon(""));
        this.jMenuItemNewVariable.setText("Variable");
        this.jMenuItemNewVariable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LibraryPanel.this.jMenuItemNewVariableActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemNewVariable);
        this.jMenuItemParameter.setIcon(new ImageIcon(""));
        this.jMenuItemParameter.setText("Parameter");
        this.jMenuItemParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LibraryPanel.this.jMenuItemParameterActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemParameter);
        this.jMenuAdd.add(this.jSeparator3);
        this.jMenuItemNewSubDataset.setText("Sub dataset");
        this.jMenuItemNewSubDataset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LibraryPanel.this.jMenuItemNewSubDatasetActionPerformed(evt);
            }
        });
        this.jMenuAdd.add(this.jMenuItemNewSubDataset);
        this.jPopupMenuFields.add(this.jMenuAdd);
        this.jPopupMenuFields.add(this.jSeparator1);
        this.jMenuItemCut.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/cut.png")));
        this.jMenuItemCut.setText(I18n.getString("cut", "Cut"));
        this.jMenuItemCut.setEnabled(false);
        this.jMenuItemCut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LibraryPanel.this.jMenuItemCutActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemCut);
        this.jMenuItemCopy.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/copy.png")));
        this.jMenuItemCopy.setText(I18n.getString("copy", "Copy"));
        this.jMenuItemCopy.setEnabled(false);
        this.jMenuItemCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LibraryPanel.this.jMenuItemCopyActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemCopy);
        this.jMenuItemPaste.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/paste.png")));
        this.jMenuItemPaste.setText(I18n.getString("paste", "Paste"));
        this.jMenuItemPaste.setEnabled(false);
        this.jMenuItemPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LibraryPanel.this.jMenuItemPasteActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemPaste);
        this.jMenuItemDelete.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/delete.png")));
        this.jMenuItemDelete.setText(I18n.getString("delete", "Delete"));
        this.jMenuItemDelete.setEnabled(false);
        this.jMenuItemDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LibraryPanel.this.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemDelete);
        this.jPopupMenuFields.add(this.jSeparator2);
        this.jMenuItemRefresh.setText(I18n.getString("refresh", "Refresh"));
        this.jMenuItemRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LibraryPanel.this.jMenuItemRefreshActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemRefresh);
        this.setLayout(new BorderLayout());
        this.jScrollPane1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LibraryPanel.this.jScrollPane1MouseClicked(evt);
            }
        });
        this.jLibraryTree.setDragEnabled(true);
        this.jLibraryTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LibraryPanel.this.jLibraryTreeMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jLibraryTree);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void jMenuItemNewSubDatasetActionPerformed(ActionEvent evt) {
        SubDatasetDialog sdd = new SubDatasetDialog(Misc.frameFromComponent(this), true);
        sdd.setVisible(true);
    }

    private void jMenuItemPasteActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.jLibraryTree.getSelectionPaths();
        if (this.jrf == null) {
            return;
        }
        if (paths.length == 1 && paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode) {
            Object osd;
            SubDataset sd = this.jrf.getReport();
            if (paths[0].getPath().length >= 3 && (osd = ((DefaultMutableTreeNode)paths[0].getPath()[1]).getUserObject()) instanceof SubDataset) {
                sd = (SubDataset)osd;
            }
            ValuesDialog vd = MainFrame.getMainInstance().getValuesDialog();
            DefaultMutableTreeNode dmn = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
            if ((dmn.getUserObject().equals(I18n.getString("gui.library.fields", "Fields")) || dmn.getUserObject() instanceof JRField) && this.jrf.getMainFrame().getValuesDialog().getClipboardFields().size() > 0) {
                vd.getValuesPanel().duplicateFields(vd.getClipboardFields(), sd);
            }
            if ((dmn.getUserObject().equals(I18n.getString("gui.library.variables", "Variables")) || dmn.getUserObject() instanceof JRVariable) && this.jrf.getMainFrame().getValuesDialog().getClipboardVariables().size() > 0) {
                vd.getValuesPanel().duplicateVariables(vd.getClipboardVariables(), sd);
            }
            if ((dmn.getUserObject().equals(I18n.getString("gui.library.parameters", "Parameters")) || dmn.getUserObject() instanceof JRParameter) && this.jrf.getMainFrame().getValuesDialog().getClipboardParameters().size() > 0) {
                vd.getValuesPanel().duplicateParameters(vd.getClipboardParameters(), sd);
            }
        }
    }

    private void jMenuItemCopyActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.jLibraryTree.getSelectionPaths();
        boolean clearedVariablesClipboard = false;
        boolean clearedParametersClipboard = false;
        boolean clearedFieldsClipboard = false;
        for (int i = 0; i < paths.length && this.jrf != null; ++i) {
            ValuesDialog vd = MainFrame.getMainInstance().getValuesDialog();
            Report report = this.jrf.getReport();
            if (!(paths[i].getLastPathComponent() instanceof DefaultMutableTreeNode)) continue;
            Object obj = ((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject();
            if (obj instanceof JRVariable) {
                if (!clearedVariablesClipboard) {
                    clearedVariablesClipboard = true;
                    vd.getClipboardVariables().removeAllElements();
                }
                vd.getClipboardVariables().add(((JRVariable)obj).cloneMe());
            }
            if (obj instanceof JRField) {
                if (!clearedFieldsClipboard) {
                    clearedFieldsClipboard = true;
                    vd.getClipboardFields().removeAllElements();
                }
                vd.getClipboardFields().add(((JRField)obj).cloneMe());
            }
            if (!(obj instanceof JRParameter)) continue;
            if (!clearedParametersClipboard) {
                clearedParametersClipboard = true;
                vd.getClipboardParameters().removeAllElements();
            }
            vd.getClipboardParameters().add(((JRParameter)obj).cloneMe());
        }
    }

    private void jMenuItemCutActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.jLibraryTree.getSelectionPaths();
        boolean clearedVariablesClipboard = false;
        boolean clearedParametersClipboard = false;
        boolean clearedFieldsClipboard = false;
        for (int i = 0; i < paths.length && this.jrf != null; ++i) {
            Object osd;
            ValuesDialog vd = MainFrame.getMainInstance().getValuesDialog();
            Report report = this.jrf.getReport();
            SubDataset sd = report;
            if (paths[i].getPath().length == 4 && (osd = ((DefaultMutableTreeNode)paths[i].getPath()[1]).getUserObject()) instanceof SubDataset) {
                sd = (SubDataset)osd;
            }
            if (!(paths[i].getLastPathComponent() instanceof DefaultMutableTreeNode)) continue;
            Object obj = ((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject();
            if (obj instanceof JRVariable) {
                if (!clearedVariablesClipboard) {
                    clearedVariablesClipboard = true;
                    vd.getClipboardVariables().removeAllElements();
                }
                vd.getClipboardVariables().add(((JRVariable)obj).cloneMe());
                sd.removeVariable((JRVariable)obj);
            }
            if (obj instanceof JRField) {
                if (!clearedFieldsClipboard) {
                    clearedFieldsClipboard = true;
                    vd.getClipboardFields().removeAllElements();
                }
                vd.getClipboardFields().add(((JRField)obj).cloneMe());
                sd.removeField((JRField)obj);
            }
            if (!(obj instanceof JRParameter)) continue;
            if (!clearedParametersClipboard) {
                clearedParametersClipboard = true;
                vd.getClipboardParameters().removeAllElements();
            }
            vd.getClipboardParameters().add(((JRParameter)obj).cloneMe());
            sd.removeParameter((JRParameter)obj);
        }
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.jLibraryTree.getSelectionPaths();
        for (int i = 0; i < paths.length && this.jrf != null; ++i) {
            Report report = this.jrf.getReport();
            SubDataset sd = report;
            try {
                Object osd;
                if (paths[i].getPath().length == 4 && (osd = ((DefaultMutableTreeNode)paths[i].getPath()[1]).getUserObject()) instanceof SubDataset) {
                    sd = (SubDataset)osd;
                }
                if (!(paths[i].getLastPathComponent() instanceof DefaultMutableTreeNode)) continue;
                Object obj = ((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject();
                if (obj instanceof JRVariable) {
                    sd.removeVariable((JRVariable)obj);
                }
                if (obj instanceof JRField) {
                    sd.removeField((JRField)obj);
                }
                if (obj instanceof JRParameter) {
                    sd.removeParameter((JRParameter)obj);
                }
                if (!(obj instanceof SubDataset) || JOptionPane.showConfirmDialog(this.jLibraryTree, I18n.getFormattedString("messages.libraryPanel.removingSubdataset", "Do you really want remove subDataset {0} ?", new Object[]{obj})) != 0) continue;
                this.jrf.getReport().removeSubDataset((SubDataset)obj);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jMenuItemParameterActionPerformed(ActionEvent evt) {
        MainFrame.getMainInstance().getValuesDialog().getValuesPanel().newParameter(this.getSelectedSubDataset());
    }

    private void jMenuItemNewFieldActionPerformed(ActionEvent evt) {
        MainFrame.getMainInstance().getValuesDialog().getValuesPanel().newField(this.getSelectedSubDataset());
    }

    private SubDataset getSelectedSubDataset() {
        Object osd;
        if (this.jrf == null) {
            return null;
        }
        SubDataset sd = this.jrf.getReport();
        TreePath[] paths = this.jLibraryTree.getSelectionPaths();
        if (paths.length == 1 && paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode && paths[0].getPath().length >= 2 && (osd = ((DefaultMutableTreeNode)paths[0].getPath()[1]).getUserObject()) instanceof SubDataset) {
            sd = (SubDataset)osd;
        }
        return sd;
    }

    private void jMenuItemNewVariableActionPerformed(ActionEvent evt) {
        MainFrame.getMainInstance().getValuesDialog().getValuesPanel().newVariable(this.getSelectedSubDataset());
    }

    private void jScrollPane1MouseClicked(MouseEvent evt) {
        this.jLibraryTreeMouseClicked(evt);
    }

    private void jMenuItemRefreshActionPerformed(ActionEvent evt) {
        this.updateReportObjects();
    }

    private void jMenuItemEditActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.jLibraryTree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return;
        }
        if (paths.length == 1 && paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode) {
            Object obj = ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject();
            if (obj instanceof JRVariable) {
                MainFrame.getMainInstance().getValuesDialog().getValuesPanel().modifyVariable((JRVariable)obj);
            }
            if (obj instanceof JRField) {
                MainFrame.getMainInstance().getValuesDialog().getValuesPanel().modifyField((JRField)obj);
            }
            if (obj instanceof JRParameter) {
                MainFrame.getMainInstance().getValuesDialog().getValuesPanel().modifyParameter((JRParameter)obj);
            }
            if (obj instanceof SubDataset) {
                Frame parent = Misc.frameFromComponent(this);
                SubDatasetDialog cd = new SubDatasetDialog(parent, true);
                cd.setSubDataset((SubDataset)obj);
                cd.setVisible(true);
            }
        }
    }

    private void jPopupMenuFieldsPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        if (this.jrf == null) {
            this.jMenuItemCut.setEnabled(false);
            this.jMenuItemCopy.setEnabled(false);
            this.jMenuItemDelete.setEnabled(false);
            this.jMenuItemPaste.setEnabled(false);
            this.jMenuItemEdit.setEnabled(false);
            this.jMenuItemRefresh.setEnabled(false);
            this.jMenuAdd.setEnabled(false);
            return;
        }
        this.jMenuAdd.setEnabled(true);
        this.jMenuItemRefresh.setEnabled(true);
        TreePath[] paths = this.jLibraryTree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            this.jMenuItemCut.setEnabled(false);
            this.jMenuItemCopy.setEnabled(false);
            this.jMenuItemDelete.setEnabled(false);
            this.jMenuItemPaste.setEnabled(false);
            this.jMenuItemEdit.setEnabled(false);
            return;
        }
        if (paths.length == 1 && paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode && (((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject() instanceof JRField || ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject() instanceof JRVariable || ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject() instanceof JRParameter || ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject() instanceof SubDataset)) {
            this.jMenuItemEdit.setEnabled(true);
        } else {
            this.jMenuItemEdit.setEnabled(false);
        }
        if (paths.length > 0) {
            this.jMenuItemCut.setEnabled(true);
            this.jMenuItemCopy.setEnabled(true);
            this.jMenuItemDelete.setEnabled(true);
        } else {
            this.jMenuItemCut.setEnabled(false);
            this.jMenuItemCopy.setEnabled(false);
            this.jMenuItemDelete.setEnabled(false);
        }
        this.jMenuItemPaste.setEnabled(false);
        if (paths.length == 1 && paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode dmn = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
            if ((dmn.getUserObject().equals(I18n.getString("gui.library.fields", "Fields")) || dmn.getUserObject() instanceof JRField) && this.jrf.getMainFrame().getValuesDialog().getClipboardFields().size() > 0) {
                this.jMenuItemPaste.setEnabled(true);
            }
            if ((dmn.getUserObject().equals(I18n.getString("gui.library.variables", "Variables")) || dmn.getUserObject() instanceof JRVariable) && this.jrf.getMainFrame().getValuesDialog().getClipboardVariables().size() > 0) {
                this.jMenuItemPaste.setEnabled(true);
            }
            if ((dmn.getUserObject().equals(I18n.getString("gui.library.parameters", "Parameters")) || dmn.getUserObject() instanceof JRParameter) && this.jrf.getMainFrame().getValuesDialog().getClipboardParameters().size() > 0) {
                this.jMenuItemPaste.setEnabled(true);
            }
        }
    }

    private void jLibraryTreeMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 1) {
            if (evt.getButton() == 3) {
                Misc.ensurePathIsSelected(this.jLibraryTree.getPathForLocation(evt.getX(), evt.getY()), this.jLibraryTree);
                this.jPopupMenuFields.show(this.jLibraryTree, evt.getPoint().x, evt.getPoint().y);
            }
        }
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                Object obj;
                TreePath[] paths = this.jLibraryTree.getSelectionPaths();
                if (paths == null || paths.length == 0) {
                    return;
                }
                if (paths.length == 1 && paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode && (obj = ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject()) instanceof SubDataset) {
                    return;
                }
                this.jMenuItemEditActionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.fieldsNode.setUserObject(I18n.getString("gui.library.fields", "Fields"));
        this.variablesNode.setUserObject(I18n.getString("gui.library.variables", "Variables"));
        this.parametersNode.setUserObject(I18n.getString("gui.library.parameters", "Parameters"));
        this.jLibraryTree.updateUI();
    }

    public void setJReportFrame(JReportFrame jrf) {
        this.jrf = jrf;
        this.updateReportObjects();
        this.updateSubDatasets();
    }

    private void loadCustomObjects() {
    }

    private void loadSystemObjects() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.jLibraryTree.getModel().getRoot();
        root.add(new DefaultMutableTreeNode(new PageNumberObject()));
        root.add(new DefaultMutableTreeNode(new TotalPagesObject()));
        root.add(new DefaultMutableTreeNode(new PageXYObject()));
        root.add(new DefaultMutableTreeNode(new TotalObject()));
        root.add(new DefaultMutableTreeNode(new DateObject()));
        root.add(new DefaultMutableTreeNode(new PercentageObject()));
    }

    private void addLibraryObject(String folder, AbstractLibraryObject obj) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.jLibraryTree.getModel().getRoot();
        if (folder == null || folder.length() == 0) {
            root.add(new DefaultMutableTreeNode(new PageNumberObject()));
        } else {
            Enumeration<TreeNode> enum_childrens = root.children();
            while (enum_childrens.hasMoreElements()) {
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)enum_childrens.nextElement();
                if (!("" + dmtn.getUserObject()).equalsIgnoreCase(folder)) continue;
                dmtn.add(new DefaultMutableTreeNode(obj));
            }
        }
    }

    public void updateReportObjects() {
        this.fieldsNode.removeAllChildren();
        this.parametersNode.removeAllChildren();
        this.variablesNode.removeAllChildren();
        if (this.jrf == null) {
            this.jLibraryTree.updateUI();
            return;
        }
        Enumeration e = this.jrf.getReport().getFields().elements();
        while (e.hasMoreElements()) {
            this.fieldsNode.add(new DefaultMutableTreeNode(e.nextElement()));
        }
        e = this.jrf.getReport().getParameters().elements();
        while (e.hasMoreElements()) {
            this.parametersNode.add(new DefaultMutableTreeNode(e.nextElement()));
        }
        e = this.jrf.getReport().getVariables().elements();
        while (e.hasMoreElements()) {
            this.variablesNode.add(new DefaultMutableTreeNode(e.nextElement()));
        }
        this.jLibraryTree.updateUI();
    }

    public void subDatasetObjectChanged(SubDatasetObjectChangedEvent evt) {
        if (evt != null && evt.getSource() instanceof Report) {
            this.updateReportObjects();
        } else {
            this.updateSubDatasetNode(evt.getSource());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void reportSubDatasetChanged(ReportSubDatasetChangedEvent evt) {
        DefaultMutableTreeNode root;
        block11: {
            block10: {
                root = (DefaultMutableTreeNode)this.jLibraryTree.getModel().getRoot();
                if (evt.getAction() == 2) {
                    if (evt.getObjectType() == 1) {
                        int lastDatasourceIndex = 3;
                        for (lastDatasourceIndex = 3; root.getChildCount() > lastDatasourceIndex && ((DefaultMutableTreeNode)root.getChildAt(lastDatasourceIndex)).getUserObject() instanceof SubDataset; ++lastDatasourceIndex) {
                        }
                        int i = 0;
                        while (i < evt.getElements().size()) {
                            DefaultMutableTreeNode subDatasetNode = new DefaultMutableTreeNode(evt.getElements().elementAt(i));
                            root.insert(subDatasetNode, lastDatasourceIndex);
                            this.updateSubDatasetNode(subDatasetNode);
                            ++lastDatasourceIndex;
                            ++i;
                        }
                        return;
                    }
                }
                if (evt.getAction() != 1) break block10;
                if (evt.getObjectType() == 1) break block11;
            }
            if (evt.getAction() != 8) return;
            if (evt.getObjectType() != 1) return;
            this.jLibraryTree.updateUI();
            return;
        }
        Object subDatasetNode = null;
        int i = 0;
        while (true) {
            if (i >= evt.getElements().size()) {
                this.jLibraryTree.updateUI();
                return;
            }
            for (int k = 0; k < root.getChildCount(); ++k) {
                if (((DefaultMutableTreeNode)root.getChildAt(k)).getUserObject() != evt.getElements().elementAt(i)) continue;
                root.remove(k);
                break;
            }
            ++i;
        }
    }

    public void updateSubDatasetNode(SubDataset subDataset) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.jLibraryTree.getModel().getRoot();
        for (int k = 0; k < root.getChildCount(); ++k) {
            if (((DefaultMutableTreeNode)root.getChildAt(k)).getUserObject() != subDataset) continue;
            this.updateSubDatasetNode((DefaultMutableTreeNode)root.getChildAt(k));
            return;
        }
    }

    public void updateSubDatasetNode(DefaultMutableTreeNode subDatasetNode) {
        DefaultMutableTreeNode dsFieldsNode = null;
        DefaultMutableTreeNode dsVariablesNode = null;
        DefaultMutableTreeNode dsParametersNode = null;
        SubDataset subDataset = (SubDataset)subDatasetNode.getUserObject();
        if (subDatasetNode.getChildCount() == 0) {
            dsFieldsNode = new DefaultMutableTreeNode(I18n.getString("gui.library.fields", "Fields"), true);
            subDatasetNode.add(dsFieldsNode);
            dsVariablesNode = new DefaultMutableTreeNode(I18n.getString("gui.library.variables", "Variables"), true);
            subDatasetNode.add(dsVariablesNode);
            dsParametersNode = new DefaultMutableTreeNode(I18n.getString("gui.library.parameters", "Parameters"), true);
            subDatasetNode.add(dsParametersNode);
        } else {
            dsFieldsNode = (DefaultMutableTreeNode)subDatasetNode.getChildAt(0);
            dsVariablesNode = (DefaultMutableTreeNode)subDatasetNode.getChildAt(1);
            dsParametersNode = (DefaultMutableTreeNode)subDatasetNode.getChildAt(2);
        }
        dsFieldsNode.removeAllChildren();
        dsVariablesNode.removeAllChildren();
        dsParametersNode.removeAllChildren();
        Enumeration e = subDataset.getFields().elements();
        while (e.hasMoreElements()) {
            dsFieldsNode.add(new DefaultMutableTreeNode(e.nextElement()));
        }
        e = subDataset.getParameters().elements();
        while (e.hasMoreElements()) {
            dsParametersNode.add(new DefaultMutableTreeNode(e.nextElement()));
        }
        e = subDataset.getVariables().elements();
        while (e.hasMoreElements()) {
            dsVariablesNode.add(new DefaultMutableTreeNode(e.nextElement()));
        }
        this.jLibraryTree.updateUI();
    }

    public void updateSubDatasets() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.jLibraryTree.getModel().getRoot();
        for (int k = 0; k < root.getChildCount(); ++k) {
            if (!(((DefaultMutableTreeNode)root.getChildAt(k)).getUserObject() instanceof SubDataset)) continue;
            root.remove(k);
            --k;
        }
        if (this.jrf != null) {
            int lastDatasourceIndex = 3;
            for (int i = 0; i < this.jrf.getReport().getSubDatasets().size(); ++i) {
                DefaultMutableTreeNode subDatasetNode = new DefaultMutableTreeNode(this.jrf.getReport().getSubDatasets().elementAt(i));
                root.insert(subDatasetNode, lastDatasourceIndex);
                this.updateSubDatasetNode(subDatasetNode);
                ++lastDatasourceIndex;
            }
        }
        this.jLibraryTree.updateUI();
    }

    public void applyI18n() {
        this.jMenuItemNewField.setText(I18n.getString("libraryPanel.menuItemNewField", "Field"));
        this.jMenuItemNewSubDataset.setText(I18n.getString("libraryPanel.menuItemNewSubDataset", "Sub dataset"));
        this.jMenuItemNewVariable.setText(I18n.getString("libraryPanel.menuItemNewVariable", "Variable"));
        this.jMenuItemParameter.setText(I18n.getString("libraryPanel.menuItemParameter", "Parameter"));
    }
}

