/*
 * Decompiled with CFR 0.152.
 */
package rex.metadata;

import java.util.HashMap;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import rex.metadata.CubeSlicer;
import rex.metadata.ExecuteResultParseException;
import rex.metadata.Query;
import rex.metadata.resultelements.Axis;
import rex.metadata.resultelements.Cell;
import rex.metadata.resultelements.Tuple;
import rex.utils.DOM;
import rex.utils.S;

public class ExecuteResult {
    Document resultDOM;
    private HashMap axes;
    private Cell[] cells;
    Query query;
    Cell defaultCell;

    public ExecuteResult(Document d, Query _query) throws ExecuteResultParseException {
        this.query = _query;
        this.resultDOM = d;
        this.parseResult();
    }

    public void parseResult() throws ExecuteResultParseException {
        int i;
        NodeList faultList = this.resultDOM.getElementsByTagName("SOAP-ENV:Fault");
        if (faultList != null && faultList.getLength() > 0) {
            StringBuffer sBuffer = new StringBuffer("");
            NodeList faultStringList = this.resultDOM.getElementsByTagName("faultstring");
            if (faultStringList != null && faultStringList.getLength() > 0) {
                sBuffer.append("\n  faultstring = " + DOM.getTextFromDOMElement(faultStringList.item(0)));
            }
            if ((faultStringList = this.resultDOM.getElementsByTagName("desc")) != null && faultStringList.getLength() > 0) {
                sBuffer.append("\n  desc = " + DOM.getTextFromDOMElement(faultStringList.item(0)));
            }
            throw new ExecuteResultParseException(sBuffer.toString());
        }
        NodeList errList = this.resultDOM.getElementsByTagName("Error");
        if (errList != null && errList.getLength() > 0) {
            StringBuffer sb = new StringBuffer("");
            for (int i2 = 0; i2 < errList.getLength(); ++i2) {
                NamedNodeMap attrs = errList.item(i2).getAttributes();
                for (int j = 0; j < attrs.getLength(); ++j) {
                    sb.append("\n  " + attrs.item(j).getNodeName() + " = " + attrs.item(j).getNodeValue());
                }
            }
            throw new ExecuteResultParseException(sb.toString());
        }
        NodeList axList = this.resultDOM.getElementsByTagName("AxisInfo");
        if (axList != null) {
            this.axes = new HashMap(axList.getLength() + 1, 1.0f);
            for (i = 0; i < axList.getLength(); ++i) {
                Axis a = new Axis(axList.item(i));
                this.axes.put(a.getName(), a);
            }
        }
        axList = this.resultDOM.getElementsByTagName("Axes");
        axList = this.resultDOM.getElementsByTagName("Axes").item(0).getChildNodes();
        if (axList != null) {
            for (i = 0; i < axList.getLength(); ++i) {
                if (axList.item(i).getNodeType() != 1) continue;
                ((Axis)this.axes.get(axList.item(i).getAttributes().getNamedItem("name").getNodeValue())).loadMemberTuples(DOM.getFirstChildNodeWithName(axList.item(i), "Tuples"));
            }
        }
        NodeList cellInfo = this.resultDOM.getElementsByTagName("CellInfo");
        this.defaultCell = new Cell(cellInfo.item(0));
        cellInfo = cellInfo.item(0).getChildNodes();
        NodeList cl = this.resultDOM.getElementsByTagName("CellData");
        if ((cl = cl.item(0).getChildNodes()) != null) {
            this.cells = new Cell[this.axisMemberCountProduct()];
            int j = 0;
            for (i = 0; i < cl.getLength(); ++i) {
                Cell c;
                if (cl.item(i).getNodeType() != 1) continue;
                this.cells[c.getCellOrdinal()] = c = new Cell(cl.item(i), this.defaultCell.getDefaultCellValue());
                ++j;
            }
        }
    }

    private int axisMemberCountProduct() {
        int retVal = 1;
        for (Axis a : this.axes.values()) {
            if (a.getName().equalsIgnoreCase("SlicerAxis")) continue;
            retVal *= a.getTupleCount();
        }
        return retVal;
    }

    public int getTupleCount(int axisNo) {
        return ((Axis)this.axes.get("Axis" + axisNo)).getTupleCount();
    }

    private void debugPrintAxes() {
        for (Axis a : this.axes.values()) {
            S.out("" + a);
        }
    }

    public void debugPrintAxesTable() {
        for (Axis a : this.axes.values()) {
            a.dumpTable();
        }
    }

    public int getAxisCount() {
        if (this.axes != null) {
            return this.axes.size() - 1;
        }
        return 0;
    }

    public Axis getAxis(String axName) {
        if (this.axes != null) {
            return (Axis)this.axes.get(axName);
        }
        return null;
    }

    public Cell getRowCol(int row, int col, CubeSlicer cs) {
        int ordinal = 0;
        int E = 1;
        for (int i = 0; i < this.getAxisCount(); ++i) {
            ordinal = i == cs.getRowAxisOrdinal() ? (ordinal += row * E) : (i == cs.getColAxisOrdinal() ? (ordinal += col * E) : (ordinal += this.getTupleOrdinal(i, cs.getTupleForAxisNo(i)) * E));
            E *= ((Axis)this.axes.get("Axis" + i)).getTupleCount();
        }
        if (ordinal >= this.cells.length) {
            S.out("assert: getXY  row = " + row + " col = " + col + " ordinal = " + ordinal + " cells.length = " + this.cells.length);
            return null;
        }
        if (this.cells[ordinal] != null) {
            return this.cells[ordinal];
        }
        return this.defaultCell;
    }

    public Double getSumForColumn(int col, CubeSlicer cubeSlicer) {
        double retVal = 0.0;
        boolean couldntParse = false;
        for (int i = 0; i < this.getTupleCount(cubeSlicer.getRowAxisOrdinal()); ++i) {
            try {
                if (this.getRowCol(i, col, cubeSlicer).getCellValue() == null || this.getRowCol(i, col, cubeSlicer).getCellValue().equals("")) continue;
                retVal += Double.parseDouble(this.getRowCol(i, col, cubeSlicer).getCellValue());
                continue;
            }
            catch (Exception e) {
                couldntParse = true;
                S.out("assert: Couldn't parse as double at position (" + i + ", " + col + ") :" + this.getRowCol(i, col, cubeSlicer).getCellValue() + " THAT IS:" + this.getRowCol(i, col, cubeSlicer));
                break;
            }
        }
        if (couldntParse) {
            return null;
        }
        return new Double(retVal);
    }

    public Double getAverageForColumn(int col, CubeSlicer cubeSlicer) {
        Double sum;
        if (this.getTupleCount(cubeSlicer.getRowAxisOrdinal()) > 0 && (sum = this.getSumForColumn(col, cubeSlicer)) != null) {
            return new Double(sum / (double)this.getTupleCount(cubeSlicer.getRowAxisOrdinal()));
        }
        return null;
    }

    public Double getSumForRow(int row, CubeSlicer cubeSlicer) {
        double retVal = 0.0;
        boolean couldntParse = false;
        for (int j = 0; j < this.getTupleCount(cubeSlicer.getColAxisOrdinal()); ++j) {
            try {
                if (this.getRowCol(row, j, cubeSlicer).getCellValue() == null || this.getRowCol(row, j, cubeSlicer).getCellValue().equals("")) continue;
                retVal += Double.parseDouble(this.getRowCol(row, j, cubeSlicer).getCellValue());
                continue;
            }
            catch (Exception e) {
                couldntParse = true;
                S.out("assert: Couldn't parse as double at position (" + row + ", " + j + ") :" + this.getRowCol(row, j, cubeSlicer).getCellValue() + " THAT IS:" + this.getRowCol(row, j, cubeSlicer));
                break;
            }
        }
        if (couldntParse) {
            return null;
        }
        return new Double(retVal);
    }

    public Double getAverageForRow(int row, CubeSlicer cubeSlicer) {
        Double sum;
        if (this.getTupleCount(cubeSlicer.getColAxisOrdinal()) > 0 && (sum = this.getSumForRow(row, cubeSlicer)) != null) {
            return new Double(sum / (double)this.getTupleCount(cubeSlicer.getColAxisOrdinal()));
        }
        return null;
    }

    public Double getTotalSum(CubeSlicer cubeSlicer) {
        double retVal = 0.0;
        for (int j = 0; j < this.getTupleCount(cubeSlicer.getColAxisOrdinal()); ++j) {
            try {
                retVal += this.getSumForColumn(j, cubeSlicer).doubleValue();
                continue;
            }
            catch (Exception e) {
                S.out("couldn't parse total sum");
                return null;
            }
        }
        return new Double(retVal);
    }

    public Double getTotalAverage(CubeSlicer cubeSlicer) {
        double retVal = 0.0;
        if (this.getTupleCount(cubeSlicer.getColAxisOrdinal()) * this.getTupleCount(cubeSlicer.getRowAxisOrdinal()) > 0) {
            try {
                retVal = this.getTotalSum(cubeSlicer) / (double)(this.getTupleCount(cubeSlicer.getColAxisOrdinal()) * this.getTupleCount(cubeSlicer.getRowAxisOrdinal()));
            }
            catch (Exception e) {
                S.out("couldn't parse total avg");
                return null;
            }
            return new Double(retVal);
        }
        return null;
    }

    private int getTupleOrdinal(int axisNo, Tuple tuple) {
        Axis a = (Axis)this.axes.get("Axis" + axisNo);
        if (a != null) {
            return a.getTupleOrdinal(tuple);
        }
        S.out("assert: ExecuteResult.getTupleOrdinal cannot get the Axis" + axisNo + ". Returning 0.");
        return 0;
    }

    public JPanel getHorizontalTreePanel(String axName, int itemWidth, int itemHeight, boolean showRowTotalsOn) {
        return ((Axis)this.axes.get(axName)).getHorizontalTreePanel(this.query, itemWidth, itemHeight, showRowTotalsOn);
    }

    public JPanel getVerticalTreePanel(String axName, int itemWidth, int itemHeight, boolean showColumnTotalsOn) {
        return ((Axis)this.axes.get(axName)).getVerticalTreePanel(this.query, itemWidth, itemHeight, showColumnTotalsOn);
    }

    public boolean isValid() {
        return (this.getAxis("Axis0") != null ? this.getAxis("Axis0").getTupleCount() : 0) * (this.getAxis("Axis1") != null ? this.getAxis("Axis1").getTupleCount() : 0) != 0;
    }
}

