/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.subdataset;

import it.businesslogic.ireport.Group;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.JRParameterDialog;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.util.I18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class GroupDialog
extends JDialog {
    private String groupName;
    private String expression;
    private int minHeightStartNewPage = 0;
    private int headerBandHeight = 0;
    private int footerBandHeight = 0;
    private boolean startNewPage = false;
    private boolean startNewColumn = false;
    private boolean printHeaderEachPage = false;
    private boolean resetPageNumber = false;
    private SubDataset subDataset = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JRTextExpressionArea jRTextExpressionArea;
    private JTextField jTextFieldName;
    private int dialogResult;

    public GroupDialog(Dialog dialog, boolean modal) {
        super(dialog, modal);
        this.initComponents();
        this.applyI18n();
        this.jRTextExpressionArea.setText("");
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                GroupDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel3 = new JLabel();
        this.jRTextExpressionArea = new JRTextExpressionArea();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify group");
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GroupDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Group name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabel3.setText("Group expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.jRTextExpressionArea.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionArea.setPreferredSize(new Dimension(300, 70));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jRTextExpressionArea, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setText("OK");
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroupDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroupDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.jRGroupDialog.notValidGroupName", "Please insert a valid group name!"), I18n.getString("messages.jRGroupDialog.notValidGroupNameCaption", "Invalid name!"), 2);
            return;
        }
        this.setGroupName(this.jTextFieldName.getText());
        this.setExpression(this.jRTextExpressionArea.getText());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public static void main(String[] args) {
        new JRParameterDialog((Frame)new JFrame(), true).setVisible(true);
    }

    public void setGroup(Group group) {
        this.jTextFieldName.setText(new String(group.getName()));
        if (group.getGroupExpression() != null) {
            this.jRTextExpressionArea.setText(new String(group.getGroupExpression()).trim());
        } else {
            this.jRTextExpressionArea.setText("");
        }
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public int getFooterBandHeight() {
        return this.footerBandHeight;
    }

    public void setFooterBandHeight(int footerBandHeight) {
        this.footerBandHeight = footerBandHeight;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public int getHeaderBandHeight() {
        return this.headerBandHeight;
    }

    public void setHeaderBandHeight(int headerBandHeight) {
        this.headerBandHeight = headerBandHeight;
    }

    public int getMinHeightStartNewPage() {
        return this.minHeightStartNewPage;
    }

    public void setMinHeightStartNewPage(int minHeightStartNewPage) {
        this.minHeightStartNewPage = minHeightStartNewPage;
    }

    public boolean isPrintHeaderEachPage() {
        return this.printHeaderEachPage;
    }

    public void setPrintHeaderEachPage(boolean printHeaderEachPage) {
        this.printHeaderEachPage = printHeaderEachPage;
    }

    public boolean isResetPageNumber() {
        return this.resetPageNumber;
    }

    public void setResetPageNumber(boolean resetPageNumber) {
        this.resetPageNumber = resetPageNumber;
    }

    public boolean isStartNewColumn() {
        return this.startNewColumn;
    }

    public void setStartNewColumn(boolean startNewColumn) {
        this.startNewColumn = startNewColumn;
    }

    public boolean isStartNewPage() {
        return this.startNewPage;
    }

    public void setStartNewPage(boolean startNewPage) {
        this.startNewPage = startNewPage;
    }

    public SubDataset getSubDataset() {
        return this.subDataset;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
        this.jRTextExpressionArea.setSubDataset(subDataset);
    }

    public void applyI18n() {
        this.jButtonCancel.setText(I18n.getString("groupDialog.buttonCancel", "Cancel"));
        this.jButtonOK.setText(I18n.getString("groupDialog.buttonOK", "OK"));
        this.jLabel1.setText(I18n.getString("groupDialog.label1", "Group name"));
        this.jLabel3.setText(I18n.getString("groupDialog.label3", "Group expression"));
        this.setTitle(I18n.getString("groupDialog.title", "Add/modify group"));
        this.jButtonCancel.setMnemonic(I18n.getString("groupDialog.buttonCancelMnemonic", "c").charAt(0));
        this.jButtonOK.setMnemonic(I18n.getString("groupDialog.buttonOKMnemonic", "o").charAt(0));
    }
}

