/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.ContextLoader;

public class ContextLoaderServlet
extends HttpServlet {
    private ContextLoader contextLoader;

    public void init() throws ServletException {
        this.contextLoader = this.createContextLoader();
        this.contextLoader.initWebApplicationContext(this.getServletContext());
    }

    protected ContextLoader createContextLoader() {
        return new ContextLoader();
    }

    public ContextLoader getContextLoader() {
        return this.contextLoader;
    }

    public void destroy() {
        if (this.contextLoader != null) {
            this.contextLoader.closeWebApplicationContext(this.getServletContext());
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.getServletContext().log("Attempt to call service method on ContextLoaderServlet as [" + request.getRequestURI() + "] was ignored");
        response.sendError(400);
    }

    public String getServletInfo() {
        return "ContextLoaderServlet for Servlet API 2.2/2.3 (deprecated in favor of ContextLoaderListener for Servlet API 2.4)";
    }
}

