/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui;

import com.l2fprod.common.swing.JButtonBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import net.charabia.jsmoothgen.application.ExeCompiler;
import net.charabia.jsmoothgen.application.JSmoothModelBean;
import net.charabia.jsmoothgen.application.JSmoothModelPersistency;
import net.charabia.jsmoothgen.application.gui.Editor;
import net.charabia.jsmoothgen.application.gui.EditorPool;
import net.charabia.jsmoothgen.application.gui.Main;
import net.charabia.jsmoothgen.application.gui.util.CommandRunner;
import net.charabia.jsmoothgen.application.gui.util.OptionalHelpPanel;
import net.charabia.jsmoothgen.application.gui.util.PanelLayout;
import net.charabia.jsmoothgen.skeleton.SkeletonBean;

public class MasterPanel
extends JPanel {
    private JButtonBar m_leftBar = new JButtonBar(1);
    private ButtonGroup m_leftGroup = new ButtonGroup();
    private JPanel m_mainpanel = new JPanel();
    private JScrollBar m_mainpanelVBar;
    private Vector m_displayedElements = new Vector();
    private JSmoothModelBean m_model = new JSmoothModelBean();
    private File m_modelLocation = null;
    private EditorPool m_edPool = new EditorPool();
    private String m_currentPanelName = "";
    private Class[] m_skelElements = new Class[]{class$net$charabia$jsmoothgen$application$gui$editors$SkeletonChooser == null ? (class$net$charabia$jsmoothgen$application$gui$editors$SkeletonChooser = MasterPanel.class$("net.charabia.jsmoothgen.application.gui.editors.SkeletonChooser")) : class$net$charabia$jsmoothgen$application$gui$editors$SkeletonChooser, class$net$charabia$jsmoothgen$application$gui$editors$SkeletonProperties == null ? (class$net$charabia$jsmoothgen$application$gui$editors$SkeletonProperties = MasterPanel.class$("net.charabia.jsmoothgen.application.gui.editors.SkeletonProperties")) : class$net$charabia$jsmoothgen$application$gui$editors$SkeletonProperties};
    private Class[] m_execElements = new Class[]{class$net$charabia$jsmoothgen$application$gui$editors$ExecutableName == null ? (class$net$charabia$jsmoothgen$application$gui$editors$ExecutableName = MasterPanel.class$("net.charabia.jsmoothgen.application.gui.editors.ExecutableName")) : class$net$charabia$jsmoothgen$application$gui$editors$ExecutableName, class$net$charabia$jsmoothgen$application$gui$editors$ExecutableIcon == null ? (class$net$charabia$jsmoothgen$application$gui$editors$ExecutableIcon = MasterPanel.class$("net.charabia.jsmoothgen.application.gui.editors.ExecutableIcon")) : class$net$charabia$jsmoothgen$application$gui$editors$ExecutableIcon, class$net$charabia$jsmoothgen$application$gui$editors$CurrentDirectory == null ? (class$net$charabia$jsmoothgen$application$gui$editors$CurrentDirectory = MasterPanel.class$("net.charabia.jsmoothgen.application.gui.editors.CurrentDirectory")) : class$net$charabia$jsmoothgen$application$gui$editors$CurrentDirectory};
    private Class[] m_appElements = new Class[]{class$net$charabia$jsmoothgen$application$gui$editors$MainClass == null ? (class$net$charabia$jsmoothgen$application$gui$editors$MainClass = MasterPanel.class$("net.charabia.jsmoothgen.application.gui.editors.MainClass")) : class$net$charabia$jsmoothgen$application$gui$editors$MainClass, class$net$charabia$jsmoothgen$application$gui$editors$ApplicationArguments == null ? (class$net$charabia$jsmoothgen$application$gui$editors$ApplicationArguments = MasterPanel.class$("net.charabia.jsmoothgen.application.gui.editors.ApplicationArguments")) : class$net$charabia$jsmoothgen$application$gui$editors$ApplicationArguments, class$net$charabia$jsmoothgen$application$gui$editors$EmbeddedJar == null ? (class$net$charabia$jsmoothgen$application$gui$editors$EmbeddedJar = MasterPanel.class$("net.charabia.jsmoothgen.application.gui.editors.EmbeddedJar")) : class$net$charabia$jsmoothgen$application$gui$editors$EmbeddedJar, class$net$charabia$jsmoothgen$application$gui$editors$ClassPath == null ? (class$net$charabia$jsmoothgen$application$gui$editors$ClassPath = MasterPanel.class$("net.charabia.jsmoothgen.application.gui.editors.ClassPath")) : class$net$charabia$jsmoothgen$application$gui$editors$ClassPath};
    private Class[] m_jvmSelElements = new Class[]{class$net$charabia$jsmoothgen$application$gui$editors$MinVersion == null ? (class$net$charabia$jsmoothgen$application$gui$editors$MinVersion = MasterPanel.class$("net.charabia.jsmoothgen.application.gui.editors.MinVersion")) : class$net$charabia$jsmoothgen$application$gui$editors$MinVersion, class$net$charabia$jsmoothgen$application$gui$editors$MaxVersion == null ? (class$net$charabia$jsmoothgen$application$gui$editors$MaxVersion = MasterPanel.class$("net.charabia.jsmoothgen.application.gui.editors.MaxVersion")) : class$net$charabia$jsmoothgen$application$gui$editors$MaxVersion, class$net$charabia$jsmoothgen$application$gui$editors$JVMBundle == null ? (class$net$charabia$jsmoothgen$application$gui$editors$JVMBundle = MasterPanel.class$("net.charabia.jsmoothgen.application.gui.editors.JVMBundle")) : class$net$charabia$jsmoothgen$application$gui$editors$JVMBundle, class$net$charabia$jsmoothgen$application$gui$editors$JVMSearchSequence == null ? (class$net$charabia$jsmoothgen$application$gui$editors$JVMSearchSequence = MasterPanel.class$("net.charabia.jsmoothgen.application.gui.editors.JVMSearchSequence")) : class$net$charabia$jsmoothgen$application$gui$editors$JVMSearchSequence};
    private Class[] m_jvmCfgElements = new Class[]{class$net$charabia$jsmoothgen$application$gui$editors$MaxMemoryHeap == null ? (class$net$charabia$jsmoothgen$application$gui$editors$MaxMemoryHeap = MasterPanel.class$("net.charabia.jsmoothgen.application.gui.editors.MaxMemoryHeap")) : class$net$charabia$jsmoothgen$application$gui$editors$MaxMemoryHeap, class$net$charabia$jsmoothgen$application$gui$editors$InitialMemoryHeap == null ? (class$net$charabia$jsmoothgen$application$gui$editors$InitialMemoryHeap = MasterPanel.class$("net.charabia.jsmoothgen.application.gui.editors.InitialMemoryHeap")) : class$net$charabia$jsmoothgen$application$gui$editors$InitialMemoryHeap, class$net$charabia$jsmoothgen$application$gui$editors$JavaProperties == null ? (class$net$charabia$jsmoothgen$application$gui$editors$JavaProperties = MasterPanel.class$("net.charabia.jsmoothgen.application.gui.editors.JavaProperties")) : class$net$charabia$jsmoothgen$application$gui$editors$JavaProperties};
    private Vector m_lastErrors = new Vector();
    static /* synthetic */ Class class$net$charabia$jsmoothgen$application$gui$editors$SkeletonChooser;
    static /* synthetic */ Class class$net$charabia$jsmoothgen$application$gui$editors$SkeletonProperties;
    static /* synthetic */ Class class$net$charabia$jsmoothgen$application$gui$editors$ExecutableName;
    static /* synthetic */ Class class$net$charabia$jsmoothgen$application$gui$editors$ExecutableIcon;
    static /* synthetic */ Class class$net$charabia$jsmoothgen$application$gui$editors$CurrentDirectory;
    static /* synthetic */ Class class$net$charabia$jsmoothgen$application$gui$editors$MainClass;
    static /* synthetic */ Class class$net$charabia$jsmoothgen$application$gui$editors$ApplicationArguments;
    static /* synthetic */ Class class$net$charabia$jsmoothgen$application$gui$editors$EmbeddedJar;
    static /* synthetic */ Class class$net$charabia$jsmoothgen$application$gui$editors$ClassPath;
    static /* synthetic */ Class class$net$charabia$jsmoothgen$application$gui$editors$MinVersion;
    static /* synthetic */ Class class$net$charabia$jsmoothgen$application$gui$editors$MaxVersion;
    static /* synthetic */ Class class$net$charabia$jsmoothgen$application$gui$editors$JVMBundle;
    static /* synthetic */ Class class$net$charabia$jsmoothgen$application$gui$editors$JVMSearchSequence;
    static /* synthetic */ Class class$net$charabia$jsmoothgen$application$gui$editors$MaxMemoryHeap;
    static /* synthetic */ Class class$net$charabia$jsmoothgen$application$gui$editors$InitialMemoryHeap;
    static /* synthetic */ Class class$net$charabia$jsmoothgen$application$gui$editors$JavaProperties;

    public MasterPanel() {
        this.setLayout(new BorderLayout());
        this.add("West", new JScrollPane((Component)this.m_leftBar));
        JScrollPane scp = new JScrollPane(this.m_mainpanel);
        this.m_mainpanelVBar = scp.getVerticalScrollBar();
        this.add("Center", scp);
        scp.setHorizontalScrollBarPolicy(31);
        PanelLayout pl = new PanelLayout();
        this.m_mainpanel.setLayout(pl);
        this.addAction("Skeleton", "/icons/stock_new-template.png", this.m_skelElements);
        this.addAction("Executable", "/icons/stock_autopilot-24.png", this.m_execElements);
        this.addAction("Application", "/icons/stock_form-image-control.png", this.m_appElements);
        this.addAction("JVM Selection", "/icons/stock_search.png", this.m_jvmSelElements);
        this.addAction("JVM Configuration", "/icons/stock_form-properties.png", this.m_jvmCfgElements);
    }

    private String getLocaleText(String key) {
        try {
            String value = Main.TEXTS.getString(key);
            return value;
        }
        catch (Exception exception) {
            return key;
        }
    }

    private void addAction(final String name, String iconloc, final Class[] els) {
        AbstractAction a = new AbstractAction(name, new ImageIcon(this.getClass().getResource(iconloc))){

            public void actionPerformed(ActionEvent e) {
                if (MasterPanel.this.m_currentPanelName.equals(name)) {
                    return;
                }
                MasterPanel.this.setupPanel(els);
                MasterPanel.this.m_currentPanelName = name;
            }
        };
        JToggleButton jtb = new JToggleButton(a);
        this.m_leftGroup.add(jtb);
        this.m_leftBar.add((Component)jtb);
    }

    public void setupPanel(Class[] els) {
        this.fireUpdateModel();
        this.detachAll();
        this.m_mainpanel.removeAll();
        this.m_displayedElements.removeAllElements();
        System.out.println("Adding " + els);
        if (els == null) {
            return;
        }
        for (int i = 0; i < els.length; ++i) {
            try {
                Editor ed = this.m_edPool.getInstance(els[i]);
                OptionalHelpPanel help = new OptionalHelpPanel();
                help.getContentPane().setLayout(new BorderLayout());
                help.getContentPane().add("Center", ed);
                help.setLabel(this.getLocaleText(ed.getLabel()));
                help.setHelpText(this.getLocaleText(ed.getDescription()));
                this.m_mainpanel.add(help);
                this.m_displayedElements.add(ed);
                continue;
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        this.m_mainpanelVBar.setValue(0);
        this.attachAll();
        this.validate();
        this.repaint();
    }

    public void fireUpdateModel() {
        Iterator i = this.m_displayedElements.iterator();
        while (i.hasNext()) {
            Editor ed = (Editor)i.next();
            ed.updateModel();
        }
    }

    public void fireModelChanged() {
        Iterator i = this.m_displayedElements.iterator();
        while (i.hasNext()) {
            Editor ed = (Editor)i.next();
            ed.dataChanged();
        }
    }

    private void detachAll() {
        Iterator i = this.m_displayedElements.iterator();
        while (i.hasNext()) {
            Editor ed = (Editor)i.next();
            if (ed instanceof JSmoothModelBean.Listener) {
                this.m_model.removeListener((JSmoothModelBean.Listener)((Object)ed));
            }
            if (ed instanceof JSmoothModelBean.SkeletonChangedListener) {
                this.m_model.removeSkeletonChangedListener((JSmoothModelBean.SkeletonChangedListener)((Object)ed));
            }
            ed.detach();
        }
    }

    private void attachAll() {
        System.out.println("Attaching all with " + this.m_modelLocation + ": " + this.m_model);
        Iterator i = this.m_displayedElements.iterator();
        while (i.hasNext()) {
            Editor ed = (Editor)i.next();
            File basedir = null;
            if (this.m_modelLocation != null) {
                basedir = this.m_modelLocation.getParentFile();
            }
            ed.attach(this.m_model, basedir);
            if (ed instanceof JSmoothModelBean.Listener) {
                this.m_model.addListener((JSmoothModelBean.Listener)((Object)ed));
            }
            if (ed instanceof JSmoothModelBean.SkeletonChangedListener) {
                this.m_model.addSkeletonChangedListener((JSmoothModelBean.SkeletonChangedListener)((Object)ed));
            }
            ed.dataChanged();
        }
    }

    public void newModel() {
        JSmoothModelBean bean = new JSmoothModelBean();
        this.newModel(bean, null);
    }

    public void newModel(JSmoothModelBean bean, File location) {
        this.detachAll();
        this.m_model = bean;
        this.m_modelLocation = location;
        this.attachAll();
    }

    public boolean openFile(File f) {
        this.m_modelLocation = f;
        try {
            JSmoothModelBean model = JSmoothModelPersistency.load(this.m_modelLocation);
            this.newModel(model, f);
            return true;
        }
        catch (IOException iox) {
            iox.printStackTrace();
            return false;
        }
    }

    public boolean save() {
        if (this.m_modelLocation == null) {
            return false;
        }
        try {
            this.fireUpdateModel();
            this.m_model.normalizePaths(this.m_modelLocation.getParentFile(), true);
            JSmoothModelPersistency.save(this.m_modelLocation, this.m_model);
            this.fireModelChanged();
            return true;
        }
        catch (IOException iox) {
            iox.printStackTrace();
            return false;
        }
    }

    public Vector getLastErrors() {
        return this.m_lastErrors;
    }

    public ExeCompiler.CompilerRunner getCompiler() {
        File basedir;
        this.fireUpdateModel();
        this.m_model.normalizePaths(this.m_modelLocation.getParentFile());
        this.m_lastErrors.removeAllElements();
        SkeletonBean skel = Main.SKELETONS.getSkeleton(this.m_model.getSkeletonName());
        if (skel == null) {
            this.m_lastErrors.add(Main.local("UNKNOWN_SKEL"));
            return null;
        }
        File skelroot = Main.SKELETONS.getDirectory(skel);
        File exedir = basedir = this.m_modelLocation.getParentFile();
        try {
            File out = null;
            out = !new File(this.m_model.getExecutableName()).isAbsolute() ? new File(exedir, this.m_model.getExecutableName()) : new File(this.m_model.getExecutableName());
            System.out.println("out = " + out.getAbsolutePath());
            ExeCompiler compiler = new ExeCompiler();
            ExeCompiler.CompilerRunner runner = compiler.getRunnable(skelroot, skel, basedir, this.m_model, out);
            return runner;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.m_lastErrors.add(exc.getMessage());
            return null;
        }
    }

    public void runexe() {
        this.fireUpdateModel();
        try {
            File basedir = this.m_modelLocation.getParentFile();
            File f = new File(basedir, this.m_model.getExecutableName());
            String[] cmd = new String[]{f.getAbsolutePath()};
            System.out.println("RUNNING " + cmd[0] + " @ " + basedir);
            CommandRunner.run(cmd, f.getParentFile());
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public File getProjectFile() {
        return this.m_modelLocation;
    }

    public void setProjectFile(File prjfile) {
        this.m_modelLocation = prjfile;
    }

    public JSmoothModelBean getModel() {
        return this.m_model;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        JFrame test = new JFrame("test");
        test.getContentPane().add(new MasterPanel());
        test.pack();
        test.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

