/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * JMDIFrame.java
 * 
 * Created on 6 febbraio 2003, 0.31
 *
 */

package it.businesslogic.ireport.gui;
import java.awt.Point;
import java.beans.PropertyVetoException;
/**
 * JMDIFrame is an evolution of the very trivial javax.swing.JInternalFrame.
 * This class implements an MDI window handling similar to Win32, with 
 * the maximized frame really maximized (without the title bar, and with the
 * minimize, maximize and close buttons on menu bar, that must be a JMDIMenuBar)
 *
 * @author  Administrator
 */
public class JMDIFrame extends javax.swing.JInternalFrame {
    
    javax.swing.border.Border borderNormal = null;
    javax.swing.JComponent northPane = null;
    java.awt.Rectangle northPaneBounds = null;
    it.businesslogic.ireport.gui.JMDIMenuBar menu = null;
    
    private boolean borderNone  = false;
    /** Creates new form JMDIFrame */
    /** OLD
    public JMDIFrame() {
        initComponents();
        
        northPane = ((javax.swing.plaf.basic.BasicInternalFrameUI) this.getUI()).getNorthPane();
        northPaneBounds = northPane.getBounds();
        setNormalSize( this.getPreferredSize());
        borderNone  = false;
        jPanel1.setBackground(new java.awt.Color((int)( Math.random()* 0xffffff)));
    }
    **/
    /** 
    	Fixed version for OSX
    */
    public JMDIFrame() { 
        initComponents(); 
        
        northPane = ((javax.swing.plaf.basic.BasicInternalFrameUI) this.getUI()).getNorthPane(); 
        if(northPane == null){//change made here 
            javax.swing.plaf.basic.BasicInternalFrameUI aUI = new javax.swing.plaf.basic.BasicInternalFrameUI(this); 
           this.setUI(aUI); 
            northPane = ((javax.swing.plaf.basic.BasicInternalFrameUI) this.getUI()).getNorthPane(); 
        } //change ends here 
        northPaneBounds = northPane.getBounds(); 
        setNormalSize( this.getPreferredSize()); 
        borderNone  = false; 
       jPanel1.setBackground(new java.awt.Color((int)( Math.random()* 0xffffff))); 
       if (getBorder() != null && !(getBorder() instanceof javax.swing.border.EmptyBorder))
       {
           this.setWindowBorder( getBorder() );
       }
    } 


    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel1 = new javax.swing.JPanel();

        setClosable(true);
        setIconifiable(true);
        setMaximizable(true);
        setResizable(true);
        setTitle("JMDIFrame");
        setPreferredSize(new java.awt.Dimension(400, 400));
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                formComponentResized(evt);
            }
        });

        addHierarchyBoundsListener(new java.awt.event.HierarchyBoundsListener() {
            public void ancestorMoved(java.awt.event.HierarchyEvent evt) {
            }
            public void ancestorResized(java.awt.event.HierarchyEvent evt) {
                formAncestorResized(evt);
            }
        });

        addInternalFrameListener(new javax.swing.event.InternalFrameListener() {
            public void internalFrameOpened(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameClosing(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameClosing(evt);
            }
            public void internalFrameClosed(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameClosed(evt);
            }
            public void internalFrameIconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeiconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameActivated(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameActivated(evt);
            }
            public void internalFrameDeactivated(javax.swing.event.InternalFrameEvent evt) {
            }
        });

        addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                formPropertyChange(evt);
            }
        });

        jPanel1.setBackground(new java.awt.Color(255, 204, 204));
        jPanel1.addHierarchyBoundsListener(new java.awt.event.HierarchyBoundsListener() {
            public void ancestorMoved(java.awt.event.HierarchyEvent evt) {
            }
            public void ancestorResized(java.awt.event.HierarchyEvent evt) {
                jPanel1AncestorResized(evt);
            }
        });

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents

    private void formInternalFrameClosing(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameClosing
        // If there is no more frames, reset menu buttons...
       // javax.swing.JOptionPane.showMessageDialog(this,"Frames: "+this.getDesktopPane().getAllFrames().length);
       // if (this.getDesktopPane().getAllFrames().length  == 1)
       // {
       //     try {
       //         this.setIcon(true);
       //     } catch (Exception ex) {}
            //if (menu != null) menu.removeFrameButtons();
       // }
        
        if (!closingFrame(false))
        {
            setDefaultCloseOperation( this.DO_NOTHING_ON_CLOSE );
        }
        else
        {
            setDefaultCloseOperation( this.DISPOSE_ON_CLOSE );
             if ( this.getDesktopPane() instanceof JMDIDesktopPane)
            {
                ((JMDIDesktopPane)this.getDesktopPane()).internalFrameClosed(this);
            }
        }
    }//GEN-LAST:event_formInternalFrameClosing

    private void formInternalFrameClosed(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameClosed

    }//GEN-LAST:event_formInternalFrameClosed

    private void jPanel1AncestorResized(java.awt.event.HierarchyEvent evt) {//GEN-FIRST:event_jPanel1AncestorResized

         
    }//GEN-LAST:event_jPanel1AncestorResized

    private void formInternalFrameActivated(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameActivated
        // We must notify the JMDIDesktopPane...
        if ( this.getDesktopPane() instanceof JMDIDesktopPane)
        {
            ((JMDIDesktopPane)this.getDesktopPane()).internalFrameActivated(this);
        }
       
    }//GEN-LAST:event_formInternalFrameActivated

    private void formComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentResized
       
        //((javax.swing.plaf.basic.BasicInternalFrameUI)getUI()).setNorthPane(null);
        
        
        if (this.isMaximum())
        {
            double h = ((javax.swing.plaf.basic.BasicInternalFrameUI)getUI()).getNorthPane().getSize().getHeight();
            
            java.awt.Rectangle rr = this.getBounds();
            if (rr.getY() >= 0)
            {
                rr.setRect(rr.getX(),(int)rr.getY()-h, (int)rr.getWidth(), rr.getHeight() + h);
                this.setBounds(rr);
            }
            this.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets( 0,0,0,0 )));
        }
        else
        {
            setNormalSize( this.getSize() );
        }
        

    }//GEN-LAST:event_formComponentResized

    public void setBorder(javax.swing.border.Border bor)
    {
        if (!isMaximum())
        {
            super.setBorder(bor);
        }
        
        if (isMaximum() && bor != null && bor instanceof javax.swing.border.EmptyBorder)
        {
            super.setBorder(bor);
        }
        else
        {
            // trying to setting border bor....
        }
    }

    private void formPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_formPropertyChange
        // Add your handling code here
        
        /*
        if (evt.getPropertyName().equals("maximum"))
                        onMaximizeMinimize();
        */
             if (evt.getPropertyName().equals("selected"))
                        onSelect();
    }//GEN-LAST:event_formPropertyChange

    private java.awt.Rectangle normalBounds = null;
    private javax.swing.border.Border windowBorder = null;

    
    public void setMaximum(boolean b) throws PropertyVetoException
    {
        if (isMaximum() == b) return;
        
        if (b == true)
        {
            this.setNormalBounds( getBounds() );
            if (getBorder() != null && !(getBorder() instanceof javax.swing.border.EmptyBorder))
            {
                this.setWindowBorder( getBorder() );
            }
            //this.getRootPane().setWindowDecorationStyle( javax.swing.JRootPane.NONE);
            this.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets( 0,0,0,0 )));
            super.setMaximum(b);
            if (menu != null) menu.setMaximizedFrame(this);
        }
        else
        {
            if (getWindowBorder() != null)
               super.setBorder( getWindowBorder() );
            //this.getRootPane().setWindowDecorationStyle( javax.swing.JRootPane.FRAME);
            if (getNormalBounds() != null)
            {
                this.setBounds(getNormalBounds());
            }
            super.setMaximum(b);
            if (menu != null) menu.setMaximizedFrame(null);
        }
       
    }
    
    
    /**
     *  This method set the activeForm to the menu. It is useful when the user 
     *  maximize windows and then close one. The frame that will activated will
     *  set activeForm in JMDIMenuBar class trought this method. 
     * 
     */
    private void onSelect()
    {
        if ( this.isMaximum)
        {
            if (menu != null) menu.setMaximizedFrame(this);
        }
        
    }
    
    
    private void formAncestorResized(java.awt.event.HierarchyEvent evt) {//GEN-FIRST:event_formAncestorResized

        
        
    }//GEN-LAST:event_formAncestorResized

    /** Getter for property menu.
     * @return Value of property menu.
     *
     */
    public it.businesslogic.ireport.gui.JMDIMenuBar getMenu() {
        return menu;
    }    
    
    /** Setter for property menu.
     *  We need a JMDIMenuBar to add, if needed, buttons to resize, close, minimize this
     * window when maximized.
     * @param menu New value of property menu.
     *
     */
    public void setMenu(it.businesslogic.ireport.gui.JMDIMenuBar menu) {
        this.menu = menu;
    }    
    
    /** Getter for property normalSize.
     * @return Value of property normalSize.
     *
     */
    public java.awt.Dimension getNormalSize() {
        return normalSize;
    }
    
    /** Setter for property normalSize.
     * @param normalSize New value of property normalSize.
     *
     */
    public void setNormalSize(java.awt.Dimension normalSize) {
        this.normalSize = normalSize;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables

    private java.awt.Dimension normalSize;    
   /* 
    public void setMaximum(boolean bMaximum) throws java.beans.PropertyVetoException
    {
        try {
        //((javax.swing.plaf.basic.BasicInternalFrameUI)getUI()).setNorthPane( northPane );
        super.setMaximum(bMaximum);
        
        } catch (Exception ex0)
        {
            
        }
    }
    */
    
    /**
     * On close event. 
     * Please return true on force. 
     * Return false to stop the window close.
     */
    public boolean closingFrame(boolean force)
    {
        return true;
    }

    public java.awt.Rectangle getNormalBounds() {
        return normalBounds;
    }

    public void setNormalBounds(java.awt.Rectangle normalBounds) {
        this.normalBounds = normalBounds;
    }

    public javax.swing.border.Border getWindowBorder() {
        return windowBorder;
    }

    public void setWindowBorder(javax.swing.border.Border windowBorder) {

        this.windowBorder = windowBorder;
    }
}
