/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mondrian.olap.Access;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Schema;
import mondrian.olap.Util;

public class Role {
    private boolean mutable = true;
    private Map grants = new HashMap();
    private static Integer[] integers = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4)};

    protected Object clone() {
        Role role = new Role();
        role.mutable = this.mutable;
        role.grants.putAll(this.grants);
        Iterator iter = this.grants.values().iterator();
        while (iter.hasNext()) {
            Object value = iter.next();
            if (!(value instanceof HierarchyAccess)) continue;
            HierarchyAccess hierarchyAccess = (HierarchyAccess)value;
            role.grants.put(hierarchyAccess.hierarchy, hierarchyAccess.clone());
        }
        return role;
    }

    public Role makeMutableClone() {
        Role role = (Role)this.clone();
        role.mutable = true;
        return role;
    }

    public void makeImmutable() {
        this.mutable = false;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void grant(Schema schema, int access) {
        Util.assertPrecondition(schema != null, "schema != null");
        Util.assertPrecondition(access == 4 || access == 1 || access == 3, "access == Access.ALL || access == Access.NONE");
        Util.assertPrecondition(this.isMutable(), "isMutable()");
        this.grants.put(schema, Role.toInteger(access));
    }

    private static Integer toInteger(int access) {
        return integers[access];
    }

    public int getAccess(Schema schema) {
        Util.assertPrecondition(schema != null, "schema != null");
        return Role.toAccess((Integer)this.grants.get(schema));
    }

    private static int toAccess(Integer i) {
        return i == null ? 1 : i;
    }

    public void grant(Cube cube, int access) {
        Util.assertPrecondition(cube != null, "cube != null");
        Util.assertPrecondition(access == 4 || access == 1, "access == Access.ALL || access == Access.NONE");
        Util.assertPrecondition(this.isMutable(), "isMutable()");
        this.grants.put(cube, Role.toInteger(access));
    }

    public int getAccess(Cube cube) {
        Util.assertPrecondition(cube != null, "cube != null");
        Integer access = (Integer)this.grants.get(cube);
        if (access == null) {
            access = (Integer)this.grants.get(cube.getSchema());
        }
        return Role.toAccess(access);
    }

    public void grant(Dimension dimension, int access) {
        Util.assertPrecondition(dimension != null, "dimension != null");
        Util.assertPrecondition(access == 4 || access == 1, "access == Access.ALL || access == Access.NONE");
        Util.assertPrecondition(this.isMutable(), "isMutable()");
        this.grants.put(dimension, Role.toInteger(access));
    }

    public int getAccess(Dimension dimension) {
        Util.assertPrecondition(dimension != null, "dimension != null");
        Integer i = (Integer)this.grants.get(dimension);
        if (i != null) {
            return Role.toAccess(i);
        }
        Iterator grantsIter = this.grants.keySet().iterator();
        while (grantsIter.hasNext()) {
            int access;
            Object object = grantsIter.next();
            if (!(object instanceof Cube) || (access = Role.toAccess((Integer)this.grants.get(object))) == 1) continue;
            Dimension[] dimensions = ((Cube)object).getDimensions();
            for (int j = 0; j < dimensions.length; ++j) {
                if (dimensions[j] != dimension) continue;
                return access;
            }
        }
        switch (this.getAccess(dimension.getSchema())) {
            case 3: 
            case 4: {
                return 4;
            }
        }
        return 1;
    }

    public void grant(Hierarchy hierarchy, int access, Level topLevel, Level bottomLevel) {
        Util.assertPrecondition(hierarchy != null, "hierarchy != null");
        Util.assertPrecondition(Access.instance().isValid(access));
        Util.assertPrecondition(access == 2 || topLevel == null && bottomLevel == null, "access == Access.CUSTOM) || (topLevel == null && bottomLevel == null)");
        Util.assertPrecondition(topLevel == null || topLevel.getHierarchy() == hierarchy, "topLevel == null || topLevel.getHierarchy() == hierarchy");
        Util.assertPrecondition(bottomLevel == null || bottomLevel.getHierarchy() == hierarchy, "bottomLevel == null || bottomLevel.getHierarchy() == hierarchy");
        Util.assertPrecondition(this.isMutable(), "isMutable()");
        this.grants.put(hierarchy, new HierarchyAccess(hierarchy, access, topLevel, bottomLevel));
    }

    public int getAccess(Hierarchy hierarchy) {
        Util.assertPrecondition(hierarchy != null, "hierarchy != null");
        HierarchyAccess access = (HierarchyAccess)this.grants.get(hierarchy);
        if (access != null) {
            return access.access;
        }
        return this.getAccess(hierarchy.getDimension());
    }

    public HierarchyAccess getAccessDetails(Hierarchy hierarchy) {
        Util.assertPrecondition(hierarchy != null, "hierarchy != null");
        return (HierarchyAccess)this.grants.get(hierarchy);
    }

    public int getAccess(Level level) {
        Util.assertPrecondition(level != null, "level != null");
        HierarchyAccess access = (HierarchyAccess)this.grants.get(level.getHierarchy());
        if (access != null) {
            if (access.topLevel != null && level.getDepth() < access.topLevel.getDepth()) {
                return 1;
            }
            if (access.bottomLevel != null && level.getDepth() > access.bottomLevel.getDepth()) {
                return 1;
            }
            return access.access;
        }
        return this.getAccess(level.getDimension());
    }

    public void grant(Member member, int access) {
        Util.assertPrecondition(member != null, "member != null");
        Util.assertPrecondition(Access.instance().isValid(access), "Access.instance().isValid(access)");
        Util.assertPrecondition(this.isMutable(), "isMutable()");
        Util.assertPrecondition(this.getAccess(member.getHierarchy()) == 2, "getAccess(member.getHierarchy()) == Access.CUSTOM");
        HierarchyAccess hierarchyAccess = (HierarchyAccess)this.grants.get(member.getHierarchy());
        Util.assertTrue(hierarchyAccess != null && hierarchyAccess.access == 2);
        hierarchyAccess.grant(member, access);
    }

    public int getAccess(Member member) {
        Util.assertPrecondition(member != null, "member != null");
        HierarchyAccess hierarchyAccess = (HierarchyAccess)this.grants.get(member.getHierarchy());
        if (hierarchyAccess != null) {
            return hierarchyAccess.getAccess(member);
        }
        return this.getAccess(member.getDimension());
    }

    public int getAccess(NamedSet set) {
        Util.assertPrecondition(set != null, "set != null");
        return 4;
    }

    public boolean canAccess(OlapElement olapElement) {
        Util.assertPrecondition(olapElement != null, "olapElement != null");
        if (olapElement instanceof Cube) {
            return this.getAccess((Cube)olapElement) != 1;
        }
        if (olapElement instanceof Dimension) {
            return this.getAccess((Dimension)olapElement) != 1;
        }
        if (olapElement instanceof Hierarchy) {
            return this.getAccess((Hierarchy)olapElement) != 1;
        }
        if (olapElement instanceof Level) {
            return this.getAccess((Level)olapElement) != 1;
        }
        if (olapElement instanceof Member) {
            return this.getAccess((Member)olapElement) != 1;
        }
        if (olapElement instanceof NamedSet) {
            return this.getAccess((NamedSet)olapElement) != 1;
        }
        return false;
    }

    public static class HierarchyAccess {
        private final Hierarchy hierarchy;
        private final Level topLevel;
        private final int access;
        private final Level bottomLevel;
        private final Map memberGrants = new HashMap();

        HierarchyAccess(Hierarchy hierarchy, int access, Level topLevel, Level bottomLevel) {
            this.hierarchy = hierarchy;
            this.access = access;
            this.topLevel = topLevel;
            this.bottomLevel = bottomLevel;
            Util.assertPrecondition(Access.instance().isValid(access));
        }

        public Object clone() {
            HierarchyAccess hierarchyAccess = new HierarchyAccess(this.hierarchy, this.access, this.topLevel, this.bottomLevel);
            hierarchyAccess.memberGrants.putAll(this.memberGrants);
            return hierarchyAccess;
        }

        void grant(Member member, int access) {
            Util.assertTrue(member.getHierarchy() == this.hierarchy);
            Iterator membersIter = this.memberGrants.keySet().iterator();
            while (membersIter.hasNext()) {
                Member m = (Member)membersIter.next();
                if (!m.isChildOrEqualTo(member)) continue;
                membersIter.remove();
            }
            this.memberGrants.put(member, Role.toInteger(access));
        }

        public int getAccess(Member member) {
            int access = this.access;
            if (access == 2) {
                access = 1;
                if (!(this.topLevel != null && member.getLevel().getDepth() < this.topLevel.getDepth() || this.bottomLevel != null && member.getLevel().getDepth() > this.bottomLevel.getDepth())) {
                    Iterator membersIter = this.memberGrants.keySet().iterator();
                    while (membersIter.hasNext()) {
                        Member m = (Member)membersIter.next();
                        int memberAccess = Role.toAccess((Integer)this.memberGrants.get(m));
                        if (member.isChildOrEqualTo(m)) {
                            access = Math.max(access, memberAccess);
                            continue;
                        }
                        if (!m.isChildOrEqualTo(member) || memberAccess == 1) continue;
                        access = Math.max(access, 2);
                    }
                }
            }
            return access;
        }

        public Hierarchy getHierarchy() {
            return this.hierarchy;
        }

        public Level getTopLevel() {
            return this.topLevel;
        }

        public Level getBottomLevel() {
            return this.bottomLevel;
        }

        public Map getMemberGrants() {
            return Collections.unmodifiableMap(this.memberGrants);
        }
    }
}

