/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.gui.JNumberField;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.ReportBandChangedEvent;
import it.businesslogic.ireport.gui.event.ReportBandsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.gui.event.ReportElementsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportListener;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BandsDialog
extends JDialog
implements ReportListener {
    private JReportFrame jReportFrame = null;
    private Band selectedBand = null;
    private JButton jButton1;
    private JCheckBox jCheckBoxSplitAllowed;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jListBands;
    private JNumberField jNumberFieldHeight;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelButtons;
    private JPanel jPanelFields;
    private JRTextExpressionArea jRTextExpressionArea;
    private JScrollPane jScrollPane1;

    public BandsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        this.pack();
        Misc.centerFrame(this);
        this.jListBands.setModel(new DefaultListModel());
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                BandsDialog.this.setVisible(false);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButton1);
        MainFrame.getMainInstance().addReportListener(this);
    }

    private void jRTextExpressionAreaTextChanged() {
    }

    public void jTableBandsListSelectionValueChanged(ListSelectionEvent e) {
    }

    public void updateBands() {
        Band selected = this.getSelectedBand();
        boolean isSelected = false;
        ((DefaultListModel)this.jListBands.getModel()).removeAllElements();
        if (this.jReportFrame == null) {
            return;
        }
        Enumeration e = this.jReportFrame.getReport().getBands().elements();
        while (e.hasMoreElements()) {
            Band band = (Band)e.nextElement();
            ((DefaultListModel)this.jListBands.getModel()).addElement(band);
            if (selected != band) continue;
            this.jListBands.setSelectedValue(selected, true);
            isSelected = true;
        }
        if (!isSelected && this.jReportFrame.getReport().getBands().size() > 0) {
            this.jListBands.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jPanelFields = new JPanel();
        this.jPanelButtons = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jNumberFieldHeight = new JNumberField();
        this.jCheckBoxSplitAllowed = new JCheckBox();
        this.jRTextExpressionArea = new JRTextExpressionArea();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListBands = new JList();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                BandsDialog.this.closeDialog(evt);
            }
        });
        this.jPanelFields.setLayout(new BorderLayout(4, 4));
        this.jPanelButtons.setLayout(new BorderLayout());
        this.jPanelButtons.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Band properties"));
        this.jPanelButtons.setMinimumSize(new Dimension(100, 10));
        this.jPanelButtons.setPreferredSize(new Dimension(300, 250));
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setPreferredSize(new Dimension(10, 55));
        this.jLabel1.setText("Print When Expression");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Band height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jNumberFieldHeight.setHorizontalAlignment(4);
        this.jNumberFieldHeight.setText("0");
        try {
            this.jNumberFieldHeight.setDecimals(0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        this.jNumberFieldHeight.setMinimumSize(new Dimension(80, 19));
        this.jNumberFieldHeight.setPreferredSize(new Dimension(80, 19));
        this.jNumberFieldHeight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BandsDialog.this.jNumberFieldHeightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel3.add((Component)this.jNumberFieldHeight, gridBagConstraints);
        this.jCheckBoxSplitAllowed.setSelected(true);
        this.jCheckBoxSplitAllowed.setText("Split allowed");
        this.jCheckBoxSplitAllowed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BandsDialog.this.jCheckBoxSplitAllowedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel3.add((Component)this.jCheckBoxSplitAllowed, gridBagConstraints);
        this.jRTextExpressionArea.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionArea.setElectricScroll(0);
        this.jRTextExpressionArea.setMinimumSize(new Dimension(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel3.add((Component)this.jRTextExpressionArea, gridBagConstraints);
        this.jButton1.setText("Apply");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BandsDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jButton1, gridBagConstraints);
        this.jPanel2.add((Component)this.jPanel3, "Center");
        this.jPanelButtons.add((Component)this.jPanel2, "Center");
        this.jPanelFields.add((Component)this.jPanelButtons, "Center");
        this.getContentPane().add((Component)this.jPanelFields, "Center");
        this.jScrollPane1.setToolTipText("");
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setPreferredSize(new Dimension(150, 300));
        this.jListBands.setBorder(BorderFactory.createEtchedBorder());
        this.jListBands.setSelectionMode(0);
        this.jListBands.setToolTipText("List of bands");
        this.jListBands.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jListBands.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                BandsDialog.this.jListBandsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListBands);
        this.getContentPane().add((Component)this.jScrollPane1, "West");
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        boolean changed = false;
        Band b = this.getSelectedBand();
        if (b == null) {
            return;
        }
        int okHeight = b.getHeight();
        int newHeight = BandsDialog.updateBandHeight(this.getJReportFrame().getReport(), b, (int)this.jNumberFieldHeight.getValue());
        if (newHeight >= 0 && okHeight != newHeight) {
            try {
                this.jNumberFieldHeight.setValue(newHeight);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.getJReportFrame().setIsDocDirty(true);
            this.getJReportFrame().updateScrollBars();
            this.getJReportFrame().getReportPanel().repaint();
            changed = true;
        }
        if ((b = this.getSelectedBand()) != null) {
            b.setSplitAllowed(this.jCheckBoxSplitAllowed.isSelected());
            changed = true;
        }
        if (!b.getPrintWhenExpression().equals(this.jRTextExpressionArea.getText())) {
            this.getSelectedBand().setPrintWhenExpression(this.jRTextExpressionArea.getText());
            changed = true;
        }
        if (changed) {
            this.getJReportFrame().fireReportListenerReportBandChanged(new ReportBandChangedEvent(this.getJReportFrame(), this.getSelectedBand(), 3));
        }
    }

    private void jCheckBoxSplitAllowedActionPerformed(ActionEvent evt) {
    }

    private void jNumberFieldHeightActionPerformed(ActionEvent evt) {
    }

    private void jListBandsValueChanged(ListSelectionEvent evt) {
        this.updateSelection();
    }

    public void updateSelection() {
        this.jNumberFieldHeightActionPerformed(null);
        if (this.jListBands.getModel().getSize() == 0) {
            try {
                this.jNumberFieldHeight.setValue(0);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.jRTextExpressionArea.setText("");
            this.jCheckBoxSplitAllowed.setSelected(false);
            return;
        }
        if (this.jListBands.getSelectedIndex() < 0) {
            this.jListBands.setSelectedIndex(0);
            return;
        }
        this.selectedBand = (Band)this.jListBands.getSelectedValue();
        try {
            this.jNumberFieldHeight.setValue(this.selectedBand.getHeight());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jRTextExpressionArea.setText(this.selectedBand.getPrintWhenExpression());
        this.jCheckBoxSplitAllowed.setSelected(this.selectedBand.isSplitAllowed());
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new BandsDialog((Frame)new JFrame(), true).setVisible(true);
    }

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        if (jReportFrame == null) {
            this.setVisible(false);
            return;
        }
        this.setTitle(jReportFrame.getReport().getName() + " " + I18n.getString("bandsDialog.bands", " bands..."));
        if (this.isVisible()) {
            this.updateBands();
        }
    }

    public void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        super.setVisible(visible);
        if (visible) {
            this.setJReportFrame(this.jReportFrame);
        }
    }

    public void setSelectedBand(String bandName) {
        for (int i = 0; i < this.jListBands.getModel().getSize(); ++i) {
            Band b = (Band)this.jListBands.getModel().getElementAt(i);
            if (!b.getName().equals(bandName)) continue;
            this.jListBands.setSelectedIndex(i);
            return;
        }
    }

    public Band getSelectedBand() {
        return this.selectedBand;
    }

    public void setSelectedBand(Band selectedBand) {
        this.selectedBand = selectedBand;
    }

    public void applyI18n() {
        this.jCheckBoxSplitAllowed.setText(I18n.getString("bandsDialog.checkBoxSplitAllowed", "Split allowed"));
        this.jButton1.setText(I18n.getString("bandsDialog.button1", "Apply"));
        this.jLabel1.setText(I18n.getString("bandsDialog.label1", "Print When Expression"));
        this.jLabel2.setText(I18n.getString("bandsDialog.label2", "Band height"));
        ((TitledBorder)this.jPanelButtons.getBorder()).setTitle(I18n.getString("bandsDialog.panelBorder.BandProperties", "Band properties"));
        this.jListBands.setToolTipText(I18n.getString("bandsDialog.listBands", "List of bands"));
    }

    public static int updateBandHeight(Report report, Band b, int newHeight) {
        if (b == null || report == null) {
            return -1;
        }
        int okHeight = b.getHeight();
        boolean changed = false;
        int delta = newHeight - b.getHeight();
        if (delta != 0) {
            changed = true;
            int available_height = report.getHeight() - report.getTopMargin() - report.getBottomMargin();
            if (!(b.getName().equals("background") || b.getName().equals("title") && report.isIsTitleNewPage() || b.getName().equals("summary") && report.isIsSummaryNewPage())) {
                for (int i = 0; i < report.getBands().size(); ++i) {
                    Band aBand = (Band)report.getBands().elementAt(i);
                    if (aBand.getName().equals("background") || aBand.getName().equals("title") && report.isIsTitleNewPage() || aBand.getName().equals("summary") && report.isIsSummaryNewPage() || aBand == b) continue;
                    available_height -= aBand.getHeight();
                }
            }
            okHeight = Math.max(0, Math.min(available_height, newHeight));
            delta = okHeight - b.getHeight();
            int band_h = report.getBandYLocation(b);
            b.setHeight(b.getHeight() + delta);
            int edge_y = Math.min(report.getBandYLocation(b) + b.getHeight(), report.getBandYLocation(b) + b.getHeight() - delta);
            Enumeration e = report.getElements().elements();
            while (e.hasMoreElements()) {
                ReportElement re = (ReportElement)e.nextElement();
                if (re.position.y < edge_y + 10) continue;
                int space_before_band = band_h - re.position.y - re.height;
                if (band_h <= report.getBandYLocation(re.getBand()) + 10) {
                    space_before_band = 0;
                }
                re.setPosition(new Point(re.getPosition().x, re.getPosition().y + delta));
            }
            if (report.getReportFrame() != null) {
                report.getReportFrame().setIsDocDirty(true);
                report.getReportFrame().updateScrollBars();
                report.getReportFrame().getReportPanel().repaint();
            }
        }
        return okHeight;
    }

    public void reportElementsSelectionChanged(ReportElementsSelectionEvent evt) {
    }

    public void reportElementsChanged(ReportElementChangedEvent evt) {
    }

    public void reportBandChanged(ReportBandChangedEvent evt) {
        this.updateSelection();
    }

    public void reportBandsSelectionChanged(ReportBandsSelectionEvent evt) {
    }
}

