/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.util.Map;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.wellknown.SectionIDMap;
import org.apache.poi.util.LittleEndian;

public class Section {
    protected Map dictionary;
    protected ClassID formatID;
    protected long offset;
    protected int size;
    protected int propertyCount;
    protected Property[] properties;
    private boolean wasNull;

    public ClassID getFormatID() {
        return this.formatID;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    public int getPropertyCount() {
        return this.propertyCount;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    protected Section() {
    }

    public Section(byte[] src, int offset) {
        int length;
        int sOffset;
        int id;
        int i;
        this.formatID = new ClassID(src, offset);
        this.offset = LittleEndian.getUInt(src, offset += 16);
        offset = (int)this.offset;
        this.size = (int)LittleEndian.getUInt(src, offset);
        this.propertyCount = (int)LittleEndian.getUInt(src, offset += 4);
        this.properties = new Property[this.propertyCount];
        int codepage = -1;
        int pass1Offset = offset += 4;
        for (i = 0; i < this.properties.length; ++i) {
            id = (int)LittleEndian.getUInt(src, pass1Offset);
            sOffset = (int)LittleEndian.getUInt(src, pass1Offset += 4);
            length = i == this.properties.length - 1 ? (int)((long)src.length - this.offset - (long)sOffset) : (int)LittleEndian.getUInt(src, (pass1Offset += 4) + 4) - sOffset;
            if (id != 1) continue;
            int o = (int)(this.offset + (long)sOffset);
            long type = LittleEndian.getUInt(src, o);
            o += 4;
            if (type != 2L) {
                throw new HPSFRuntimeException("Value type of property ID 1 is not VT_I2 but " + type + ".");
            }
            codepage = LittleEndian.getUShort(src, o);
        }
        for (i = 0; i < this.properties.length; ++i) {
            id = (int)LittleEndian.getUInt(src, offset);
            sOffset = (int)LittleEndian.getUInt(src, offset += 4);
            length = i == this.properties.length - 1 ? (int)((long)src.length - this.offset - (long)sOffset) : (int)LittleEndian.getUInt(src, (offset += 4) + 4) - sOffset;
            this.properties[i] = new Property(id, src, this.offset + (long)sOffset, length, codepage);
        }
        this.dictionary = (Map)this.getProperty(0);
    }

    public Object getProperty(int id) {
        this.wasNull = false;
        for (int i = 0; i < this.properties.length; ++i) {
            if (id != this.properties[i].getID()) continue;
            return this.properties[i].getValue();
        }
        this.wasNull = true;
        return null;
    }

    protected int getPropertyIntValue(int id) {
        Long i = (Long)this.getProperty(id);
        if (i != null) {
            return i.intValue();
        }
        return 0;
    }

    protected boolean getPropertyBooleanValue(int id) {
        Boolean b = (Boolean)this.getProperty(id);
        if (b != null) {
            return b;
        }
        return false;
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public String getPIDString(int pid) {
        String s = null;
        if (this.dictionary != null) {
            s = (String)this.dictionary.get(new Integer(pid));
        }
        if (s == null) {
            s = SectionIDMap.getPIDString(this.getFormatID().getBytes(), pid);
        }
        if (s == null) {
            s = "[undefined]";
        }
        return s;
    }
}

