/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.Level;
import mondrian.olap.QueryPart;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;

public class QueryAxis
extends QueryPart {
    public boolean nonEmpty;
    public Exp set;
    private final AxisOrdinal axisOrdinal;
    private int showSubtotals;

    static QueryAxis[] cloneArray(QueryAxis[] a) {
        QueryAxis[] a2 = new QueryAxis[a.length];
        for (int i = 0; i < a.length; ++i) {
            a2[i] = (QueryAxis)a[i].clone();
        }
        return a2;
    }

    public QueryAxis(boolean nonEmpty, Exp set, AxisOrdinal axisDef, int showSubtotals) {
        this.nonEmpty = nonEmpty;
        this.set = set;
        this.axisOrdinal = axisDef;
        this.showSubtotals = showSubtotals;
    }

    public Object clone() {
        return new QueryAxis(this.nonEmpty, (Exp)this.set.clone(), this.axisOrdinal, this.showSubtotals);
    }

    public String getAxisName() {
        return this.axisOrdinal.getName();
    }

    public AxisOrdinal getAxisOrdinal() {
        return this.axisOrdinal;
    }

    public boolean isNonEmpty() {
        return this.nonEmpty;
    }

    public void setNonEmpty(boolean nonEmpty) {
        this.nonEmpty = nonEmpty;
    }

    public Exp getSet() {
        return this.set;
    }

    public void setSet(Exp set) {
        this.set = set;
    }

    public void resolve(Validator validator) {
        this.set = validator.validate(this.set, false);
        Type type = this.set.getTypeX();
        if (!TypeUtil.isSet(type)) {
            throw MondrianResource.instance().MdxAxisIsNotSet.ex(this.axisOrdinal.getName());
        }
    }

    public Object[] getChildren() {
        return new Object[]{this.set};
    }

    public void replaceChild(int ordinal, QueryPart with) {
        Util.assertTrue(ordinal == 0);
        this.set = (Exp)((Object)with);
    }

    public void unparse(PrintWriter pw) {
        if (this.nonEmpty) {
            pw.print("NON EMPTY ");
        }
        if (this.set != null) {
            this.set.unparse(pw);
        }
        pw.print(" ON " + this.axisOrdinal);
    }

    public void addLevel(Level level) {
        Util.assertTrue(level != null, "addLevel needs level");
        this.set = new FunCall("Crossjoin", Syntax.Function, new Exp[]{this.set, new FunCall("Members", Syntax.Property, new Exp[]{level})});
    }

    void setShowSubtotals(boolean bShowSubtotals) {
        this.showSubtotals = bShowSubtotals ? 1 : 0;
    }

    public int getShowSubtotals() {
        return this.showSubtotals;
    }

    public void resetShowHideSubtotals() {
        this.showSubtotals = -1;
    }

    public static class SubtotalVisibility
    extends EnumeratedValues {
        public static final SubtotalVisibility instance = new SubtotalVisibility();
        public static final int Undefined = -1;
        public static final int Hide = 0;
        public static final int Show = 1;

        private SubtotalVisibility() {
            super(new String[]{"undefined", "hide", "show"}, new int[]{-1, 0, 1});
        }
    }
}

