/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.util.Assert;

public abstract class AbstractRegexpMethodPointcut
extends StaticMethodMatcherPointcut
implements ClassFilter,
Serializable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String[] patterns = new String[0];
    private String[] excludedPatterns = new String[0];

    public void setPattern(String pattern) {
        this.setPatterns(new String[]{pattern});
    }

    public void setPatterns(String[] patterns) {
        Assert.notEmpty(patterns, "'patterns' cannot be null or empty.");
        this.patterns = patterns;
        this.initPatternRepresentation(patterns);
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public void setExcludedPattern(String excludedPattern) {
        this.setExcludedPatterns(new String[]{excludedPattern});
    }

    public void setExcludedPatterns(String[] excludedPatterns) {
        Assert.notEmpty(excludedPatterns, "'excludedPatterns' cannot be null or empty.");
        this.excludedPatterns = excludedPatterns;
        this.initExcludedPatternRepresentation(excludedPatterns);
    }

    public String[] getExcludedPatterns() {
        return this.excludedPatterns;
    }

    protected abstract void initPatternRepresentation(String[] var1) throws IllegalArgumentException;

    protected abstract void initExcludedPatternRepresentation(String[] var1) throws IllegalArgumentException;

    protected abstract boolean matches(String var1, int var2);

    protected abstract boolean matchesExclusion(String var1, int var2);

    public final boolean matches(Method method, Class targetClass) {
        String patt = method.getDeclaringClass().getName() + "." + method.getName();
        for (int i = 0; i < this.patterns.length; ++i) {
            boolean matched = this.matches(patt, i);
            if (!matched) continue;
            for (int j = 0; j < this.excludedPatterns.length; ++j) {
                boolean excluded = this.matchesExclusion(patt, j);
                if (!excluded) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean matches(Class clazz) {
        return true;
    }

    public final ClassFilter getClassFilter() {
        return this;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.logger = LogFactory.getLog(this.getClass());
        this.initPatternRepresentation(this.patterns);
        this.initExcludedPatternRepresentation(this.excludedPatterns);
    }
}

