/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.util.Iterator;
import mondrian.olap.Hierarchy;
import mondrian.recorder.MessageRecorder;
import mondrian.resource.MondrianResource;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapStar;
import mondrian.rolap.aggmatcher.DefaultRules;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.aggmatcher.Recognizer;

class DefaultRecognizer
extends Recognizer {
    private static final MondrianResource mres = MondrianResource.instance();
    private final DefaultRules aggDefault;

    DefaultRecognizer(DefaultRules aggDefault, RolapStar star, JdbcSchema.Table dbFactTable, JdbcSchema.Table aggTable, MessageRecorder msgRecorder) {
        super(star, dbFactTable, aggTable, msgRecorder);
        this.aggDefault = aggDefault;
    }

    DefaultRules getRules() {
        return this.aggDefault;
    }

    protected Recognizer.Matcher getIgnoreMatcher() {
        return new Recognizer.Matcher(){

            public boolean matches(String name) {
                return false;
            }
        };
    }

    protected Recognizer.Matcher getFactCountMatcher() {
        return this.getRules().getFactCountMatcher();
    }

    protected Recognizer.Matcher getMeasureMatcher(JdbcSchema.Table.Column.Usage factUsage) {
        String measureName = factUsage.getSymbolicName();
        String measureColumnName = factUsage.getColumn().getName();
        String aggregateName = factUsage.getAggregator().getName();
        Recognizer.Matcher matcher = this.getRules().getMeasureMatcher(measureName, measureColumnName, aggregateName);
        return matcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int checkMeasures() {
        this.msgRecorder.pushContextName("DefaultRecognizer.checkMeasures");
        try {
            int nosOfMeasureColumns = 0;
            Iterator it = this.dbFactTable.getColumnUsages(4);
            while (it.hasNext()) {
                JdbcSchema.Table.Column.Usage factUsage = (JdbcSchema.Table.Column.Usage)it.next();
                Recognizer.Matcher matcher = this.getMeasureMatcher(factUsage);
                int nosMatched = 0;
                Iterator aggit = this.aggTable.getColumns();
                while (aggit.hasNext()) {
                    JdbcSchema.Table.Column aggColumn = (JdbcSchema.Table.Column)aggit.next();
                    if (aggColumn.hasUsage(32) || !matcher.matches(aggColumn.getName())) continue;
                    this.makeMeasure(factUsage, aggColumn);
                    ++nosOfMeasureColumns;
                    ++nosMatched;
                }
                if (nosMatched <= true) continue;
                String msg = DefaultRecognizer.mres.AggMultipleMatchingMeasure.str(this.msgRecorder.getContext(), this.aggTable.getName(), this.dbFactTable.getName(), new Integer(nosMatched), factUsage.getSymbolicName(), factUsage.getColumn().getName(), factUsage.getAggregator().getName());
                this.msgRecorder.reportError(msg);
                this.returnValue = false;
            }
            int n = nosOfMeasureColumns;
            return n;
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }

    protected int matchForeignKey(JdbcSchema.Table.Column.Usage factUsage) {
        JdbcSchema.Table.Column factColumn = factUsage.getColumn();
        Recognizer.Matcher matcher = this.getRules().getForeignKeyMatcher(factColumn.getName());
        int nosMatched = 0;
        Iterator aggit = this.aggTable.getColumns();
        while (aggit.hasNext()) {
            JdbcSchema.Table.Column aggColumn = (JdbcSchema.Table.Column)aggit.next();
            if (aggColumn.hasUsage(32) || !matcher.matches(aggColumn.getName())) continue;
            this.makeForeignKey(factUsage, aggColumn, null);
            ++nosMatched;
        }
        return nosMatched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean matchLevel(Hierarchy hierarchy, HierarchyUsage hierarchyUsage, RolapLevel level) {
        this.msgRecorder.pushContextName("DefaultRecognizer.matchLevel");
        try {
            String usagePrefix = hierarchyUsage.getUsagePrefix();
            String hierName = hierarchy.getName();
            String levelName = level.getName();
            String levelColumnName = this.getColumnName(level.getKeyExp());
            Recognizer.Matcher matcher = this.getRules().getLevelMatcher(usagePrefix, hierName, levelName, levelColumnName);
            Iterator aggit = this.aggTable.getColumns();
            while (aggit.hasNext()) {
                JdbcSchema.Table.Column aggColumn = (JdbcSchema.Table.Column)aggit.next();
                if (!matcher.matches(aggColumn.getName())) continue;
                this.makeLevel(aggColumn, hierarchy, hierarchyUsage, this.getColumnName(level.getKeyExp()), this.getColumnName(level.getKeyExp()), level.getName());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }
}

