/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRCsvExporterNature;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public class JRCsvExporter
extends JRAbstractExporter {
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();
    protected String delimiter = null;
    protected String recordDelimiter = null;
    protected Writer writer = null;
    protected JRExportProgressMonitor progressMonitor = null;

    public void exportReport() throws JRException {
        StringBuffer sb;
        String encoding;
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        this.setInput();
        if (!this.isModeBatch) {
            this.setPageRange();
        }
        if ((encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING)) == null) {
            encoding = "ISO-8859-1";
        }
        this.delimiter = (String)this.parameters.get(JRCsvExporterParameter.FIELD_DELIMITER);
        if (this.delimiter == null) {
            this.delimiter = ",";
        }
        this.recordDelimiter = (String)this.parameters.get(JRCsvExporterParameter.RECORD_DELIMITER);
        if (this.recordDelimiter == null) {
            this.recordDelimiter = "\n";
        }
        if ((sb = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER)) != null) {
            try {
                this.writer = new StringWriter();
                this.exportReportToWriter();
                sb.append(this.writer.toString());
            }
            catch (IOException e) {
                throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), e);
            }
            finally {
                if (this.writer != null) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
        if (this.writer != null) {
            try {
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), e);
            }
        }
        OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
        if (os != null) {
            try {
                this.writer = new OutputStreamWriter(os, encoding);
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), e);
            }
        }
        File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
        if (destFile == null) {
            String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
            if (fileName != null) {
                destFile = new File(fileName);
            } else {
                throw new JRException("No output specified for the exporter.");
            }
        }
        try {
            os = new FileOutputStream(destFile);
            this.writer = new OutputStreamWriter(os, encoding);
            this.exportReportToWriter();
        }
        catch (IOException e) {
            throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), e);
        }
        finally {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void exportReportToWriter() throws JRException, IOException {
        for (int reportIndex = 0; reportIndex < this.jasperPrintList.size(); ++reportIndex) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(reportIndex);
            List pages = this.jasperPrint.getPages();
            if (pages == null || pages.size() <= 0) continue;
            if (this.isModeBatch) {
                this.startPageIndex = 0;
                this.endPageIndex = pages.size() - 1;
            }
            for (int i = this.startPageIndex; i <= this.endPageIndex; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                JRPrintPage page = (JRPrintPage)pages.get(i);
                this.exportPage(page);
            }
        }
        this.writer.flush();
    }

    protected void exportPage(JRPrintPage page) throws IOException {
        JRGridLayout layout = new JRGridLayout((ExporterNature)JRCsvExporterNature.getInstance(), page.getElements(), this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, null);
        JRExporterGridCell[][] grid = layout.getGrid();
        boolean[] isRowUsed = layout.getIsRowNotEmpty();
        boolean[] isColUsed = layout.getIsColumnNotEmpty();
        StringBuffer rowbuffer = null;
        JRPrintElement element = null;
        String text = null;
        boolean isFirstColumn = true;
        for (int y = 0; y < grid.length; ++y) {
            rowbuffer = new StringBuffer();
            if (!isRowUsed[y]) continue;
            isFirstColumn = true;
            for (int x = 0; x < grid[y].length; ++x) {
                if (grid[y][x].getWrapper() != null) {
                    element = grid[y][x].getWrapper().getElement();
                    if (!(element instanceof JRPrintText)) continue;
                    JRStyledText styledText = this.getStyledText((JRPrintText)element);
                    text = styledText == null ? "" : styledText.getText();
                    if (!isFirstColumn) {
                        rowbuffer.append(this.delimiter);
                    }
                    rowbuffer.append(this.prepareText(text));
                    isFirstColumn = false;
                    continue;
                }
                if (!isColUsed[x]) continue;
                if (!isFirstColumn) {
                    rowbuffer.append(this.delimiter);
                }
                isFirstColumn = false;
            }
            if (rowbuffer.length() <= 0) continue;
            this.writer.write(rowbuffer.toString());
            this.writer.write(this.recordDelimiter);
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        JRStyledText styledText = null;
        String text = textElement.getText();
        if (text != null) {
            if (textElement.isStyledText()) {
                try {
                    styledText = this.styledTextParser.parse(null, text);
                }
                catch (SAXException e) {
                    // empty catch block
                }
            }
            if (styledText == null) {
                styledText = new JRStyledText();
                styledText.append(text);
                styledText.addRun(new JRStyledText.Run(null, 0, text.length()));
            }
        }
        return styledText;
    }

    protected String prepareText(String source) {
        String str = null;
        if (source != null) {
            boolean putQuotes = false;
            if (source.indexOf(this.delimiter) >= 0 || source.indexOf(this.recordDelimiter) >= 0) {
                putQuotes = true;
            }
            StringBuffer sbuffer = new StringBuffer();
            StringTokenizer tkzer = new StringTokenizer(source, "\"\n", true);
            String token = null;
            while (tkzer.hasMoreTokens()) {
                token = tkzer.nextToken();
                if ("\"".equals(token)) {
                    putQuotes = true;
                    sbuffer.append("\"\"");
                    continue;
                }
                if ("\n".equals(token)) {
                    putQuotes = true;
                    sbuffer.append("\n");
                    continue;
                }
                sbuffer.append(token);
            }
            str = sbuffer.toString();
            if (putQuotes) {
                str = "\"" + str + "\"";
            }
        }
        return str;
    }
}

