/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.awt.Color;
import java.util.Collection;
import net.sf.jasperreports.charts.util.JRAxisFormat;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.xml.sax.Attributes;

public class JRChartFactory
extends JRBaseFactory {
    public Object createObject(Attributes atts) {
        String chartCustomizerClass;
        String bookmarkLevelAttr;
        Byte hyperlinkTarget;
        String hyperlinkType;
        Byte evaluationTime;
        JRXmlLoader xmlLoader = (JRXmlLoader)this.digester.peek(this.digester.getCount() - 1);
        Collection groupEvaluatedCharts = xmlLoader.getGroupEvaluatedCharts();
        JRDesignChart chart = (JRDesignChart)this.digester.peek();
        String isShowLegend = atts.getValue("isShowLegend");
        if (isShowLegend != null && isShowLegend.length() > 0) {
            chart.setShowLegend(Boolean.valueOf(isShowLegend));
        }
        if ((evaluationTime = (Byte)JRXmlConstants.getEvaluationTimeMap().get(atts.getValue("evaluationTime"))) != null) {
            chart.setEvaluationTime(evaluationTime);
        }
        if (chart.getEvaluationTime() == 5) {
            groupEvaluatedCharts.add(chart);
            String groupName = atts.getValue("evaluationGroup");
            if (groupName != null) {
                JRDesignGroup group = new JRDesignGroup();
                group.setName(groupName);
                chart.setEvaluationGroup(group);
            }
        }
        if ((hyperlinkType = atts.getValue("hyperlinkType")) != null) {
            chart.setLinkType(hyperlinkType);
        }
        if ((hyperlinkTarget = (Byte)JRXmlConstants.getHyperlinkTargetMap().get(atts.getValue("hyperlinkTarget"))) != null) {
            chart.setHyperlinkTarget(hyperlinkTarget);
        }
        if ((bookmarkLevelAttr = atts.getValue("bookmarkLevel")) != null) {
            chart.setBookmarkLevel(Integer.parseInt(bookmarkLevelAttr));
        }
        if ((chartCustomizerClass = atts.getValue("customizerClass")) != null && chartCustomizerClass.length() > 0) {
            chart.setCustomizerClass(chartCustomizerClass);
        }
        return chart;
    }

    public static class JRChartAxisFormatFactory
    extends JRBaseFactory {
        public Object createObject(Attributes atts) throws JRException {
            Color color;
            JRAxisFormat axisLabel = new JRAxisFormat();
            String attrValue = atts.getValue("labelColor");
            if (attrValue != null && attrValue.length() > 0) {
                color = JRXmlConstants.getColor(attrValue, null);
                axisLabel.setLabelColor(color);
            }
            if ((attrValue = atts.getValue("tickLabelColor")) != null && attrValue.length() > 0) {
                color = JRXmlConstants.getColor(attrValue, null);
                axisLabel.setTickLabelColor(color);
            }
            if ((attrValue = atts.getValue("tickLabelMask")) != null && attrValue.length() > 0) {
                axisLabel.setTickLabelMask(attrValue);
            }
            if ((attrValue = atts.getValue("axisLineColor")) != null && attrValue.length() > 0) {
                color = JRXmlConstants.getColor(attrValue, null);
                axisLabel.setLineColor(color);
            }
            return axisLabel;
        }
    }

    public static class JRChartLegendFactory
    extends JRBaseFactory {
        public Object createObject(Attributes atts) throws JRException {
            Color color;
            JRDesignChart chart = (JRDesignChart)this.digester.peek();
            String attrValue = atts.getValue("textColor");
            if (attrValue != null && attrValue.length() > 0) {
                color = JRXmlConstants.getColor(attrValue, null);
                chart.setLegendColor(color);
            }
            if ((attrValue = atts.getValue("backgroundColor")) != null && attrValue.length() > 0) {
                color = JRXmlConstants.getColor(attrValue, null);
                chart.setLegendBackgroundColor(color);
            }
            return chart;
        }
    }

    public static class JRChartSubtitleFactory
    extends JRBaseFactory {
        public Object createObject(Attributes atts) {
            JRDesignChart chart = (JRDesignChart)this.digester.peek();
            Color color = JRXmlConstants.getColor(atts.getValue("color"), Color.black);
            if (color != null) {
                chart.setSubtitleColor(color);
            }
            return chart;
        }
    }

    public static class JRChartTitleFactory
    extends JRBaseFactory {
        public Object createObject(Attributes atts) {
            Color color;
            JRDesignChart chart = (JRDesignChart)this.digester.peek();
            String position = atts.getValue("position");
            if (position != null && position.length() > 0) {
                chart.setTitlePosition((Byte)JRXmlConstants.getChartTitlePositionMap().get(position));
            }
            if ((color = JRXmlConstants.getColor(atts.getValue("color"), Color.black)) != null) {
                chart.setTitleColor(color);
            }
            return chart;
        }
    }
}

