/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovyjarjarasm.asm.AnnotationVisitor;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.ClassWriter;
import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NegationExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.RegexExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.classgen.ClassGenerator;
import org.codehaus.groovy.classgen.CompileStack;
import org.codehaus.groovy.classgen.DummyClassGenerator;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.classgen.MethodCaller;
import org.codehaus.groovy.classgen.MethodCallerMultiAdapter;
import org.codehaus.groovy.classgen.Variable;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.syntax.RuntimeParserException;

public class AsmClassGenerator
extends ClassGenerator {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private ClassVisitor cw;
    private MethodVisitor cv;
    private GeneratorContext context;
    private String sourceFile;
    private ClassNode classNode;
    private ClassNode outermostClass;
    private String internalClassName;
    private String internalBaseClassName;
    private CompileStack compileStack;
    private boolean outputReturn;
    private boolean leftHandExpression = false;
    MethodCallerMultiAdapter invokeMethodOnCurrent = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeMethodOnCurrent", true, false);
    MethodCallerMultiAdapter invokeMethodOnSuper = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeMethodOnSuper", true, false);
    MethodCallerMultiAdapter invokeMethod = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeMethod", true, false);
    MethodCallerMultiAdapter invokeStaticMethod = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeStaticMethod", true, true);
    MethodCallerMultiAdapter invokeNew = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "invokeNew", true, true);
    MethodCallerMultiAdapter setField = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "setField", false, false);
    MethodCallerMultiAdapter getField = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "getField", false, false);
    MethodCallerMultiAdapter setGroovyObjectField = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "setGroovyObjectField", false, false);
    MethodCallerMultiAdapter getGroovyObjectField = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "getGroovyObjectField", false, false);
    MethodCallerMultiAdapter setFieldOnSuper = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "setFieldOnSuper", false, false);
    MethodCallerMultiAdapter getFieldOnSuper = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "getFieldOnSuper", false, false);
    MethodCallerMultiAdapter setProperty = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "setProperty", false, false);
    MethodCallerMultiAdapter getProperty = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "getProperty", false, false);
    MethodCallerMultiAdapter setGroovyObjectProperty = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "setGroovyObjectProperty", false, false);
    MethodCallerMultiAdapter getGroovyObjectProperty = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "getGroovyObjectProperty", false, false);
    MethodCallerMultiAdapter setPropertyOnSuper = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "setPropertyOnSuper", false, false);
    MethodCallerMultiAdapter getPropertyOnSuper = MethodCallerMultiAdapter.newStatic(ScriptBytecodeAdapter.class, "getPropertyOnSuper", false, false);
    MethodCaller iteratorNextMethod = MethodCaller.newInterface(Iterator.class, "next");
    MethodCaller iteratorHasNextMethod = MethodCaller.newInterface(Iterator.class, "hasNext");
    MethodCaller assertFailedMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "assertFailed");
    MethodCaller isCaseMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "isCase");
    MethodCaller compareIdenticalMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "compareIdentical");
    MethodCaller compareEqualMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "compareEqual");
    MethodCaller compareNotEqualMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "compareNotEqual");
    MethodCaller compareToMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "compareTo");
    MethodCaller compareLessThanMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "compareLessThan");
    MethodCaller compareLessThanEqualMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "compareLessThanEqual");
    MethodCaller compareGreaterThanMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "compareGreaterThan");
    MethodCaller compareGreaterThanEqualMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "compareGreaterThanEqual");
    MethodCaller findRegexMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "findRegex");
    MethodCaller matchRegexMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "matchRegex");
    MethodCaller regexPattern = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "regexPattern");
    MethodCaller spreadMap = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "spreadMap");
    MethodCaller despreadList = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "despreadList");
    MethodCaller getMethodPointer = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "getMethodPointer");
    MethodCaller invokeClosureMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "invokeClosure");
    MethodCaller negation = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "negate");
    MethodCaller bitNegation = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "bitNegate");
    MethodCaller asTypeMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "asType");
    MethodCaller castToTypeMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "castToType");
    MethodCaller createListMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "createList");
    MethodCaller createTupleMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "createTuple");
    MethodCaller createMapMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "createMap");
    MethodCaller createRangeMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "createRange");
    MethodCaller createPojoWrapperMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "createPojoWrapper");
    MethodCaller createGroovyObjectWrapperMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "createGroovyObjectWrapper");
    MethodCaller selectConstructorAndTransformArguments = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "selectConstructorAndTransformArguments");
    private List exceptionBlocks = new ArrayList();
    private Set syntheticStaticFields = new HashSet();
    private boolean passingClosureParams;
    private ConstructorNode constructorNode;
    private MethodNode methodNode;
    private BytecodeHelper helper = new BytecodeHelper(null);
    public static final boolean CREATE_DEBUG_INFO = true;
    public static final boolean CREATE_LINE_NUMBER_INFO = true;
    private static final boolean MARK_START = true;
    public static final boolean ASM_DEBUG = false;
    private int lineNumber = -1;
    private int columnNumber = -1;
    private ASTNode currentASTNode = null;
    private DummyClassGenerator dummyGen = null;
    private ClassWriter dummyClassWriter = null;
    private ClassNode interfaceClassLoadingClass;
    private boolean implicitThis = false;

    public AsmClassGenerator(GeneratorContext context, ClassVisitor classVisitor, ClassLoader classLoader, String sourceFile) {
        super(classLoader);
        this.context = context;
        this.cw = classVisitor;
        this.sourceFile = sourceFile;
        this.dummyClassWriter = new ClassWriter(true);
        this.dummyGen = new DummyClassGenerator(context, this.dummyClassWriter, classLoader, sourceFile);
        this.compileStack = new CompileStack();
    }

    protected SourceUnit getSourceUnit() {
        return null;
    }

    public void visitClass(ClassNode classNode) {
        try {
            this.syntheticStaticFields.clear();
            this.classNode = classNode;
            this.outermostClass = null;
            this.internalClassName = BytecodeHelper.getClassInternalName(classNode);
            this.internalBaseClassName = BytecodeHelper.getClassInternalName(classNode.getSuperClass());
            this.cw.visit(47, classNode.getModifiers(), this.internalClassName, null, this.internalBaseClassName, BytecodeHelper.getClassInternalNames(classNode.getInterfaces()));
            this.cw.visitSource(this.sourceFile, null);
            if (classNode.isInterface()) {
                ClassNode owner = classNode;
                if (owner instanceof InnerClassNode) {
                    owner = owner.getOuterClass();
                }
                String outerClassName = owner.getName();
                String name = outerClassName + "$" + this.context.getNextInnerClassIdx();
                this.interfaceClassLoadingClass = new InnerClassNode(owner, name, 4128, ClassHelper.OBJECT_TYPE);
                super.visitClass(classNode);
                this.createInterfaceSyntheticStaticFields();
            } else {
                super.visitClass(classNode);
                this.createMopMethods();
                this.createSyntheticStaticFields();
            }
            Iterator iter = this.innerClasses.iterator();
            while (iter.hasNext()) {
                ClassNode innerClass = (ClassNode)iter.next();
                String innerClassName = innerClass.getName();
                String innerClassInternalName = BytecodeHelper.getClassInternalName(innerClassName);
                int index = innerClassName.lastIndexOf(36);
                if (index >= 0) {
                    innerClassName = innerClassName.substring(index + 1);
                }
                String outerClassName = this.internalClassName;
                MethodNode enclosingMethod = innerClass.getEnclosingMethod();
                if (enclosingMethod != null) {
                    outerClassName = null;
                    innerClassName = null;
                }
                this.cw.visitInnerClass(innerClassInternalName, outerClassName, innerClassName, innerClass.getModifiers());
            }
            this.cw.visitEnd();
        }
        catch (GroovyRuntimeException e) {
            e.setModule(classNode.getModule());
            throw e;
        }
    }

    private void createMopMethods() {
        this.visitMopMethodList(this.classNode.getMethods(), true);
        this.visitMopMethodList(this.classNode.getSuperClass().getAllDeclaredMethods(), false);
    }

    private String[] buildExceptions(ClassNode[] exceptions) {
        if (exceptions == null) {
            return null;
        }
        String[] ret = new String[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            ret[i] = BytecodeHelper.getClassInternalName(exceptions[i]);
        }
        return ret;
    }

    private void visitMopMethodList(List methods, boolean isThis) {
        LinkedList<MethodNode> mopCalls = new LinkedList<MethodNode>();
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            String name;
            String methodName;
            MethodNode mn = (MethodNode)iter.next();
            if ((mn.getModifiers() & 0x400) != 0 || isThis ^ (mn.getModifiers() & 5) == 0 || AsmClassGenerator.isMopMethod(methodName = mn.getName()) || methodName.startsWith("<") || this.containsMethod(methods, name = AsmClassGenerator.getMopMethodName(mn, isThis), mn.getParameters())) continue;
            mopCalls.add(mn);
        }
        this.generateMopCalls(mopCalls, isThis);
        mopCalls.clear();
    }

    private boolean containsMethod(List methods, String name, Parameter[] paras) {
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            MethodNode element = (MethodNode)iter.next();
            if (!element.getName().equals(name) || !this.equalParameterTypes(paras, element.getParameters())) continue;
            return true;
        }
        return false;
    }

    private boolean equalParameterTypes(Parameter[] p1, Parameter[] p2) {
        if (p1.length != p2.length) {
            return false;
        }
        for (int i = 0; i < p1.length; ++i) {
            if (p1[i].getType().equals(p2[i].getType())) continue;
            return false;
        }
        return true;
    }

    private void generateMopCalls(LinkedList mopCalls, boolean useThis) {
        Iterator iter = mopCalls.iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            String name = AsmClassGenerator.getMopMethodName(method, useThis);
            Parameter[] parameters = method.getParameters();
            String methodDescriptor = BytecodeHelper.getMethodDescriptor(method.getReturnType(), method.getParameters());
            this.cv = this.cw.visitMethod(0, name, methodDescriptor, null, null);
            this.cv.visitVarInsn(25, 0);
            BytecodeHelper helper = new BytecodeHelper(this.cv);
            int newRegister = 1;
            for (int i = 0; i < parameters.length; ++i) {
                ClassNode type = parameters[i].getType();
                helper.load(parameters[i].getType(), newRegister);
                ++newRegister;
                if (type != ClassHelper.double_TYPE && type != ClassHelper.long_TYPE) continue;
                ++newRegister;
            }
            this.cv.visitMethodInsn(183, BytecodeHelper.getClassInternalName(method.getDeclaringClass()), method.getName(), methodDescriptor);
            helper.doReturn(method.getReturnType());
            this.cv.visitMaxs(0, 0);
            this.cv.visitEnd();
            this.classNode.addMethod(name, 0, method.getReturnType(), parameters, null, null);
        }
    }

    public static String getMopMethodName(MethodNode method, boolean useThis) {
        int distance = 0;
        for (ClassNode declaringNode = method.getDeclaringClass(); declaringNode != null; declaringNode = declaringNode.getSuperClass()) {
            ++distance;
        }
        return (useThis ? "this" : "super") + "$" + distance + "$" + method.getName();
    }

    public static boolean isMopMethod(String methodName) {
        return methodName.startsWith("this$") || methodName.startsWith("super$");
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        String methodType = BytecodeHelper.getMethodDescriptor(node.getReturnType(), node.getParameters());
        this.cv = this.cw.visitMethod(node.getModifiers(), node.getName(), methodType, null, this.buildExceptions(node.getExceptions()));
        this.helper = new BytecodeHelper(this.cv);
        if (!node.isAbstract()) {
            Statement code = node.getCode();
            if (isConstructor && (code == null || !this.firstStatementIsSpecialConstructorCall(node))) {
                this.cv.visitVarInsn(25, 0);
                this.cv.visitMethodInsn(183, BytecodeHelper.getClassInternalName(this.classNode.getSuperClass()), "<init>", "()V");
            }
            this.compileStack.init(node.getVariableScope(), node.getParameters(), this.cv, this.classNode);
            new ClassExpression(this.classNode).visit(this);
            this.cv.visitInsn(87);
            new ClassExpression(ClassHelper.METACLASS_TYPE).visit(this);
            this.cv.visitInsn(87);
            super.visitConstructorOrMethod(node, isConstructor);
            if (!this.outputReturn || node.isVoidMethod()) {
                this.cv.visitInsn(177);
            }
            this.compileStack.clear();
            Iterator iter = this.exceptionBlocks.iterator();
            while (iter.hasNext()) {
                Runnable runnable = (Runnable)iter.next();
                runnable.run();
            }
            this.exceptionBlocks.clear();
            this.cv.visitMaxs(0, 0);
        }
    }

    private boolean firstStatementIsSpecialConstructorCall(MethodNode node) {
        Statement code = node.getFirstStatement();
        if (code == null || !(code instanceof ExpressionStatement)) {
            return false;
        }
        Expression expression = ((ExpressionStatement)code).getExpression();
        if (!(expression instanceof ConstructorCallExpression)) {
            return false;
        }
        ConstructorCallExpression cce = (ConstructorCallExpression)expression;
        return cce.isSpecialCall();
    }

    public void visitConstructor(ConstructorNode node) {
        this.constructorNode = node;
        this.methodNode = null;
        this.outputReturn = false;
        super.visitConstructor(node);
    }

    public void visitMethod(MethodNode node) {
        this.constructorNode = null;
        this.methodNode = node;
        this.outputReturn = false;
        super.visitMethod(node);
    }

    public void visitField(FieldNode fieldNode) {
        this.onLineNumber(fieldNode, "visitField: " + fieldNode.getName());
        ClassNode t = fieldNode.getType();
        this.cw.visitField(fieldNode.getModifiers(), fieldNode.getName(), BytecodeHelper.getTypeDescription(t), null, null);
        this.visitAnnotations(fieldNode);
    }

    public void visitProperty(PropertyNode statement) {
        this.onLineNumber(statement, "visitProperty:" + statement.getField().getName());
        this.methodNode = null;
    }

    protected void visitStatement(Statement statement) {
        String name = statement.getStatementLabel();
        if (name != null) {
            Label label = this.compileStack.createLocalLabel(name);
            this.cv.visitLabel(label);
        }
    }

    public void visitBlockStatement(BlockStatement block) {
        this.onLineNumber(block, "visitBlockStatement");
        this.visitStatement(block);
        this.compileStack.pushVariableScope(block.getVariableScope());
        super.visitBlockStatement(block);
        this.compileStack.pop();
    }

    public void visitForLoop(ForStatement loop) {
        this.onLineNumber(loop, "visitForLoop");
        this.visitStatement(loop);
        this.compileStack.pushLoop(loop.getVariableScope(), loop.getStatementLabel());
        Variable variable = this.compileStack.defineVariable(loop.getVariable(), false);
        MethodCallExpression iterator = new MethodCallExpression(loop.getCollectionExpression(), "iterator", (Expression)new ArgumentListExpression());
        iterator.visit(this);
        int iteratorIdx = this.compileStack.defineTemporaryVariable("iterator", ClassHelper.make(Iterator.class), true);
        Label continueLabel = this.compileStack.getContinueLabel();
        Label breakLabel = this.compileStack.getBreakLabel();
        this.cv.visitLabel(continueLabel);
        this.cv.visitVarInsn(25, iteratorIdx);
        this.iteratorHasNextMethod.call(this.cv);
        this.cv.visitJumpInsn(153, breakLabel);
        this.cv.visitVarInsn(25, iteratorIdx);
        this.iteratorNextMethod.call(this.cv);
        this.helper.storeVar(variable);
        loop.getLoopBlock().visit(this);
        this.cv.visitJumpInsn(167, continueLabel);
        this.cv.visitLabel(breakLabel);
        this.compileStack.pop();
    }

    public void visitWhileLoop(WhileStatement loop) {
        this.onLineNumber(loop, "visitWhileLoop");
        this.visitStatement(loop);
        this.compileStack.pushLoop(loop.getStatementLabel());
        Label continueLabel = this.compileStack.getContinueLabel();
        Label breakLabel = this.compileStack.getBreakLabel();
        this.cv.visitLabel(continueLabel);
        loop.getBooleanExpression().visit(this);
        this.cv.visitJumpInsn(153, breakLabel);
        loop.getLoopBlock().visit(this);
        this.cv.visitJumpInsn(167, continueLabel);
        this.cv.visitLabel(breakLabel);
        this.compileStack.pop();
    }

    public void visitDoWhileLoop(DoWhileStatement loop) {
        this.onLineNumber(loop, "visitDoWhileLoop");
        this.visitStatement(loop);
        this.compileStack.pushLoop(loop.getStatementLabel());
        Label breakLabel = this.compileStack.getBreakLabel();
        Label continueLabel = this.compileStack.getContinueLabel();
        this.cv.visitLabel(continueLabel);
        loop.getLoopBlock().visit(this);
        loop.getBooleanExpression().visit(this);
        this.cv.visitJumpInsn(153, continueLabel);
        this.cv.visitLabel(breakLabel);
        this.compileStack.pop();
    }

    public void visitIfElse(IfStatement ifElse) {
        this.onLineNumber(ifElse, "visitIfElse");
        this.visitStatement(ifElse);
        ifElse.getBooleanExpression().visit(this);
        Label l0 = new Label();
        this.cv.visitJumpInsn(153, l0);
        ifElse.getIfBlock().visit(this);
        Label l1 = new Label();
        this.cv.visitJumpInsn(167, l1);
        this.cv.visitLabel(l0);
        ifElse.getElseBlock().visit(this);
        this.cv.visitLabel(l1);
    }

    public void visitTernaryExpression(TernaryExpression expression) {
        this.onLineNumber(expression, "visitTernaryExpression");
        expression.getBooleanExpression().visit(this);
        Label l0 = new Label();
        this.cv.visitJumpInsn(153, l0);
        this.visitAndAutoboxBoolean(expression.getTrueExpression());
        Label l1 = new Label();
        this.cv.visitJumpInsn(167, l1);
        this.cv.visitLabel(l0);
        this.visitAndAutoboxBoolean(expression.getFalseExpression());
        this.cv.visitLabel(l1);
    }

    public void visitAssertStatement(AssertStatement statement) {
        this.onLineNumber(statement, "visitAssertStatement");
        this.visitStatement(statement);
        BooleanExpression booleanExpression = statement.getBooleanExpression();
        booleanExpression.visit(this);
        Label l0 = new Label();
        this.cv.visitJumpInsn(153, l0);
        Label l1 = new Label();
        this.cv.visitJumpInsn(167, l1);
        this.cv.visitLabel(l0);
        String expressionText = booleanExpression.getText();
        ArrayList list = new ArrayList();
        this.addVariableNames(booleanExpression, list);
        if (list.isEmpty()) {
            this.cv.visitLdcInsn(expressionText);
        } else {
            boolean first = true;
            this.cv.visitTypeInsn(187, "java/lang/StringBuffer");
            this.cv.visitInsn(89);
            this.cv.visitLdcInsn(expressionText + ". Values: ");
            this.cv.visitMethodInsn(183, "java/lang/StringBuffer", "<init>", "(Ljava/lang/String;)V");
            int tempIndex = this.compileStack.defineTemporaryVariable("assert", true);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                String text = name + " = ";
                if (first) {
                    first = false;
                } else {
                    text = ", " + text;
                }
                this.cv.visitVarInsn(25, tempIndex);
                this.cv.visitLdcInsn(text);
                this.cv.visitMethodInsn(182, "java/lang/StringBuffer", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuffer;");
                this.cv.visitInsn(87);
                this.cv.visitVarInsn(25, tempIndex);
                new VariableExpression(name).visit(this);
                this.cv.visitMethodInsn(182, "java/lang/StringBuffer", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuffer;");
                this.cv.visitInsn(87);
            }
            this.cv.visitVarInsn(25, tempIndex);
            this.compileStack.removeVar(tempIndex);
        }
        statement.getMessageExpression().visit(this);
        this.assertFailedMethod.call(this.cv);
        this.cv.visitLabel(l1);
    }

    private void addVariableNames(Expression expression, List list) {
        if (expression instanceof BooleanExpression) {
            BooleanExpression boolExp = (BooleanExpression)expression;
            this.addVariableNames(boolExp.getExpression(), list);
        } else if (expression instanceof BinaryExpression) {
            BinaryExpression binExp = (BinaryExpression)expression;
            this.addVariableNames(binExp.getLeftExpression(), list);
            this.addVariableNames(binExp.getRightExpression(), list);
        } else if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            list.add(varExp.getName());
        }
    }

    public void visitTryCatchFinally(TryCatchStatement statement) {
        this.onLineNumber(statement, "visitTryCatchFinally");
        this.visitStatement(statement);
        CatchStatement catchStatement = statement.getCatchStatement(0);
        Statement tryStatement = statement.getTryStatement();
        final Statement finallyStatement = statement.getFinallyStatement();
        int anyExceptionIndex = this.compileStack.defineTemporaryVariable("exception", false);
        if (!finallyStatement.isEmpty()) {
            this.compileStack.pushFinallyBlock(new Runnable(){

                public void run() {
                    finallyStatement.visit(AsmClassGenerator.this);
                }
            });
        }
        final Label tryStart = new Label();
        this.cv.visitLabel(tryStart);
        tryStatement.visit(this);
        Label finallyStart = new Label();
        this.cv.visitJumpInsn(167, finallyStart);
        final Label tryEnd = new Label();
        this.cv.visitLabel(tryEnd);
        Iterator it = statement.getCatchStatements().iterator();
        while (it.hasNext()) {
            catchStatement = (CatchStatement)it.next();
            ClassNode exceptionType = catchStatement.getExceptionType();
            final Label catchStart = new Label();
            this.cv.visitLabel(catchStart);
            this.compileStack.defineVariable(catchStatement.getVariable(), true);
            catchStatement.visit(this);
            this.cv.visitJumpInsn(167, finallyStart);
            final String exceptionTypeInternalName = BytecodeHelper.getClassInternalName(exceptionType);
            this.exceptionBlocks.add(new Runnable(){

                public void run() {
                    AsmClassGenerator.this.cv.visitTryCatchBlock(tryStart, tryEnd, catchStart, exceptionTypeInternalName);
                }
            });
        }
        final Label endOfAllCatches = new Label();
        this.cv.visitLabel(endOfAllCatches);
        if (!finallyStatement.isEmpty()) {
            this.compileStack.popFinallyBlock();
        }
        this.cv.visitLabel(finallyStart);
        finallyStatement.visit(this);
        Label afterFinally = new Label();
        this.cv.visitJumpInsn(167, afterFinally);
        final Label catchAny = new Label();
        this.cv.visitLabel(catchAny);
        this.cv.visitVarInsn(58, anyExceptionIndex);
        finallyStatement.visit(this);
        this.cv.visitVarInsn(25, anyExceptionIndex);
        this.cv.visitInsn(191);
        this.cv.visitLabel(afterFinally);
        this.exceptionBlocks.add(new Runnable(){

            public void run() {
                AsmClassGenerator.this.cv.visitTryCatchBlock(tryStart, endOfAllCatches, catchAny, null);
            }
        });
    }

    public void visitSwitch(SwitchStatement statement) {
        int i;
        this.onLineNumber(statement, "visitSwitch");
        this.visitStatement(statement);
        statement.getExpression().visit(this);
        Label breakLabel = this.compileStack.pushSwitch();
        int switchVariableIndex = this.compileStack.defineTemporaryVariable("switch", true);
        List caseStatements = statement.getCaseStatements();
        int caseCount = caseStatements.size();
        Label[] labels = new Label[caseCount + 1];
        for (i = 0; i < caseCount; ++i) {
            labels[i] = new Label();
        }
        i = 0;
        Iterator iter = caseStatements.iterator();
        while (iter.hasNext()) {
            CaseStatement caseStatement = (CaseStatement)iter.next();
            this.visitCaseStatement(caseStatement, switchVariableIndex, labels[i], labels[i + 1]);
            ++i;
        }
        statement.getDefaultStatement().visit(this);
        this.cv.visitLabel(breakLabel);
        this.compileStack.pop();
    }

    public void visitCaseStatement(CaseStatement statement) {
    }

    public void visitCaseStatement(CaseStatement statement, int switchVariableIndex, Label thisLabel, Label nextLabel) {
        this.onLineNumber(statement, "visitCaseStatement");
        this.cv.visitVarInsn(25, switchVariableIndex);
        statement.getExpression().visit(this);
        this.isCaseMethod.call(this.cv);
        Label l0 = new Label();
        this.cv.visitJumpInsn(153, l0);
        this.cv.visitLabel(thisLabel);
        statement.getCode().visit(this);
        if (nextLabel != null) {
            this.cv.visitJumpInsn(167, nextLabel);
        }
        this.cv.visitLabel(l0);
    }

    public void visitBreakStatement(BreakStatement statement) {
        this.onLineNumber(statement, "visitBreakStatement");
        this.visitStatement(statement);
        String name = statement.getLabel();
        Label breakLabel = this.compileStack.getNamedBreakLabel(name);
        this.compileStack.applyFinallyBlocks(breakLabel, true);
        this.cv.visitJumpInsn(167, breakLabel);
    }

    public void visitContinueStatement(ContinueStatement statement) {
        this.onLineNumber(statement, "visitContinueStatement");
        this.visitStatement(statement);
        String name = statement.getLabel();
        Label continueLabel = this.compileStack.getContinueLabel();
        if (name != null) {
            continueLabel = this.compileStack.getNamedContinueLabel(name);
        }
        this.compileStack.applyFinallyBlocks(continueLabel, false);
        this.cv.visitJumpInsn(167, continueLabel);
    }

    public void visitSynchronizedStatement(SynchronizedStatement statement) {
        this.onLineNumber(statement, "visitSynchronizedStatement");
        this.visitStatement(statement);
        statement.getExpression().visit(this);
        final int index = this.compileStack.defineTemporaryVariable("synchronized", ClassHelper.Integer_TYPE, true);
        final Label synchronizedStart = new Label();
        Label synchronizedEnd = new Label();
        final Label catchAll = new Label();
        this.cv.visitVarInsn(25, index);
        this.cv.visitInsn(194);
        this.cv.visitLabel(synchronizedStart);
        Runnable finallyPart = new Runnable(){

            public void run() {
                AsmClassGenerator.this.cv.visitVarInsn(25, index);
                AsmClassGenerator.this.cv.visitInsn(195);
            }
        };
        this.compileStack.pushFinallyBlock(finallyPart);
        statement.getCode().visit(this);
        finallyPart.run();
        this.cv.visitJumpInsn(167, synchronizedEnd);
        this.cv.visitLabel(catchAll);
        finallyPart.run();
        this.cv.visitInsn(191);
        this.cv.visitLabel(synchronizedEnd);
        this.compileStack.popFinallyBlock();
        this.exceptionBlocks.add(new Runnable(){

            public void run() {
                AsmClassGenerator.this.cv.visitTryCatchBlock(synchronizedStart, catchAll, catchAll, null);
            }
        });
    }

    public void visitThrowStatement(ThrowStatement statement) {
        this.onLineNumber(statement, "visitThrowStatement");
        this.visitStatement(statement);
        statement.getExpression().visit(this);
        this.cv.visitTypeInsn(192, "java/lang/Throwable");
        this.cv.visitInsn(191);
    }

    public void visitReturnStatement(ReturnStatement statement) {
        this.onLineNumber(statement, "visitReturnStatement");
        this.visitStatement(statement);
        ClassNode returnType = this.methodNode.getReturnType();
        if (returnType == ClassHelper.VOID_TYPE) {
            if (statement != ReturnStatement.RETURN_NULL_OR_VOID) {
                this.throwException("Cannot use return statement with an expression on a method that returns void");
            }
            this.compileStack.applyFinallyBlocks();
            this.cv.visitInsn(177);
            this.outputReturn = true;
            return;
        }
        Expression expression = statement.getExpression();
        this.evaluateExpression(expression);
        if (returnType == ClassHelper.OBJECT_TYPE && expression.getType() != null && expression.getType() == ClassHelper.VOID_TYPE) {
            this.cv.visitInsn(1);
        } else {
            this.doConvertAndCast(returnType, expression, false, true, false);
            this.helper.unbox(returnType);
        }
        if (this.compileStack.hasFinallyBlocks()) {
            int returnValueIdx = this.compileStack.defineTemporaryVariable("returnValue", returnType, true);
            this.compileStack.applyFinallyBlocks();
            this.helper.load(returnType, returnValueIdx);
        }
        this.helper.doReturn(returnType);
        this.outputReturn = true;
    }

    protected void doConvertAndCast(ClassNode type, Expression expression, boolean ignoreAutoboxing, boolean forceCast, boolean coerce) {
        ClassNode expType = this.getExpressionType(expression);
        if (!ignoreAutoboxing && ClassHelper.isPrimitiveType(type)) {
            type = ClassHelper.getWrapper(type);
        }
        if (forceCast || type != null && !type.equals(expType)) {
            this.doConvertAndCast(type, coerce);
        }
    }

    protected void evaluateExpression(Expression expression) {
        this.visitAndAutoboxBoolean(expression);
        Expression assignExpr = this.createReturnLHSExpression(expression);
        if (assignExpr != null) {
            this.leftHandExpression = false;
            assignExpr.visit(this);
        }
    }

    public void visitExpressionStatement(ExpressionStatement statement) {
        this.onLineNumber(statement, "visitExpressionStatement: " + statement.getExpression().getClass().getName());
        this.visitStatement(statement);
        Expression expression = statement.getExpression();
        this.visitAndAutoboxBoolean(expression);
        if (this.isPopRequired(expression)) {
            this.cv.visitInsn(87);
        }
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        this.onLineNumber(expression, "visitDeclarationExpression: \"" + expression.getVariableExpression().getName() + "\"");
        Expression rightExpression = expression.getRightExpression();
        VariableExpression vex = expression.getVariableExpression();
        ClassNode type = vex.getType();
        if (ClassHelper.isPrimitiveType(type)) {
            rightExpression.visit(this);
        } else if (type != ClassHelper.OBJECT_TYPE) {
            this.visitCastExpression(new CastExpression(type, rightExpression));
        } else {
            this.visitAndAutoboxBoolean(rightExpression);
        }
        this.compileStack.defineVariable(vex, true);
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        this.onLineNumber(expression, "visitBinaryExpression: \"" + expression.getOperation().getText() + "\" ");
        switch (expression.getOperation().getType()) {
            case 100: {
                this.evaluateEqual(expression);
                break;
            }
            case 121: {
                this.evaluateBinaryExpression(this.compareIdenticalMethod, expression);
                break;
            }
            case 123: {
                this.evaluateBinaryExpression(this.compareEqualMethod, expression);
                break;
            }
            case 120: {
                this.evaluateBinaryExpression(this.compareNotEqualMethod, expression);
                break;
            }
            case 128: {
                this.evaluateCompareTo(expression);
                break;
            }
            case 126: {
                this.evaluateBinaryExpression(this.compareGreaterThanMethod, expression);
                break;
            }
            case 127: {
                this.evaluateBinaryExpression(this.compareGreaterThanEqualMethod, expression);
                break;
            }
            case 124: {
                this.evaluateBinaryExpression(this.compareLessThanMethod, expression);
                break;
            }
            case 125: {
                this.evaluateBinaryExpression(this.compareLessThanEqualMethod, expression);
                break;
            }
            case 164: {
                this.evaluateLogicalAndExpression(expression);
                break;
            }
            case 162: {
                this.evaluateLogicalOrExpression(expression);
                break;
            }
            case 341: {
                this.evaluateBinaryExpression("and", expression);
                break;
            }
            case 351: {
                this.evaluateBinaryExpressionWithAsignment("and", expression);
                break;
            }
            case 340: {
                this.evaluateBinaryExpression("or", expression);
                break;
            }
            case 350: {
                this.evaluateBinaryExpressionWithAsignment("or", expression);
                break;
            }
            case 342: {
                this.evaluateBinaryExpression("xor", expression);
                break;
            }
            case 352: {
                this.evaluateBinaryExpressionWithAsignment("xor", expression);
                break;
            }
            case 200: {
                this.evaluateBinaryExpression("plus", expression);
                break;
            }
            case 210: {
                this.evaluateBinaryExpressionWithAsignment("plus", expression);
                break;
            }
            case 201: {
                this.evaluateBinaryExpression("minus", expression);
                break;
            }
            case 211: {
                this.evaluateBinaryExpressionWithAsignment("minus", expression);
                break;
            }
            case 202: {
                this.evaluateBinaryExpression("multiply", expression);
                break;
            }
            case 212: {
                this.evaluateBinaryExpressionWithAsignment("multiply", expression);
                break;
            }
            case 203: {
                this.evaluateBinaryExpression("div", expression);
                break;
            }
            case 213: {
                this.evaluateBinaryExpressionWithAsignment("div", expression);
                break;
            }
            case 204: {
                this.evaluateBinaryExpression("intdiv", expression);
                break;
            }
            case 214: {
                this.evaluateBinaryExpressionWithAsignment("intdiv", expression);
                break;
            }
            case 205: {
                this.evaluateBinaryExpression("mod", expression);
                break;
            }
            case 215: {
                this.evaluateBinaryExpressionWithAsignment("mod", expression);
                break;
            }
            case 206: {
                this.evaluateBinaryExpression("power", expression);
                break;
            }
            case 216: {
                this.evaluateBinaryExpressionWithAsignment("power", expression);
                break;
            }
            case 280: {
                this.evaluateBinaryExpression("leftShift", expression);
                break;
            }
            case 285: {
                this.evaluateBinaryExpressionWithAsignment("leftShift", expression);
                break;
            }
            case 281: {
                this.evaluateBinaryExpression("rightShift", expression);
                break;
            }
            case 286: {
                this.evaluateBinaryExpressionWithAsignment("rightShift", expression);
                break;
            }
            case 282: {
                this.evaluateBinaryExpression("rightShiftUnsigned", expression);
                break;
            }
            case 287: {
                this.evaluateBinaryExpressionWithAsignment("rightShiftUnsigned", expression);
                break;
            }
            case 544: {
                this.evaluateInstanceof(expression);
                break;
            }
            case 90: {
                this.evaluateBinaryExpression(this.findRegexMethod, expression);
                break;
            }
            case 94: {
                this.evaluateBinaryExpression(this.matchRegexMethod, expression);
                break;
            }
            case 30: {
                if (this.leftHandExpression) {
                    this.throwException("Should not be called here. Possible reason: postfix operation on array.");
                    break;
                }
                this.evaluateBinaryExpression("getAt", expression);
                break;
            }
            case 573: {
                this.evaluateBinaryExpression(this.isCaseMethod, expression);
                break;
            }
            default: {
                this.throwException("Operation: " + expression.getOperation() + " not supported");
            }
        }
    }

    private void load(Expression exp) {
        boolean wasLeft = this.leftHandExpression;
        this.leftHandExpression = false;
        this.visitAndAutoboxBoolean(exp);
        this.leftHandExpression = wasLeft;
    }

    public void visitPostfixExpression(PostfixExpression expression) {
        switch (expression.getOperation().getType()) {
            case 250: {
                this.evaluatePostfixMethod("next", expression.getExpression());
                break;
            }
            case 260: {
                this.evaluatePostfixMethod("previous", expression.getExpression());
            }
        }
    }

    private void throwException(String s) {
        throw new RuntimeParserException(s, this.currentASTNode);
    }

    public void visitPrefixExpression(PrefixExpression expression) {
        switch (expression.getOperation().getType()) {
            case 250: {
                this.evaluatePrefixMethod("next", expression.getExpression());
                break;
            }
            case 260: {
                this.evaluatePrefixMethod("previous", expression.getExpression());
            }
        }
    }

    public void visitClosureExpression(ClosureExpression expression) {
        ClassNode innerClass = this.createClosureClass(expression);
        this.addInnerClass(innerClass);
        String innerClassinternalName = BytecodeHelper.getClassInternalName(innerClass);
        this.passingClosureParams = true;
        List constructors = innerClass.getDeclaredConstructors();
        ConstructorNode node = (ConstructorNode)constructors.get(0);
        Parameter[] localVariableParams = node.getParameters();
        this.cv.visitTypeInsn(187, innerClassinternalName);
        this.cv.visitInsn(89);
        if (this.isStaticMethod() || this.classNode.isStaticClass()) {
            this.visitClassExpression(new ClassExpression(this.classNode));
            this.visitClassExpression(new ClassExpression(this.getOutermostClass()));
        } else {
            this.cv.visitVarInsn(25, 0);
            this.loadThis();
        }
        for (int i = 2; i < localVariableParams.length; ++i) {
            Parameter param = localVariableParams[i];
            String name = param.getName();
            if (!this.compileStack.containsVariable(name) && this.compileStack.getScope().isReferencedClassVariable(name)) {
                this.visitFieldExpression(new FieldExpression(this.classNode.getField(name)));
                continue;
            }
            Variable v = this.compileStack.getVariable(name, this.classNode.getSuperClass() != ClassHelper.CLOSURE_TYPE);
            if (v == null) {
                FieldNode field = this.classNode.getField(name);
                this.cv.visitVarInsn(25, 0);
                this.cv.visitFieldInsn(180, this.internalClassName, name, BytecodeHelper.getTypeDescription(field.getType()));
                param.setClosureSharedVariable(false);
                v = this.compileStack.defineVariable(param, true);
                param.setClosureSharedVariable(true);
                v.setHolder(true);
            }
            this.cv.visitVarInsn(25, v.getIndex());
        }
        this.passingClosureParams = false;
        this.cv.visitMethodInsn(183, innerClassinternalName, "<init>", BytecodeHelper.getMethodDescriptor(ClassHelper.VOID_TYPE, localVariableParams));
    }

    protected void loadThisOrOwner() {
        if (this.isInnerClass()) {
            this.visitFieldExpression(new FieldExpression(this.classNode.getField("owner")));
        } else {
            this.loadThis();
        }
    }

    public void visitRegexExpression(RegexExpression expression) {
        expression.getRegex().visit(this);
        this.regexPattern.call(this.cv);
    }

    public void visitConstantExpression(ConstantExpression expression) {
        Object value = expression.getValue();
        this.helper.loadConstant(value);
    }

    public void visitSpreadExpression(SpreadExpression expression) {
        throw new GroovyBugError("SpreadExpression should not be visited here");
    }

    public void visitSpreadMapExpression(SpreadMapExpression expression) {
        Expression subExpression = expression.getExpression();
        subExpression.visit(this);
        this.spreadMap.call(this.cv);
    }

    public void visitMethodPointerExpression(MethodPointerExpression expression) {
        Expression subExpression = expression.getExpression();
        subExpression.visit(this);
        this.helper.loadConstant(expression.getMethodName());
        this.getMethodPointer.call(this.cv);
    }

    public void visitNegationExpression(NegationExpression expression) {
        Expression subExpression = expression.getExpression();
        subExpression.visit(this);
        this.negation.call(this.cv);
    }

    public void visitBitwiseNegExpression(BitwiseNegExpression expression) {
        Expression subExpression = expression.getExpression();
        subExpression.visit(this);
        this.bitNegation.call(this.cv);
    }

    public void visitCastExpression(CastExpression expression) {
        ClassNode type = expression.getType();
        this.visitAndAutoboxBoolean(expression.getExpression());
        this.doConvertAndCast(type, expression.getExpression(), expression.isIgnoringAutoboxing(), false, expression.isCoerce());
    }

    public void visitNotExpression(NotExpression expression) {
        Expression subExpression = expression.getExpression();
        subExpression.visit(this);
        if (!this.isComparisonExpression(subExpression) && !(subExpression instanceof BooleanExpression)) {
            this.helper.unbox(Boolean.TYPE);
        }
        this.helper.negateBoolean();
    }

    public void visitBooleanExpression(BooleanExpression expression) {
        this.compileStack.pushBooleanExpression();
        expression.getExpression().visit(this);
        if (!this.isComparisonExpression(expression.getExpression())) {
            this.helper.unbox(Boolean.TYPE);
        }
        this.compileStack.pop();
    }

    private void makeInvokeMethodCall(MethodCallExpression call, boolean useSuper, MethodCallerMultiAdapter adapter) {
        Expression objectExpression = call.getObjectExpression();
        if (!this.isStaticMethod() && !this.isStaticContext() && AsmClassGenerator.isThisExpression(call.getObjectExpression())) {
            objectExpression = new CastExpression(ClassHelper.make(GroovyObject.class), objectExpression);
        }
        CastExpression messageName = new CastExpression(ClassHelper.STRING_TYPE, call.getMethod());
        if (useSuper) {
            this.makeCall(new ClassExpression(this.getOutermostClass().getSuperClass()), objectExpression, messageName, call.getArguments(), adapter, call.isSafe(), call.isSpreadSafe(), false);
        } else {
            this.makeCall(objectExpression, messageName, call.getArguments(), adapter, call.isSafe(), call.isSpreadSafe(), call.isImplicitThis());
        }
    }

    private void makeCall(Expression receiver, Expression message, Expression arguments, MethodCallerMultiAdapter adapter, boolean safe, boolean spreadSafe, boolean implicitThis) {
        ClassNode cn = this.classNode;
        if (this.isInClosure() && !implicitThis) {
            cn = this.getOutermostClass();
        }
        this.makeCall(new ClassExpression(cn), receiver, message, arguments, adapter, safe, spreadSafe, implicitThis);
    }

    private void makeCall(ClassExpression sender, Expression receiver, Expression message, Expression arguments, MethodCallerMultiAdapter adapter, boolean safe, boolean spreadSafe, boolean implicitThis) {
        boolean containsSpreadExpression;
        boolean lhs = this.leftHandExpression;
        this.leftHandExpression = false;
        sender.visit(this);
        boolean oldVal = this.implicitThis;
        this.implicitThis = implicitThis;
        receiver.visit(this);
        this.implicitThis = oldVal;
        if (message != null) {
            message.visit(this);
        }
        int numberOfArguments = (containsSpreadExpression = AsmClassGenerator.containsSpreadExpression(arguments)) ? -1 : AsmClassGenerator.argumentSize(arguments);
        if (numberOfArguments > 0 || containsSpreadExpression) {
            ArgumentListExpression ae;
            if (arguments instanceof ArgumentListExpression) {
                ae = (ArgumentListExpression)arguments;
            } else if (arguments instanceof TupleExpression) {
                TupleExpression te = (TupleExpression)arguments;
                ae = new ArgumentListExpression(te.getExpressions());
            } else {
                ae = new ArgumentListExpression();
                ae.addExpression(arguments);
            }
            if (containsSpreadExpression) {
                this.despreadList(ae.getExpressions(), true);
            } else {
                ae.visit(this);
            }
        } else if (numberOfArguments > 0) {
            TupleExpression te = (TupleExpression)arguments;
            for (int i = 0; i < numberOfArguments; ++i) {
                Expression argument = te.getExpression(i);
                this.visitAndAutoboxBoolean(argument);
                if (!(argument instanceof CastExpression)) continue;
                this.loadWrapper(argument);
            }
        }
        adapter.call(this.cv, numberOfArguments, safe, spreadSafe);
        this.leftHandExpression = lhs;
    }

    private void despreadList(List expressions, boolean wrap) {
        ArrayList<ConstantExpression> spreadIndexes = new ArrayList<ConstantExpression>();
        ArrayList<Expression> spreadExpressions = new ArrayList<Expression>();
        ArrayList normalArguments = new ArrayList();
        for (int i = 0; i < expressions.size(); ++i) {
            Object expr = expressions.get(i);
            if (!(expr instanceof SpreadExpression)) {
                normalArguments.add(expr);
                continue;
            }
            spreadIndexes.add(new ConstantExpression(new Integer(i - spreadExpressions.size())));
            spreadExpressions.add(((SpreadExpression)expr).getExpression());
        }
        this.visitTupleExpression(new ArgumentListExpression(normalArguments), wrap);
        new TupleExpression(spreadExpressions).visit(this);
        new ArrayExpression(ClassHelper.int_TYPE, spreadIndexes, null).visit(this);
        this.despreadList.call(this.cv);
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        this.onLineNumber(call, "visitMethodCallExpression: \"" + call.getMethod() + "\":");
        Expression arguments = call.getArguments();
        String methodName = call.getMethodAsString();
        boolean isSuperMethodCall = AsmClassGenerator.usesSuper(call);
        boolean isThisExpression = AsmClassGenerator.isThisExpression(call.getObjectExpression());
        if (methodName != null && isThisExpression && this.isFieldOrVariable(methodName) && !this.classNode.hasPossibleMethod(methodName, arguments)) {
            this.visitVariableExpression(new VariableExpression(methodName));
            arguments.visit(this);
            this.invokeClosureMethod.call(this.cv);
        } else {
            MethodCallerMultiAdapter adapter = this.invokeMethod;
            if (isThisExpression) {
                adapter = this.invokeMethodOnCurrent;
            }
            if (isSuperMethodCall) {
                adapter = this.invokeMethodOnSuper;
            }
            if (this.isStaticInvocation(call)) {
                adapter = this.invokeStaticMethod;
            }
            this.makeInvokeMethodCall(call, isSuperMethodCall, adapter);
        }
    }

    private boolean isStaticInvocation(MethodCallExpression call) {
        if (!AsmClassGenerator.isThisExpression(call.getObjectExpression())) {
            return false;
        }
        if (this.isStaticMethod()) {
            return true;
        }
        return this.isStaticContext() && !call.isImplicitThis();
    }

    protected boolean emptyArguments(Expression arguments) {
        return AsmClassGenerator.argumentSize(arguments) == 0;
    }

    protected static boolean containsSpreadExpression(Expression arguments) {
        List args = null;
        if (arguments instanceof TupleExpression) {
            TupleExpression tupleExpression = (TupleExpression)arguments;
            args = tupleExpression.getExpressions();
        } else if (arguments instanceof ListExpression) {
            ListExpression le = (ListExpression)arguments;
            args = le.getExpressions();
        } else {
            return arguments instanceof SpreadExpression;
        }
        Iterator iter = args.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof SpreadExpression)) continue;
            return true;
        }
        return false;
    }

    protected static int argumentSize(Expression arguments) {
        if (arguments instanceof TupleExpression) {
            TupleExpression tupleExpression = (TupleExpression)arguments;
            int size = tupleExpression.getExpressions().size();
            return size;
        }
        return 1;
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        this.onLineNumber(call, "visitStaticMethodCallExpression: \"" + call.getMethod() + "\":");
        this.makeCall(new ClassExpression(call.getOwnerType()), new ConstantExpression(call.getMethod()), call.getArguments(), this.invokeStaticMethod, false, false, false);
    }

    private void visitSpecialConstructorCall(ConstructorCallExpression call) {
        ClassNode callNode = this.classNode;
        if (call.isSuperCall()) {
            callNode = callNode.getSuperClass();
        }
        List constructors = this.sortConstructors(call, callNode);
        call.getArguments().visit(this);
        this.cv.visitInsn(89);
        this.helper.pushConstant(constructors.size());
        this.visitClassExpression(new ClassExpression(callNode));
        this.selectConstructorAndTransformArguments.call(this.cv);
        this.cv.visitInsn(90);
        this.cv.visitInsn(4);
        this.cv.visitInsn(126);
        Label afterIf = new Label();
        this.cv.visitJumpInsn(153, afterIf);
        this.cv.visitInsn(3);
        this.cv.visitInsn(50);
        this.cv.visitTypeInsn(192, "[Ljava/lang/Object;");
        this.cv.visitLabel(afterIf);
        this.cv.visitInsn(95);
        this.cv.visitVarInsn(25, 0);
        this.cv.visitInsn(95);
        this.cv.visitIntInsn(16, 8);
        this.cv.visitInsn(122);
        Label[] targets = new Label[constructors.size()];
        int[] indices = new int[constructors.size()];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = new Label();
            indices[i] = i;
        }
        Label defaultLabel = new Label();
        Label afterSwitch = new Label();
        this.cv.visitLookupSwitchInsn(defaultLabel, indices, targets);
        for (int i = 0; i < targets.length; ++i) {
            this.cv.visitLabel(targets[i]);
            this.cv.visitInsn(95);
            this.cv.visitInsn(90);
            ConstructorNode cn = (ConstructorNode)constructors.get(i);
            String descriptor = BytecodeHelper.getMethodDescriptor(ClassHelper.VOID_TYPE, cn.getParameters());
            Parameter[] parameters = cn.getParameters();
            for (int p = 0; p < parameters.length; ++p) {
                this.cv.visitInsn(89);
                this.helper.pushConstant(p);
                this.cv.visitInsn(50);
                ClassNode type = parameters[p].getType();
                if (ClassHelper.isPrimitiveType(type)) {
                    this.helper.unbox(type);
                } else {
                    this.helper.doCast(type);
                }
                this.helper.swapWithObject(type);
            }
            this.cv.visitInsn(87);
            this.cv.visitMethodInsn(183, BytecodeHelper.getClassInternalName(callNode), "<init>", descriptor);
            this.cv.visitJumpInsn(167, afterSwitch);
        }
        this.cv.visitLabel(defaultLabel);
        this.cv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        this.cv.visitInsn(89);
        this.cv.visitLdcInsn("illegal constructor number");
        this.cv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        this.cv.visitInsn(191);
        this.cv.visitLabel(afterSwitch);
    }

    private List sortConstructors(ConstructorCallExpression call, ClassNode callNode) {
        ArrayList constructors = new ArrayList(callNode.getDeclaredConstructors());
        Comparator comp = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                ConstructorNode c0 = (ConstructorNode)arg0;
                ConstructorNode c1 = (ConstructorNode)arg1;
                AsmClassGenerator.this.helper;
                String descriptor0 = BytecodeHelper.getMethodDescriptor(ClassHelper.VOID_TYPE, c0.getParameters());
                AsmClassGenerator.this.helper;
                String descriptor1 = BytecodeHelper.getMethodDescriptor(ClassHelper.VOID_TYPE, c1.getParameters());
                return descriptor0.compareTo(descriptor1);
            }
        };
        Collections.sort(constructors, comp);
        return constructors;
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        TupleExpression tupleExpression;
        int size;
        this.onLineNumber(call, "visitConstructorCallExpression: \"" + call.getType().getName() + "\":");
        if (call.isSpecialCall()) {
            this.visitSpecialConstructorCall(call);
            return;
        }
        Expression arguments = call.getArguments();
        if (arguments instanceof TupleExpression && (size = (tupleExpression = (TupleExpression)arguments).getExpressions().size()) == 0) {
            arguments = MethodCallExpression.NO_ARGUMENTS;
        }
        ClassExpression receiverClass = new ClassExpression(call.getType());
        this.makeCall(receiverClass, null, arguments, this.invokeNew, false, false, false);
    }

    private static String makeFieldClassName(ClassNode type) {
        String internalName = BytecodeHelper.getClassInternalName(type);
        StringBuffer ret = new StringBuffer(internalName.length());
        for (int i = 0; i < internalName.length(); ++i) {
            char c = internalName.charAt(i);
            if (c == '/') {
                ret.append('$');
                continue;
            }
            if (c == ';') continue;
            ret.append(c);
        }
        return ret.toString();
    }

    private static String getStaticFieldName(ClassNode type) {
        ClassNode componentType = type;
        String prefix = "";
        while (componentType.isArray()) {
            prefix = prefix + "$";
            componentType = componentType.getComponentType();
        }
        if (prefix.length() != 0) {
            prefix = "array" + prefix;
        }
        String name = prefix + "class$" + AsmClassGenerator.makeFieldClassName(componentType);
        return name;
    }

    private void visitAttributeOrProperty(PropertyExpression expression, MethodCallerMultiAdapter adapter) {
        FieldNode field;
        String name;
        Expression objectExpression = expression.getObjectExpression();
        if (AsmClassGenerator.isThisExpression(objectExpression) && (name = expression.getPropertyAsString()) != null && (field = this.classNode.getField(name)) != null) {
            this.visitFieldExpression(new FieldExpression(field));
            return;
        }
        this.makeCall(objectExpression, new CastExpression(ClassHelper.STRING_TYPE, expression.getProperty()), MethodCallExpression.NO_ARGUMENTS, adapter, expression.isSafe(), expression.isSpreadSafe(), expression.isImplicitThis());
    }

    private boolean isStaticContext() {
        if (!this.isInClosure()) {
            return false;
        }
        if (this.constructorNode != null) {
            return false;
        }
        return this.classNode.isStaticClass() || this.methodNode.isStatic();
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        MethodCallerMultiAdapter adapter;
        Expression objectExpression = expression.getObjectExpression();
        if (this.leftHandExpression) {
            adapter = this.setProperty;
            if (this.isGroovyObject(objectExpression)) {
                adapter = this.setGroovyObjectProperty;
            }
            if (this.isStaticContext() && AsmClassGenerator.isThisOrSuper(objectExpression)) {
                adapter = this.setProperty;
            }
        } else {
            adapter = this.getProperty;
            if (this.isGroovyObject(objectExpression)) {
                adapter = this.getGroovyObjectProperty;
            }
            if (this.isStaticContext() && AsmClassGenerator.isThisOrSuper(objectExpression)) {
                adapter = this.getProperty;
            }
        }
        this.visitAttributeOrProperty(expression, adapter);
    }

    public void visitAttributeExpression(AttributeExpression expression) {
        MethodCallerMultiAdapter adapter;
        Expression objectExpression = expression.getObjectExpression();
        if (this.leftHandExpression) {
            adapter = this.setField;
            if (this.isGroovyObject(objectExpression)) {
                adapter = this.setGroovyObjectField;
            }
            if (AsmClassGenerator.usesSuper(expression)) {
                adapter = this.getFieldOnSuper;
            }
        } else {
            adapter = this.getField;
            if (this.isGroovyObject(objectExpression)) {
                adapter = this.getGroovyObjectField;
            }
            if (AsmClassGenerator.usesSuper(expression)) {
                adapter = this.getFieldOnSuper;
            }
        }
        this.visitAttributeOrProperty(expression, adapter);
    }

    protected boolean isGroovyObject(Expression objectExpression) {
        return AsmClassGenerator.isThisExpression(objectExpression);
    }

    public void visitFieldExpression(FieldExpression expression) {
        FieldNode field = expression.getField();
        if (field.isStatic()) {
            if (this.leftHandExpression) {
                this.storeStaticField(expression);
            } else {
                this.loadStaticField(expression);
            }
        } else if (this.leftHandExpression) {
            this.storeThisInstanceField(expression);
        } else {
            this.loadInstanceField(expression);
        }
    }

    public void loadStaticField(FieldExpression fldExp) {
        String ownerName;
        FieldNode field = fldExp.getField();
        boolean holder = field.isHolder() && !this.isInClosureConstructor();
        ClassNode type = field.getType();
        String string = ownerName = field.getOwner().equals(this.classNode) ? this.internalClassName : BytecodeHelper.getClassInternalName(field.getOwner());
        if (holder) {
            this.cv.visitFieldInsn(178, ownerName, fldExp.getFieldName(), BytecodeHelper.getTypeDescription(type));
            this.cv.visitMethodInsn(182, "groovy/lang/Reference", "get", "()Ljava/lang/Object;");
        } else {
            this.cv.visitFieldInsn(178, ownerName, fldExp.getFieldName(), BytecodeHelper.getTypeDescription(type));
            if (ClassHelper.isPrimitiveType(type)) {
                this.helper.box(type);
            }
        }
    }

    public void loadInstanceField(FieldExpression fldExp) {
        FieldNode field = fldExp.getField();
        boolean holder = field.isHolder() && !this.isInClosureConstructor();
        ClassNode type = field.getType();
        String ownerName = field.getOwner().equals(this.classNode) ? this.internalClassName : BytecodeHelper.getClassInternalName(field.getOwner());
        this.cv.visitVarInsn(25, 0);
        this.cv.visitFieldInsn(180, ownerName, fldExp.getFieldName(), BytecodeHelper.getTypeDescription(type));
        if (holder) {
            this.cv.visitMethodInsn(182, "groovy/lang/Reference", "get", "()Ljava/lang/Object;");
        } else if (ClassHelper.isPrimitiveType(type)) {
            this.helper.box(type);
        }
    }

    public void storeThisInstanceField(FieldExpression expression) {
        String ownerName;
        FieldNode field = expression.getField();
        boolean holder = field.isHolder() && !this.isInClosureConstructor();
        ClassNode type = field.getType();
        String string = ownerName = field.getOwner().equals(this.classNode) ? this.internalClassName : BytecodeHelper.getClassInternalName(field.getOwner());
        if (holder) {
            this.cv.visitVarInsn(25, 0);
            this.cv.visitFieldInsn(180, ownerName, expression.getFieldName(), BytecodeHelper.getTypeDescription(type));
            this.cv.visitInsn(95);
            this.cv.visitMethodInsn(182, "groovy/lang/Reference", "set", "(Ljava/lang/Object;)V");
        } else {
            if (this.isInClosureConstructor()) {
                this.helper.doCast(type);
            } else if (!ClassHelper.isPrimitiveType(type)) {
                this.doConvertAndCast(type);
            }
            this.cv.visitVarInsn(25, 0);
            this.cv.visitInsn(95);
            this.helper.unbox(type);
            this.helper.putField(field, ownerName);
        }
    }

    public void storeStaticField(FieldExpression expression) {
        String ownerName;
        FieldNode field = expression.getField();
        boolean holder = field.isHolder() && !this.isInClosureConstructor();
        ClassNode type = field.getType();
        String string = field.getOwner().equals(this.classNode) ? this.internalClassName : (ownerName = BytecodeHelper.getClassInternalName(field.getOwner()));
        if (holder) {
            this.cv.visitFieldInsn(178, ownerName, expression.getFieldName(), BytecodeHelper.getTypeDescription(type));
            this.cv.visitInsn(95);
            this.cv.visitMethodInsn(182, "groovy/lang/Reference", "set", "(Ljava/lang/Object;)V");
        } else {
            this.helper.doCast(type);
            this.cv.visitFieldInsn(179, ownerName, expression.getFieldName(), BytecodeHelper.getTypeDescription(type));
        }
    }

    protected void visitOuterFieldExpression(FieldExpression expression, ClassNode outerClassNode, int steps, boolean first) {
        FieldNode field = expression.getField();
        boolean isStatic = field.isStatic();
        int tempIdx = this.compileStack.defineTemporaryVariable(field, this.leftHandExpression && first);
        if (steps > 1 || !isStatic) {
            this.cv.visitVarInsn(25, 0);
            this.cv.visitFieldInsn(180, this.internalClassName, "owner", BytecodeHelper.getTypeDescription(outerClassNode));
        }
        if (steps == 1) {
            int opcode = this.leftHandExpression ? (isStatic ? 179 : 181) : (isStatic ? 178 : 180);
            String ownerName = BytecodeHelper.getClassInternalName(outerClassNode);
            if (this.leftHandExpression) {
                boolean holder;
                this.cv.visitVarInsn(25, tempIdx);
                boolean bl = holder = field.isHolder() && !this.isInClosureConstructor();
                if (!holder) {
                    this.doConvertAndCast(field.getType());
                }
            }
            this.cv.visitFieldInsn(opcode, ownerName, expression.getFieldName(), BytecodeHelper.getTypeDescription(field.getType()));
            if (!this.leftHandExpression && ClassHelper.isPrimitiveType(field.getType())) {
                this.helper.box(field.getType());
            }
        } else {
            this.visitOuterFieldExpression(expression, outerClassNode.getOuterClass(), steps - 1, false);
        }
    }

    public void visitVariableExpression(VariableExpression expression) {
        String variableName = expression.getName();
        ClassNode classNode = this.classNode;
        if (this.isInClosure()) {
            classNode = this.getOutermostClass();
        }
        if (variableName.equals("this")) {
            if (this.isStaticMethod() || !this.implicitThis && this.isStaticContext()) {
                this.visitClassExpression(new ClassExpression(classNode));
            } else {
                this.loadThis();
            }
            return;
        }
        if (variableName.equals("super")) {
            if (this.isStaticMethod()) {
                this.visitClassExpression(new ClassExpression(classNode.getSuperClass()));
            } else {
                this.loadThis();
            }
            return;
        }
        Variable variable = this.compileStack.getVariable(variableName, false);
        VariableScope scope = this.compileStack.getScope();
        if (variable == null) {
            this.processClassVariable(variableName);
        } else {
            this.processStackVariable(variable);
        }
    }

    private void loadThis() {
        this.cv.visitVarInsn(25, 0);
        if (!this.implicitThis && this.isInClosure()) {
            this.cv.visitMethodInsn(182, "groovy/lang/Closure", "getThisObject", "()Ljava/lang/Object;");
        }
    }

    protected void processStackVariable(Variable variable) {
        if (this.leftHandExpression) {
            this.helper.storeVar(variable);
        } else {
            this.helper.loadVar(variable);
        }
    }

    protected void processClassVariable(String name) {
        if (this.passingClosureParams && this.isInScriptBody()) {
            this.cv.visitTypeInsn(187, "org/codehaus/groovy/runtime/ScriptReference");
            this.cv.visitInsn(89);
            this.loadThisOrOwner();
            this.cv.visitLdcInsn(name);
            this.cv.visitMethodInsn(183, "org/codehaus/groovy/runtime/ScriptReference", "<init>", "(Lgroovy/lang/Script;Ljava/lang/String;)V");
        } else {
            PropertyExpression pexp = new PropertyExpression((Expression)VariableExpression.THIS_EXPRESSION, name);
            pexp.setImplicitThis(true);
            this.visitPropertyExpression(pexp);
        }
    }

    protected void processFieldAccess(String name, FieldNode field, int steps) {
        FieldExpression expression = new FieldExpression(field);
        if (steps == 0) {
            this.visitFieldExpression(expression);
        } else {
            this.visitOuterFieldExpression(expression, this.classNode.getOuterClass(), steps, true);
        }
    }

    protected boolean isInScriptBody() {
        if (this.classNode.isScriptBody()) {
            return true;
        }
        return this.classNode.isScript() && this.methodNode != null && this.methodNode.getName().equals("run");
    }

    protected boolean isPopRequired(Expression expression) {
        if (expression instanceof MethodCallExpression) {
            if (expression.getType() == ClassHelper.VOID_TYPE) {
                return false;
            }
            return !AsmClassGenerator.usesSuper((MethodCallExpression)expression);
        }
        if (expression instanceof DeclarationExpression) {
            return false;
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binExp = (BinaryExpression)expression;
            binExp.getOperation().getType();
        }
        if (expression instanceof ConstructorCallExpression) {
            ConstructorCallExpression cce = (ConstructorCallExpression)expression;
            return !cce.isSpecialCall();
        }
        return true;
    }

    protected void createInterfaceSyntheticStaticFields() {
        if (this.syntheticStaticFields.isEmpty()) {
            return;
        }
        this.addInnerClass(this.interfaceClassLoadingClass);
        Iterator iter = this.syntheticStaticFields.iterator();
        while (iter.hasNext()) {
            String staticFieldName = (String)iter.next();
            this.interfaceClassLoadingClass.addField(staticFieldName, 4104, ClassHelper.CLASS_Type, null);
        }
    }

    protected void createSyntheticStaticFields() {
        Iterator iter = this.syntheticStaticFields.iterator();
        while (iter.hasNext()) {
            String staticFieldName = (String)iter.next();
            FieldNode fn = this.classNode.getField(staticFieldName);
            if (fn != null) {
                boolean modifiers;
                boolean type = fn.getType() == ClassHelper.CLASS_Type;
                boolean bl = modifiers = fn.getModifiers() == 4104;
                if (type && modifiers) continue;
                String text = "";
                if (!type) {
                    text = " with wrong type: " + fn.getType() + " (java.lang.Class needed)";
                }
                if (!modifiers) {
                    text = " with wrong modifiers: " + fn.getModifiers() + " (" + 4104 + " needed)";
                }
                this.throwException("tried to set a static syntethic field " + staticFieldName + " in " + this.classNode.getName() + " for class resolving, but found alreeady a node of that" + " name " + text);
                continue;
            }
            this.cw.visitField(4104, staticFieldName, "Ljava/lang/Class;", null, null);
        }
        this.cv = this.cw.visitMethod(4104, "class$", "(Ljava/lang/String;)Ljava/lang/Class;", null, null);
        Label l0 = new Label();
        this.cv.visitLabel(l0);
        this.cv.visitVarInsn(25, 0);
        this.cv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        Label l1 = new Label();
        this.cv.visitLabel(l1);
        this.cv.visitInsn(176);
        Label l2 = new Label();
        this.cv.visitLabel(l2);
        this.cv.visitVarInsn(58, 1);
        this.cv.visitTypeInsn(187, "java/lang/NoClassDefFoundError");
        this.cv.visitInsn(89);
        this.cv.visitVarInsn(25, 1);
        this.cv.visitMethodInsn(182, "java/lang/ClassNotFoundException", "getMessage", "()Ljava/lang/String;");
        this.cv.visitMethodInsn(183, "java/lang/NoClassDefFoundError", "<init>", "(Ljava/lang/String;)V");
        this.cv.visitInsn(191);
        this.cv.visitTryCatchBlock(l0, l2, l2, "java/lang/ClassNotFoundException");
        this.cv.visitMaxs(3, 2);
    }

    public void visitClassExpression(ClassExpression expression) {
        ClassNode type = expression.getType();
        if (ClassHelper.isPrimitiveType(type)) {
            ClassNode objectType = ClassHelper.getWrapper(type);
            this.cv.visitFieldInsn(178, BytecodeHelper.getClassInternalName(objectType), "TYPE", "Ljava/lang/Class;");
        } else {
            String staticFieldName;
            if (type.equals(this.classNode)) {
                staticFieldName = "class$0";
                if (this.compileStack.getCurrentClassIndex() != -1) {
                    this.cv.visitVarInsn(25, this.compileStack.getCurrentClassIndex());
                    return;
                }
            } else if (type.equals(ClassHelper.METACLASS_TYPE)) {
                staticFieldName = AsmClassGenerator.getStaticFieldName(type);
                if (this.compileStack.getCurrentMetaClassIndex() != -1) {
                    this.cv.visitVarInsn(25, this.compileStack.getCurrentMetaClassIndex());
                    return;
                }
            } else {
                staticFieldName = AsmClassGenerator.getStaticFieldName(type);
            }
            this.syntheticStaticFields.add(staticFieldName);
            String internalClassName = this.internalClassName;
            if (this.classNode.isInterface()) {
                internalClassName = BytecodeHelper.getClassInternalName(this.interfaceClassLoadingClass);
            }
            this.cv.visitFieldInsn(178, internalClassName, staticFieldName, "Ljava/lang/Class;");
            Label l0 = new Label();
            this.cv.visitJumpInsn(199, l0);
            this.cv.visitLdcInsn(BytecodeHelper.getClassLoadingTypeDescription(type));
            this.cv.visitMethodInsn(184, internalClassName, "class$", "(Ljava/lang/String;)Ljava/lang/Class;");
            this.cv.visitInsn(89);
            this.cv.visitFieldInsn(179, internalClassName, staticFieldName, "Ljava/lang/Class;");
            Label l1 = new Label();
            this.cv.visitJumpInsn(167, l1);
            this.cv.visitLabel(l0);
            this.cv.visitFieldInsn(178, internalClassName, staticFieldName, "Ljava/lang/Class;");
            this.cv.visitLabel(l1);
            if (type.equals(this.classNode)) {
                this.cv.visitInsn(89);
                int index = this.compileStack.defineTemporaryVariable("class$0", ClassHelper.CLASS_Type, true);
                this.compileStack.setCurrentClassIndex(index);
            } else if (type.equals(ClassHelper.METACLASS_TYPE)) {
                this.cv.visitInsn(89);
                int index = this.compileStack.defineTemporaryVariable("meta$class$0", ClassHelper.CLASS_Type, true);
                this.compileStack.setCurrentMetaClassIndex(index);
            }
        }
    }

    public void visitRangeExpression(RangeExpression expression) {
        expression.getFrom().visit(this);
        expression.getTo().visit(this);
        this.helper.pushConstant(expression.isInclusive());
        this.createRangeMethod.call(this.cv);
    }

    public void visitMapEntryExpression(MapEntryExpression expression) {
        throw new GroovyBugError("MapEntryExpression should not be visited here");
    }

    public void visitMapExpression(MapExpression expression) {
        List entries = expression.getMapEntryExpressions();
        int size = entries.size();
        this.helper.pushConstant(size * 2);
        this.cv.visitTypeInsn(189, "java/lang/Object");
        int i = 0;
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            MapEntryExpression entry = (MapEntryExpression)object;
            this.cv.visitInsn(89);
            this.helper.pushConstant(i++);
            this.visitAndAutoboxBoolean(entry.getKeyExpression());
            this.cv.visitInsn(83);
            this.cv.visitInsn(89);
            this.helper.pushConstant(i++);
            this.visitAndAutoboxBoolean(entry.getValueExpression());
            this.cv.visitInsn(83);
        }
        this.createMapMethod.call(this.cv);
    }

    public void visitArgumentlistExpression(ArgumentListExpression ale) {
        if (AsmClassGenerator.containsSpreadExpression(ale)) {
            this.despreadList(ale.getExpressions(), true);
        } else {
            this.visitTupleExpression(ale, true);
        }
    }

    public void visitTupleExpression(TupleExpression expression) {
        this.visitTupleExpression(expression, false);
    }

    private void visitTupleExpression(TupleExpression expression, boolean useWrapper) {
        int size = expression.getExpressions().size();
        this.helper.pushConstant(size);
        this.cv.visitTypeInsn(189, "java/lang/Object");
        for (int i = 0; i < size; ++i) {
            this.cv.visitInsn(89);
            this.helper.pushConstant(i);
            Expression argument = expression.getExpression(i);
            this.visitAndAutoboxBoolean(argument);
            if (useWrapper && argument instanceof CastExpression) {
                this.loadWrapper(argument);
            }
            this.cv.visitInsn(83);
        }
    }

    private void loadWrapper(Expression argument) {
        ClassNode goalClass = argument.getType();
        this.visitClassExpression(new ClassExpression(goalClass));
        if (goalClass.isDerivedFromGroovyObject()) {
            this.createGroovyObjectWrapperMethod.call(this.cv);
        } else {
            this.createPojoWrapperMethod.call(this.cv);
        }
    }

    public void visitArrayExpression(ArrayExpression expression) {
        ClassNode elementType = expression.getElementType();
        String arrayTypeName = BytecodeHelper.getClassInternalName(elementType);
        List sizeExpression = expression.getSizeExpression();
        int size = 0;
        int dimensions = 0;
        if (sizeExpression != null) {
            Expression element;
            Iterator iter = sizeExpression.iterator();
            while (iter.hasNext() && (element = (Expression)iter.next()) != ConstantExpression.EMTPY_EXPRESSION) {
                ++dimensions;
                this.visitAndAutoboxBoolean(element);
                this.helper.unbox(Integer.TYPE);
            }
        } else {
            size = expression.getExpressions().size();
            this.helper.pushConstant(size);
        }
        int storeIns = 83;
        if (sizeExpression != null) {
            arrayTypeName = BytecodeHelper.getTypeDescription(expression.getType());
            this.cv.visitMultiANewArrayInsn(arrayTypeName, dimensions);
        } else if (ClassHelper.isPrimitiveType(elementType)) {
            int primType = 0;
            if (elementType == ClassHelper.boolean_TYPE) {
                primType = 4;
                storeIns = 84;
            } else if (elementType == ClassHelper.char_TYPE) {
                primType = 5;
                storeIns = 85;
            } else if (elementType == ClassHelper.float_TYPE) {
                primType = 6;
                storeIns = 81;
            } else if (elementType == ClassHelper.double_TYPE) {
                primType = 7;
                storeIns = 82;
            } else if (elementType == ClassHelper.byte_TYPE) {
                primType = 8;
                storeIns = 84;
            } else if (elementType == ClassHelper.short_TYPE) {
                primType = 9;
                storeIns = 86;
            } else if (elementType == ClassHelper.int_TYPE) {
                primType = 10;
                storeIns = 79;
            } else if (elementType == ClassHelper.long_TYPE) {
                primType = 11;
                storeIns = 80;
            }
            this.cv.visitIntInsn(188, primType);
        } else {
            this.cv.visitTypeInsn(189, arrayTypeName);
        }
        for (int i = 0; i < size; ++i) {
            this.cv.visitInsn(89);
            this.helper.pushConstant(i);
            Expression elementExpression = expression.getExpression(i);
            if (elementExpression == null) {
                ConstantExpression.NULL.visit(this);
            } else if (!elementType.equals(elementExpression.getType())) {
                this.visitCastExpression(new CastExpression(elementType, elementExpression, true));
            } else {
                this.visitAndAutoboxBoolean(elementExpression);
            }
            this.cv.visitInsn(storeIns);
        }
        if (sizeExpression == null && ClassHelper.isPrimitiveType(elementType)) {
            int par = this.compileStack.defineTemporaryVariable("par", true);
            this.cv.visitVarInsn(25, par);
        }
    }

    public void visitListExpression(ListExpression expression) {
        int size = expression.getExpressions().size();
        boolean containsSpreadExpression = AsmClassGenerator.containsSpreadExpression(expression);
        if (!containsSpreadExpression) {
            this.helper.pushConstant(size);
            this.cv.visitTypeInsn(189, "java/lang/Object");
            for (int i = 0; i < size; ++i) {
                this.cv.visitInsn(89);
                this.helper.pushConstant(i);
                this.visitAndAutoboxBoolean(expression.getExpression(i));
                this.cv.visitInsn(83);
            }
        } else {
            this.despreadList(expression.getExpressions(), false);
        }
        this.createListMethod.call(this.cv);
    }

    public void visitGStringExpression(GStringExpression expression) {
        int size = expression.getValues().size();
        this.helper.pushConstant(size);
        this.cv.visitTypeInsn(189, "java/lang/Object");
        for (int i = 0; i < size; ++i) {
            this.cv.visitInsn(89);
            this.helper.pushConstant(i);
            this.visitAndAutoboxBoolean(expression.getValue(i));
            this.cv.visitInsn(83);
        }
        int paramIdx = this.compileStack.defineTemporaryVariable("iterator", true);
        ClassNode innerClass = this.createGStringClass(expression);
        this.addInnerClass(innerClass);
        String innerClassinternalName = BytecodeHelper.getClassInternalName(innerClass);
        this.cv.visitTypeInsn(187, innerClassinternalName);
        this.cv.visitInsn(89);
        this.cv.visitVarInsn(25, paramIdx);
        this.cv.visitMethodInsn(183, innerClassinternalName, "<init>", "([Ljava/lang/Object;)V");
        this.compileStack.removeVar(paramIdx);
    }

    public void visitAnnotations(AnnotatedNode node) {
        Map annotionMap = node.getAnnotations();
        if (annotionMap.isEmpty()) {
            return;
        }
        Iterator it = annotionMap.values().iterator();
        while (it.hasNext()) {
            AnnotationNode an = (AnnotationNode)it.next();
            if (an.isBuiltIn()) continue;
            ClassNode type = an.getClassNode();
            String clazz = type.getName();
            AnnotationVisitor av = this.cw.visitAnnotation(BytecodeHelper.formatNameForClassLoading(clazz), false);
            Iterator mIt = an.getMembers().keySet().iterator();
            while (mIt.hasNext()) {
                String name = (String)mIt.next();
                ConstantExpression exp = (ConstantExpression)an.getMember(name);
                av.visit(name, exp.getValue());
            }
            av.visitEnd();
        }
    }

    protected boolean addInnerClass(ClassNode innerClass) {
        innerClass.setModule(this.classNode.getModule());
        return this.innerClasses.add(innerClass);
    }

    protected ClassNode createClosureClass(ClosureExpression expression) {
        ClassNode outerClass = this.getOutermostClass();
        String name = outerClass.getName() + "$" + this.context.getNextClosureInnerName(outerClass, this.classNode, this.methodNode);
        boolean staticMethodOrInStaticClass = this.isStaticMethod() || this.classNode.isStaticClass();
        Parameter[] parameters = expression.getParameters();
        if (parameters == null) {
            parameters = new Parameter[]{};
        } else if (parameters.length == 0) {
            parameters = new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE, "it", ConstantExpression.NULL)};
        }
        Parameter[] localVariableParams = this.getClosureSharedVariables(expression);
        InnerClassNode answer = new InnerClassNode(outerClass, name, 0, ClassHelper.CLOSURE_TYPE);
        answer.setEnclosingMethod(this.methodNode);
        answer.setSynthetic(true);
        if (staticMethodOrInStaticClass) {
            answer.setStaticClass(true);
        }
        if (this.isInScriptBody()) {
            answer.setScriptBody(true);
        }
        MethodNode method = answer.addMethod("doCall", 1, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, expression.getCode());
        method.setSourcePosition(expression);
        VariableScope varScope = expression.getVariableScope();
        if (varScope == null) {
            throw new RuntimeException("Must have a VariableScope by now! for expression: " + expression + " class: " + name);
        }
        method.setVariableScope(varScope.copy());
        if (parameters.length > 1 || parameters.length == 1 && parameters[0].getType() != null && parameters[0].getType() != ClassHelper.OBJECT_TYPE) {
            MethodNode call = answer.addMethod("call", 1, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, new ReturnStatement(new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "doCall", (Expression)new ArgumentListExpression(parameters))));
            call.setSourcePosition(expression);
        }
        BlockStatement block = new BlockStatement();
        block.setSourcePosition(expression);
        VariableExpression outer = new VariableExpression("_outerInstance");
        outer.setSourcePosition(expression);
        block.getVariableScope().getReferencedLocalVariables().put("_outerInstance", outer);
        VariableExpression thisObject = new VariableExpression("_thisObject");
        thisObject.setSourcePosition(expression);
        block.getVariableScope().getReferencedLocalVariables().put("_thisObject", thisObject);
        TupleExpression conArgs = new TupleExpression();
        conArgs.addExpression(outer);
        conArgs.addExpression(thisObject);
        block.addStatement(new ExpressionStatement(new ConstructorCallExpression(ClassNode.SUPER, conArgs)));
        for (int i = 0; i < localVariableParams.length; ++i) {
            Parameter param = localVariableParams[i];
            String paramName = param.getName();
            VariableExpression initialValue = null;
            ClassNode type = param.getType();
            FieldNode paramField = null;
            initialValue = new VariableExpression(paramName);
            ClassNode realType = type;
            type = ClassHelper.makeReference();
            param.setType(type);
            paramField = answer.addField(paramName, 2, type, initialValue);
            paramField.setHolder(true);
            String methodName = Verifier.capitalize(paramName);
            FieldExpression fieldExp = new FieldExpression(paramField);
            answer.addMethod("get" + methodName, 1, realType, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, new ReturnStatement(fieldExp));
        }
        Parameter[] params = new Parameter[2 + localVariableParams.length];
        params[0] = new Parameter(ClassHelper.OBJECT_TYPE, "_outerInstance");
        params[1] = new Parameter(ClassHelper.OBJECT_TYPE, "_thisObject");
        System.arraycopy(localVariableParams, 0, params, 2, localVariableParams.length);
        ConstructorNode sn = answer.addConstructor(1, params, ClassNode.EMPTY_ARRAY, block);
        sn.setSourcePosition(expression);
        return answer;
    }

    protected Parameter[] getClosureSharedVariables(ClosureExpression ce) {
        VariableScope scope = ce.getVariableScope();
        Map references = scope.getReferencedLocalVariables();
        Parameter[] ret = new Parameter[references.size()];
        int index = 0;
        Iterator iter = references.values().iterator();
        while (iter.hasNext()) {
            Parameter p;
            org.codehaus.groovy.ast.Variable element = (org.codehaus.groovy.ast.Variable)iter.next();
            ret[index] = element instanceof Parameter ? (Parameter)element : (p = new Parameter(element.getType(), element.getName()));
            ++index;
        }
        return ret;
    }

    protected ClassNode getOutermostClass() {
        if (this.outermostClass == null) {
            this.outermostClass = this.classNode;
            while (this.outermostClass instanceof InnerClassNode) {
                this.outermostClass = this.outermostClass.getOuterClass();
            }
        }
        return this.outermostClass;
    }

    protected ClassNode createGStringClass(GStringExpression expression) {
        ClassNode owner = this.classNode;
        if (owner instanceof InnerClassNode) {
            owner = owner.getOuterClass();
        }
        String outerClassName = owner.getName();
        String name = outerClassName + "$" + this.context.getNextInnerClassIdx();
        InnerClassNode answer = new InnerClassNode(owner, name, 0, ClassHelper.GSTRING_TYPE);
        answer.setEnclosingMethod(this.methodNode);
        FieldNode stringsField = answer.addField("strings", 2, ClassHelper.STRING_TYPE.makeArray(), new ArrayExpression(ClassHelper.STRING_TYPE, expression.getStrings()));
        answer.addMethod("getStrings", 1, ClassHelper.STRING_TYPE.makeArray(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, new ReturnStatement(new FieldExpression(stringsField)));
        BlockStatement block = new BlockStatement();
        block.addStatement(new ExpressionStatement(new ConstructorCallExpression(ClassNode.SUPER, new VariableExpression("values"))));
        Parameter[] contructorParams = new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE.makeArray(), "values")};
        answer.addConstructor(1, contructorParams, ClassNode.EMPTY_ARRAY, block);
        return answer;
    }

    protected void doConvertAndCast(ClassNode type) {
        this.doConvertAndCast(type, false);
    }

    protected void doConvertAndCast(ClassNode type, boolean coerce) {
        if (type == ClassHelper.OBJECT_TYPE) {
            return;
        }
        if (this.isValidTypeForCast(type)) {
            this.visitClassExpression(new ClassExpression(type));
            if (coerce) {
                this.asTypeMethod.call(this.cv);
            } else {
                this.castToTypeMethod.call(this.cv);
            }
        }
        this.helper.doCast(type);
    }

    protected void evaluateLogicalOrExpression(BinaryExpression expression) {
        this.visitBooleanExpression(new BooleanExpression(expression.getLeftExpression()));
        Label l0 = new Label();
        Label l2 = new Label();
        this.cv.visitJumpInsn(153, l0);
        this.cv.visitLabel(l2);
        this.visitConstantExpression(ConstantExpression.TRUE);
        Label l1 = new Label();
        this.cv.visitJumpInsn(167, l1);
        this.cv.visitLabel(l0);
        this.visitBooleanExpression(new BooleanExpression(expression.getRightExpression()));
        this.cv.visitJumpInsn(154, l2);
        this.visitConstantExpression(ConstantExpression.FALSE);
        this.cv.visitLabel(l1);
    }

    protected void evaluateLogicalAndExpression(BinaryExpression expression) {
        this.visitBooleanExpression(new BooleanExpression(expression.getLeftExpression()));
        Label l0 = new Label();
        this.cv.visitJumpInsn(153, l0);
        this.visitBooleanExpression(new BooleanExpression(expression.getRightExpression()));
        this.cv.visitJumpInsn(153, l0);
        this.visitConstantExpression(ConstantExpression.TRUE);
        Label l1 = new Label();
        this.cv.visitJumpInsn(167, l1);
        this.cv.visitLabel(l0);
        this.visitConstantExpression(ConstantExpression.FALSE);
        this.cv.visitLabel(l1);
    }

    protected void evaluateBinaryExpression(String method, BinaryExpression expression) {
        this.makeCall(expression.getLeftExpression(), new ConstantExpression(method), new ArgumentListExpression().addExpression(expression.getRightExpression()), this.invokeMethod, false, false, false);
    }

    protected void evaluateCompareTo(BinaryExpression expression) {
        Expression leftExpression = expression.getLeftExpression();
        leftExpression.visit(this);
        if (this.isComparisonExpression(leftExpression)) {
            this.helper.boxBoolean();
        }
        Expression rightExpression = expression.getRightExpression();
        rightExpression.visit(this);
        if (this.isComparisonExpression(rightExpression)) {
            this.helper.boxBoolean();
        }
        this.compareToMethod.call(this.cv);
    }

    protected void evaluateBinaryExpressionWithAsignment(String method, BinaryExpression expression) {
        BinaryExpression leftBinExpr;
        Expression leftExpression = expression.getLeftExpression();
        if (leftExpression instanceof BinaryExpression && (leftBinExpr = (BinaryExpression)leftExpression).getOperation().getType() == 30) {
            MethodCallExpression methodCall = new MethodCallExpression(expression.getLeftExpression(), method, (Expression)new ArgumentListExpression(new Expression[]{expression.getRightExpression()}));
            Expression safeIndexExpr = this.createReusableExpression(leftBinExpr.getRightExpression());
            this.visitMethodCallExpression(new MethodCallExpression(leftBinExpr.getLeftExpression(), "putAt", (Expression)new ArgumentListExpression(new Expression[]{safeIndexExpr, methodCall})));
            return;
        }
        this.evaluateBinaryExpression(method, expression);
        this.cv.visitInsn(89);
        this.leftHandExpression = true;
        this.evaluateExpression(leftExpression);
        this.leftHandExpression = false;
    }

    private void evaluateBinaryExpression(MethodCaller compareMethod, BinaryExpression expression) {
        Expression leftExp = expression.getLeftExpression();
        Expression rightExp = expression.getRightExpression();
        this.load(leftExp);
        this.load(rightExp);
        compareMethod.call(this.cv);
    }

    protected void evaluateEqual(BinaryExpression expression) {
        BinaryExpression leftBinExpr;
        Expression leftExpression = expression.getLeftExpression();
        if (leftExpression instanceof BinaryExpression && (leftBinExpr = (BinaryExpression)leftExpression).getOperation().getType() == 30) {
            this.visitMethodCallExpression(new MethodCallExpression(leftBinExpr.getLeftExpression(), "putAt", (Expression)new ArgumentListExpression(new Expression[]{leftBinExpr.getRightExpression(), expression.getRightExpression()})));
            return;
        }
        Expression rightExpression = expression.getRightExpression();
        ClassNode type = this.getLHSType(leftExpression);
        if (ClassHelper.isPrimitiveType(type)) {
            this.visitAndAutoboxBoolean(rightExpression);
        } else if (type != ClassHelper.OBJECT_TYPE) {
            this.visitCastExpression(new CastExpression(type, rightExpression));
        } else {
            this.visitAndAutoboxBoolean(rightExpression);
        }
        this.cv.visitInsn(89);
        this.leftHandExpression = true;
        leftExpression.visit(this);
        this.leftHandExpression = false;
    }

    protected ClassNode getLHSType(Expression leftExpression) {
        FieldExpression fieldExp;
        ClassNode type;
        if (leftExpression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)leftExpression;
            ClassNode type2 = varExp.getType();
            if (this.isValidTypeForCast(type2)) {
                return type2;
            }
            String variableName = varExp.getName();
            Variable variable = this.compileStack.getVariable(variableName, false);
            if (variable != null) {
                if (variable.isHolder()) {
                    return type2;
                }
                if (variable.isProperty()) {
                    return variable.getType();
                }
                type2 = variable.getType();
                if (this.isValidTypeForCast(type2)) {
                    return type2;
                }
            } else {
                FieldNode field = this.classNode.getField(variableName);
                if (field == null) {
                    field = this.classNode.getOuterField(variableName);
                }
                if (field != null) {
                    type2 = field.getType();
                    if (!field.isHolder() && this.isValidTypeForCast(type2)) {
                        return type2;
                    }
                }
            }
        } else if (leftExpression instanceof FieldExpression && this.isValidTypeForCast(type = (fieldExp = (FieldExpression)leftExpression).getType())) {
            return type;
        }
        return ClassHelper.DYNAMIC_TYPE;
    }

    protected boolean isValidTypeForCast(ClassNode type) {
        return type != ClassHelper.DYNAMIC_TYPE && type != ClassHelper.REFERENCE_TYPE;
    }

    protected void visitAndAutoboxBoolean(Expression expression) {
        expression.visit(this);
        if (this.isComparisonExpression(expression)) {
            this.helper.boxBoolean();
        }
    }

    protected void evaluatePrefixMethod(String method, Expression expression) {
        this.makeCall(expression, new ConstantExpression(method), MethodCallExpression.NO_ARGUMENTS, this.invokeMethod, false, false, false);
        this.leftHandExpression = true;
        expression.visit(this);
        this.leftHandExpression = false;
        expression.visit(this);
    }

    protected void evaluatePostfixMethod(String method, Expression expression) {
        expression.visit(this);
        int tempIdx = this.compileStack.defineTemporaryVariable("postfix_" + method, true);
        this.makeCall(expression, new ConstantExpression(method), MethodCallExpression.NO_ARGUMENTS, this.invokeMethod, false, false, false);
        this.leftHandExpression = true;
        expression.visit(this);
        this.leftHandExpression = false;
        this.cv.visitVarInsn(25, tempIdx);
        this.compileStack.removeVar(tempIdx);
    }

    protected void evaluateInstanceof(BinaryExpression expression) {
        this.visitAndAutoboxBoolean(expression.getLeftExpression());
        Expression rightExp = expression.getRightExpression();
        ClassNode classType = ClassHelper.DYNAMIC_TYPE;
        if (!(rightExp instanceof ClassExpression)) {
            throw new RuntimeException("Right hand side of the instanceof keyword must be a class name, not: " + rightExp);
        }
        ClassExpression classExp = (ClassExpression)rightExp;
        classType = classExp.getType();
        String classInternalName = BytecodeHelper.getClassInternalName(classType);
        this.cv.visitTypeInsn(193, classInternalName);
    }

    protected boolean argumentsUseStack(Expression arguments) {
        return arguments instanceof TupleExpression || arguments instanceof ClosureExpression;
    }

    protected boolean isNonStaticField(Expression expression) {
        PropertyExpression fieldExp;
        String possibleField;
        FieldNode field = null;
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            field = this.classNode.getField(varExp.getName());
        } else if (expression instanceof FieldExpression) {
            FieldExpression fieldExp2 = (FieldExpression)expression;
            field = this.classNode.getField(fieldExp2.getFieldName());
        } else if (expression.getClass() == PropertyExpression.class && (possibleField = (fieldExp = (PropertyExpression)expression).getPropertyAsString()) != null) {
            field = this.classNode.getField(possibleField);
        }
        if (field != null) {
            return !field.isStatic();
        }
        return false;
    }

    private static boolean isThisExpression(Expression expression) {
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            return varExp.getName().equals("this");
        }
        return false;
    }

    private static boolean isSuperExpression(Expression expression) {
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            return varExp.getName().equals("super");
        }
        return false;
    }

    private static boolean isThisOrSuper(Expression expression) {
        return AsmClassGenerator.isThisExpression(expression) || AsmClassGenerator.isSuperExpression(expression);
    }

    protected Expression createReturnLHSExpression(Expression expression) {
        BinaryExpression binExpr;
        if (expression instanceof BinaryExpression && (binExpr = (BinaryExpression)expression).getOperation().isA(1100)) {
            return this.createReusableExpression(binExpr.getLeftExpression());
        }
        return null;
    }

    protected Expression createReusableExpression(Expression expression) {
        ExpressionTransformer transformer = new ExpressionTransformer(){

            public Expression transform(Expression expression) {
                if (expression instanceof PostfixExpression) {
                    PostfixExpression postfixExp = (PostfixExpression)expression;
                    return postfixExp.getExpression();
                }
                if (expression instanceof PrefixExpression) {
                    PrefixExpression prefixExp = (PrefixExpression)expression;
                    return prefixExp.getExpression();
                }
                return expression;
            }
        };
        return transformer.transform(expression.transformExpression(transformer));
    }

    protected boolean isComparisonExpression(Expression expression) {
        if (expression instanceof BinaryExpression) {
            BinaryExpression binExpr = (BinaryExpression)expression;
            switch (binExpr.getOperation().getType()) {
                case 94: 
                case 120: 
                case 121: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 544: 
                case 573: {
                    return true;
                }
            }
        } else if (expression instanceof BooleanExpression) {
            return true;
        }
        return false;
    }

    protected void onLineNumber(ASTNode statement, String message) {
        int line = statement.getLineNumber();
        int col = statement.getColumnNumber();
        this.currentASTNode = statement;
        if (line >= 0) {
            this.lineNumber = line;
            this.columnNumber = col;
        }
        if (line >= 0 && this.cv != null) {
            Label l = new Label();
            this.cv.visitLabel(l);
            this.cv.visitLineNumber(line, l);
        }
    }

    private boolean isInnerClass() {
        return this.classNode instanceof InnerClassNode;
    }

    protected boolean isFieldOrVariable(String name) {
        return this.compileStack.containsVariable(name) || this.classNode.getField(name) != null;
    }

    protected ClassNode getExpressionType(Expression expression) {
        if (this.isComparisonExpression(expression)) {
            return ClassHelper.boolean_TYPE;
        }
        if (expression instanceof VariableExpression) {
            org.codehaus.groovy.ast.Variable var;
            if (expression == VariableExpression.THIS_EXPRESSION) {
                return this.classNode;
            }
            if (expression == VariableExpression.SUPER_EXPRESSION) {
                return this.classNode.getSuperClass();
            }
            VariableExpression varExpr = (VariableExpression)expression;
            Variable variable = this.compileStack.getVariable(varExpr.getName(), false);
            if (variable != null && !variable.isHolder()) {
                ClassNode type = variable.getType();
                if (!variable.isDynamicTyped()) {
                    return type;
                }
            }
            if (variable == null && (var = (org.codehaus.groovy.ast.Variable)this.compileStack.getScope().getReferencedClassVariables().get(varExpr.getName())) != null && !var.isDynamicTyped()) {
                return var.getType();
            }
        }
        return expression.getType();
    }

    protected boolean isInClosureConstructor() {
        return this.constructorNode != null && this.classNode.getOuterClass() != null && this.classNode.getSuperClass() == ClassHelper.CLOSURE_TYPE;
    }

    protected boolean isInClosure() {
        return this.classNode.getOuterClass() != null && this.classNode.getSuperClass() == ClassHelper.CLOSURE_TYPE;
    }

    protected boolean isStaticMethod() {
        if (this.methodNode == null) {
            return false;
        }
        return this.methodNode.isStatic();
    }

    protected CompileUnit getCompileUnit() {
        CompileUnit answer = this.classNode.getCompileUnit();
        if (answer == null) {
            answer = this.context.getCompileUnit();
        }
        return answer;
    }

    protected boolean isHolderVariable(Expression expression) {
        if (expression instanceof FieldExpression) {
            FieldExpression fieldExp = (FieldExpression)expression;
            return fieldExp.getField().isHolder();
        }
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            Variable variable = this.compileStack.getVariable(varExp.getName(), false);
            if (variable != null) {
                return variable.isHolder();
            }
            FieldNode field = this.classNode.getField(varExp.getName());
            if (field != null) {
                return field.isHolder();
            }
        }
        return false;
    }

    public static boolean usesSuper(MethodCallExpression call) {
        Expression expression = call.getObjectExpression();
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            String variable = varExp.getName();
            return variable.equals("super");
        }
        return false;
    }

    public static boolean usesSuper(PropertyExpression pe) {
        Expression expression = pe.getObjectExpression();
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            String variable = varExp.getName();
            return variable.equals("super");
        }
        return false;
    }
}

