/*
 * JDBCConnectionEditor.java
 *
 * Created on March 27, 2007, 10:35 AM
 */

package it.businesslogic.ireport.connection.gui;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.connection.JDBCConnection;
import it.businesslogic.ireport.IReportConnectionEditor;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import javax.swing.DefaultComboBoxModel;

/**
 *
 * @author  gtoffoli
 */
public class JDBCConnectionEditor extends javax.swing.JPanel implements IReportConnectionEditor {
    
    private IReportConnection iReportConnection = null;
    /** Creates new form JDBCConnectionEditor */
    public JDBCConnectionEditor() {
        initComponents();
        applyI18n();
        
        jComboBoxJDBCDriver.setModel( new DefaultComboBoxModel(new Object[]{
            "COM.cloudscape.JDBCDriver",
            "COM.ibm.db2.jdbc.app.DB2Driver",
            "com.inet.tds.TdsDriver",
            "com.informix.jdbc.IfxDriver",
            "com.ingres.jdbc.IngresDriver",
            "com.internetcds.jdbc.tds.Driver",
            "com.merant.datadirect.jdbc.sqlserver.SQLServerDriver",
            "com.microsoft.jdbc.sqlserver.SQLServerDriver",
            "com.ms.jdbc.odbc.JdbcOdbcDriver",
            "com.mysql.jdbc.Driver",
            "com.sybase.jdbc2.jdbc.SybDriver",
            "net.sourceforge.jtds.jdbc.Driver",
            "oracle.jdbc.driver.OracleDriver",
            "org.gjt.mm.mysql.Driver",
            "org.hsqldb.jdbcDriver",
            "org.postgresql.Driver",
            "sun.jdbc.odbc.JdbcOdbcDriver"}));
            
         jComboBoxJDBCDriver.setSelectedItem("com.mysql.jdbc.Driver");
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelJDBC = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jComboBoxJDBCDriver = new javax.swing.JComboBox();
        jTextFieldJDBCUrl = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        jLabel14 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jTextFieldDBName = new javax.swing.JTextField();
        jTextFieldServerAddress = new javax.swing.JTextField();
        jButtonWizard = new javax.swing.JButton();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jTextFieldPassword = new javax.swing.JPasswordField();
        jTextFieldUsername = new javax.swing.JTextField();
        jCheckBoxSavePassword = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        jPanelJDBC.setLayout(new java.awt.GridBagLayout());

        jLabel2.setText("JDBC Driver");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jLabel2, gridBagConstraints);

        jLabel3.setText("JDBC URL");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jLabel3, gridBagConstraints);

        jComboBoxJDBCDriver.setEditable(true);
        jComboBoxJDBCDriver.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxJDBCDriverActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanelJDBC.add(jComboBoxJDBCDriver, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanelJDBC.add(jTextFieldJDBCUrl, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("JDBC URL Wizard"));
        jPanel2.setMinimumSize(new java.awt.Dimension(179, 70));
        jLabel14.setText("Server Address");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel2.add(jLabel14, gridBagConstraints);

        jLabel5.setText("Database");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel2.add(jLabel5, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel2.add(jTextFieldDBName, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel2.add(jTextFieldServerAddress, gridBagConstraints);

        jButtonWizard.setText("Wizard");
        jButtonWizard.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButtonWizard.setMaximumSize(new java.awt.Dimension(60, 23));
        jButtonWizard.setMinimumSize(new java.awt.Dimension(60, 23));
        jButtonWizard.setPreferredSize(new java.awt.Dimension(60, 23));
        jButtonWizard.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonWizardActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 2, 0);
        jPanel2.add(jButtonWizard, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        jPanelJDBC.add(jPanel2, gridBagConstraints);

        jLabel6.setText("Username");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jLabel6, gridBagConstraints);

        jLabel7.setText("Password");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jLabel7, gridBagConstraints);

        jTextFieldPassword.setFont(new java.awt.Font("Tahoma", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jTextFieldPassword, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jTextFieldUsername, gridBagConstraints);

        jCheckBoxSavePassword.setText("Save password");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanelJDBC.add(jCheckBoxSavePassword, gridBagConstraints);

        jLabel1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/problems/warning.png")));
        jLabel1.setText("jLabel1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanelJDBC.add(jLabel1, gridBagConstraints);

        add(jPanelJDBC, java.awt.BorderLayout.CENTER);

    }// </editor-fold>//GEN-END:initComponents

    private void jComboBoxJDBCDriverActionPerformed(java.awt.event.ActionEvent evt) {                                                    
        // Run the wizard to populate Connection URL
        jButtonWizardActionPerformed(null);
    }
    
    private void jButtonWizardActionPerformed(java.awt.event.ActionEvent evt) {                                              
          
        if (jComboBoxJDBCDriver.getSelectedIndex() < 0) return;
        String driver = ""+jComboBoxJDBCDriver.getSelectedItem();
        driver = driver.trim();
        if (driver.equals("")) return;
        
        String server = jTextFieldServerAddress.getText().trim();
        if( server.length()==0 ) {
            server = "localhost";
        }
        
        String databaseName = jTextFieldDBName.getText().trim();
        
        if (driver.equalsIgnoreCase("org.gjt.mm.mysql.Driver")) {
            String url = "jdbc:mysql://" + server + "/";
            if ( databaseName.length()>0 )
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.mysql.jdbc.Driver")) {
            String url = "jdbc:mysql://" + server + "/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.internetcds.jdbc.tds.Driver")) {
            String url = "jdbc:freetds:sqlserver://localhost/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.microsoft.jdbc.sqlserver.SQLServerDriver")) {
            String url = "jdbc:microsoft:sqlserver://" + server + ":1433;DatabaseName=";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("sun.jdbc.odbc.JdbcOdbcDriver")) {
            String url = "jdbc:odbc:";
            if (databaseName.length()>0)
                url += jTextFieldDBName.getText();
            else
                url += "DSNAME";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.ms.jdbc.odbc.JdbcOdbcDriver")) {
            String url = "jdbc:odbc:";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "DSNAME";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("oracle.jdbc.driver.OracleDriver")) {
            String url = "jdbc:oracle:thin:@" + server + ":1521:";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("COM.ibm.db2.jdbc.app.DB2Driver")) {
            String url = "jdbc:db2:";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.informix.jdbc.IfxDriver")) {
            String url = "jdbc:informix-sqli://" + server + ":port/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            
            url += ":informixserver=SERVERNAME";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.sybase.jdbc2.jdbc.SybDriver")) {
            String url = "jdbc:sybase:Tds:" + server + ":2638/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.mysql.jdbc.Driver")) {
            String url = "jdbc:mysql://"+server+"/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.merant.datadirect.jdbc.sqlserver.SQLServerDriver")) {
            String url = "jdbc:sqlserver://" + server + ":1433/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.inet.tds.TdsDriver")) {
            String url = "jdbc:inetdae7:"+server+":1433/";
            if (databaseName.length()>0)
                url += jTextFieldDBName.getText();
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("org.postgresql.Driver")) {
            String url = "jdbc:postgresql://" + server + ":5432/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("org.hsqldb.jdbcDriver")) {
            String url = "jdbc:hsqldb:[PATH_TO_DB_FILES]/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("COM.cloudscape.JDBCDriver ")) {
            String url = "jdbc:cloudscape:/cloudscape/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        } 
        else if (driver.equalsIgnoreCase("net.sourceforge.jtds.jdbc.Driver"))
        {
            String url = "jdbc:jtds:sqlserver://" +
            server + "/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            url += ";instance=";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.ingres.jdbc.IngresDriver"))
        {
            String url = "jdbc:ingres://" +
            server + ":II7/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }

    }
    
    public void setIReportConnection(IReportConnection c) {
        this.iReportConnection = c;
        
        if (iReportConnection instanceof JDBCConnection)
        {
            JDBCConnection con = (JDBCConnection)iReportConnection;
            this.jComboBoxJDBCDriver.setSelectedItem(con.getJDBCDriver());
            this.jTextFieldJDBCUrl.setText( con.getUrl());
            this.jTextFieldServerAddress.setText( con.getServerAddress() );
            this.jTextFieldDBName.setText( con.getDatabase() );
            this.jTextFieldUsername.setText( con.getUsername());
            if (con.isSavePassword())
                this.jTextFieldPassword.setText( con.getPassword());
            else 
                this.jTextFieldPassword.setText( "");
            this.jCheckBoxSavePassword.setSelected( con.isSavePassword());
        }
        
    }

    public IReportConnection getIReportConnection() {
        
        IReportConnection irConn = new JDBCConnection();
        //irConn.setName( this.jTextFieldName.getText().trim() );
        ((JDBCConnection)irConn).setServerAddress( this.jTextFieldServerAddress.getText().trim() );
        ((JDBCConnection)irConn).setDatabase( this.jTextFieldDBName.getText().trim() );
        ((JDBCConnection)irConn).setUsername( this.jTextFieldUsername.getText().trim() );
        if (jCheckBoxSavePassword.isSelected())
            ((JDBCConnection)irConn).setPassword( new String( this.jTextFieldPassword.getPassword() ) );
        else
            ((JDBCConnection)irConn).setPassword("");
        ((JDBCConnection)irConn).setSavePassword( jCheckBoxSavePassword.isSelected() );
        ((JDBCConnection)irConn).setJDBCDriver( (this.jComboBoxJDBCDriver.getSelectedItem()+"").trim() );
        if ((this.jComboBoxJDBCDriver.getSelectedItem()+"").trim().length() == 0) {
            javax.swing.JOptionPane.showMessageDialog(this,
                    I18n.getString("messages.connectionDialog.jdbc.invalidDriver","Please insert a valid JDBC driver!"),
                    I18n.getString("messages.connectionDialog.jdbc.invalidDriverCaption","Invalid driver!"),
                    javax.swing.JOptionPane.WARNING_MESSAGE );
            return null;
        }

        if (this.jTextFieldJDBCUrl.getText().trim().length() == 0) {
            javax.swing.JOptionPane.showMessageDialog(this,
                    I18n.getString("messages.connectionDialog.jdbc.invalidUrl","Please insert a valid JDBC URL!"),
                    I18n.getString("messages.connectionDialog.jdbc.invalidUrlCaption","Invalid url!"),javax.swing.JOptionPane.WARNING_MESSAGE );
            return null;
        }
        ((JDBCConnection)irConn).setUrl(this.jTextFieldJDBCUrl.getText().trim());
            
        iReportConnection = irConn;
        return iReportConnection;
    }
    
    
    public void applyI18n(){
                // Start autogenerated code ----------------------
                jCheckBoxSavePassword.setText(I18n.getString("connectionDialog.checkBoxSavePassword","Save password"));
                jButtonWizard.setText(I18n.getString("connectionDialog.buttonWizard","Wizard"));
                jLabel14.setText(I18n.getString("connectionDialog.label14","Server Address"));
                jLabel2.setText(I18n.getString("connectionDialog.label2","JDBC Driver"));
                jLabel3.setText(I18n.getString("connectionDialog.label3","JDBC URL"));
                jLabel5.setText(I18n.getString("connectionDialog.label5","Database"));
                jLabel6.setText(I18n.getString("connectionDialog.label6","Username"));
                jLabel7.setText(I18n.getString("connectionDialog.label7","Password"));
                
                ((javax.swing.border.TitledBorder)jPanel2.getBorder()).setTitle( it.businesslogic.ireport.util.I18n.getString("connectionDialog.panelBorder.jdbcUrlWizard","JDBC URL Wizard") );
                
                jLabel1.setText( "<html>" + I18n.getString("connectionDialog.textArea1","ATTENTION! Passwords are stored in clear text. If you dont specify a password now, iReport will ask you for one only when required and will not save it."));
                
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonWizard;
    private javax.swing.JCheckBox jCheckBoxSavePassword;
    private javax.swing.JComboBox jComboBoxJDBCDriver;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanelJDBC;
    private javax.swing.JTextField jTextFieldDBName;
    private javax.swing.JTextField jTextFieldJDBCUrl;
    private javax.swing.JPasswordField jTextFieldPassword;
    private javax.swing.JTextField jTextFieldServerAddress;
    private javax.swing.JTextField jTextFieldUsername;
    // End of variables declaration//GEN-END:variables
    
}
