/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import java.util.SortedSet;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.swingx.JXDatePickerFormatter;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.calendar.DateSpan;
import org.jdesktop.swingx.calendar.JXMonthView;
import org.jdesktop.swingx.event.EventListenerMap;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.plaf.DatePickerUI;
import org.jdesktop.swingx.plaf.JXDatePickerAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXDatePicker
extends JComponent {
    public static final String uiClassID = "DatePickerUI";
    public static final String EDITOR = "editor";
    public static final String MONTH_VIEW = "monthView";
    public static final String DATE_IN_MILLIS = "dateInMillis";
    public static final String LINK_PANEL = "linkPanel";
    private JFormattedTextField _dateField;
    private JPanel _linkPanel;
    private long _linkDate;
    private MessageFormat _linkFormat;
    private JXMonthView _monthView;
    private String _actionCommand = "selectionChanged";
    private boolean editable = true;
    private EventListenerMap listenerMap;
    protected boolean lightWeightPopupEnabled = JPopupMenu.getDefaultLightWeightPopupEnabled();

    public JXDatePicker() {
        this(System.currentTimeMillis());
    }

    public JXDatePicker(long millis) {
        this.listenerMap = new EventListenerMap();
        this._monthView = new JXMonthView(millis);
        Date date = new Date(millis);
        this._monthView.setSelectionInterval(date, date);
        this._monthView.setTraversable(true);
        this._linkFormat = new MessageFormat(UIManager.getString("JXDatePicker.linkFormat"));
        this._linkDate = System.currentTimeMillis();
        this._linkPanel = new TodayPanel();
        this.updateUI();
        this._dateField.setValue(this._monthView.getSelection().first());
    }

    @Override
    public DatePickerUI getUI() {
        return (DatePickerUI)this.ui;
    }

    public void setUI(DatePickerUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((DatePickerUI)LookAndFeelAddons.getUI(this, DatePickerUI.class));
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setFormats(String ... formats) {
        DateFormat[] dateFormats = new DateFormat[formats.length];
        for (int counter = formats.length - 1; counter >= 0; --counter) {
            dateFormats[counter] = new SimpleDateFormat(formats[counter]);
        }
        this.setFormats(dateFormats);
    }

    public void setFormats(DateFormat ... formats) {
        this._dateField.setFormatterFactory(new DefaultFormatterFactory(new JXDatePickerFormatter(formats)));
    }

    public DateFormat[] getFormats() {
        JFormattedTextField.AbstractFormatter formatter;
        JFormattedTextField.AbstractFormatterFactory factory = this._dateField.getFormatterFactory();
        if (factory != null && (formatter = factory.getFormatter(this._dateField)) instanceof JXDatePickerFormatter) {
            return ((JXDatePickerFormatter)formatter).getFormats();
        }
        return null;
    }

    public void setDate(Date date) {
        Date selectedDate;
        SortedSet<Date> selection = this._monthView.getSelection();
        Date date2 = selectedDate = selection.isEmpty() ? null : selection.first();
        if (date == null && selectedDate != date) {
            this._monthView.clearSelection();
            this.getEditor().setValue(date);
        } else if (date != null && !date.equals(selectedDate)) {
            this._monthView.setSelectionInterval(date, date);
            this.getEditor().setValue(date);
        }
    }

    public void setDateInMillis(long millis) {
        this.setDate(new Date(millis));
    }

    public Date getDate() {
        SortedSet<Date> selection = this._monthView.getSelection();
        return selection.isEmpty() ? null : selection.first();
    }

    public long getDateInMillis() {
        long result = -1L;
        Date selection = this.getDate();
        if (selection != null) {
            result = selection.getTime();
        }
        return result;
    }

    public JXMonthView getMonthView() {
        return this._monthView;
    }

    public void setMonthView(JXMonthView monthView) {
        JXMonthView oldMonthView = this._monthView;
        this._monthView = monthView;
        this.firePropertyChange(MONTH_VIEW, oldMonthView, this._monthView);
    }

    public TimeZone getTimeZone() {
        return this._monthView.getTimeZone();
    }

    public void setTimeZone(TimeZone tz) {
        this._monthView.setTimeZone(tz);
    }

    public long getLinkDate() {
        return this._linkDate;
    }

    public void setLinkDate(long linkDate, String linkFormatString) {
        this._linkDate = linkDate;
        this._linkFormat = new MessageFormat(linkFormatString);
        this.setLinkPanel(new TodayPanel());
    }

    public JPanel getLinkPanel() {
        return this._linkPanel;
    }

    public void setLinkPanel(JPanel linkPanel) {
        JPanel oldLinkPanel = this._linkPanel;
        this._linkPanel = linkPanel;
        this.firePropertyChange(LINK_PANEL, oldLinkPanel, this._linkPanel);
    }

    public JFormattedTextField getEditor() {
        return this._dateField;
    }

    public void setEditor(JFormattedTextField editor) {
        JFormattedTextField oldEditor = this._dateField;
        this._dateField = editor;
        this.firePropertyChange(EDITOR, oldEditor, this._dateField);
    }

    @Override
    public void setComponentOrientation(ComponentOrientation orientation) {
        super.setComponentOrientation(orientation);
        this._monthView.setComponentOrientation(orientation);
    }

    public boolean isEditValid() {
        return this._dateField.isEditValid();
    }

    public void commitEdit() throws ParseException {
        this._dateField.commitEdit();
        this._dateField.setValue(this._dateField.getValue());
        Date date = (Date)this._dateField.getValue();
        this.setDate(date);
    }

    public void setEditable(boolean value) {
        boolean oldEditable = this.isEditable();
        this.editable = value;
        this.firePropertyChange("editable", oldEditable, this.editable);
        if (this.editable != oldEditable) {
            this.repaint();
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public Font getFont() {
        return this.getEditor().getFont();
    }

    @Override
    public void setFont(Font font) {
        this.getEditor().setFont(font);
    }

    public void setLightWeightPopupEnabled(boolean aFlag) {
        boolean oldFlag = this.lightWeightPopupEnabled;
        this.lightWeightPopupEnabled = aFlag;
        this.firePropertyChange("lightWeightPopupEnabled", oldFlag, this.lightWeightPopupEnabled);
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    @Override
    public int getBaseline(int width, int height) {
        return ((DatePickerUI)this.ui).getBaseline(width, height);
    }

    public String getActionCommand() {
        return this._actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this._actionCommand = actionCommand;
    }

    public void addActionListener(ActionListener l) {
        this.listenerMap.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerMap.remove(ActionListener.class, l);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        EventListener[] result;
        List<EventListener> listeners = this.listenerMap.getListeners(listenerType);
        if (!listeners.isEmpty()) {
            result = (EventListener[])Array.newInstance(listenerType, listeners.size());
            result = listeners.toArray(result);
        } else {
            result = super.getListeners(listenerType);
        }
        return result;
    }

    protected void fireActionPerformed() {
        ActionListener[] listeners = (ActionListener[])this.getListeners(ActionListener.class);
        ActionEvent e = null;
        for (ActionListener listener : listeners) {
            if (e == null) {
                e = new ActionEvent(this, 1001, this._actionCommand);
            }
            listener.actionPerformed(e);
        }
    }

    public void postActionEvent() {
        this.fireActionPerformed();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(3);
                JXDatePicker datePicker = new JXDatePicker();
                datePicker.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        System.out.println(((JXDatePicker)e.getSource()).getMonthView().getSelection());
                    }
                });
                frame.getContentPane().add(datePicker);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    static {
        LookAndFeelAddons.contribute(new JXDatePickerAddon());
    }

    private final class TodayPanel
    extends JXPanel {
        TodayPanel() {
            super(new FlowLayout());
            this.setBackgroundPainter(new MattePainter(new GradientPaint(0.0f, 0.0f, new Color(238, 238, 238), 0.0f, 1.0f, Color.WHITE)));
            JXHyperlink todayLink = new JXHyperlink(new TodayAction());
            Color textColor = new Color(16, 66, 104);
            todayLink.setUnclickedColor(textColor);
            todayLink.setClickedColor(textColor);
            this.add(todayLink);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(new Color(187, 187, 187));
            g.drawLine(0, 0, this.getWidth(), 0);
            g.setColor(new Color(221, 221, 221));
            g.drawLine(0, 1, this.getWidth(), 1);
        }

        private final class TodayAction
        extends AbstractAction {
            TodayAction() {
                super(JXDatePicker.this._linkFormat.format(new Object[]{new Date(JXDatePicker.this._linkDate)}));
            }

            public void actionPerformed(ActionEvent ae) {
                DateSpan span = new DateSpan(JXDatePicker.this._linkDate, JXDatePicker.this._linkDate);
                JXDatePicker.this._monthView.ensureDateVisible(span.getStart());
            }
        }
    }
}

