/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.web.context.ServletConfigAware;
import org.springframework.web.context.ServletContextAware;

public class ServletContextAwareProcessor
implements BeanPostProcessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ServletContext servletContext;
    private ServletConfig servletConfig;

    public ServletContextAwareProcessor(ServletContext servletContext) {
        this(servletContext, null);
    }

    public ServletContextAwareProcessor(ServletConfig servletConfig) {
        this(null, servletConfig);
    }

    public ServletContextAwareProcessor(ServletContext servletContext, ServletConfig servletConfig) {
        this.servletContext = servletContext;
        this.servletConfig = servletConfig;
        if (servletContext == null && servletConfig != null) {
            this.servletContext = servletConfig.getServletContext();
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ServletContextAware) {
            if (this.servletContext == null) {
                throw new IllegalStateException("Cannot satisfy ServletContextAware for bean '" + beanName + "' without ServletContext");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking setServletContext on ServletContextAware bean '" + beanName + "'"));
            }
            ((ServletContextAware)bean).setServletContext(this.servletContext);
        }
        if (bean instanceof ServletConfigAware) {
            if (this.servletConfig == null) {
                throw new IllegalStateException("Cannot satisfy ServletConfigAware for bean '" + beanName + "' without ServletConfig");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking setServletConfig on ServletConfigAware bean '" + beanName + "'"));
            }
            ((ServletConfigAware)bean).setServletConfig(this.servletConfig);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }
}

