/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.ConditionedStyle;
import it.businesslogic.ireport.gui.sheet.ColorSelectorPanel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;

public class Style {
    public static final String ATTRIBUTE_name = "name";
    public static final String ATTRIBUTE_isDefault = "isDefault";
    public static final String ATTRIBUTE_mode = "mode";
    public static final String ATTRIBUTE_forecolor = "forecolor";
    public static final String ATTRIBUTE_backcolor = "backcolor";
    public static final String ATTRIBUTE_style = "style";
    public static final String ATTRIBUTE_pen = "pen";
    public static final String ATTRIBUTE_fill = "fill";
    public static final String ATTRIBUTE_radius = "radius";
    public static final String ATTRIBUTE_scaleImage = "scaleImage";
    public static final String ATTRIBUTE_hAlign = "hAlign";
    public static final String ATTRIBUTE_vAlign = "vAlign";
    public static final String ATTRIBUTE_border = "border";
    public static final String ATTRIBUTE_borderColor = "borderColor";
    public static final String ATTRIBUTE_padding = "padding";
    public static final String ATTRIBUTE_topBorder = "topBorder";
    public static final String ATTRIBUTE_topBorderColor = "topBorderColor";
    public static final String ATTRIBUTE_topPadding = "topPadding";
    public static final String ATTRIBUTE_leftBorder = "leftBorder";
    public static final String ATTRIBUTE_leftBorderColor = "leftBorderColor";
    public static final String ATTRIBUTE_leftPadding = "leftPadding";
    public static final String ATTRIBUTE_bottomBorder = "bottomBorder";
    public static final String ATTRIBUTE_bottomBorderColor = "bottomBorderColor";
    public static final String ATTRIBUTE_bottomPadding = "bottomPadding";
    public static final String ATTRIBUTE_rightBorder = "rightBorder";
    public static final String ATTRIBUTE_rightBorderColor = "rightBorderColor";
    public static final String ATTRIBUTE_rightPadding = "rightPadding";
    public static final String ATTRIBUTE_rotation = "rotation";
    public static final String ATTRIBUTE_lineSpacing = "lineSpacing";
    public static final String ATTRIBUTE_isStyledText = "isStyledText";
    public static final String ATTRIBUTE_pattern = "pattern";
    public static final String ATTRIBUTE_isBlankWhenNull = "isBlankWhenNull";
    public static final String ATTRIBUTE_fontName = "fontName";
    public static final String ATTRIBUTE_isBold = "isBold";
    public static final String ATTRIBUTE_isItalic = "isItalic";
    public static final String ATTRIBUTE_isUnderline = "isUnderline";
    public static final String ATTRIBUTE_isStrikeThrough = "isStrikeThrough";
    public static final String ATTRIBUTE_fontSize = "fontSize";
    public static final String ATTRIBUTE_pdfFontName = "pdfFontName";
    public static final String ATTRIBUTE_pdfEncoding = "pdfEncoding";
    public static final String ATTRIBUTE_isPdfEmbedded = "isPdfEmbedded";
    public static final String ATTRIBUTE_condition = "condition";
    private Vector conditionedStyles = new Vector();
    public static final String[] JRXMLStyleAttributes = new String[]{"name", "isDefault", "style", "mode", "forecolor", "backcolor", "pen", "fill", "radius", "scaleImage", "hAlign", "vAlign", "border", "borderColor", "padding", "topBorder", "topBorderColor", "topPadding", "leftBorder", "leftBorderColor", "leftPadding", "bottomBorder", "bottomBorderColor", "bottomPadding", "rightBorder", "rightBorderColor", "rightPadding", "rotation", "lineSpacing", "isStyledText", "fontName", "fontSize", "isBold", "isItalic", "isUnderline", "isStrikeThrough", "pdfFontName", "pdfEncoding", "isPdfEmbedded", "pattern", "isBlankWhenNull"};
    private String name = "";
    private HashMap attributes = new HashMap();
    private Style defaultStyle = null;

    public Style() {
    }

    public Style(Style s1) {
        for (Object key : s1.getAttributes().keySet()) {
            Object val = s1.getAttributes().get(key);
            this.getAttributes().put(key, val);
        }
        this.getAttributes().put(ATTRIBUTE_isDefault, "false");
        this.getConditionedStyles().clear();
        for (int i = 0; i < s1.getConditionedStyles().size(); ++i) {
            Style c_s = (Style)s1.getConditionedStyles().elementAt(i);
            this.getConditionedStyles().addElement(new ConditionedStyle(c_s));
        }
    }

    public void copyStyleFrom(Style s1) {
        for (Object key : s1.getAttributes().keySet()) {
            Object val = s1.getAttributes().get(key);
            this.getAttributes().put(key, val);
        }
        this.setConditionedStyles(s1.getConditionedStyles());
    }

    public String getName() {
        return this.getAttributes().get(ATTRIBUTE_name) == null ? null : this.getAttributes().get(ATTRIBUTE_name) + "";
    }

    public void setName(String name) {
        this.getAttributes().put(ATTRIBUTE_name, name);
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    public void setAttributes(HashMap attributes) {
        this.attributes = attributes;
    }

    public Object getAttribute(String attribute) {
        if (this.getAttributes().containsKey(attribute)) {
            return this.getAttributes().get(attribute);
        }
        return null;
    }

    public Object getAttribute(String attribute, boolean lookInParent) {
        return this.getAttributeSafe(attribute, lookInParent, null);
    }

    private Object getAttributeSafe(String attribute, boolean lookInParent, Collection coll) {
        if (this.getAttributes().containsKey(attribute)) {
            return this.getAttributes().get(attribute);
        }
        if (lookInParent && attribute != ATTRIBUTE_style && this.getParent() != null) {
            if (coll == null) {
                coll = new ArrayList<Style>();
            }
            coll.add(this);
            if (coll.contains(this.getParent())) {
                return null;
            }
            return this.getParent().getAttributeSafe(attribute, true, coll);
        }
        return null;
    }

    public String getAttributeString(String attribute, String defaultString) {
        return this.getAttributeString(attribute, defaultString, false);
    }

    public String getAttributeString(String attribute, String defaultString, boolean lookInParentToo) {
        Object obj = this.getAttribute(attribute, true);
        return obj != null ? "" + obj : defaultString;
    }

    public int getAttributeInteger(String attribute, int defaultInt) {
        return this.getAttributeInteger(attribute, defaultInt, false);
    }

    public int getAttributeInteger(String attribute, int defaultInt, boolean lookInParentToo) {
        Object obj = this.getAttribute(attribute, true);
        if (obj == null) {
            return defaultInt;
        }
        if (obj instanceof Double) {
            return ((Double)obj).intValue();
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        try {
            return Integer.parseInt(obj + "");
        }
        catch (Exception ex) {
            return defaultInt;
        }
    }

    public double getAttributeDouble(String attribute, double defaultDouble) {
        Object obj = this.getAttribute(attribute);
        if (obj == null) {
            return defaultDouble;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Integer) {
            return (double)((Integer)obj).intValue() * 1.0;
        }
        return defaultDouble;
    }

    public Color getAttributeColor(String attribute, Color defaultColor) {
        return this.getAttributeColor(attribute, defaultColor, false);
    }

    public Color getAttributeColor(String attribute, Color defaultColor, boolean lookInParentToo) {
        Object obj = this.getAttribute(attribute);
        if (obj == null) {
            return defaultColor;
        }
        if (obj instanceof Color) {
            return (Color)obj;
        }
        Color c = ColorSelectorPanel.parseColorString(obj + "");
        if (c != null) {
            return c;
        }
        return defaultColor;
    }

    public boolean getAttributeBoolean(String attribute, boolean defaultBoolean) {
        return this.getAttributeBoolean(attribute, defaultBoolean, false);
    }

    public boolean getAttributeBoolean(String attribute, boolean defaultBoolean, boolean lookInParentToo) {
        Object obj = this.getAttribute(attribute, lookInParentToo);
        if (obj == null) {
            return defaultBoolean;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        try {
            return Boolean.valueOf(obj + "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return defaultBoolean;
        }
    }

    public Style getParent() {
        Object obj = this.getAttributes().get(ATTRIBUTE_style);
        if (obj == null || !(obj instanceof Style)) {
            return null;
        }
        return (Style)obj;
    }

    public String toString() {
        return this.getName() + "";
    }

    public Vector getConditionedStyles() {
        return this.conditionedStyles;
    }

    public void setConditionedStyles(Vector conditionedStyles) {
        this.conditionedStyles = conditionedStyles;
    }

    public static boolean isDefaultValue(Object value, String attributeName, Style elementStyle, Style defaultStyle) {
        if (elementStyle == null && defaultStyle == null) {
            return false;
        }
        Style referenceStyle = elementStyle == null ? defaultStyle : elementStyle;
        Object defaultValue = referenceStyle.getAttribute(attributeName, true);
        if (defaultValue == null) {
            return false;
        }
        if (attributeName.endsWith("color") && value instanceof Color) {
            Color color = ColorSelectorPanel.parseColorString("" + defaultValue);
            return color.equals((Color)value);
        }
        return defaultValue.equals(value);
    }
}

