/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import nickyb.sqleonardo.common.util.Text;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.content.AbstractMaskPerform;
import nickyb.sqleonardo.environment.ctrl.content.ContentView;

public class MaskExport
extends AbstractMaskPerform {
    private AbstractChoice eChoice;

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        for (int i = 0; i < this.eChoice.getComponentCount(); ++i) {
            this.eChoice.getComponent(i).setEnabled(b);
        }
    }

    void setType(short type, String tname, String fname) {
        if (this.eChoice != null) {
            this.remove(this.eChoice);
        }
        this.progress.setValue(0);
        this.progress.setMaximum(0);
        if (type == 2) {
            if (!fname.endsWith(".htm") && !fname.endsWith(".html")) {
                fname = fname + ".html";
            }
            this.eChoice = new WebChoice();
            this.setComponentCenter(this.eChoice);
        } else if (type == 0) {
            if (!fname.endsWith(".sql")) {
                fname = fname + ".sql";
            }
            this.eChoice = new SqlChoice(tname);
            this.setComponentCenter(this.eChoice);
        } else if (type == 1) {
            if (!fname.endsWith(".txt")) {
                fname = fname + ".txt";
            }
            this.eChoice = new TxtChoice();
            this.setComponentCenter(this.eChoice);
        }
        this.lblFile.setText("file: " + fname);
    }

    void init(ContentView view) {
        super.init(view);
        this.progress.setValue(0);
        this.progress.setMaximum(view.getFlatRowCount());
        this.eChoice.open();
    }

    void next() {
        this.eChoice.handle(this.view.getValues(this.progress.getValue()));
        this.progress.setValue(this.progress.getValue() + 1);
    }

    boolean finished() {
        if (this.progress.getValue() == this.progress.getMaximum()) {
            this.eChoice.close();
            this.btnStop.setEnabled(false);
            this.lblMsg.setText("ready!");
            return true;
        }
        return false;
    }

    private class TxtChoice
    extends AbstractChoice {
        JCheckBox cbxHeader;
        JCheckBox cbxNull;
        JCheckBox cbxTrim;
        JRadioButton rbTab;
        JRadioButton rbOther;
        JTextField txtDelimiter;

        TxtChoice() {
            super("options");
            GridBagLayout gbl = new GridBagLayout();
            this.setLayout(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            this.cbxHeader = new JCheckBox("with header");
            gbl.setConstraints(this.cbxHeader, gbc);
            this.add(this.cbxHeader);
            this.cbxNull = new JCheckBox("null if blanks");
            this.cbxNull.setEnabled(false);
            gbl.setConstraints(this.cbxNull, gbc);
            this.add(this.cbxNull);
            this.cbxTrim = new JCheckBox("trim value");
            this.cbxTrim.setEnabled(false);
            gbl.setConstraints(this.cbxTrim, gbc);
            this.add(this.cbxTrim);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(5, 3, 0, 0);
            gbc.weighty = 1.0;
            JLabel lbl = new JLabel("delimiter:");
            gbl.setConstraints(lbl, gbc);
            this.add(lbl);
            this.rbTab = new JRadioButton("tab", true);
            gbl.setConstraints(this.rbTab, gbc);
            this.add(this.rbTab);
            this.rbOther = new JRadioButton("other");
            gbl.setConstraints(this.rbOther, gbc);
            this.add(this.rbOther);
            gbc.anchor = 17;
            this.txtDelimiter = new JTextField(";", 5);
            this.txtDelimiter.setEditable(false);
            this.txtDelimiter.setEnabled(false);
            gbl.setConstraints(this.txtDelimiter, gbc);
            this.add(this.txtDelimiter);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rbTab);
            bg.add(this.rbOther);
            this.rbTab.addItemListener(new ItemListener(this){
                private final /* synthetic */ TxtChoice this$1;
                {
                    this.this$1 = this$1;
                }

                public void itemStateChanged(ItemEvent e) {
                    this.this$1.txtDelimiter.setEditable(!this.this$1.rbTab.isSelected());
                    this.this$1.txtDelimiter.setEnabled(!this.this$1.rbTab.isSelected());
                }
            });
        }

        private String getDelimiter() {
            if (this.rbTab.isSelected()) {
                return "\t";
            }
            return this.txtDelimiter.getText();
        }

        void open() {
            super.open();
            if (this.cbxHeader.isSelected()) {
                StringBuffer buffer = new StringBuffer();
                for (int col = 0; col < MaskExport.this.view.getColumnCount(); ++col) {
                    buffer.append(MaskExport.this.view.getColumnName(col) + this.getDelimiter());
                }
                if (buffer.length() > 0) {
                    buffer.deleteCharAt(buffer.length() - 1);
                }
                this.println(buffer.toString());
            }
        }

        void handle(Object[] vals) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < vals.length; ++i) {
                String val = vals[i] == null ? "null" : vals[i].toString();
                buffer.append(val + this.getDelimiter());
            }
            if (buffer.length() > 0) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            this.println(buffer.toString());
        }
    }

    private class SqlChoice
    extends AbstractChoice {
        JCheckBox cbxDelete;
        JTextField txtTable;
        String insert;

        SqlChoice(String tname) {
            super("options");
            this.insert = null;
            GridBagLayout gbl = new GridBagLayout();
            this.setLayout(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            this.cbxDelete = new JCheckBox("with delete statement");
            gbl.setConstraints(this.cbxDelete, gbc);
            this.add(this.cbxDelete);
            gbc.gridwidth = -1;
            gbc.anchor = 18;
            gbc.insets = new Insets(5, 3, 0, 3);
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            JLabel lbl = new JLabel("table name:");
            gbl.setConstraints(lbl, gbc);
            this.add(lbl);
            gbc.fill = 2;
            this.txtTable = new JTextField(tname, 10);
            gbl.setConstraints(this.txtTable, gbc);
            this.add(this.txtTable);
        }

        void open() {
            super.open();
            if (this.cbxDelete.isSelected()) {
                this.println("DELETE FROM " + this.txtTable.getText() + ";");
            }
            StringBuffer buffer = new StringBuffer("INSERT INTO " + this.txtTable.getText() + " (");
            for (int col = 0; col < MaskExport.this.view.getColumnCount(); ++col) {
                buffer.append(MaskExport.this.view.getColumnName(col) + ",");
            }
            buffer.deleteCharAt(buffer.length() - 1);
            this.insert = buffer.toString() + ")";
        }

        void handle(Object[] vals) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < vals.length; ++i) {
                buffer.append(this.toSQLValue(vals[i], i + 1) + ",");
            }
            buffer.deleteCharAt(buffer.length() - 1);
            this.println(this.insert + " VALUES (" + buffer.toString() + ");");
        }

        private String toSQLValue(Object value, int col) {
            if (value == null) {
                return "null";
            }
            switch (MaskExport.this.view.getColumnType(col)) {
                case 1: 
                case 12: {
                    value = Text.replaceText(value.toString(), "'", "\\'");
                    return "'" + value.toString() + "'";
                }
                case 91: {
                    return "{d '" + value.toString() + "'}";
                }
                case 92: {
                    return "{t '" + value.toString() + "'}";
                }
                case 93: {
                    return "{ts '" + value.toString() + "'}";
                }
            }
            return value.toString();
        }
    }

    private class WebChoice
    extends AbstractChoice {
        JCheckBox cbxHeader;

        WebChoice() {
            super("options");
            this.setLayout(new FlowLayout(0));
            this.cbxHeader = new JCheckBox("with header");
            this.add(this.cbxHeader);
        }

        void open() {
            super.open();
            this.println("<html><body><table border=1>");
            if (this.cbxHeader.isSelected()) {
                this.print("<tr>");
                for (int col = 0; col < MaskExport.this.view.getColumnCount(); ++col) {
                    this.print("<th>" + MaskExport.this.view.getColumnName(col) + "</th>");
                }
                this.println("</tr>");
            }
        }

        void handle(Object[] vals) {
            this.print("<tr>");
            for (int i = 0; i < vals.length; ++i) {
                String val = vals[i] == null ? "null" : vals[i].toString();
                this.print("<td>" + val + "</td>");
            }
            this.println("</tr>");
        }

        void close() {
            this.println("</table></body></html>");
            super.close();
        }
    }

    private abstract class AbstractChoice
    extends JPanel {
        private PrintStream stream;

        AbstractChoice(String title) {
            this.setBorder(new TitledBorder(title));
        }

        void open() {
            try {
                this.stream = new PrintStream(new FileOutputStream(MaskExport.this.lblFile.getText().substring(6)));
            }
            catch (FileNotFoundException e) {
                Application.println(e, true);
            }
        }

        abstract void handle(Object[] var1);

        void close() {
            this.stream.close();
        }

        void print(String s) {
            this.stream.print(s);
        }

        void println(String s) {
            this.stream.println(s);
        }
    }
}

