/*
 * Copyright (C) 2005 - 2008 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * ToolbarConnectionPanel.java
 * 
 * Created on 7 mei 2005, 13:27
 *
 */

package it.businesslogic.ireport.gui;
//import it.businesslogic.ireport.gui.event.*;
//import it.businesslogic.ireport.undo.*;
//import it.businesslogic.ireport.util.*;
import javax.swing.JToolBar;



/**
 *
 * @Author: Robert Lamping
 */
public class ToolbarConnectionPanel extends javax.swing.JPanel {
    
    private boolean updating = false;
    private MainFrame mf = null; // MainFrame.getMainInstance();;
    private StringBuffer outputBuffer;
    
    
    /** Creates new form ToolbarFormatPanel */
    // Pass the workspace to this toolbar
    public ToolbarConnectionPanel(MainFrame mf ) {
        this.mf = mf;
        initComponents();
    }
    
    public JToolBar getToolBar() {
        // Make toolbar available to e.g. MainFrame
        return jToolBarConnections;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jToolBarConnections = new javax.swing.JToolBar();
        jComboBoxConnections = new javax.swing.JComboBox();
        jButtonDatasources = new javax.swing.JButton();

        setLayout(new java.awt.BorderLayout());

        setName("ToolbarConnectionPanel");
        getAccessibleContext().setAccessibleName("ToolbarConnectionPanel");
        jComboBoxConnections.setMaximumSize(new java.awt.Dimension(250, 32767));
        jComboBoxConnections.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxConnectionsActionPerformed(evt);
            }
        });

        jToolBarConnections.add(jComboBoxConnections);
        jComboBoxConnections.getAccessibleContext().setAccessibleName("ToolbarConnections");

        jButtonDatasources.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/datasources.png")));
        jButtonDatasources.setToolTipText("Datasources");
        jButtonDatasources.setBorder(null);
        jButtonDatasources.setBorderPainted(false);
        jButtonDatasources.setFocusPainted(false);
        jButtonDatasources.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonDatasources.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonDatasources.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonDatasources.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonDatasources.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDatasourcesActionPerformed(evt);
            }
        });

        jToolBarConnections.add(jButtonDatasources);

        add(jToolBarConnections, java.awt.BorderLayout.NORTH);
        jToolBarConnections.getAccessibleContext().setAccessibleName("ToolbarConnections");

    }// </editor-fold>//GEN-END:initComponents

    private void jButtonDatasourcesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDatasourcesActionPerformed
           try{
                ConnectionsDialog cd = new ConnectionsDialog(this.getMainFrame(),true);
                cd.setVisible(true);
                this.updateConnections();
            } catch (Exception ex)
            {
                ex.printStackTrace();
            }
    }//GEN-LAST:event_jButtonDatasourcesActionPerformed

    private void jComboBoxConnectionsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxConnectionsActionPerformed
        
        if (!updating && jComboBoxConnections.getSelectedItem() != null)
        {
            this.getMainFrame().getProperties().put("DefaultConnection",jComboBoxConnections.getSelectedItem());
            this.getMainFrame().saveiReportConfiguration();
        }
    }//GEN-LAST:event_jComboBoxConnectionsActionPerformed
                                                                        
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonDatasources;
    private javax.swing.JComboBox jComboBoxConnections;
    private javax.swing.JToolBar jToolBarConnections;
    // End of variables declaration//GEN-END:variables
    
    public javax.swing.JComboBox getJComboBoxConnextions()
    {
        return jComboBoxConnections;
    }
    
    public synchronized void updateConnections()
    {
        this.updating = true;
        
        try {
            it.businesslogic.ireport.util.Misc.updateComboBox(jComboBoxConnections,getMainFrame().getConnections());
            if (getMainFrame().getProperties().get("DefaultConnection") != null )
                jComboBoxConnections.setSelectedItem( getMainFrame().getProperties().get("DefaultConnection"));
        } catch (Exception ex)
        {
            ex.printStackTrace();
        }
        this.updating = false;
    }
    
    private MainFrame getMainFrame() {
        return mf;
    }
    
    
    
    
}
