/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class StyleRecord
extends Record {
    public static final short sid = 659;
    public static final short STYLE_USER_DEFINED = 0;
    public static final short STYLE_BUILT_IN = 1;
    private short field_1_xf_index;
    private byte field_2_builtin_style;
    private byte field_3_outline_style_level;
    private short field_2_name_length;
    private byte field_3_string_options;
    private BitField fHighByte;
    private String field_4_name;

    public StyleRecord() {
    }

    public StyleRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 659) {
            throw new RecordFormatException("NOT A STYLE RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.fHighByte = BitFieldFactory.getInstance(1);
        this.field_1_xf_index = in.readShort();
        if (this.getType() == 1) {
            this.field_2_builtin_style = in.readByte();
            this.field_3_outline_style_level = in.readByte();
        } else if (this.getType() == 0) {
            this.field_2_name_length = in.readShort();
            this.field_3_string_options = in.readByte();
            byte[] string = in.readRemainder();
            this.field_4_name = this.fHighByte.isSet(this.field_3_string_options) ? StringUtil.getFromUnicodeBE(string, 0, this.field_2_name_length) : StringUtil.getFromCompressedUnicode(string, 0, this.field_2_name_length);
        }
    }

    public void setIndex(short index) {
        this.field_1_xf_index = index;
    }

    public void setType(short type) {
        this.field_1_xf_index = this.setField(this.field_1_xf_index, type, 32768, 15);
    }

    public void setXFIndex(short index) {
        this.field_1_xf_index = this.setField(this.field_1_xf_index, index, 8191, 0);
    }

    public void setNameLength(byte length) {
        this.field_2_name_length = length;
    }

    public void setName(String name) {
        this.field_4_name = name;
    }

    public void setBuiltin(byte builtin) {
        this.field_2_builtin_style = builtin;
    }

    public void setOutlineStyleLevel(byte level) {
        this.field_3_outline_style_level = level;
    }

    public short getIndex() {
        return this.field_1_xf_index;
    }

    public short getType() {
        return (short)((this.field_1_xf_index & 0x8000) >> 15);
    }

    public short getXFIndex() {
        return (short)(this.field_1_xf_index & 0x1FFF);
    }

    public short getNameLength() {
        return this.field_2_name_length;
    }

    public String getName() {
        return this.field_4_name;
    }

    public byte getBuiltin() {
        return this.field_2_builtin_style;
    }

    public byte getOutlineStyleLevel() {
        return this.field_3_outline_style_level;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[STYLE]\n");
        buffer.append("    .xf_index_raw    = ").append(Integer.toHexString(this.getIndex())).append("\n");
        buffer.append("        .type        = ").append(Integer.toHexString(this.getType())).append("\n");
        buffer.append("        .xf_index    = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        if (this.getType() == 1) {
            buffer.append("    .builtin_style   = ").append(Integer.toHexString(this.getBuiltin())).append("\n");
            buffer.append("    .outline_level   = ").append(Integer.toHexString(this.getOutlineStyleLevel())).append("\n");
        } else if (this.getType() == 0) {
            buffer.append("    .name_length     = ").append(Integer.toHexString(this.getNameLength())).append("\n");
            buffer.append("    .name            = ").append(this.getName()).append("\n");
        }
        buffer.append("[/STYLE]\n");
        return buffer.toString();
    }

    private short setField(int fieldValue, int new_value, int mask, int shiftLeft) {
        return (short)(fieldValue & ~mask | new_value << shiftLeft & mask);
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)659);
        if (this.getType() == 1) {
            LittleEndian.putShort(data, 2 + offset, (short)4);
        } else {
            LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        }
        LittleEndian.putShort(data, 4 + offset, this.getIndex());
        if (this.getType() == 1) {
            data[6 + offset] = this.getBuiltin();
            data[7 + offset] = this.getOutlineStyleLevel();
        } else {
            LittleEndian.putShort(data, 6 + offset, this.getNameLength());
            data[8 + offset] = this.field_3_string_options;
            StringUtil.putCompressedUnicode(this.getName(), data, 9 + offset);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int retval = this.getType() == 1 ? 8 : (this.fHighByte.isSet(this.field_3_string_options) ? 9 + 2 * this.getNameLength() : 9 + this.getNameLength());
        return retval;
    }

    public short getSid() {
        return 659;
    }
}

