/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.gui.JRFontDialog;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class FontSheetPropertyComponent
extends JPanel {
    String expression = "";
    private Font font = null;
    private IReportFont ireportFont = null;
    private JButton jButton1;
    private JLabel jLabelFont;
    private EventListenerList listenerList = null;
    private int fontMode = 0;

    public FontSheetPropertyComponent() {
        this.initComponents();
        this.font = this.jLabelFont.getFont();
        this.applyI18n();
    }

    public void fontChanged() {
        ActionEvent event = new ActionEvent(this, 0, "");
        this.fireActionListenerActionPerformed(event);
    }

    private void initComponents() {
        this.jLabelFont = new JLabel();
        this.jButton1 = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(255, 255, 255));
        this.jLabelFont.setBackground(new Color(255, 255, 255));
        this.jLabelFont.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.jLabelFont, gridBagConstraints);
        this.jButton1.setText("...");
        this.jButton1.setMaximumSize(new Dimension(19, 10));
        this.jButton1.setMinimumSize(new Dimension(19, 10));
        this.jButton1.setPreferredSize(new Dimension(19, 10));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FontSheetPropertyComponent.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButton1, gridBagConstraints);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JRFontDialog jrfd = new JRFontDialog((Frame)MainFrame.getMainInstance(), true);
        jrfd.updateFonts(MainFrame.getMainInstance().getTtfFonts());
        jrfd.setReportFontMode(this.fontMode);
        if (this.ireportFont != null) {
            jrfd.setIReportFont((IReportFont)this.ireportFont.clone());
        } else {
            jrfd.setIReportFont(new IReportFont());
        }
        jrfd.setVisible(true);
        if (jrfd.getDialogResult() == 0) {
            this.setIreportFont(jrfd.getIReportFont());
            this.fontChanged();
        }
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ActionListener.class, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    private void fireActionListenerActionPerformed(ActionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public IReportFont getIreportFont() {
        return this.ireportFont;
    }

    public void setIreportFont(IReportFont ireportFont) {
        this.ireportFont = ireportFont;
        if (ireportFont == null) {
            ireportFont = new IReportFont();
        }
        this.jLabelFont.setFont(ireportFont.getJavaAWTFont());
        String bold = ireportFont.isBold() ? " bold" : "";
        this.jLabelFont.setText(ireportFont.getFontName() + " " + ireportFont.getFontSize() + bold);
    }

    public int getFontMode() {
        return this.fontMode;
    }

    public void setFontMode(int fontMode) {
        this.fontMode = fontMode;
    }

    public void applyI18n() {
        this.jButton1.setText(I18n.getString("fontSheetPropertyComponent.button1", "..."));
    }
}

