/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.calc.ParameterSlot;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpCacheDescriptor;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.CellReader;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;
import mondrian.util.Format;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapEvaluator
implements Evaluator {
    private static final Logger LOGGER = Logger.getLogger(RolapEvaluator.class);
    private static final Object nullResult = new Object();
    private final Member[] currentMembers;
    private final Evaluator parent;
    protected CellReader cellReader;
    private final int depth;
    private Member expandingMember;
    private boolean nonEmpty;
    protected final RolapEvaluatorRoot root;
    private int iterationLength;
    private boolean evalAxes;
    private final Member[] calcMembers;
    private int calcMemberCount;

    protected RolapEvaluator(RolapEvaluatorRoot root, RolapEvaluator parent, CellReader cellReader, Member[] currentMembers) {
        this.root = root;
        this.parent = parent;
        if (parent == null) {
            this.depth = 0;
            this.nonEmpty = false;
        } else {
            this.depth = parent.depth + 1;
            this.nonEmpty = parent.nonEmpty;
        }
        this.iterationLength = 1;
        this.evalAxes = false;
        this.cellReader = cellReader;
        this.currentMembers = currentMembers == null ? new Member[root.cube.getDimensions().length] : currentMembers;
        this.calcMembers = new Member[this.currentMembers.length];
        this.calcMemberCount = 0;
        for (Member member : this.currentMembers) {
            if (member == null || !member.isCalculated()) continue;
            this.addCalcMember(member);
        }
    }

    public RolapEvaluator(RolapEvaluatorRoot root) {
        this(root, null, null, null);
        Dimension[] dimensions;
        SchemaReader scr = this.root.connection.getSchemaReader();
        for (Dimension dimension : dimensions = this.root.cube.getDimensions()) {
            int ordinal = dimension.getOrdinal(this.root.cube);
            Hierarchy hier = dimension.getHierarchy();
            Member member = scr.getHierarchyDefaultMember(hier);
            if (member == null) {
                throw MondrianResource.instance().InvalidHierarchyCondition.ex(hier.getUniqueName());
            }
            HierarchyUsage[] hierarchyUsages = this.root.cube.getUsages(hier);
            if (hierarchyUsages.length != 0) {
                ((RolapMember)member).makeUniqueName(hierarchyUsages[0]);
            }
            this.currentMembers[ordinal] = member;
            if (!member.isCalculated()) continue;
            this.addCalcMember(member);
        }
        root.init(this);
    }

    public static Evaluator create(Query query) {
        RolapEvaluatorRoot root = new RolapEvaluatorRoot(query);
        return new RolapEvaluator(root);
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public Member[] getMembers() {
        return this.currentMembers;
    }

    void setCellReader(CellReader cellReader) {
        this.cellReader = cellReader;
    }

    @Override
    public Cube getCube() {
        return this.root.cube;
    }

    @Override
    public Query getQuery() {
        return this.root.query;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public Evaluator getParent() {
        return this.parent;
    }

    @Override
    public SchemaReader getSchemaReader() {
        return this.root.schemaReader;
    }

    @Override
    public Evaluator push(Member[] members) {
        RolapEvaluator evaluator = this._push();
        evaluator.setContext(members);
        return evaluator;
    }

    @Override
    public Evaluator push(Member member) {
        RolapEvaluator evaluator = this._push();
        evaluator.setContext(member);
        return evaluator;
    }

    @Override
    public Evaluator push() {
        return this._push();
    }

    protected RolapEvaluator _push() {
        this.getQuery().checkCancelOrTimeout();
        Member[] cloneCurrentMembers = (Member[])this.currentMembers.clone();
        RolapEvaluator newEvaluator = new RolapEvaluator(this.root, this, this.cellReader, cloneCurrentMembers);
        newEvaluator.setEvalAxes(this.evalAxes);
        return newEvaluator;
    }

    @Override
    public Evaluator pop() {
        return this.parent;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RolapEvaluator)) {
            return false;
        }
        RolapEvaluator that = (RolapEvaluator)obj;
        return Arrays.equals(this.currentMembers, that.currentMembers);
    }

    public void printCurrentMemberNames() {
        for (int i = 0; i < this.currentMembers.length; ++i) {
            Member m = this.currentMembers[i];
            if (m == null) {
                System.out.println("RolapEvaluator.printCurrentMemberNames: i=" + i + ", member NULL");
                continue;
            }
            System.out.println("RolapEvaluator.printCurrentMemberNames: i=" + i + ", member=" + m.getUniqueName());
        }
    }

    Member setContextConditional(Member member) {
        RolapMember m = (RolapMember)member;
        int ordinal = m.getDimension().getOrdinal(this.root.cube);
        if (ordinal >= this.currentMembers.length) {
            return null;
        }
        Member previous = this.currentMembers[ordinal];
        if (previous.isNull()) {
            return this.setContext(member);
        }
        if (previous.isMeasure()) {
            return this.setContext(member);
        }
        if (previous.isAll()) {
            return this.setContext(member);
        }
        RolapHierarchy heirarchy = m.getHierarchy();
        Member defaultMember = heirarchy.getDefaultMember();
        if (previous.equals(defaultMember) && !previous.equals(member)) {
            return this.setContext(member);
        }
        return null;
    }

    @Override
    public Member setContext(Member member) {
        RolapMember m = (RolapMember)member;
        int ordinal = m.getDimension().getOrdinal(this.root.cube);
        Member previous = this.currentMembers[ordinal];
        if (previous.isCalculated()) {
            this.removeCalcMember(previous);
        }
        this.currentMembers[ordinal] = m;
        if (m.isCalculated()) {
            this.addCalcMember(m);
        }
        return previous;
    }

    @Override
    public void setContext(List<Member> memberList) {
        int i = 0;
        for (Member member : memberList) {
            if (member == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("RolapEvaluator.setContext: member == null  , count=" + i));
                }
                assert (false);
            } else {
                this.setContext(member);
            }
            ++i;
        }
    }

    @Override
    public void setContext(Member[] members) {
        for (int i = 0; i < members.length; ++i) {
            Member member = members[i];
            if (member == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("RolapEvaluator.setContext: member == null  , count=" + i));
                }
                assert (false);
                continue;
            }
            this.setContext(member);
        }
    }

    @Override
    public Member getContext(Dimension dimension) {
        return this.currentMembers[dimension.getOrdinal(this.root.cube)];
    }

    @Override
    public Object evaluateCurrent() {
        Member maxSolveMember = this.peekCalcMember();
        if (maxSolveMember == null) {
            Object o = this.cellReader.get(this);
            if (o == Util.nullValue) {
                o = null;
            }
            return o;
        }
        RolapMember defaultMember = (RolapMember)maxSolveMember.getHierarchy().getDefaultMember();
        Util.assertTrue(defaultMember != maxSolveMember, "default member must not be calculated");
        RolapEvaluator evaluator = (RolapEvaluator)this.push(defaultMember);
        evaluator.setExpanding(maxSolveMember);
        Exp exp = maxSolveMember.getExpression();
        Calc calc = this.root.getCompiled(exp, true);
        Object o = calc.evaluate(evaluator);
        if (o == Util.nullValue) {
            o = null;
        }
        return o;
    }

    private void setExpanding(Member member) {
        this.expandingMember = member;
        int memberCount = this.currentMembers.length;
        if (this.depth > memberCount && this.depth % memberCount == 0) {
            RolapEvaluator.checkRecursion((RolapEvaluator)this.parent);
        }
    }

    private static void checkRecursion(RolapEvaluator eval) {
        while (true) {
            if (eval == null) {
                return;
            }
            if (eval.expandingMember != null) break;
            eval = (RolapEvaluator)eval.getParent();
        }
        block1: for (RolapEvaluator eval2 = (RolapEvaluator)eval.getParent(); eval2 != null; eval2 = (RolapEvaluator)eval2.getParent()) {
            if (eval2.expandingMember != eval.expandingMember) continue;
            for (int i = 0; i < eval.currentMembers.length; ++i) {
                Member member = eval2.currentMembers[i];
                if (member == null) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("RolapEvaluator.checkRecursion: member == null  , count=" + i));
                    continue;
                }
                Member parentMember = eval.getContext(member.getDimension());
                if (member != parentMember) continue block1;
            }
            throw FunUtil.newEvalException(null, "Infinite loop while evaluating calculated member '" + eval.expandingMember + "'; context stack is " + eval.getContextString());
        }
    }

    private String getContextString() {
        boolean skipDefaultMembers = true;
        StringBuilder buf = new StringBuilder("{");
        int frameCount = 0;
        for (RolapEvaluator eval = this; eval != null; eval = (RolapEvaluator)eval.getParent()) {
            if (eval.expandingMember == null) continue;
            if (frameCount++ > 0) {
                buf.append(", ");
            }
            buf.append("(");
            int memberCount = 0;
            for (Member m : eval.currentMembers) {
                if (skipDefaultMembers && m == m.getHierarchy().getDefaultMember()) continue;
                if (memberCount++ > 0) {
                    buf.append(", ");
                }
                buf.append(m.getUniqueName());
            }
            buf.append(")");
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public Object getProperty(String name, Object defaultValue) {
        Object o = defaultValue;
        int maxSolve = Integer.MIN_VALUE;
        for (int i = 0; i < this.currentMembers.length; ++i) {
            int solve;
            Member member = this.currentMembers[i];
            if (member == null) {
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug((Object)("RolapEvaluator.getProperty: member == null  , count=" + i));
                continue;
            }
            Object p = member.getPropertyValue(name);
            if (p == null || (solve = member.getSolveOrder()) <= maxSolve) continue;
            o = p;
            maxSolve = solve;
        }
        return o;
    }

    @Override
    public String getFormatString() {
        Exp formatExp = (Exp)this.getProperty(Property.FORMAT_EXP.name, null);
        if (formatExp == null) {
            return "Standard";
        }
        Calc formatCalc = this.root.getCompiled(formatExp, true);
        Object o = formatCalc.evaluate(this);
        if (o == null) {
            return "Standard";
        }
        return o.toString();
    }

    private Format getFormat() {
        String formatString = this.getFormatString();
        return this.getFormat(formatString);
    }

    private Format getFormat(String formatString) {
        return Format.get(formatString, this.root.connection.getLocale());
    }

    @Override
    public Locale getConnectionLocale() {
        return this.root.connection.getLocale();
    }

    String format(Evaluator evaluator, Object o) {
        return this.getFormat().format(o);
    }

    @Override
    public String format(Object o) {
        if (o == Util.nullValue) {
            Format format = this.getFormat();
            return format.format(null);
        }
        if (o instanceof Throwable) {
            return "#ERR: " + o.toString();
        }
        if (o instanceof String) {
            return (String)o;
        }
        Format format = this.getFormat();
        return format.format(o);
    }

    @Override
    public String format(Object o, String formatString) {
        if (o == Util.nullValue) {
            Format format = this.getFormat(formatString);
            return format.format(null);
        }
        if (o instanceof Throwable) {
            return "#ERR: " + o.toString();
        }
        if (o instanceof String) {
            return (String)o;
        }
        Format format = this.getFormat(formatString);
        return format.format(o);
    }

    private Object getExpResultCacheKey(ExpCacheDescriptor descriptor) {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(descriptor.getExp());
        int[] dimensionOrdinals = descriptor.getDependentDimensionOrdinals();
        for (int i = 0; i < dimensionOrdinals.length; ++i) {
            int dimensionOrdinal = dimensionOrdinals[i];
            Member member = this.currentMembers[dimensionOrdinal];
            if (member == null) {
                this.getLogger().debug((Object)("RolapEvaluator.getExpResultCacheKey: member == null; dimensionOrdinal=" + i));
                continue;
            }
            key.add(member);
        }
        return key;
    }

    @Override
    public Object getCachedResult(ExpCacheDescriptor cacheDescriptor) {
        Object key = this.getExpResultCacheKey(cacheDescriptor);
        Object result = this.root.expResultCache.get(key);
        if (result == null) {
            result = cacheDescriptor.evaluate(this);
            this.root.expResultCache.put(key, result == null ? nullResult : result);
        } else if (result == nullResult) {
            result = null;
        }
        return result;
    }

    public void clearExpResultCache() {
        this.root.expResultCache.clear();
        this.root.clearNamedSets();
    }

    @Override
    public boolean isNonEmpty() {
        return this.nonEmpty;
    }

    @Override
    public void setNonEmpty(boolean nonEmpty) {
        this.nonEmpty = nonEmpty;
    }

    @Override
    public RuntimeException newEvalException(Object context, String s) {
        return FunUtil.newEvalException((FunDef)context, s);
    }

    @Override
    public Object evaluateNamedSet(String name, Exp exp) {
        return this.root.evaluateNamedSet(name, exp);
    }

    @Override
    public int getMissCount() {
        return this.cellReader.getMissCount();
    }

    @Override
    public Object getParameterValue(ParameterSlot slot) {
        return this.root.getParameterValue(slot);
    }

    void addCalcMember(Member member) {
        assert (member != null);
        assert (member.isCalculated());
        this.calcMembers[this.calcMemberCount++] = member;
    }

    private Member peekCalcMember() {
        switch (this.calcMemberCount) {
            case 0: {
                return null;
            }
            case 1: {
                return this.calcMembers[0];
            }
        }
        Member maxSolveMember = this.calcMembers[0];
        int maxSolve = maxSolveMember.getSolveOrder();
        for (int i = 1; i < this.calcMemberCount; ++i) {
            Member member = this.calcMembers[i];
            int solve = member.getSolveOrder();
            if (solve < maxSolve || solve <= maxSolve && member.getDimension().getOrdinal(this.root.cube) >= maxSolveMember.getDimension().getOrdinal(this.root.cube)) continue;
            maxSolve = solve;
            maxSolveMember = member;
        }
        return maxSolveMember;
    }

    private void removeCalcMember(Member previous) {
        for (int i = 0; i < this.calcMemberCount; ++i) {
            Member calcMember = this.calcMembers[i];
            if (calcMember != previous) continue;
            --this.calcMemberCount;
            this.calcMembers[i] = this.calcMembers[this.calcMemberCount];
            this.calcMembers[this.calcMemberCount] = null;
        }
    }

    @Override
    public int getIterationLength() {
        return this.iterationLength;
    }

    @Override
    public void setIterationLength(int length) {
        this.iterationLength = length;
    }

    @Override
    public boolean isEvalAxes() {
        return this.evalAxes;
    }

    @Override
    public void setEvalAxes(boolean evalAxes) {
        this.evalAxes = evalAxes;
    }

    protected static class RolapEvaluatorRoot {
        final Map<Object, Object> expResultCache = new HashMap<Object, Object>();
        final RolapCube cube;
        final RolapConnection connection;
        final SchemaReader schemaReader;
        final Map<Exp, Calc> compiledExps = new HashMap<Exp, Calc>();
        private final Query query;

        public RolapEvaluatorRoot(Query query) {
            this.query = query;
            this.cube = (RolapCube)query.getCube();
            this.connection = (RolapConnection)query.getConnection();
            this.schemaReader = query.getSchemaReader(true);
        }

        Calc getCompiled(Exp exp, boolean scalar) {
            Calc calc = this.compiledExps.get(exp);
            if (calc == null) {
                calc = this.query.compileExpression(exp, scalar);
                this.compiledExps.put(exp, calc);
            }
            return calc;
        }

        protected Object evaluateNamedSet(String name, Exp exp) {
            throw new UnsupportedOperationException();
        }

        protected void clearNamedSets() {
        }

        protected void init(Evaluator evaluator) {
        }

        public Object getParameterValue(ParameterSlot slot) {
            throw new UnsupportedOperationException();
        }
    }
}

