/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class BeginRecord
extends Record {
    public static final short sid = 4147;

    public BeginRecord() {
    }

    public BeginRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 4147) {
            throw new RecordFormatException("NOT A BEGIN RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[BEGIN]\n");
        buffer.append("[/BEGIN]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)4147);
        LittleEndian.putShort(data, 2 + offset, (short)0);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4;
    }

    public short getSid() {
        return 4147;
    }
}

