/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Calendar;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import rex.utils.AppColors;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public class StatusBar
extends JPanel
implements LanguageChangedListener {
    private JLabel status;
    private JLabel progress;
    private JLabel dataCellsNo;
    private JLabel clientTime;
    private JLabel serverTime;
    private JLabel memUsage;
    Timer timer;
    private boolean stopProgressing;
    private long clientStart;
    private long clientStop;
    private long serverStart;
    private long serverStop;
    private static long MB = 0x100000L;
    private static ImageIcon[][] progressIcon;
    public static int JOB_TYPE_NORMAL;
    public static int JOB_TYPE_CRITICAL;

    public StatusBar() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(AppColors.STATUS_BAR_BORDER);
        this.setOpaque(true);
        this.setBackground(AppColors.STATUS_BAR_BACKGROUND);
        this.status = new JLabel(" ");
        this.status.setPreferredSize(new Dimension(Short.MAX_VALUE, 20));
        this.status.setBorder(AppColors.STATUS_BAR_STATUS_MESSAGE_BORDER);
        this.progress = new JLabel(" ");
        this.progress.setBorder(AppColors.STATUS_BAR_PROGRESSBAR_BORDER);
        this.progress.setMinimumSize(new Dimension(95, 20));
        this.progress.setPreferredSize(new Dimension(95, 20));
        this.dataCellsNo = new JLabel(" ");
        this.dataCellsNo.setBorder(AppColors.STATUS_BAR_DATA_CELLS_NO_BORDER);
        this.clientTime = new JLabel(" ");
        this.clientTime.setBorder(AppColors.STATUS_BAR_TIME_BORDER);
        this.serverTime = new JLabel(" ");
        this.serverTime.setBorder(AppColors.STATUS_BAR_TIME_BORDER);
        this.memUsage = new JLabel(" ");
        this.memUsage.setBorder(AppColors.STATUS_BAR_MEM_USAGE_BORDER);
        this.refreshMemUsage();
        this.add(this.status);
        this.add(Box.createHorizontalGlue());
        this.add(this.progress);
        this.add(this.dataCellsNo);
        this.add(this.clientTime);
        this.add(this.serverTime);
        this.add(this.memUsage);
        JLabel runGC = new JLabel(S.getAppIcon("garbage_can.gif"));
        runGC.setBorder(AppColors.STATUS_BAR_RUN_GC_BORDER);
        runGC.setMaximumSize(new Dimension(30, 18));
        runGC.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                StatusBar.this.setStatus(I18n.getString("label.gC"));
                Runtime.getRuntime().gc();
                StatusBar.this.refreshMemUsage();
                StatusBar.this.setStatus(I18n.getString("statusBar.ready"));
            }
        });
        this.add(runGC);
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
    }

    public void startClientClock() {
        this.clientStart = Calendar.getInstance().getTimeInMillis();
        if (this.timer == null) {
            this.stopProgressing = false;
        }
    }

    public void stopClientClock() {
        this.clientStop = Calendar.getInstance().getTimeInMillis() - this.clientStart;
        this.calculateTimeDiff(I18n.getString("label.clientTime"), this.clientTime, this.clientStop);
        this.stopProgressing = true;
    }

    public void startServerClock() {
        this.serverStart = Calendar.getInstance().getTimeInMillis();
    }

    public void stopServerClock() {
        this.serverStop = Calendar.getInstance().getTimeInMillis() - this.serverStart;
        this.calculateTimeDiff(I18n.getString("label.serverTime"), this.serverTime, this.serverStop);
    }

    private void calculateTimeDiff(String prefix, JLabel lab, long diff) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(2);
        lab.setText("" + prefix + nf.format(diff / 60000L) + ":" + nf.format(diff / 1000L % 60L) + ":" + nf.format(diff % 1000L));
    }

    public void setStatus(String _status) {
        this.status.setText(_status);
        S.out("Setting status:\t" + _status);
        this.paintComponentImmediately(this.status);
        this.refreshMemUsage();
    }

    private void refreshMemUsage() {
        this.memUsage.setText(Runtime.getRuntime().totalMemory() / MB + "/" + Runtime.getRuntime().maxMemory() / MB + "MB");
    }

    public void setProgressText(String p) {
        this.progress.setText(p);
        this.progress.repaint();
        this.getRootPane().repaint();
    }

    public String getProgressText() {
        return this.progress.getText();
    }

    public void setDataCellsNumber(int rowNum, int colNum) {
        this.dataCellsNo.setText(I18n.getString("label.dataCells") + rowNum + "x" + colNum + "=" + rowNum * colNum + I18n.getString("label.cells") + " ");
    }

    private void paintComponentImmediately(JComponent c) {
        Rectangle progressRect = c.getBounds();
        progressRect.x = 0;
        progressRect.y = 0;
        c.paintImmediately(progressRect);
    }

    public void progressJob(Runnable job, int jobType) {
        Thread jobThread = new Thread(job);
        this.progress.setIcon(progressIcon[jobType][0]);
        jobThread.start();
        int loop = 0;
        while (jobThread.isAlive()) {
            try {
                jobThread.join((int)Math.exp(loop > 5 ? (double)loop : 0.0) + 100);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            loop = (loop + 1) % 12;
            this.progress.setIcon(progressIcon[jobType][loop]);
            this.paintComponentImmediately(this.progress);
        }
        while (loop < 12) {
            this.progress.setIcon(progressIcon[jobType][loop]);
            this.paintComponentImmediately(this.progress);
            ++loop;
        }
        this.progress.setIcon(null);
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public void applyI18n() {
        this.status.setText(" ");
        this.progress.setText(" ");
        this.dataCellsNo.setText(" ");
        this.clientTime.setText(" ");
        this.serverTime.setText(" ");
        this.memUsage.setText(" ");
        this.status.setPreferredSize(new Dimension(Short.MAX_VALUE, 20));
        this.progress.setPreferredSize(new Dimension(125, 20));
        this.dataCellsNo.setPreferredSize(new Dimension(135, 20));
        this.clientTime.setPreferredSize(new Dimension(135, 20));
        this.serverTime.setPreferredSize(new Dimension(135, 20));
        this.memUsage.setPreferredSize(new Dimension(125, 20));
    }

    static {
        JOB_TYPE_NORMAL = 0;
        JOB_TYPE_CRITICAL = 1;
        progressIcon = new ImageIcon[2][12];
        StatusBar.progressIcon[0][0] = S.getAppIcon("pbar01.gif");
        StatusBar.progressIcon[0][1] = S.getAppIcon("pbar02.gif");
        StatusBar.progressIcon[0][2] = S.getAppIcon("pbar03.gif");
        StatusBar.progressIcon[0][3] = S.getAppIcon("pbar04.gif");
        StatusBar.progressIcon[0][4] = S.getAppIcon("pbar05.gif");
        StatusBar.progressIcon[0][5] = S.getAppIcon("pbar06.gif");
        StatusBar.progressIcon[0][6] = S.getAppIcon("pbar07.gif");
        StatusBar.progressIcon[0][7] = S.getAppIcon("pbar08.gif");
        StatusBar.progressIcon[0][8] = S.getAppIcon("pbar09.gif");
        StatusBar.progressIcon[0][9] = S.getAppIcon("pbar010.gif");
        StatusBar.progressIcon[0][10] = S.getAppIcon("pbar011.gif");
        StatusBar.progressIcon[0][11] = S.getAppIcon("pbar012.gif");
        StatusBar.progressIcon[1][0] = S.getAppIcon("pbar11.gif");
        StatusBar.progressIcon[1][1] = S.getAppIcon("pbar12.gif");
        StatusBar.progressIcon[1][2] = S.getAppIcon("pbar13.gif");
        StatusBar.progressIcon[1][3] = S.getAppIcon("pbar14.gif");
        StatusBar.progressIcon[1][4] = S.getAppIcon("pbar15.gif");
        StatusBar.progressIcon[1][5] = S.getAppIcon("pbar16.gif");
        StatusBar.progressIcon[1][6] = S.getAppIcon("pbar17.gif");
        StatusBar.progressIcon[1][7] = S.getAppIcon("pbar18.gif");
        StatusBar.progressIcon[1][8] = S.getAppIcon("pbar19.gif");
        StatusBar.progressIcon[1][9] = S.getAppIcon("pbar110.gif");
        StatusBar.progressIcon[1][10] = S.getAppIcon("pbar111.gif");
        StatusBar.progressIcon[1][11] = S.getAppIcon("pbar112.gif");
    }
}

