/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin.wsclient;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.irplugin.JServer;
import com.jaspersoft.jasperserver.irplugin.wsclient.FileContent;
import com.jaspersoft.jasperserver.irplugin.wsclient.ManagementService;
import com.jaspersoft.jasperserver.irplugin.wsclient.ManagementServiceServiceLocator;
import com.jaspersoft.jasperserver.irplugin.wsclient.RequestAttachment;
import com.jaspersoft.jasperserver.ws.xml.Marshaller;
import com.jaspersoft.jasperserver.ws.xml.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.client.Stub;

public class WSClient {
    private JServer server = null;
    private String webservicesUri = null;
    private ManagementService managementService = null;
    private Unmarshaller unmarshaller = new Unmarshaller();
    private Marshaller marshaller = new Marshaller();
    private String cachedServerVersion;

    public WSClient(JServer server) throws Exception {
        URL url;
        this.server = server;
        try {
            url = new URL(server.getUrl());
        }
        catch (MalformedURLException e1) {
            throw new Exception(e1);
        }
        this.setWebservicesUri(url.toString());
    }

    public List listDatasources() throws Exception {
        Request req = new Request();
        req.setOperationName("list");
        req.setResourceDescriptor(null);
        req.setLocale(this.getServer().getLocale());
        req.getArguments().add(new Argument("LIST_DATASOURCES", "true"));
        StringWriter xmlStringWriter = new StringWriter();
        Marshaller.marshal((Object)req, (StringWriter)xmlStringWriter);
        return this.list(xmlStringWriter.toString());
    }

    public List list(ResourceDescriptor descriptor) throws Exception {
        Request req = new Request();
        req.setOperationName("list");
        req.setResourceDescriptor(descriptor);
        req.setLocale(this.getServer().getLocale());
        StringWriter xmlStringWriter = new StringWriter();
        Marshaller.marshal((Object)req, (StringWriter)xmlStringWriter);
        return this.list(xmlStringWriter.toString());
    }

    public String getVersion() throws Exception {
        if (this.cachedServerVersion != null) {
            return this.cachedServerVersion;
        }
        Request req = new Request();
        req.setOperationName("list");
        req.setResourceDescriptor(null);
        req.setLocale(this.getServer().getLocale());
        try {
            ManagementService ms = this.getManagementService();
            String reqXml = this.marshaller.marshal(req);
            String result = ms.list(reqXml);
            OperationResult or = (OperationResult)this.unmarshaller.unmarshal(result);
            if (or.getReturnCode() != 0) {
                throw new Exception(or.getReturnCode() + " - " + or.getMessage());
            }
            String string = this.cachedServerVersion = or.getVersion();
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public List list(String xmlRequest) throws Exception {
        try {
            String result = this.getManagementService().list(xmlRequest);
            OperationResult or = (OperationResult)this.unmarshaller.unmarshal(result);
            if (or.getReturnCode() != 0) {
                throw new Exception(or.getReturnCode() + " - " + or.getMessage());
            }
            List list = or.getResourceDescriptors();
            return list;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public void delete(ResourceDescriptor descriptor) throws Exception {
        this.delete(descriptor, null);
    }

    public void delete(ResourceDescriptor descriptor, String reportUnitUri) throws Exception {
        try {
            String result;
            OperationResult or;
            Request req = new Request();
            req.setOperationName("delete");
            req.setResourceDescriptor(descriptor);
            req.setLocale(this.getServer().getLocale());
            if (reportUnitUri != null && reportUnitUri.length() > 0) {
                req.getArguments().add(new Argument("MODIFY_REPORTUNIT_URI", reportUnitUri));
            }
            if ((or = (OperationResult)this.unmarshaller.unmarshal(result = this.getManagementService().delete(this.marshaller.marshal(req)))).getReturnCode() != 0) {
                throw new Exception(or.getReturnCode() + " - " + or.getMessage());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public ResourceDescriptor get(ResourceDescriptor descriptor, File outputFile) throws Exception {
        return this.get(descriptor, outputFile, null);
    }

    public ResourceDescriptor get(ResourceDescriptor descriptor, File outputFile, List args) throws Exception {
        try {
            String result;
            OperationResult or;
            Request req = new Request();
            req.setOperationName("get");
            req.setResourceDescriptor(descriptor);
            req.setLocale(this.getServer().getLocale());
            if (args != null) {
                for (int i = 0; i < args.size(); ++i) {
                    Argument arg = (Argument)args.get(i);
                    req.getArguments().add(arg);
                }
            }
            if (outputFile == null) {
                req.getArguments().add(new Argument("NO_ATTACHMENT", null));
            }
            if ((or = (OperationResult)this.unmarshaller.unmarshal(result = this.getManagementService().get(this.marshaller.marshal(req)))).getReturnCode() != 0) {
                throw new Exception(or.getReturnCode() + " - " + or.getMessage());
            }
            Object[] resAtts = ((Stub)this.getManagementService()).getAttachments();
            if (resAtts != null && resAtts.length > 0 && outputFile != null) {
                InputStream is = ((AttachmentPart)resAtts[0]).getDataHandler().getInputStream();
                byte[] buffer = new byte[1024];
                FileOutputStream os = new FileOutputStream(outputFile);
                int bCount = 0;
                while ((bCount = is.read(buffer)) > 0) {
                    ((OutputStream)os).write(buffer, 0, bCount);
                }
                is.close();
                ((OutputStream)os).close();
            } else if (outputFile != null) {
                throw new Exception("Attachment not present!");
            }
            ResourceDescriptor resourceDescriptor = (ResourceDescriptor)or.getResourceDescriptors().get(0);
            return resourceDescriptor;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public JasperPrint runReport(ResourceDescriptor descriptor, Map parameters) throws Exception {
        ArrayList<Argument> args = new ArrayList<Argument>(1);
        args.add(new Argument("RUN_OUTPUT_FORMAT", "JRPRINT"));
        Map attachments = this.runReport(descriptor, parameters, args);
        FileContent content = null;
        if (attachments != null && !attachments.isEmpty()) {
            content = (FileContent)attachments.values().toArray()[0];
        }
        if (content == null) {
            throw new Exception("No JasperPrint");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(content.getData());
        JasperPrint print = (JasperPrint)JRLoader.loadObject((InputStream)is);
        return print;
    }

    public Map runReport(ResourceDescriptor descriptor, Map parameters, List args) throws Exception {
        try {
            Request req = new Request();
            req.setOperationName("runReport");
            req.setLocale(this.getServer().getLocale());
            ResourceDescriptor newRUDescriptor = new ResourceDescriptor();
            newRUDescriptor.setUriString(descriptor.getUriString());
            Iterator i = parameters.keySet().iterator();
            while (i.hasNext()) {
                String key = "" + i.next();
                Object value = parameters.get(key);
                if (value instanceof Collection) {
                    Iterator cIter = ((Collection)value).iterator();
                    while (cIter.hasNext()) {
                        String item = "" + cIter.next();
                        ListItem l = new ListItem(key + "", (Object)item);
                        l.setIsListItem(true);
                        newRUDescriptor.getParameters().add(l);
                    }
                    continue;
                }
                newRUDescriptor.getParameters().add(new ListItem(key + "", parameters.get(key)));
            }
            req.setResourceDescriptor(newRUDescriptor);
            req.getArguments().addAll(args);
            String result = this.getManagementService().runReport(this.marshaller.marshal(req));
            OperationResult or = (OperationResult)this.unmarshaller.unmarshal(result);
            if (or.getReturnCode() != 0) {
                throw new Exception(or.getReturnCode() + " - " + or.getMessage());
            }
            HashMap<String, FileContent> results = new HashMap<String, FileContent>();
            Object[] resAtts = ((Stub)this.getManagementService()).getAttachments();
            boolean attachFound = false;
            for (int i2 = 0; resAtts != null && i2 < resAtts.length; ++i2) {
                int bytesRead;
                attachFound = true;
                DataHandler actualDH = ((AttachmentPart)resAtts[i2]).getDataHandler();
                String name = actualDH.getName();
                String contentId = ((AttachmentPart)resAtts[i2]).getContentId();
                if (name == null) {
                    name = "attachment-" + i2;
                }
                if (contentId == null) {
                    contentId = "attachment-" + i2;
                }
                InputStream is = actualDH.getInputStream();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] data = new byte[1000];
                while ((bytesRead = is.read(data)) != -1) {
                    bos.write(data, 0, bytesRead);
                }
                data = bos.toByteArray();
                String contentType = actualDH.getContentType();
                FileContent content = new FileContent();
                content.setData(data);
                content.setMimeType(contentType);
                content.setName(name);
                results.put(contentId, content);
            }
            if (!attachFound) {
                throw new Exception("Attachment not present!");
            }
            HashMap<String, FileContent> hashMap = results;
            return hashMap;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public ResourceDescriptor addOrModifyResource(ResourceDescriptor descriptor, File inputFile) throws Exception {
        return this.modifyReportUnitResource(null, descriptor, inputFile);
    }

    public ResourceDescriptor putResource(ResourceDescriptor descriptor, RequestAttachment[] attachments) throws Exception {
        return this.putReportUnitResource(null, descriptor, attachments);
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public String getUsername() {
        return this.getServer().getUsername();
    }

    public String getPassword() {
        return this.getServer().getPassword();
    }

    public ResourceDescriptor modifyReportUnitResource(String reportUnitUri, ResourceDescriptor descriptor, File inputFile) throws Exception {
        RequestAttachment[] attachments;
        if (inputFile == null) {
            attachments = new RequestAttachment[]{};
        } else {
            FileDataSource fileDataSource = new FileDataSource(inputFile);
            RequestAttachment attachment = new RequestAttachment((DataSource)fileDataSource);
            attachments = new RequestAttachment[]{attachment};
        }
        return this.putReportUnitResource(reportUnitUri, descriptor, attachments);
    }

    public ResourceDescriptor putReportUnitResource(String reportUnitUri, ResourceDescriptor descriptor, RequestAttachment[] attachments) throws Exception {
        try {
            Request req = new Request();
            req.setOperationName("put");
            req.setLocale(this.getServer().getLocale());
            if (reportUnitUri != null && reportUnitUri.length() > 0) {
                req.getArguments().add(new Argument("MODIFY_REPORTUNIT_URI", reportUnitUri));
            }
            ManagementService ms = this.getManagementService();
            if (attachments != null && attachments.length > 0) {
                descriptor.setHasData(true);
                ((Stub)ms)._setProperty("attachment_encapsulation_format", (Object)"axis.attachment.style.dime");
                for (int i = 0; i < attachments.length; ++i) {
                    RequestAttachment attachment = attachments[i];
                    DataHandler attachmentHandler = new DataHandler(attachment.getDataSource());
                    AttachmentPart attachmentPart = new AttachmentPart(attachmentHandler);
                    if (attachment.getContentID() != null) {
                        attachmentPart.setContentId(attachment.getContentID());
                    }
                    ((Stub)ms).addAttachment((Object)attachmentPart);
                }
            }
            req.setResourceDescriptor(descriptor);
            String result = ms.put(this.marshaller.marshal(req));
            OperationResult or = (OperationResult)this.unmarshaller.unmarshal(result);
            if (or.getReturnCode() != 0) {
                throw new Exception(or.getReturnCode() + " - " + or.getMessage());
            }
            ResourceDescriptor resourceDescriptor = (ResourceDescriptor)or.getResourceDescriptors().get(0);
            return resourceDescriptor;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public String getWebservicesUri() {
        return this.webservicesUri;
    }

    public void setWebservicesUri(String webservicesUri) {
        this.webservicesUri = webservicesUri;
    }

    public ManagementService getManagementService() throws Exception {
        if (this.managementService == null) {
            ManagementServiceServiceLocator rsl = new ManagementServiceServiceLocator();
            this.managementService = rsl.getrepository(new URL(this.getWebservicesUri()));
            ((Stub)this.managementService).setUsername(this.getUsername());
            ((Stub)this.managementService).setPassword(this.getPassword());
            ((Stub)this.managementService).setMaintainSession(true);
        }
        return this.managementService;
    }

    public void setManagementService(ManagementService managementService) {
        this.managementService = managementService;
    }
}

