/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.Calendar;
import mondrian.util.DateSchedule;
import mondrian.util.ScheduleUtil;

class WeeklyDateSchedule
implements DateSchedule {
    int period;
    int beginOrdinal;
    int daysOfWeekBitmap;

    WeeklyDateSchedule(Calendar begin, int period, int daysOfWeekBitmap) {
        this.period = period;
        ScheduleUtil.assertTrue(period > 0, "period must be positive");
        this.beginOrdinal = ScheduleUtil.julianDay(begin == null ? ScheduleUtil.epochDay : begin) / 7;
        this.daysOfWeekBitmap = daysOfWeekBitmap;
        ScheduleUtil.assertTrue((daysOfWeekBitmap & 0xFE) != 0, "weekly schedule must have at least one day set");
        ScheduleUtil.assertTrue((daysOfWeekBitmap & 0xFE) == daysOfWeekBitmap, "weekly schedule has bad bits set: " + daysOfWeekBitmap);
    }

    public Calendar nextOccurrence(Calendar earliest, boolean strict) {
        earliest = (Calendar)earliest.clone();
        if (strict) {
            earliest.add(5, 1);
        }
        int i = 7 + this.period;
        while (i-- > 0) {
            int ordinal;
            int dayOfWeek = earliest.get(7);
            if ((this.daysOfWeekBitmap & 1 << dayOfWeek) != 0 && ((ordinal = ScheduleUtil.julianDay(earliest) / 7) - this.beginOrdinal) % this.period == 0) {
                return earliest;
            }
            earliest.add(5, 1);
        }
        throw ScheduleUtil.newInternal("weekly date schedule is looping -- maybe the bitmap is empty: " + this.daysOfWeekBitmap);
    }
}

