/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class TinyPopupMenuBorder
extends AbstractBorder
implements UIResource {
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyBorder(g, x, y, w, h);
                break;
            }
            case 1: {
                this.drawWinBorder(g, x, y, w, h);
                break;
            }
            case 2: {
                this.drawXpBorder(g, x, y, w, h);
            }
        }
    }

    private void drawTinyBorder(Graphics g, int x, int y, int w, int h) {
    }

    private void drawWinBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(Theme.menuInnerHilightColor[Theme.style].getColor());
        g.drawLine(1, 1, w - 3, 1);
        g.drawLine(1, 1, 1, h - 3);
        g.setColor(Theme.menuInnerShadowColor[Theme.style].getColor());
        g.drawLine(w - 2, 1, w - 2, h - 2);
        g.drawLine(1, h - 2, w - 2, h - 2);
        g.setColor(Theme.menuOuterHilightColor[Theme.style].getColor());
        g.drawLine(0, 0, w - 2, 0);
        g.drawLine(0, 0, 0, h - 1);
        g.setColor(Theme.menuOuterShadowColor[Theme.style].getColor());
        g.drawLine(w - 1, 0, w - 1, h - 1);
        g.drawLine(0, h - 1, w - 1, h - 1);
        g.translate(-x, -y);
    }

    private void drawXpBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(Theme.menuInnerHilightColor[Theme.style].getColor());
        g.drawLine(1, 1, w - 3, 1);
        g.drawLine(1, 1, 1, h - 3);
        g.setColor(Theme.menuInnerShadowColor[Theme.style].getColor());
        g.drawLine(w - 2, 1, w - 2, h - 2);
        g.drawLine(1, h - 2, w - 2, h - 2);
        g.setColor(Theme.menuOuterHilightColor[Theme.style].getColor());
        g.drawLine(0, 0, w - 2, 0);
        g.drawLine(0, 0, 0, h - 1);
        g.setColor(Theme.menuOuterShadowColor[Theme.style].getColor());
        g.drawLine(w - 1, 0, w - 1, h - 1);
        g.drawLine(0, h - 1, w - 1, h - 1);
        g.translate(-x, -y);
    }

    public Insets getBorderInsets(Component c) {
        return Theme.menuBorderInsets[Theme.style];
    }
}

