/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep.init;

import flex2.compiler.mxml.gen.CodeFragmentList;
import flex2.compiler.mxml.gen.TextGen;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.rep.EventHandler;
import flex2.compiler.mxml.rep.init.Initializer;
import flex2.compiler.util.NameFormatter;
import java.util.Iterator;
import org.apache.commons.collections.iterators.SingletonIterator;

public class EventInitializer
implements Initializer {
    private final EventHandler handler;

    public EventInitializer(EventHandler handler) {
        this.handler = handler;
    }

    public String getName() {
        return this.handler.getName();
    }

    public Type getLValueType() {
        return this.handler.getType();
    }

    public int getLineRef() {
        return this.handler.getXmlLineNumber();
    }

    public boolean isBinding() {
        return false;
    }

    public String getValueExpr() {
        return this.handler.getDocumentFunctionName();
    }

    public String getAssignExpr(String lvalueBase) {
        return lvalueBase + ".addEventListener(" + TextGen.quoteWord(this.getName()) + ", " + this.getValueExpr() + ")";
    }

    public boolean hasDefinition() {
        return true;
    }

    public Iterator getDefinitionsIterator() {
        return new SingletonIterator((Object)this.getDefinitionBody());
    }

    protected CodeFragmentList getDefinitionBody() {
        int line = this.getLineRef();
        CodeFragmentList list = new CodeFragmentList();
        list.add("/**", line);
        list.add(" * @private", line);
        list.add(" **/", line);
        list.add("public function ", this.handler.getDocumentFunctionName(), "(event:", NameFormatter.toDot(this.handler.getType().getName()), "):void", line);
        list.add("{", line);
        list.add("\t", this.handler.getEventHandlerText(), line);
        list.add("}", line);
        return list;
    }
}

