/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.Collections;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.def.AbstractVisitor;
import org.hibernate.type.CollectionType;

public class FlushVisitor
extends AbstractVisitor {
    private Object owner;

    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        if (collection == CollectionType.UNFETCHED_COLLECTION) {
            return null;
        }
        if (collection != null) {
            PersistentCollection coll = type.hasHolder(this.getSession().getEntityMode()) ? this.getSession().getPersistenceContext().getCollectionHolder(collection) : (PersistentCollection)collection;
            Collections.processReachableCollection(coll, type, this.owner, this.getSession());
        }
        return null;
    }

    FlushVisitor(SessionImplementor session, Object owner) {
        super(session);
        this.owner = owner;
    }
}

