/*
 * Copyright (C) 2005 - 2008 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * XYSeriesDialog.java
 * 
 * Created on 17 agosto 2005, 11.19
 *
 */

package it.businesslogic.ireport.chart;

import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;

/**
 *
 * @author  Administrator
 */
public class XYSeriesDialog extends javax.swing.JDialog {
    
    private String seriesExpression = "";
    private String xValueExpression = "";
    private String yValueExpression = "";
    private String labelExpression = "";
    
    private int dialogResult = javax.swing.JOptionPane.CANCEL_OPTION;
    
    /** Creates new form CategorySeriesDialog */
    public XYSeriesDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        applyI18n();
        
        this.setSize(500,500);
        it.businesslogic.ireport.util.Misc.centerFrame(this);
        
        javax.swing.KeyStroke escape =  javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_ESCAPE, 0, false);
        javax.swing.Action escapeAction = new javax.swing.AbstractAction() {
            public void actionPerformed(java.awt.event.ActionEvent e) {
                jButtonCancelActionPerformed(e);
            }
        };
       
        getRootPane().getInputMap(javax.swing.JComponent.WHEN_IN_FOCUSED_WINDOW).put(escape, "ESCAPE");
        getRootPane().getActionMap().put("ESCAPE", escapeAction);


        //to make the default button ...
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }
    
    /**
     * this method is used to pass the correct subdataset to the expression editor
     */
    public void setSubDataset( SubDataset sds )
    {
        jRTextExpressionLabel.setSubDataset(sds);
        jRTextExpressionSeries.setSubDataset(sds);
        jRTextExpressionXValue.setSubDataset(sds);
        jRTextExpressionYValue.setSubDataset(sds);
        sectionItemHyperlinkPanel1.setSubDataset( sds);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel1 = new javax.swing.JPanel();
        jLabelSeriesExpression = new javax.swing.JLabel();
        jLabelXValueExpression = new javax.swing.JLabel();
        jLabelYValueExpression = new javax.swing.JLabel();
        jLabelLabelExpression = new javax.swing.JLabel();
        jRTextExpressionSeries = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jRTextExpressionXValue = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jRTextExpressionYValue = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jRTextExpressionLabel = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        sectionItemHyperlinkPanel1 = new it.businesslogic.ireport.chart.gui.SectionItemHyperlinkPanel();
        jPanel6 = new javax.swing.JPanel();
        jPanel7 = new javax.swing.JPanel();
        jButtonOK = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("XY series");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jLabelSeriesExpression.setText("Series expression (required)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jLabelSeriesExpression, gridBagConstraints);

        jLabelXValueExpression.setText("X value expression (required)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        jPanel1.add(jLabelXValueExpression, gridBagConstraints);

        jLabelYValueExpression.setText("Y value expression (required)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        jPanel1.add(jLabelYValueExpression, gridBagConstraints);

        jLabelLabelExpression.setText("Label expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        jPanel1.add(jLabelLabelExpression, gridBagConstraints);

        jRTextExpressionSeries.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jRTextExpressionSeries.setElectricScroll(0);
        jRTextExpressionSeries.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionSeries.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jRTextExpressionSeries, gridBagConstraints);

        jRTextExpressionXValue.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jRTextExpressionXValue.setElectricScroll(0);
        jRTextExpressionXValue.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionXValue.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jRTextExpressionXValue, gridBagConstraints);

        jRTextExpressionYValue.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jRTextExpressionYValue.setElectricScroll(0);
        jRTextExpressionYValue.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionYValue.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jRTextExpressionYValue, gridBagConstraints);

        jRTextExpressionLabel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jRTextExpressionLabel.setElectricScroll(0);
        jRTextExpressionLabel.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionLabel.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jRTextExpressionLabel, gridBagConstraints);

        jTabbedPane1.addTab("Data", jPanel1);

        jTabbedPane1.addTab("Item hyperlink", sectionItemHyperlinkPanel1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jTabbedPane1, gridBagConstraints);

        jPanel6.setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel6.add(jPanel7, gridBagConstraints);

        jButtonOK.setMnemonic('o');
        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel6.add(jButtonOK, gridBagConstraints);

        jButtonCancel.setMnemonic('c');
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        jPanel6.add(jButtonCancel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        getContentPane().add(jPanel6, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        sectionItemHyperlinkPanel1.openExtraWindows();
    }//GEN-LAST:event_formWindowOpened

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        this.setVisible(false);
        this.dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed

        seriesExpression = jRTextExpressionSeries.getText();
        setXValueExpression(jRTextExpressionXValue.getText());
        setYValueExpression(jRTextExpressionYValue.getText());
        labelExpression = jRTextExpressionLabel.getText();
         
       
        java.text.MessageFormat formatter = new java.text.MessageFormat( it.businesslogic.ireport.util.I18n.getString("gui.notvalidexp","{0} cannot be blank!") );

        if (seriesExpression.trim().length() == 0) {
            
           javax.swing.JOptionPane.showMessageDialog(this, formatter.format(new Object[]{it.businesslogic.ireport.util.I18n.getString("charts.seriesExpression","Series expression")}) ,I18n.getString("message.title.invalidExpression","Invalid expression"),javax.swing.JOptionPane.ERROR_MESSAGE);
           return;
        } 
        
        if (xValueExpression.trim().length() == 0) {
           javax.swing.JOptionPane.showMessageDialog(this, formatter.format(new Object[]{it.businesslogic.ireport.util.I18n.getString("charts.yValueExpression","X Value expression")}) ,I18n.getString("message.title.invalidExpression","Invalid expression"),javax.swing.JOptionPane.ERROR_MESSAGE);
           return;
        }  
        
        if (yValueExpression.trim().length() == 0) {
           javax.swing.JOptionPane.showMessageDialog(this, formatter.format(new Object[]{it.businesslogic.ireport.util.I18n.getString("charts.yValueExpression","Y Value expression")}) ,I18n.getString("message.title.invalidExpression","Invalid expression"),javax.swing.JOptionPane.ERROR_MESSAGE);
           return;
        } 
        
        this.setDialogResult(javax.swing.JOptionPane.OK_OPTION);
        this.setVisible(false);
        this.dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new CategorySeriesDialog(new javax.swing.JFrame(), true).setVisible(true);
            }
        });
    }

    public String getSeriesExpression() {
        return seriesExpression;
    }

    public void setSeriesExpression(String seriesExpression) {
        this.seriesExpression = seriesExpression;
        jRTextExpressionSeries.setText( seriesExpression );
    }

 
    public String getLabelExpression() {
        return labelExpression;
    }

    public void setLabelExpression(String labelExpression) {
        this.labelExpression = labelExpression;
        jRTextExpressionLabel.setText( labelExpression );
    }
    
    public void setSectionItemHyperlink(SectionItemHyperlink sectionItemHyperlink)
    {
        sectionItemHyperlinkPanel1.setSectionItemHyperlink( sectionItemHyperlink.cloneMe());
    }
    
    public SectionItemHyperlink getSectionItemHyperlink()
    {
        return sectionItemHyperlinkPanel1.getSectionItemHyperlink();
    }

    public int getDialogResult() {
        return dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JLabel jLabelLabelExpression;
    private javax.swing.JLabel jLabelSeriesExpression;
    private javax.swing.JLabel jLabelXValueExpression;
    private javax.swing.JLabel jLabelYValueExpression;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionLabel;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionSeries;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionXValue;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionYValue;
    private javax.swing.JTabbedPane jTabbedPane1;
    private it.businesslogic.ireport.chart.gui.SectionItemHyperlinkPanel sectionItemHyperlinkPanel1;
    // End of variables declaration//GEN-END:variables
    
        public void applyI18n()
        {
                // Start autogenerated code ----------------------
                // End autogenerated code ----------------------
            jButtonOK.setText( it.businesslogic.ireport.util.I18n.getString("ok","Ok"));
            jButtonCancel.setText( it.businesslogic.ireport.util.I18n.getString("cancel","Cancel"));
             
            jLabelSeriesExpression.setText( it.businesslogic.ireport.util.I18n.getString("charts.seriesExpression","Series expression"));
            jLabelXValueExpression.setText( it.businesslogic.ireport.util.I18n.getString("charts.xValueExpression","X Value expression"));
            jLabelYValueExpression.setText( it.businesslogic.ireport.util.I18n.getString("charts.yValueExpression","Y Value expression"));
            
            jLabelLabelExpression.setText( it.businesslogic.ireport.util.I18n.getString("charts.labelExpression","Label expression"));
            
            jTabbedPane1.setTitleAt(0,I18n.getString("chartSeries.tab.Data","Data"));
            jTabbedPane1.setTitleAt(1,I18n.getString("chartSeries.tab.ItemHyperlink","Item hyperlink"));
            
            this.setTitle(I18n.getString("xYSeriesDialog.title","XY series"));
            jButtonCancel.setMnemonic(I18n.getString("xYSeriesDialog.buttonCancelMnemonic","c").charAt(0));
            jButtonOK.setMnemonic(I18n.getString("xYSeriesDialog.buttonOKMnemonic","o").charAt(0));
            
            this.getRootPane().updateUI();
        }

    public String getXValueExpression() {
        return xValueExpression;
    }

    public void setXValueExpression(String xValueExpression) {
        this.xValueExpression = xValueExpression;
        jRTextExpressionXValue.setText( xValueExpression );
    }

    public String getYValueExpression() {
        return yValueExpression;
    }

    public void setYValueExpression(String yValueExpression) {
        this.yValueExpression = yValueExpression;
        jRTextExpressionYValue.setText( yValueExpression );
    }
    
    public static final int COMPONENT_NONE=0;
    public static final int COMPONENT_SERIES_EXPRESSION=1;
    public static final int COMPONENT_X_EXPRESSION=2;
    public static final int COMPONENT_Y_EXPRESSION=3;
    public static final int COMPONENT_LABEL_EXPRESSION=4;
    public static final int COMPONENT_HYPERLINK=100;
        
    /**
     * This method set the focus on a specific component.
     * 
     * expressionInfo[0] can be something like:
     * COMPONENT_SERIES_EXPRESSION, ...
     *
     * If it is COMPONENT_HYPERLINK, other parameters are expected...
     * otherInfo is used here only for COMPONENT_HYPERLINK
     * otherInfo[0] = expression ID
     * otherInfo[1] = parameter #
     * otherInfo[2] = parameter expression ID
     */
    public void setFocusedExpression(Object[] expressionInfo)
    {
        if (expressionInfo == null) return;
        int expID = ((Integer)expressionInfo[0]).intValue();
        
        switch (expID)
        {
            case COMPONENT_SERIES_EXPRESSION:
                Misc.selectTextAndFocusArea(jRTextExpressionSeries);
                break;
            case COMPONENT_X_EXPRESSION:
                Misc.selectTextAndFocusArea(jRTextExpressionXValue);
                break;
            case COMPONENT_Y_EXPRESSION:
                Misc.selectTextAndFocusArea(jRTextExpressionYValue);
                break;
            case COMPONENT_LABEL_EXPRESSION:
                Misc.selectTextAndFocusArea(jRTextExpressionLabel);
                break;
            case COMPONENT_HYPERLINK:
                jTabbedPane1.setSelectedComponent( sectionItemHyperlinkPanel1 );
                Object newInfo[] = new Object[expressionInfo.length -1 ];
                for (int i=1; i< expressionInfo.length; ++i) newInfo[i-1] = expressionInfo[i];
                sectionItemHyperlinkPanel1.setFocusedExpression(newInfo);
                break;
        }
    }
}
