/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.ElementGroupNode;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.undo.AddElementGroupUndoableEdit;
import com.jaspersoft.ireport.designer.undo.DeleteElementGroupUndoableEdit;
import com.jaspersoft.ireport.designer.undo.DeleteElementUndoableEdit;
import com.jaspersoft.ireport.designer.undo.GroupElementsUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.util.ArrayList;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class GroupElementsAction
extends NodeAction {
    public String getName() {
        return I18n.getString("GroupElementsAction.name");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        GroupElementsUndoableEdit undoEdit = new GroupElementsUndoableEdit();
        JRDesignElementGroup newgroup = new JRDesignElementGroup();
        ArrayList<JRDesignElement> elements = new ArrayList<JRDesignElement>();
        ArrayList<JRDesignElement> groups = new ArrayList<JRDesignElement>();
        boolean firstIndex = false;
        for (int i = 0; i < activatedNodes.length; ++i) {
            JRDesignElement element;
            if (activatedNodes[i] instanceof ElementNode) {
                element = ((ElementNode)activatedNodes[i]).getElement();
                elements.add(element);
                continue;
            }
            if (!(activatedNodes[i] instanceof ElementGroupNode)) continue;
            element = ((ElementGroupNode)activatedNodes[i]).getElementGroup();
            groups.add(element);
        }
        JRElementGroup parent = (JRElementGroup)activatedNodes[0].getParentNode().getLookup().lookup(JRElementGroup.class);
        if (parent != null) {
            int index;
            for (JRDesignElement jRDesignElement : elements) {
                index = parent.getChildren().indexOf(jRDesignElement);
                if (parent instanceof JRDesignElementGroup) {
                    ((JRDesignElementGroup)parent).removeElement(jRDesignElement);
                } else if (parent instanceof JRDesignBand) {
                    ((JRDesignBand)parent).removeElement(jRDesignElement);
                } else if (parent instanceof JRDesignCellContents) {
                    ((JRDesignCellContents)parent).removeElement(jRDesignElement);
                } else if (parent instanceof JRDesignFrame) {
                    ((JRDesignFrame)parent).removeElement((JRElement)jRDesignElement);
                }
                undoEdit.concatenate(new DeleteElementUndoableEdit(jRDesignElement, parent, index));
                newgroup.addElement(jRDesignElement);
            }
            for (JRDesignElementGroup jRDesignElementGroup : groups) {
                index = parent.getChildren().indexOf(jRDesignElementGroup);
                if (parent instanceof JRDesignElementGroup) {
                    ((JRDesignElementGroup)parent).removeElementGroup(jRDesignElementGroup);
                } else if (parent instanceof JRDesignBand) {
                    ((JRDesignBand)parent).removeElementGroup(jRDesignElementGroup);
                } else if (parent instanceof JRDesignCellContents) {
                    ((JRDesignCellContents)parent).removeElementGroup(jRDesignElementGroup);
                } else if (parent instanceof JRDesignFrame) {
                    ((JRDesignCellContents)parent).removeElementGroup(jRDesignElementGroup);
                }
                undoEdit.concatenate(new DeleteElementGroupUndoableEdit(jRDesignElementGroup, parent, index));
                newgroup.addElementGroup(jRDesignElementGroup);
            }
        }
        if (parent instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)parent).addElementGroup(newgroup);
        } else if (parent instanceof JRDesignBand) {
            ((JRDesignBand)parent).addElementGroup(newgroup);
        } else if (parent instanceof JRDesignCellContents) {
            ((JRDesignCellContents)parent).addElementGroup(newgroup);
        } else if (parent instanceof JRDesignFrame) {
            ((JRDesignCellContents)parent).addElementGroup(newgroup);
        }
        undoEdit.concatenate(new AddElementGroupUndoableEdit(newgroup, parent));
        for (JRDesignElementGroup jRDesignElementGroup : groups) {
            IReportManager.getInstance().addSelectedObject(jRDesignElementGroup);
        }
        for (JRDesignElement jRDesignElement : elements) {
            IReportManager.getInstance().addSelectedObject(jRDesignElement);
        }
        IReportManager.getInstance().addUndoableEdit(undoEdit);
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return false;
        }
        Node parent = activatedNodes[0].getParentNode();
        ArrayList<Node> selectedNodes = new ArrayList<Node>();
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (!(activatedNodes[i] instanceof ElementNode) && !(activatedNodes[i] instanceof ElementGroupNode) || parent != activatedNodes[i].getParentNode()) {
                return false;
            }
            selectedNodes.add(activatedNodes[i]);
        }
        Children children = parent.getChildren();
        Node[] nodes = children.getNodes();
        boolean fistFound = false;
        for (int i = 0; i < nodes.length && selectedNodes.size() != 0; ++i) {
            if (selectedNodes.size() > 0 && selectedNodes.contains(nodes[i])) {
                fistFound = true;
                selectedNodes.remove(nodes[i]);
                continue;
            }
            if (!fistFound) continue;
            return false;
        }
        return true;
    }
}

