/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.borders;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import org.netbeans.api.visual.border.Border;
import org.openide.util.Utilities;

public class ElementSelectedBorder
implements Border {
    public static int STATUS_NONE = 0;
    public static int STATUS_PRIMARY_SELECTION = 1;
    public static int STATUS_SECONDARY_SELECTION = 2;
    public static int STATUS_PARTIAL_OVERLAP = 3;
    public static int STATUS_TOTAL_OVERLAP = 4;
    protected static final BasicStroke STROKE = new BasicStroke(1.0f);
    protected static final Insets INSETS = new Insets(5, 5, 5, 5);
    protected Color COLOR_1 = Color.LIGHT_GRAY;
    protected Color COLOR_2 = new Color(255, 175, 0, 200);
    private static final ImageIcon gripIcon = new ImageIcon(Utilities.loadImage((String)"com/jaspersoft/ireport/designer/borders/grip.png"));
    private int status = 0;
    protected Color[] colors = new Color[]{Color.WHITE, new Color(70, 130, 180), Color.LIGHT_GRAY, Color.GREEN, Color.PINK};

    public Insets getInsets() {
        return INSETS;
    }

    public void paint(Graphics2D g, Rectangle bounds) {
        g.setPaint(this.COLOR_2);
        g.setStroke(new BasicStroke(2.0f));
        Rectangle2D.Double r = new Rectangle2D.Double((double)(bounds.x + ElementSelectedBorder.INSETS.left - 1) + 0.5, (double)(bounds.y + ElementSelectedBorder.INSETS.top - 1) + 0.5, (double)(bounds.width - ElementSelectedBorder.INSETS.left - ElementSelectedBorder.INSETS.right) - 1.0 + 2.0, (double)(bounds.height - ElementSelectedBorder.INSETS.top - ElementSelectedBorder.INSETS.bottom) - 1.0 + 2.0);
        g.draw(r);
        this.paintGrip(g, bounds.x, bounds.y);
        this.paintGrip(g, bounds.x + bounds.width - 5, bounds.y);
        this.paintGrip(g, bounds.x, bounds.y + bounds.height - 5);
        this.paintGrip(g, bounds.x + bounds.width - 5, bounds.y + bounds.height - 5);
        this.paintGrip(g, bounds.x + bounds.width / 2 - 2, bounds.y);
        this.paintGrip(g, bounds.x + bounds.width / 2 - 2, bounds.y + bounds.height - 5);
        this.paintGrip(g, bounds.x, bounds.y + bounds.height / 2 - 3);
        this.paintGrip(g, bounds.x + bounds.width - 5, bounds.y + bounds.height / 2 - 3);
    }

    public boolean isOpaque() {
        return false;
    }

    public void paintGrip(Graphics2D g, double x, double y) {
        Stroke oldStroke = g.getStroke();
        Paint oldPain = g.getPaint();
        Rectangle2D.Double r = new Rectangle2D.Double(x + 0.5, y + 0.5, 4.0, 4.0);
        GradientPaint gp = new GradientPaint((float)x, (float)y, Color.WHITE, (float)x + 3.0f, (float)y + 3.0f, this.colors[this.getStatus()]);
        g.setPaint(gp);
        g.fill(r);
        g.setPaint(this.colors[this.getStatus()].darker());
        g.setStroke(new BasicStroke(1.0f));
        g.draw(r);
        g.setPaint(oldPain);
        g.setStroke(oldStroke);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

