/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.options.export;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.options.export.AbstractExportParametersPanel;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;

public class TextExportParametersPanel
extends AbstractExportParametersPanel {
    private JLabel jLabelBetweenPagesText;
    private JLabel jLabelCharacterHeight;
    private JLabel jLabelCharacterWidth;
    private JLabel jLabelDefault1;
    private JLabel jLabelDefault2;
    private JLabel jLabelDefault3;
    private JLabel jLabelDefault4;
    private JLabel jLabelDefault5;
    private JLabel jLabelLineSeparator;
    private JLabel jLabelPageHeight;
    private JLabel jLabelPageWidth;
    private JLabel jLabelTitle;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerCharacterHeight;
    private JSpinner jSpinnerCharacterWidth;
    private JSpinner jSpinnerPageHeight;
    private JSpinner jSpinnerPageWidth;
    private JTextArea jTextAreaBetweenPagesText;
    private JTextField jTextFieldLineSeparator;

    public TextExportParametersPanel() {
        this.initComponents();
        ChangeListener snmcl = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TextExportParametersPanel.this.notifyChange();
            }
        };
        SpinnerNumberModel snm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
        this.jSpinnerCharacterWidth.setModel(snm);
        snm.addChangeListener(snmcl);
        snm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
        this.jSpinnerCharacterHeight.setModel(snm);
        snm.addChangeListener(snmcl);
        snm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
        this.jSpinnerPageWidth.setModel(snm);
        snm.addChangeListener(snmcl);
        snm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
        this.jSpinnerPageHeight.setModel(snm);
        snm.addChangeListener(snmcl);
        DocumentListener textfieldListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                TextExportParametersPanel.this.notifyChange();
            }

            public void insertUpdate(DocumentEvent evt) {
                TextExportParametersPanel.this.notifyChange();
            }

            public void removeUpdate(DocumentEvent evt) {
                TextExportParametersPanel.this.notifyChange();
            }
        };
        this.jTextAreaBetweenPagesText.getDocument().addDocumentListener(textfieldListener);
        this.jTextFieldLineSeparator.getDocument().addDocumentListener(textfieldListener);
        this.applyI18n();
    }

    public void applyI18n() {
        this.jLabelTitle.setText(I18n.getString("TextExportParametersPanel.jLabelTitle.text"));
        this.jLabelCharacterWidth.setText(I18n.getString("TextExportParametersPanel.jLabelCharacterWidth.text"));
        this.jLabelCharacterHeight.setText(I18n.getString("TextExportParametersPanel.jLabelCharacterHeight.text"));
        this.jLabelPageWidth.setText(I18n.getString("TextExportParametersPanel.jLabelPageWidth.text"));
        this.jLabelPageHeight.setText(I18n.getString("TextExportParametersPanel.jLabelPageHeight.text"));
        this.jLabelBetweenPagesText.setText(I18n.getString("TextExportParametersPanel.jLabelBetweenPagesText.text"));
        this.jLabelLineSeparator.setText(I18n.getString("TextExportParametersPanel.jLabelLineSeparator.text"));
        this.jLabelDefault1.setText(I18n.getString("TextExportParametersPanel.jLabelDefault1.text"));
        this.jLabelDefault2.setText(I18n.getString("TextExportParametersPanel.jLabelDefault2.text"));
        this.jLabelDefault3.setText(I18n.getString("TextExportParametersPanel.jLabelDefault3.text"));
        this.jLabelDefault4.setText(I18n.getString("TextExportParametersPanel.jLabelDefault4.text"));
        this.jLabelDefault5.setText(I18n.getString("TextExportParametersPanel.jLabelDefault5.text"));
    }

    private void initComponents() {
        this.jLabelTitle = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabelCharacterWidth = new JLabel();
        this.jSpinnerCharacterWidth = new JSpinner();
        this.jLabelCharacterHeight = new JLabel();
        this.jSpinnerCharacterHeight = new JSpinner();
        this.jLabelPageWidth = new JLabel();
        this.jSpinnerPageWidth = new JSpinner();
        this.jLabelPageHeight = new JLabel();
        this.jSpinnerPageHeight = new JSpinner();
        this.jLabelBetweenPagesText = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaBetweenPagesText = new JTextArea();
        this.jLabelLineSeparator = new JLabel();
        this.jTextFieldLineSeparator = new JTextField();
        this.jLabelDefault1 = new JLabel();
        this.jLabelDefault2 = new JLabel();
        this.jLabelDefault3 = new JLabel();
        this.jLabelDefault4 = new JLabel();
        this.jLabelDefault5 = new JLabel();
        this.jLabelTitle.setFont(new Font("Tahoma", 1, 12));
        this.jLabelTitle.setText("Text Export parameters");
        this.jLabelCharacterWidth.setText("Character Width");
        this.jLabelCharacterHeight.setText("Character Height");
        this.jLabelPageWidth.setText("Page Width");
        this.jLabelPageHeight.setText("Page Height");
        this.jLabelBetweenPagesText.setText("Between Pages Text");
        this.jTextAreaBetweenPagesText.setColumns(20);
        this.jTextAreaBetweenPagesText.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaBetweenPagesText);
        this.jLabelLineSeparator.setText("Line Separator");
        this.jLabelDefault1.setText("(0 to use default)");
        this.jLabelDefault2.setText("(0 to use default)");
        this.jLabelDefault3.setText("(0 to use default)");
        this.jLabelDefault4.setText("(0 to use default)");
        this.jLabelDefault5.setText("Usually \"\\n\" in Unix and \"\\r\\n\" in Windows");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTitle).addContainerGap(275, Short.MAX_VALUE)).add((Component)this.jSeparator1, -1, 420, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabelBetweenPagesText).addContainerGap(311, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 400, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelLineSeparator).addPreferredGap(0).add((Component)this.jTextFieldLineSeparator)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelCharacterWidth).add((Component)this.jLabelCharacterHeight).add((Component)this.jLabelPageWidth).add((Component)this.jLabelPageHeight)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSpinnerCharacterHeight, -2, 45, -2).add((Component)this.jSpinnerCharacterWidth, -2, 45, -2).add((Component)this.jSpinnerPageWidth, -2, 45, -2).add((Component)this.jSpinnerPageHeight, -2, 45, -2)))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelDefault1).add((Component)this.jLabelDefault2).add((Component)this.jLabelDefault3).add((Component)this.jLabelDefault4).add((Component)this.jLabelDefault5)).addContainerGap(78, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTitle).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelCharacterWidth).add((Component)this.jSpinnerCharacterWidth, -2, -1, -2).add((Component)this.jLabelDefault1)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelCharacterHeight).add((Component)this.jSpinnerCharacterHeight, -2, -1, -2).add((Component)this.jLabelDefault2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelPageWidth).add((Component)this.jSpinnerPageWidth, -2, -1, -2).add((Component)this.jLabelDefault3)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelPageHeight).add((Component)this.jSpinnerPageHeight, -2, -1, -2).add((Component)this.jLabelDefault4)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelLineSeparator).add((Component)this.jTextFieldLineSeparator, -2, -1, -2).add((Component)this.jLabelDefault5)).addPreferredGap(0).add((Component)this.jLabelBetweenPagesText).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 166, Short.MAX_VALUE).addContainerGap()));
    }

    public void load() {
        Preferences pref = IReportManager.getPreferences();
        SpinnerNumberModel model = (SpinnerNumberModel)this.jSpinnerCharacterHeight.getModel();
        model.setValue(pref.getInt("net.sf.jasperreports.export.txt.characterHeight", 0));
        model = (SpinnerNumberModel)this.jSpinnerCharacterWidth.getModel();
        model.setValue(pref.getInt("net.sf.jasperreports.export.txt.characterWidth", 0));
        model = (SpinnerNumberModel)this.jSpinnerPageHeight.getModel();
        model.setValue(pref.getInt("net.sf.jasperreports.export.txt.pageHeight", 0));
        model = (SpinnerNumberModel)this.jSpinnerPageWidth.getModel();
        model.setValue(pref.getInt("net.sf.jasperreports.export.txt.pageWidth", 0));
        this.jTextAreaBetweenPagesText.setText(pref.get("net.sf.jasperreports.export.txt.betweenPagesText", ""));
        this.jTextFieldLineSeparator.setText(Misc.addSlashesString(pref.get("net.sf.jasperreports.export.txt.lineSeparator", System.getProperty("line.separator"))));
    }

    public void store() {
        Preferences pref = IReportManager.getPreferences();
        SpinnerNumberModel model = (SpinnerNumberModel)this.jSpinnerCharacterHeight.getModel();
        pref.putInt("net.sf.jasperreports.export.txt.characterHeight", model.getNumber().intValue());
        model = (SpinnerNumberModel)this.jSpinnerCharacterWidth.getModel();
        pref.putInt("net.sf.jasperreports.export.txt.characterWidth", model.getNumber().intValue());
        model = (SpinnerNumberModel)this.jSpinnerPageHeight.getModel();
        pref.putInt("net.sf.jasperreports.export.txt.pageHeight", model.getNumber().intValue());
        model = (SpinnerNumberModel)this.jSpinnerPageWidth.getModel();
        pref.putInt("net.sf.jasperreports.export.txt.pageWidth", model.getNumber().intValue());
        pref.put("net.sf.jasperreports.export.txt.betweenPagesText", this.jTextAreaBetweenPagesText.getText());
        pref.put("net.sf.jasperreports.export.txt.lineSeparator", Misc.removeSlashesString(this.jTextFieldLineSeparator.getText()));
    }

    public boolean valid() {
        return true;
    }

    public String getDisplayName() {
        return I18n.getString("TextExportParametersPanel.title");
    }
}

