/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.actions;

import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepositoryFolder;
import com.jaspersoft.ireport.jasperserver.RepositoryReportUnit;
import com.jaspersoft.ireport.jasperserver.ui.ResourceChooser;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ReportUnitInputControlsNode;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class AddExistingInputControlAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(AddExistingInputControlAction.class, (String)"CTL_AddExistingInputControlAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return;
        }
        if (activatedNodes[0] instanceof ReportUnitInputControlsNode) {
            ReportUnitInputControlsNode ruicn = (ReportUnitInputControlsNode)activatedNodes[0];
            RepositoryReportUnit ru = ruicn.getReportUnit();
            ResourceChooser rc = new ResourceChooser();
            String reportUnitUri = null;
            reportUnitUri = ru.getDescriptor().getUriString();
            rc.setServer(ru.getServer());
            if (rc.showDialog(Misc.getMainFrame(), null) == 0) {
                ResourceDescriptor rd = rc.getSelectedDescriptor();
                if (rd == null || rd.getUriString() == null) {
                    return;
                }
                if (!rd.getWsType().equals("inputControl")) {
                    JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getFormattedString("repositoryExplorer.message.invalidInputControl", "{0} is not an Input Control!", new Object[]{rd.getName()}), "", 0);
                    return;
                }
                ResourceDescriptor newRd = new ResourceDescriptor();
                newRd.setWsType("inputControl");
                newRd.setIsReference(true);
                newRd.setReferenceUri(rd.getUriString());
                newRd.setIsNew(true);
                newRd.setUriString(reportUnitUri + "/<cotnrols>");
                try {
                    newRd = ru.getServer().getWSClient().modifyReportUnitResource(reportUnitUri, newRd, null);
                    RepositoryFolder obj = RepositoryFolder.createRepositoryObject(ru.getServer(), newRd);
                    if (ruicn.getRepositoryObject().isLoaded()) {
                        ruicn.getResourceDescriptor().getChildren().add(newRd);
                        ruicn.getRepositoryObject().getChildren().add(obj);
                        ruicn.refreshChildrens(false);
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
                    ex.printStackTrace();
                }
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        return activatedNodes[0] instanceof ReportUnitInputControlsNode;
    }
}

