/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.modules.search.AbstractSearchScope;
import org.netbeans.modules.search.SearchScope;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;

final class SearchScopeNodeSelection
extends AbstractSearchScope
implements PropertyChangeListener {
    private PropertyChangeListener currentNodesWeakListener;

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"SearchScopeNameSelectedNodes");
    }

    protected String getAdditionalInfo() {
        Node[] nodeArray = this.getNodes();
        if (nodeArray == null || nodeArray.length == 0) {
            return null;
        }
        return nodeArray.length == 1 ? nodeArray[0].getDisplayName() : NbBundle.getMessage(this.getClass(), (String)"SearchScopeSelectionAddInfo", (Object)nodeArray.length);
    }

    protected boolean checkIsApplicable() {
        return SearchScopeNodeSelection.checkIsApplicable(this.getNodes());
    }

    private Node[] getNodes() {
        return TopComponent.getRegistry().getActivatedNodes();
    }

    private static boolean checkIsApplicable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return false;
        }
        for (Node node : nodeArray) {
            if (SearchScopeNodeSelection.canSearch(node)) continue;
            return false;
        }
        return true;
    }

    private static boolean canSearch(Node node) {
        Lookup lookup = node.getLookup();
        SearchInfo searchInfo = (SearchInfo)lookup.lookup(SearchInfo.class);
        if (searchInfo != null) {
            return searchInfo.canSearch();
        }
        DataObject dataObject = (DataObject)lookup.lookup(DataObject.class);
        return dataObject != null && dataObject.isValid();
    }

    protected void startListening() {
        TopComponent.Registry registry = TopComponent.getRegistry();
        this.currentNodesWeakListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)registry);
        registry.addPropertyChangeListener(this.currentNodesWeakListener);
    }

    protected void stopListening() {
        TopComponent.getRegistry().removePropertyChangeListener(this.currentNodesWeakListener);
        this.currentNodesWeakListener = null;
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("currentNodes".equals(propertyChangeEvent.getPropertyName())) {
            this.updateIsApplicable();
        }
    }

    public SearchInfo getSearchInfo() {
        return this.getSearchInfo(TopComponent.getRegistry().getActivatedNodes());
    }

    private SearchInfo getSearchInfo(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return this.createEmptySearchInfo();
        }
        if ((nodeArray = SearchScopeNodeSelection.normalizeNodes(nodeArray)).length == 1) {
            SearchInfo searchInfo = SearchScopeNodeSelection.getSearchInfo(nodeArray[0]);
            return searchInfo != null ? searchInfo : this.createEmptySearchInfo();
        }
        ArrayList<SearchInfo> arrayList = new ArrayList<SearchInfo>(nodeArray.length);
        for (Node node : nodeArray) {
            SearchInfo searchInfo = SearchScopeNodeSelection.getSearchInfo(node);
            if (searchInfo == null) continue;
            arrayList.add(searchInfo);
        }
        if (arrayList.isEmpty()) {
            return this.createEmptySearchInfo();
        }
        int n = arrayList.size();
        if (n == 1) {
            return (SearchInfo)arrayList.get(0);
        }
        return SearchInfoFactory.createCompoundSearchInfo((SearchInfo[])arrayList.toArray(new SearchInfo[n]));
    }

    private static SearchInfo getSearchInfo(Node node) {
        SearchInfo searchInfo = (SearchInfo)node.getLookup().lookup(SearchInfo.class);
        if (searchInfo != null) {
            return searchInfo;
        }
        Lookup lookup = node.getLookup();
        DataFolder dataFolder = (DataFolder)lookup.lookup(DataFolder.class);
        if (dataFolder != null) {
            return SearchInfoFactory.createSearchInfo((FileObject)dataFolder.getPrimaryFile(), (boolean)true, (FileObjectFilter[])new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER});
        }
        DataObject dataObject = (DataObject)lookup.lookup(DataObject.class);
        if (dataObject != null) {
            return new DataObjectSearchInfo(dataObject);
        }
        return null;
    }

    private static Node[] normalizeNodes(Node[] nodeArray) {
        if (nodeArray.length < 2) {
            return nodeArray;
        }
        HashMap<Node, Boolean> hashMap = new HashMap<Node, Boolean>(2 * nodeArray.length, 0.75f);
        HashMap<Node, Boolean> hashMap2 = new HashMap<Node, Boolean>(2 * nodeArray.length, 0.75f);
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        ArrayList<Node> arrayList2 = new ArrayList<Node>(nodeArray.length);
        for (Node node : nodeArray) {
            hashMap.put(node, Boolean.FALSE);
        }
        for (Node node : nodeArray) {
            Node node2;
            Object object;
            arrayList.clear();
            boolean bl = false;
            for (object = node.getParentNode(); object != null; object = object.getParentNode()) {
                if (hashMap.containsKey(object)) {
                    bl = true;
                    break;
                }
                if (hashMap2.containsKey(object)) break;
                arrayList.add(object);
            }
            if (bl) {
                hashMap.put(node, Boolean.TRUE);
                object = arrayList.iterator();
                while (object.hasNext()) {
                    node2 = (Node)object.next();
                    hashMap.put(node2, Boolean.TRUE);
                }
                continue;
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                node2 = (Node)object.next();
                hashMap2.put(node2, Boolean.TRUE);
            }
            arrayList2.add(node);
        }
        return arrayList2.toArray(new Node[arrayList2.size()]);
    }

    protected SearchScope getContextSensitiveInstance(Lookup lookup) {
        return new LookupSensitive(this, lookup);
    }

    private static final class LookupSensitive
    extends AbstractSearchScope
    implements LookupListener {
        private static final Node[] emptyNodesArray = new Node[0];
        private final SearchScopeNodeSelection delegate;
        private final Lookup.Result<Node> lookupResult;
        private LookupListener lookupListener;

        LookupSensitive(SearchScopeNodeSelection searchScopeNodeSelection, Lookup lookup) {
            this.delegate = searchScopeNodeSelection;
            this.lookupResult = lookup.lookupResult(Node.class);
        }

        private Node[] nodes() {
            Collection collection = this.lookupResult.allInstances();
            return collection.isEmpty() ? emptyNodesArray : collection.toArray(emptyNodesArray);
        }

        protected void startListening() {
            this.lookupListener = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.lookupResult);
            this.lookupResult.addLookupListener(this.lookupListener);
        }

        protected void stopListening() {
            if (this.lookupListener != null) {
                this.lookupResult.removeLookupListener(this.lookupListener);
            }
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.updateIsApplicable();
        }

        protected boolean checkIsApplicable() {
            return SearchScopeNodeSelection.checkIsApplicable(this.nodes());
        }

        protected SearchInfo getSearchInfo() {
            return this.delegate.getSearchInfo(this.nodes());
        }

        protected String getDisplayName() {
            return this.delegate.getDisplayName();
        }

        protected String getAdditionalInfo() {
            return this.delegate.getAdditionalInfo();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DataObjectSearchInfo
    implements SearchInfo {
        private final DataObject dataObj;

        DataObjectSearchInfo(DataObject dataObject) {
            this.dataObj = dataObject;
        }

        public boolean canSearch() {
            return this.dataObj.isValid();
        }

        public Iterator<DataObject> objectsToSearch() {
            return Collections.singleton(this.dataObj).iterator();
        }
    }
}

