/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.code39;

import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.DefaultCanvasLogicHandler;
import org.krysalis.barcode4j.impl.code39.Code39LogicImpl;
import org.krysalis.barcode4j.output.Canvas;
import org.krysalis.barcode4j.output.CanvasProvider;

public class Code39Bean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = (double)0.19f;
    protected static final double DEFAULT_WIDE_FACTOR = 2.5;
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private double intercharGapWidth = this.moduleWidth = (double)0.19f;
    private double wideFactor = 2.5;
    private boolean displayStartStop = false;
    private boolean displayChecksum = false;
    private boolean extendedCharSet = false;

    public Code39Bean() {
        this.setQuietZone(10.0 * this.moduleWidth);
        this.setVerticalQuietZone(0.0);
    }

    public void setChecksumMode(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public double getIntercharGapWidth() {
        return this.intercharGapWidth;
    }

    public void setIntercharGapWidth(double width) {
        this.intercharGapWidth = width;
    }

    public double getWideFactor() {
        return this.wideFactor;
    }

    public void setWideFactor(double value) {
        if (value <= 1.0) {
            throw new IllegalArgumentException("wide factor must be > 1.0");
        }
        this.wideFactor = value;
    }

    public boolean isDisplayStartStop() {
        return this.displayStartStop;
    }

    public void setDisplayStartStop(boolean value) {
        this.displayStartStop = value;
        if (value) {
            this.setDisplayChecksum(true);
        }
    }

    public boolean isDisplayChecksum() {
        return this.displayChecksum;
    }

    public void setDisplayChecksum(boolean value) {
        if (this.isDisplayStartStop() && !value) {
            return;
        }
        this.displayChecksum = value;
    }

    public boolean isExtendedCharSetEnabled() {
        return this.extendedCharSet;
    }

    public void setExtendedCharSetEnabled(boolean value) {
        this.extendedCharSet = value;
    }

    public double getBarWidth(int width) {
        if (width == 1) {
            return this.moduleWidth;
        }
        if (width == 2) {
            return this.moduleWidth * this.wideFactor;
        }
        if (width == -1) {
            return this.intercharGapWidth;
        }
        throw new IllegalArgumentException("Only widths 1 and 2 allowed");
    }

    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultCanvasLogicHandler handler = new DefaultCanvasLogicHandler(this, new Canvas(canvas));
        Code39LogicImpl impl = new Code39LogicImpl(this.getChecksumMode(), this.isDisplayStartStop(), this.isDisplayChecksum(), this.isExtendedCharSetEnabled());
        impl.generateBarcodeLogic(handler, msg);
    }

    public BarcodeDimension calcDimensions(String msg) {
        int msglen = msg.length();
        double width = (double)(msglen + 2) * (3.0 * this.wideFactor + 6.0) * this.moduleWidth + (double)(msglen + 1) * this.intercharGapWidth;
        double qz = this.hasQuietZone() ? this.quietZone : 0.0;
        return new BarcodeDimension(width, this.getHeight(), width + 2.0 * qz, this.getHeight(), this.quietZone, 0.0);
    }
}

