/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentManager;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.component.FillComponent;
import net.sf.jasperreports.engine.component.FillContext;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateElement;

public class JRFillComponentElement
extends JRFillElement
implements JRComponentElement,
FillContext {
    private FillComponent fillComponent;
    private boolean filling;

    public JRFillComponentElement(JRBaseFiller filler, JRComponentElement element, JRFillObjectFactory factory) {
        super(filler, element, factory);
        ComponentKey componentKey = element.getComponentKey();
        ComponentManager manager = ComponentsEnvironment.getComponentManager(componentKey);
        this.fillComponent = manager.getComponentFillFactory().toFillComponent(element.getComponent(), factory);
        this.fillComponent.initialize(this);
    }

    public JRFillComponentElement(JRFillComponentElement element, JRFillCloneFactory factory) {
        super(element, factory);
        ComponentKey componentKey = element.getComponentKey();
        ComponentManager manager = ComponentsEnvironment.getComponentManager(componentKey);
        this.fillComponent = manager.getComponentFillFactory().cloneFillComponent(element.fillComponent, factory);
        this.fillComponent.initialize(this);
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.fillComponent.evaluate(evaluation);
        }
        this.filling = false;
    }

    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        super.prepare(availableHeight, isOverflow);
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (!this.filling && isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
            isToPrint = false;
        }
        if (isToPrint && availableHeight < this.getRelativeY() + this.getHeight()) {
            isToPrint = false;
            willOverflow = true;
        }
        if (!this.filling && isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isPrintRepeatedValues())) {
            isReprinted = true;
        }
        if (isToPrint) {
            FillPrepareResult result = this.fillComponent.prepare(availableHeight - this.getRelativeY());
            isToPrint = result.isToPrint();
            willOverflow = result.willOverflow();
            this.setStretchHeight(result.getStretchHeight());
            this.filling = willOverflow;
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    protected JRPrintElement fill() throws JRException {
        return this.fillComponent.fill();
    }

    protected JRTemplateElement createElementTemplate() {
        return null;
    }

    protected void resolveElement(JRPrintElement element, byte evaluation, JREvaluationTime evaluationTime) throws JRException {
        this.performDelayedEvaluation(element, evaluation);
    }

    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
        this.fillComponent.evaluateDelayedElement(element, evaluation);
    }

    protected void rewind() throws JRException {
        this.fillComponent.rewind();
        this.filling = false;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitComponentElement(this);
    }

    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillComponentElement(this, factory);
    }

    public Component getComponent() {
        return ((JRComponentElement)this.parent).getComponent();
    }

    public ComponentKey getComponentKey() {
        return ((JRComponentElement)this.parent).getComponentKey();
    }

    public Object evaluate(JRExpression expression, byte evaluation) throws JRException {
        return super.evaluateExpression(expression, evaluation);
    }

    public JRComponentElement getComponentElement() {
        return this;
    }

    public JROrigin getElementOrigin() {
        return super.getElementOrigin();
    }

    public int getElementPrintY() {
        return this.getRelativeY();
    }

    public JRStyle getElementStyle() {
        return this.getStyle();
    }

    public void registerDelayedEvaluation(JRPrintElement printElement, byte evaluationTime, String evaluationGroup) {
        this.filler.addBoundElement((JRFillElement)this, printElement, evaluationTime, evaluationGroup, this.band);
    }
}

