/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.XMLStorage;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColoringStorage {
    private static final Logger LOG = Logger.getLogger(ColoringStorage.class.getName());
    private static final String HIGHLIGHTING_FILE_NAME = "editorColoring.xml";
    private static final String E_ROOT = "fontscolors";
    private static final String E_FONTCOLOR = "fontcolor";
    private static final String E_FONT = "font";
    private static final String A_NAME = "name";
    private static final String A_FOREGROUND = "foreColor";
    private static final String A_BACKGROUND = "bgColor";
    private static final String A_STRIKETHROUGH = "strikeThrough";
    private static final String A_WAVEUNDERLINE = "waveUnderlined";
    private static final String A_UNDERLINE = "underline";
    private static final String A_DEFAULT = "default";
    private static final String A_SIZE = "size";
    private static final String A_STYLE = "style";
    private static final String V_BOLD_ITALIC = "bold+italic";
    private static final String V_BOLD = "bold";
    private static final String V_ITALIC = "italic";
    private static final String V_PLAIN = "plain";
    private static final String PUBLIC_ID = "-//NetBeans//DTD Editor Fonts and Colors settings 1.1//EN";
    private static final String SYSTEM_ID = "http://www.netbeans.org/dtds/EditorFontsColors-1_1.dtd";
    private static final String FA_TYPE = "nbeditor-settings-ColoringType";
    private static final String FAV_TOKEN = "token";
    private static final String FAV_HIGHLIGHT = "highlight";
    private static final Object ATTR_MODULE_SUPPLIED = new Object();

    private ColoringStorage() {
    }

    public static Map<String, AttributeSet> loadColorings(MimePath mimePath, String string, boolean bl, boolean bl2) {
        List<Object[]> list;
        HashMap<String, List<Object[]>> hashMap;
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (string != null) : "The parameter profile must not be null";
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Editors");
        HashMap<String, List<Object[]>> hashMap2 = new HashMap<String, List<Object[]>>();
        SettingsType.FONTSCOLORS.getLocator().scan(fileObject, mimePath.getPath(), string, true, true, !bl2, hashMap2);
        assert (hashMap2.size() <= 1) : "Too many results in the scan";
        List<Object[]> list2 = (List<Object[]>)hashMap2.get(string);
        if (list2 == null) {
            return null;
        }
        if (!string.equals("NetBeans")) {
            hashMap = new HashMap<String, List<Object[]>>();
            SettingsType.FONTSCOLORS.getLocator().scan(fileObject, mimePath.getPath(), "NetBeans", true, true, false, hashMap);
            list = (List)hashMap.get("NetBeans");
            if (list == null) {
                list = Collections.emptyList();
            }
        } else {
            list = list2;
        }
        hashMap = new HashMap();
        for (Object[] objectArray : list2) {
            FileObject fileObject2 = (FileObject)objectArray[0];
            FileObject fileObject3 = (FileObject)objectArray[1];
            int n = ((Boolean)objectArray[2]).booleanValue();
            boolean bl3 = ColoringStorage.isTokenColoringFile(fileObject3);
            if (bl3 != bl) continue;
            List list3 = (List)XMLStorage.load(fileObject3, new ColoringsReader());
            for (SimpleAttributeSet simpleAttributeSet : list3) {
                int n2;
                String string2 = (String)simpleAttributeSet.getAttribute(StyleConstants.NameAttribute);
                String string3 = null;
                SimpleAttributeSet simpleAttributeSet2 = (SimpleAttributeSet)hashMap.get(string2);
                if (simpleAttributeSet2 == null && !n && bl && (n2 = string2.indexOf(45)) != -1 && (simpleAttributeSet2 = (SimpleAttributeSet)hashMap.get(string3 = string2.substring(n2 + 1))) != null) {
                    simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, string3);
                    string2 = string3;
                }
                if (simpleAttributeSet2 == null) {
                    String string4 = ColoringStorage.findDisplayName(string2, fileObject3, list);
                    if (string4 == null && !n) {
                        if (string3 != null) {
                            string4 = ColoringStorage.findDisplayName(string3, fileObject3, list);
                        }
                        if (string4 == null) {
                            if (!LOG.isLoggable(Level.FINE)) continue;
                            LOG.fine("Ignoring an extra coloring '" + string2 + "' that was not defined by modules.");
                            continue;
                        }
                        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, string3);
                        string2 = string3;
                    }
                    if (string4 == null) {
                        string4 = string2;
                    }
                    simpleAttributeSet.addAttribute(EditorStyleConstants.DisplayName, string4);
                    simpleAttributeSet.addAttribute(ATTR_MODULE_SUPPLIED, n != 0);
                    hashMap.put(string2, (List<Object[]>)((Object)simpleAttributeSet));
                    continue;
                }
                n2 = ((Boolean)simpleAttributeSet2.getAttribute(ATTR_MODULE_SUPPLIED)).booleanValue() ? 1 : 0;
                if (n2 == n) {
                    ColoringStorage.mergeAttributeSets(simpleAttributeSet2, simpleAttributeSet);
                    continue;
                }
                simpleAttributeSet.addAttribute(EditorStyleConstants.DisplayName, simpleAttributeSet2.getAttribute(EditorStyleConstants.DisplayName));
                Object object = simpleAttributeSet2.getAttribute(EditorStyleConstants.Default);
                if (object != null) {
                    simpleAttributeSet.addAttribute(EditorStyleConstants.Default, object);
                }
                simpleAttributeSet.addAttribute(ATTR_MODULE_SUPPLIED, n != 0);
                hashMap.put(string2, (List<Object[]>)((Object)simpleAttributeSet));
            }
        }
        return Utils.immutize(hashMap, ATTR_MODULE_SUPPLIED);
    }

    private static String findDisplayName(String string, FileObject fileObject, List<Object[]> list) {
        String string2;
        block1: {
            Object[] objectArray;
            FileObject fileObject2;
            string2 = Utils.getLocalizedName(fileObject, string, null, true);
            if (string2 != null) break block1;
            Iterator<Object[]> iterator = list.iterator();
            while (iterator.hasNext() && (string2 = Utils.getLocalizedName(fileObject2 = (FileObject)(objectArray = iterator.next())[1], string, null, true)) == null) {
            }
        }
        return string2;
    }

    private static void mergeAttributeSets(SimpleAttributeSet simpleAttributeSet, AttributeSet attributeSet) {
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object object = attributeSet.getAttribute(obj);
            simpleAttributeSet.addAttribute(obj, object);
        }
    }

    public static void deleteColorings(MimePath mimePath, String string, final boolean bl, boolean bl2) {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (string != null) : "The parameter profile must not be null";
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("Editors");
        HashMap<String, List<Object[]>> hashMap = new HashMap<String, List<Object[]>>();
        SettingsType.FONTSCOLORS.getLocator().scan(fileObject, mimePath.getPath(), string, true, bl2, !bl2, hashMap);
        assert (hashMap.size() <= 1) : "Too many results in the scan";
        final List list = (List)hashMap.get(string);
        if (list != null) {
            try {
                fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() {
                        for (Object[] objectArray : list) {
                            FileObject fileObject = (FileObject)objectArray[1];
                            boolean bl2 = ColoringStorage.isTokenColoringFile(fileObject);
                            if (bl2 != bl) continue;
                            try {
                                fileObject.delete();
                            }
                            catch (IOException iOException) {
                                LOG.log(Level.WARNING, "Can't delete editor settings file " + fileObject.getPath(), iOException);
                            }
                        }
                    }
                });
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Can't delete editor colorings for " + mimePath.getPath() + ", " + string, iOException);
            }
        }
    }

    public static void saveColorings(MimePath mimePath, String string, final boolean bl, boolean bl2, final Collection<AttributeSet> collection) {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (string != null) : "The parameter profile must not be null";
        final FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        final String string2 = SettingsType.FONTSCOLORS.getLocator().getWritableFileName(mimePath.getPath(), string, bl ? "-tokenColorings" : "-highlights", bl2);
        try {
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileObject fileObject = fileSystem.findResource("Editors");
                    FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string2);
                    fileObject2.setAttribute(ColoringStorage.FA_TYPE, (Object)(bl ? ColoringStorage.FAV_TOKEN : ColoringStorage.FAV_HIGHLIGHT));
                    ColoringStorage.saveColorings(fileObject2, collection);
                }
            });
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Can't save editor colorings for " + mimePath.getPath() + ", " + string, iOException);
        }
    }

    private static void saveColorings(FileObject fileObject, Collection<AttributeSet> collection) {
        Document document = XMLUtil.createDocument((String)E_ROOT, null, (String)PUBLIC_ID, (String)SYSTEM_ID);
        Node node = document.getElementsByTagName(E_ROOT).item(0);
        for (AttributeSet attributeSet : collection) {
            Element element = document.createElement(E_FONTCOLOR);
            node.appendChild(element);
            element.setAttribute(A_NAME, (String)attributeSet.getAttribute(StyleConstants.NameAttribute));
            if (attributeSet.isDefined(StyleConstants.Foreground)) {
                element.setAttribute(A_FOREGROUND, Utils.colorToString((Color)attributeSet.getAttribute(StyleConstants.Foreground)));
            }
            if (attributeSet.isDefined(StyleConstants.Background)) {
                element.setAttribute(A_BACKGROUND, Utils.colorToString((Color)attributeSet.getAttribute(StyleConstants.Background)));
            }
            if (attributeSet.isDefined(StyleConstants.StrikeThrough)) {
                element.setAttribute(A_STRIKETHROUGH, Utils.colorToString((Color)attributeSet.getAttribute(StyleConstants.StrikeThrough)));
            }
            if (attributeSet.isDefined(EditorStyleConstants.WaveUnderlineColor)) {
                element.setAttribute(A_WAVEUNDERLINE, Utils.colorToString((Color)attributeSet.getAttribute(EditorStyleConstants.WaveUnderlineColor)));
            }
            if (attributeSet.isDefined(StyleConstants.Underline)) {
                element.setAttribute(A_UNDERLINE, Utils.colorToString((Color)attributeSet.getAttribute(StyleConstants.Underline)));
            }
            if (attributeSet.isDefined(EditorStyleConstants.Default)) {
                element.setAttribute(A_DEFAULT, (String)attributeSet.getAttribute(EditorStyleConstants.Default));
            }
            if (!attributeSet.isDefined(StyleConstants.FontFamily) && !attributeSet.isDefined(StyleConstants.FontSize) && !attributeSet.isDefined(StyleConstants.Bold) && !attributeSet.isDefined(StyleConstants.Italic)) continue;
            Element element2 = document.createElement(E_FONT);
            element.appendChild(element2);
            if (attributeSet.isDefined(StyleConstants.FontFamily)) {
                element2.setAttribute(A_NAME, (String)attributeSet.getAttribute(StyleConstants.FontFamily));
            }
            if (attributeSet.isDefined(StyleConstants.FontSize)) {
                element2.setAttribute(A_SIZE, ((Integer)attributeSet.getAttribute(StyleConstants.FontSize)).toString());
            }
            if (!attributeSet.isDefined(StyleConstants.Bold) && !attributeSet.isDefined(StyleConstants.Italic)) continue;
            Boolean bl = Boolean.FALSE;
            Boolean bl2 = Boolean.FALSE;
            if (attributeSet.isDefined(StyleConstants.Bold)) {
                bl = (Boolean)attributeSet.getAttribute(StyleConstants.Bold);
            }
            if (attributeSet.isDefined(StyleConstants.Italic)) {
                bl2 = (Boolean)attributeSet.getAttribute(StyleConstants.Italic);
            }
            element2.setAttribute(A_STYLE, bl.booleanValue() ? (bl2.booleanValue() ? V_BOLD_ITALIC : V_BOLD) : (bl2 != false ? V_ITALIC : V_PLAIN));
        }
        XMLStorage.save(fileObject, document);
    }

    private static boolean isTokenColoringFile(FileObject fileObject) {
        Object object = fileObject.getAttribute(FA_TYPE);
        if (object instanceof String) {
            return object.equals(FAV_TOKEN);
        }
        return !fileObject.getNameExt().equals(HIGHLIGHTING_FILE_NAME);
    }

    private static class ColoringsReader
    extends XMLStorage.Handler {
        private final List<AttributeSet> colorings = new ArrayList<AttributeSet>();

        public Object getResult() {
            return this.colorings;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            block14: {
                try {
                    if (string3.equals(ColoringStorage.E_ROOT)) break block14;
                    if (string3.equals(ColoringStorage.E_FONTCOLOR)) {
                        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, attributes.getValue(ColoringStorage.A_NAME));
                        String string4 = attributes.getValue(ColoringStorage.A_BACKGROUND);
                        if (string4 != null) {
                            simpleAttributeSet.addAttribute(StyleConstants.Background, Utils.stringToColor(string4));
                        }
                        if ((string4 = attributes.getValue(ColoringStorage.A_FOREGROUND)) != null) {
                            simpleAttributeSet.addAttribute(StyleConstants.Foreground, Utils.stringToColor(string4));
                        }
                        if ((string4 = attributes.getValue(ColoringStorage.A_UNDERLINE)) != null) {
                            simpleAttributeSet.addAttribute(StyleConstants.Underline, Utils.stringToColor(string4));
                        }
                        if ((string4 = attributes.getValue(ColoringStorage.A_STRIKETHROUGH)) != null) {
                            simpleAttributeSet.addAttribute(StyleConstants.StrikeThrough, Utils.stringToColor(string4));
                        }
                        if ((string4 = attributes.getValue(ColoringStorage.A_WAVEUNDERLINE)) != null) {
                            simpleAttributeSet.addAttribute(EditorStyleConstants.WaveUnderlineColor, Utils.stringToColor(string4));
                        }
                        if ((string4 = attributes.getValue(ColoringStorage.A_DEFAULT)) != null) {
                            simpleAttributeSet.addAttribute(EditorStyleConstants.Default, string4);
                        }
                        this.colorings.add(simpleAttributeSet);
                        break block14;
                    }
                    if (!string3.equals(ColoringStorage.E_FONT)) break block14;
                    SimpleAttributeSet simpleAttributeSet = (SimpleAttributeSet)this.colorings.get(this.colorings.size() - 1);
                    String string5 = attributes.getValue(ColoringStorage.A_NAME);
                    if (string5 != null) {
                        simpleAttributeSet.addAttribute(StyleConstants.FontFamily, string5);
                    }
                    if ((string5 = attributes.getValue(ColoringStorage.A_SIZE)) != null) {
                        try {
                            simpleAttributeSet.addAttribute(StyleConstants.FontSize, Integer.decode(string5));
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOG.log(Level.WARNING, string5 + " is not a valid Integer; parsing attribute " + ColoringStorage.A_SIZE + this.getProcessedFile().getPath(), numberFormatException);
                        }
                    }
                    if ((string5 = attributes.getValue(ColoringStorage.A_STYLE)) != null) {
                        simpleAttributeSet.addAttribute(StyleConstants.Bold, string5.indexOf(ColoringStorage.V_BOLD) >= 0);
                        simpleAttributeSet.addAttribute(StyleConstants.Italic, string5.indexOf(ColoringStorage.V_ITALIC) >= 0);
                    }
                }
                catch (Exception exception) {
                    LOG.log(Level.WARNING, "Can't parse colorings file " + this.getProcessedFile().getPath(), exception);
                }
            }
        }
    }
}

