/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jrx.export;

import com.jaspersoft.jrx.export.IDisplayWidthProvider;
import com.jaspersoft.jrx.export.IDisplayWidthProviderFactory;
import com.jaspersoft.jrx.export.JRTxtExporterParameter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;

public class JRTxtExporter
extends JRAbstractExporter {
    private IDisplayWidthProvider dwProvider = null;
    int PAGE_ROWS = 61;
    int PAGE_COLUMNS = 255;
    int CHAR_UNIT_H = 10;
    int CHAR_UNIT_V = 20;
    boolean ADD_FORM_FEED = true;
    protected String delimiter = null;
    protected Writer writer = null;
    protected JRExportProgressMonitor progressMonitor = null;
    private int currentLineDiff = 0;
    private boolean useBIDIMarker = false;
    private String bidi_prefix = System.getProperty("BIDI_PREFIX");

    public JRTxtExporter() {
        if (this.bidi_prefix != null && this.bidi_prefix.trim().length() > 0) {
            this.useBIDIMarker = true;
        }
    }

    public void exportReport() throws JRException {
        String page_rows;
        String strBidiPrefixParam;
        Object bidiPrefixParam;
        Object obj;
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setInput();
        this.setPageRange();
        String encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING);
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        if ((obj = this.parameters.get((Object)JRTxtExporterParameter.DISPLAY_WIDTH_PROVIDER_FACTORY)) != null && obj instanceof String) {
            String stringDisplaywidthProviderFactoryClass = (String)obj;
            try {
                obj = Class.forName(stringDisplaywidthProviderFactoryClass, true, this.classLoader == null ? Thread.currentThread().getContextClassLoader() : this.classLoader).newInstance();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if ((bidiPrefixParam = this.parameters.get((Object)JRTxtExporterParameter.BIDI_PREFIX)) != null && bidiPrefixParam instanceof String && (strBidiPrefixParam = (String)bidiPrefixParam).length() > 0) {
            this.useBIDIMarker = true;
            this.bidi_prefix = strBidiPrefixParam;
        }
        if (obj != null && obj instanceof IDisplayWidthProviderFactory) {
            try {
                this.dwProvider = ((IDisplayWidthProviderFactory)obj).createDisplayWidthProvider();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.PAGE_ROWS = (page_rows = (String)this.parameters.get((Object)JRTxtExporterParameter.PAGE_ROWS)) != null ? Integer.parseInt(page_rows) : this.jasperPrint.getPageHeight() / 20;
        String page_cols = (String)this.parameters.get((Object)JRTxtExporterParameter.PAGE_COLUMNS);
        this.PAGE_COLUMNS = page_cols != null ? Integer.parseInt(page_cols) : this.jasperPrint.getPageWidth() / this.CHAR_UNIT_H;
        Object add_form_feed = this.parameters.get((Object)JRTxtExporterParameter.ADD_FORM_FEED);
        this.ADD_FORM_FEED = add_form_feed != null ? (add_form_feed + "").equals("true") : true;
        this.delimiter = ",";
        StringBuffer sb = (StringBuffer)this.parameters.get(JRXmlExporterParameter.OUTPUT_STRING_BUFFER);
        if (sb != null) {
            try {
                this.writer = new StringWriter();
                this.exportReportToWriter();
                sb.append(this.writer.toString());
            }
            catch (IOException e) {
                throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), (Throwable)e);
            }
            finally {
                if (this.writer != null) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
        if (this.writer != null) {
            try {
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), (Throwable)e);
            }
        }
        OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
        if (os != null) {
            try {
                this.writer = new OutputStreamWriter(os, encoding);
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), (Throwable)e);
            }
        }
        File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
        if (destFile == null) {
            String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
            if (fileName != null) {
                destFile = new File(fileName);
            } else {
                throw new JRException("No output specified for the exporter.");
            }
        }
        try {
            os = new FileOutputStream(destFile);
            this.writer = new OutputStreamWriter(os, encoding);
            this.exportReportToWriter();
        }
        catch (IOException e) {
            throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), (Throwable)e);
        }
        finally {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void exportReportToWriter() throws JRException, IOException {
        List pages = this.jasperPrint.getPages();
        if (pages != null && pages.size() > 0) {
            JRPrintPage page = null;
            for (int i = this.startPageIndex; i <= this.endPageIndex; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                page = (JRPrintPage)pages.get(i);
                this.exportPage(page);
            }
        }
        this.writer.flush();
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        Vector lines = this.layoutGrid(page);
        int y = 0;
        for (y = 0; y < lines.size(); ++y) {
            String s = "" + lines.elementAt(y);
            while (s.endsWith(" ")) {
                s = s.substring(0, s.length() - 1);
            }
            this.writer.write(s);
            this.writer.write("\n");
        }
        while (y < this.PAGE_ROWS) {
            this.writer.write("\n");
            ++y;
        }
        if (this.ADD_FORM_FEED) {
            this.writer.write("\f");
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected Vector layoutGrid(JRPrintPage page) {
        int i;
        Vector<String> v_lines = new Vector<String>();
        String void_line = "";
        for (i = 0; i < this.PAGE_COLUMNS; ++i) {
            void_line = void_line + " ";
        }
        for (i = 0; i < this.PAGE_ROWS; ++i) {
            void_line = void_line + " ";
            v_lines.add(void_line);
        }
        ArrayList<Integer> yCuts = new ArrayList<Integer>();
        yCuts.add(new Integer(0));
        yCuts.add(new Integer(this.jasperPrint.getPageHeight()));
        Integer y = null;
        List elems = page.getElements();
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            JRPrintElement element = (JRPrintElement)it.next();
            if (!(element instanceof JRPrintText)) continue;
            y = new Integer(element.getY());
            if (!yCuts.contains(y)) {
                yCuts.add(y);
            }
            if (yCuts.contains(y = new Integer(element.getY() + element.getHeight()))) continue;
            yCuts.add(y);
        }
        Collections.sort(yCuts);
        int yCellCount = yCuts.size() - 1;
        int real_line_num = 0;
        JRPrintElement[] elements = elems.toArray(new JRPrintElement[0]);
        JRPrintElement[] sortedElements = this.doQuickSort(elements, 0, elements.length - 1);
        HashMap pageElements = this.separateElementsByLine(sortedElements);
        for (int j = 0; j < yCellCount; ++j) {
            if (v_lines.size() <= real_line_num) {
                v_lines.add(new String(void_line));
            }
            Integer actual_cut = (Integer)yCuts.get(j);
            int lines_used = 1;
            this.currentLineDiff = 0;
            HashMap<Integer, Integer> lineDiffs = new HashMap<Integer, Integer>();
            ArrayList lineElements = (ArrayList)pageElements.get(actual_cut);
            if (lineElements != null) {
                Iterator it2 = lineElements.iterator();
                while (it2.hasNext()) {
                    JRPrintText pt = (JRPrintText)it2.next();
                    int start_at = pt.getX() / this.CHAR_UNIT_H;
                    int len = pt.getWidth() / this.CHAR_UNIT_H;
                    String str = pt.getText();
                    boolean line_height = false;
                    if (pt.getHeight() <= this.CHAR_UNIT_V) {
                        if (str.length() > len) {
                            str = str.substring(0, len);
                        }
                        if (pt.getY() / this.CHAR_UNIT_V > real_line_num) {
                            real_line_num = pt.getY() / this.CHAR_UNIT_V;
                        }
                        if (v_lines.size() <= real_line_num) {
                            v_lines.add(new String(void_line));
                        }
                        String line = (String)v_lines.elementAt(real_line_num);
                        line = this.replaceLineRegion(line, start_at, len, str, pt.getTextAlignment());
                        lineDiffs.put(new Integer(real_line_num), new Integer(this.currentLineDiff));
                        v_lines.setElementAt(line, real_line_num);
                        continue;
                    }
                    boolean max_field_lines = true;
                    Vector field_lines = this.getFieldLines(str, len);
                    int nl = 0;
                    for (nl = 0; nl < field_lines.size(); ++nl) {
                        String text = (String)field_lines.elementAt(nl);
                        while (v_lines.size() <= real_line_num + nl) {
                            v_lines.add(new String(void_line));
                        }
                        String line = (String)v_lines.elementAt(real_line_num + nl);
                        this.currentLineDiff = lineDiffs.containsKey(new Integer(real_line_num + nl)) ? (Integer)lineDiffs.get(new Integer(real_line_num + nl)) : 0;
                        line = this.replaceLineRegion(line, start_at, len, text, pt.getTextAlignment());
                        lineDiffs.put(new Integer(real_line_num + nl), new Integer(this.currentLineDiff));
                        v_lines.setElementAt(line, real_line_num + nl);
                    }
                    if (nl <= lines_used) continue;
                    lines_used = nl;
                }
            }
            real_line_num += lines_used;
        }
        return v_lines;
    }

    private HashMap separateElementsByLine(JRPrintElement[] elems) {
        HashMap<Integer, ArrayList<JRPrintText>> pageElements = new HashMap<Integer, ArrayList<JRPrintText>>();
        for (int i = 0; i < elems.length; ++i) {
            JRPrintElement element = elems[i];
            if (!(element instanceof JRPrintText)) continue;
            JRPrintText pt = (JRPrintText)element;
            Integer yCut = pt.getY();
            ArrayList<JRPrintText> lineElements = (ArrayList<JRPrintText>)pageElements.get(yCut);
            if (lineElements == null) {
                lineElements = new ArrayList<JRPrintText>();
                pageElements.put(yCut, lineElements);
            }
            lineElements.add(pt);
        }
        return pageElements;
    }

    protected String replaceLineRegion(String line, int start_at, int len, String str, byte alignment) {
        int side = 0;
        if (this.useBIDIMarker) {
            str = this.bidi_prefix + str;
        }
        int displayWidthOfString = this.getDisplayWidth(str);
        if (alignment == 2 && (side = len - displayWidthOfString) > 0) {
            side /= 2;
            for (int k = 0; k < side; ++k) {
                str = " " + str;
            }
            displayWidthOfString += side;
        }
        if (alignment == 3) {
            side = len - displayWidthOfString;
            for (int i = 1; i <= side; ++i) {
                str = " " + str;
            }
            displayWidthOfString += side;
        }
        int lengthOfString = str.length();
        side = len - displayWidthOfString;
        for (int i = 1; i <= side; ++i) {
            str = str + " ";
        }
        String replacedLine = line.substring(0, start_at + this.currentLineDiff) + str + line.substring(start_at + len + this.currentLineDiff);
        this.currentLineDiff = this.currentLineDiff + lengthOfString - displayWidthOfString;
        return replacedLine;
    }

    public Vector getFieldLines(String str, int row_len) {
        Vector<String> lines = new Vector<String>();
        StringTokenizer st = new StringTokenizer(str, "\n", false);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            while (token.length() > row_len) {
                String tmp_line = token.substring(0, row_len);
                int li = tmp_line.lastIndexOf(32);
                if (token.charAt(row_len) == ' ') {
                    lines.addElement(tmp_line);
                    token = token.substring(row_len).trim();
                    continue;
                }
                if (li == -1) {
                    lines.addElement(tmp_line);
                    token = token.substring(row_len).trim();
                    continue;
                }
                tmp_line = token.substring(0, li);
                lines.addElement(tmp_line);
                token = token.substring(li + 1).trim();
            }
            if (token.trim().length() <= 0) continue;
            if (lines.size() == 0) {
                lines.addElement(token);
                continue;
            }
            lines.addElement(token.trim());
        }
        return lines;
    }

    private JRPrintElement[] doQuickSort(JRPrintElement[] elems, int start, int end) {
        int i = start;
        int j = end;
        if (elems.length <= 0) {
            return elems;
        }
        int pivot = elems[(start + end) / 2].getX();
        while (true) {
            if (elems[i].getX() < pivot) {
                ++i;
                continue;
            }
            while (elems[j].getX() > pivot) {
                --j;
            }
            if (i <= j) {
                JRPrintElement temp = elems[i];
                elems[i] = elems[j];
                elems[j] = temp;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (start < j) {
            this.doQuickSort(elems, start, j);
        }
        if (i < end) {
            this.doQuickSort(elems, i, end);
        }
        return elems;
    }

    private int getDisplayWidth(String str) {
        if (this.dwProvider != null) {
            try {
                return this.dwProvider.getDisplayWidth(str);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return str.length();
    }
}

