/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class DVALRecord
extends Record {
    public static final short sid = 434;
    private short field_1_options;
    private int field_2_horiz_pos;
    private int field_3_vert_pos;
    private int field_cbo_id;
    private int field_5_dv_no;

    public DVALRecord() {
        this.field_cbo_id = -1;
        this.field_5_dv_no = 0;
    }

    public DVALRecord(RecordInputStream in) {
        this.field_1_options = in.readShort();
        this.field_2_horiz_pos = in.readInt();
        this.field_3_vert_pos = in.readInt();
        this.field_cbo_id = in.readInt();
        this.field_5_dv_no = in.readInt();
    }

    public void setOptions(short field_1_options) {
        this.field_1_options = field_1_options;
    }

    public void setHorizontalPos(int field_2_horiz_pos) {
        this.field_2_horiz_pos = field_2_horiz_pos;
    }

    public void setVerticalPos(int field_3_vert_pos) {
        this.field_3_vert_pos = field_3_vert_pos;
    }

    public void setObjectID(int cboID) {
        this.field_cbo_id = cboID;
    }

    public void setDVRecNo(int dvNo) {
        this.field_5_dv_no = dvNo;
    }

    public short getOptions() {
        return this.field_1_options;
    }

    public int getHorizontalPos() {
        return this.field_2_horiz_pos;
    }

    public int getVerticalPos() {
        return this.field_3_vert_pos;
    }

    public int getObjectID() {
        return this.field_cbo_id;
    }

    public int getDVRecNo() {
        return this.field_5_dv_no;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[DVAL]\n");
        buffer.append("    .options      = ").append(this.getOptions()).append('\n');
        buffer.append("    .horizPos     = ").append(this.getHorizontalPos()).append('\n');
        buffer.append("    .vertPos      = ").append(this.getVerticalPos()).append('\n');
        buffer.append("    .comboObjectID   = ").append(Integer.toHexString(this.getObjectID())).append("\n");
        buffer.append("    .DVRecordsNumber = ").append(Integer.toHexString(this.getDVRecNo())).append("\n");
        buffer.append("[/DVAL]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)434);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset, this.getOptions());
        LittleEndian.putInt(data, 6 + offset, this.getHorizontalPos());
        LittleEndian.putInt(data, 10 + offset, this.getVerticalPos());
        LittleEndian.putInt(data, 14 + offset, this.getObjectID());
        LittleEndian.putInt(data, 18 + offset, this.getDVRecNo());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 22;
    }

    public short getSid() {
        return 434;
    }

    public Object clone() {
        DVALRecord rec = new DVALRecord();
        rec.field_1_options = this.field_1_options;
        rec.field_2_horiz_pos = this.field_2_horiz_pos;
        rec.field_3_vert_pos = this.field_3_vert_pos;
        rec.field_cbo_id = this.field_cbo_id;
        rec.field_5_dv_no = this.field_5_dv_no;
        return rec;
    }
}

