/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.awt.Image;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRGanttSeries;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.fill.JRPercentageCalculator;
import net.sf.jasperreports.crosstabs.fill.JRPercentageCalculatorFactory;
import net.sf.jasperreports.engine.JRAnchor;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRGenericElementParameter;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentCompiler;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRValidationFault;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementerFactory;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRQueryExecuterUtils;

public class JRVerifier {
    public static final String PROPERTY_ALLOW_ELEMENT_OVERLAP = "net.sf.jasperreports.allow.element.overlap";
    private static String[] textFieldClassNames = null;
    private static String[] imageClassNames = null;
    private static String[] subreportClassNames = null;
    private static Class[] templateTypes = new Class[]{String.class, File.class, URL.class, InputStream.class, JRTemplate.class};
    private JasperDesign jasperDesign = null;
    private Collection brokenRules = null;
    private JRExpressionCollector expressionCollector;

    protected JRVerifier(JasperDesign jrDesign) {
        this(jrDesign, null);
    }

    protected JRVerifier(JasperDesign jrDesign, JRExpressionCollector expressionCollector) {
        this.jasperDesign = jrDesign;
        this.brokenRules = new ArrayList();
        this.expressionCollector = expressionCollector != null ? expressionCollector : JRExpressionCollector.collector(this.jasperDesign);
    }

    public JasperDesign getReportDesign() {
        return this.jasperDesign;
    }

    public void addBrokenRule(String message, Object source) {
        JRVerifier.addBrokenRule(this.brokenRules, message, source);
    }

    protected static void addBrokenRule(Collection brokenRules, String message, Object source) {
        JRValidationFault fault = new JRValidationFault();
        fault.setMessage(message);
        fault.setSource(source);
        brokenRules.add(fault);
    }

    public void addBrokenRule(Exception e, Object source) {
        JRValidationFault fault = new JRValidationFault();
        fault.setMessage(e.getMessage());
        fault.setSource(source);
        this.brokenRules.add(fault);
    }

    public static Collection verifyDesign(JasperDesign jasperDesign, JRExpressionCollector expressionCollector) {
        JRVerifier verifier = new JRVerifier(jasperDesign, expressionCollector);
        return verifier.verifyDesign();
    }

    public static Collection verifyDesign(JasperDesign jasperDesign) {
        return JRVerifier.verifyDesign(jasperDesign, null);
    }

    protected Collection verifyDesign() {
        this.jasperDesign.preprocess();
        this.verifyDesignAttributes();
        this.verifyReportTemplates();
        this.verifyReportFonts();
        this.verifyDataset(this.jasperDesign.getMainDesignDataset());
        this.verifyDatasets();
        this.verifyStyles();
        if (this.toVerifyElementOverlap()) {
            this.verifyEmptyBackground();
        }
        this.verifyBand(this.jasperDesign.getBackground());
        this.verifyBand(this.jasperDesign.getTitle());
        this.verifyBand(this.jasperDesign.getPageHeader());
        this.verifyBand(this.jasperDesign.getColumnHeader());
        this.verifySection(this.jasperDesign.getDetailSection());
        this.verifyBand(this.jasperDesign.getColumnFooter());
        this.verifyBand(this.jasperDesign.getPageFooter());
        this.verifyBand(this.jasperDesign.getLastPageFooter());
        this.verifyBand(this.jasperDesign.getSummary());
        this.verifyBand(this.jasperDesign.getNoData());
        return this.brokenRules;
    }

    protected void verifyEmptyBackground() {
        JRElement[] elements;
        JRBand background = this.jasperDesign.getBackground();
        if (background != null && background.getHeight() > 0 && (elements = background.getElements()) != null && elements.length > 0) {
            boolean foundContent = false;
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i].getWidth() <= 0 || elements[i].getHeight() <= 0) continue;
                foundContent = true;
                break;
            }
            if (foundContent) {
                this.addBrokenRule("Use of the background section is not recommended for reports that are supposed to be exported using grid exporters such as HTML and XLS because the background content would likely be overlapped by other sections resulting in it not showing up.", (Object)background);
            }
        }
    }

    private void verifyDesignAttributes() {
        if (this.jasperDesign.getName() == null || this.jasperDesign.getName().trim().length() == 0) {
            this.addBrokenRule("Report name is missing.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getColumnCount() <= 0) {
            this.addBrokenRule("Column count must be greater than zero.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getPageWidth() < 0) {
            this.addBrokenRule("Page width must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getPageHeight() < 0) {
            this.addBrokenRule("Page height must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getColumnWidth() < 0) {
            this.addBrokenRule("Column width must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getColumnSpacing() < 0) {
            this.addBrokenRule("Column spacing must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getLeftMargin() < 0) {
            this.addBrokenRule("Left margin must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getRightMargin() < 0) {
            this.addBrokenRule("Right margin must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getTopMargin() < 0) {
            this.addBrokenRule("Top margin must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getBottomMargin() < 0) {
            this.addBrokenRule("Bottom margin must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getLeftMargin() + this.jasperDesign.getColumnCount() * this.jasperDesign.getColumnWidth() + (this.jasperDesign.getColumnCount() - 1) * this.jasperDesign.getColumnSpacing() + this.jasperDesign.getRightMargin() > this.jasperDesign.getPageWidth()) {
            this.addBrokenRule("The columns and the margins do not fit the page width.", (Object)this.jasperDesign);
        }
        JRVerifier.verifyBandHeights(this.brokenRules, this.jasperDesign, this.jasperDesign.getPageHeight(), this.jasperDesign.getTopMargin(), this.jasperDesign.getBottomMargin());
        this.verifyFormatFactoryClass();
    }

    public static void verifyBandHeights(Collection brokenRules, JRReport report, int pageHeight, int topMargin, int bottomMargin) {
        JRBand[] detailBands;
        JRSection detailSection;
        if (topMargin + (report.getBackground() != null ? report.getBackground().getHeight() : 0) + bottomMargin > pageHeight) {
            JRVerifier.addBrokenRule(brokenRules, "The background section and the margins do not fit the page height.", report);
        }
        if (report.isTitleNewPage()) {
            if (topMargin + JRVerifier.getBreakHeight(report.getTitle()) + bottomMargin > pageHeight) {
                JRVerifier.addBrokenRule(brokenRules, "The title section and the margins do not fit the page height.", report);
            }
        } else if (topMargin + JRVerifier.getBreakHeight(report.getTitle()) + (report.getPageHeader() != null ? report.getPageHeader().getHeight() : 0) + (report.getColumnHeader() != null ? report.getColumnHeader().getHeight() : 0) + (report.getColumnFooter() != null ? report.getColumnFooter().getHeight() : 0) + (report.getPageFooter() != null ? report.getPageFooter().getHeight() : 0) + bottomMargin > pageHeight) {
            JRVerifier.addBrokenRule(brokenRules, "The title section, the page and column headers and footers and the margins do not fit the page height.", report);
        }
        if (topMargin + (report.getPageHeader() != null ? report.getPageHeader().getHeight() : 0) + (report.getColumnHeader() != null ? report.getColumnHeader().getHeight() : 0) + (report.getColumnFooter() != null ? report.getColumnFooter().getHeight() : 0) + (report.getPageFooter() != null ? report.getPageFooter().getHeight() : 0) + bottomMargin > pageHeight) {
            JRVerifier.addBrokenRule(brokenRules, "The page and column headers and footers and the margins do not fit the page height.", report);
        }
        if (topMargin + (report.getPageHeader() != null ? report.getPageHeader().getHeight() : 0) + (report.getColumnHeader() != null ? report.getColumnHeader().getHeight() : 0) + (report.getColumnFooter() != null ? report.getColumnFooter().getHeight() : 0) + (report.getLastPageFooter() != null ? report.getLastPageFooter().getHeight() : 0) + bottomMargin > pageHeight) {
            JRVerifier.addBrokenRule(brokenRules, "The page and column headers and footers and the margins do not fit the last page height.", report);
        }
        if (topMargin + JRVerifier.getBreakHeight(report.getSummary()) + bottomMargin > pageHeight) {
            JRVerifier.addBrokenRule(brokenRules, "The summary section and the margins do not fit the page height.", report);
        }
        if ((detailSection = report.getDetailSection()) != null && (detailBands = detailSection.getBands()) != null && detailBands.length > 0) {
            for (int i = 0; i < detailBands.length; ++i) {
                JRBand detailBand = detailBands[i];
                if (topMargin + (report.getPageHeader() != null ? report.getPageHeader().getHeight() : 0) + (report.getColumnHeader() != null ? report.getColumnHeader().getHeight() : 0) + JRVerifier.getBreakHeight(detailBand) + (report.getColumnFooter() != null ? report.getColumnFooter().getHeight() : 0) + (report.getPageFooter() != null ? report.getPageFooter().getHeight() : 0) + bottomMargin <= pageHeight) continue;
                JRVerifier.addBrokenRule(brokenRules, "The detail section, the page and column headers and footers and the margins do not fit the page height.", report);
            }
        }
        if (topMargin + JRVerifier.getBreakHeight(report.getNoData()) + bottomMargin > pageHeight) {
            JRVerifier.addBrokenRule(brokenRules, "The noData section and the margins do not fit the page height.", report);
        }
    }

    protected void verifyFormatFactoryClass() {
        String formatFactoryClassName = this.jasperDesign.getFormatFactoryClass();
        if (formatFactoryClassName != null) {
            try {
                Class formatFactoryClass = JRClassLoader.loadClassForName(formatFactoryClassName);
                if (!FormatFactory.class.isAssignableFrom(formatFactoryClass)) {
                    this.addBrokenRule("The report format factory class is not compatible with " + FormatFactory.class.getName(), (Object)this.jasperDesign);
                }
            }
            catch (ClassNotFoundException e) {
                this.addBrokenRule(e.toString(), (Object)this.jasperDesign);
            }
        }
    }

    private void verifyQuery(JRDesignDataset dataset) {
        JRQuery query = dataset.getQuery();
        if (query != null) {
            String language = query.getLanguage();
            JRQueryExecuterFactory queryExecuterFactory = null;
            if (language == null || language.length() == 0) {
                this.addBrokenRule("Query language not set.", (Object)query);
            } else {
                try {
                    queryExecuterFactory = JRQueryExecuterUtils.getQueryExecuterFactory(query.getLanguage());
                }
                catch (JRException e1) {
                    this.addBrokenRule("Query executer factory for " + language + " cannot be created.", (Object)query);
                }
            }
            JRQueryChunk[] chunks = query.getChunks();
            if (chunks != null && chunks.length > 0) {
                Map parametersMap = dataset.getParametersMap();
                block8: for (int j = 0; j < chunks.length; ++j) {
                    JRQueryChunk queryChunk = chunks[j];
                    switch (queryChunk.getType()) {
                        case 2: {
                            JRParameter parameter = (JRParameter)parametersMap.get(queryChunk.getText());
                            if (parameter == null) {
                                this.addBrokenRule("Query parameter not found : " + queryChunk.getText(), (Object)query);
                                continue block8;
                            }
                            if (queryExecuterFactory == null) continue block8;
                            String parameterType = null;
                            try {
                                parameterType = parameter.getValueClassName();
                            }
                            catch (JRRuntimeException e) {
                                // empty catch block
                            }
                            if (parameterType == null || queryExecuterFactory.supportsQueryParameterType(parameterType)) continue block8;
                            this.addBrokenRule("Parameter type not supported in query : " + queryChunk.getText() + " class " + parameterType, (Object)query);
                            continue block8;
                        }
                        case 3: {
                            if (parametersMap.containsKey(queryChunk.getText())) continue block8;
                            this.addBrokenRule("Query parameter not found : " + queryChunk.getText(), (Object)query);
                            continue block8;
                        }
                    }
                }
            }
        }
    }

    private void verifyExpressions(List expressions, Map parametersMap, Map fieldsMap, Map variablesMap) {
        if (expressions != null && expressions.size() > 0) {
            Iterator it = expressions.iterator();
            while (it.hasNext()) {
                JRExpression expression = (JRExpression)it.next();
                JRExpressionChunk[] chunks = expression.getChunks();
                if (chunks == null || chunks.length <= 0) continue;
                block6: for (int j = 0; j < chunks.length; ++j) {
                    JRExpressionChunk expressionChunk = chunks[j];
                    switch (expressionChunk.getType()) {
                        case 4: {
                            if (variablesMap.containsKey(expressionChunk.getText())) continue block6;
                            this.addBrokenRule("Variable not found : " + expressionChunk.getText(), (Object)expression);
                            continue block6;
                        }
                        case 3: {
                            if (fieldsMap.containsKey(expressionChunk.getText())) continue block6;
                            this.addBrokenRule("Field not found : " + expressionChunk.getText(), (Object)expression);
                            continue block6;
                        }
                        case 2: {
                            if (parametersMap.containsKey(expressionChunk.getText())) continue block6;
                            this.addBrokenRule("Parameter not found : " + expressionChunk.getText(), (Object)expression);
                            continue block6;
                        }
                    }
                }
            }
        }
    }

    private void verifyExpressions(JRDesignDataset dataset) {
        this.verifyExpressions(this.expressionCollector.getExpressions(dataset), dataset.getParametersMap(), dataset.getFieldsMap(), dataset.getVariablesMap());
    }

    private void verifyReportFonts() {
        JRReportFont[] fonts = this.jasperDesign.getFonts();
        if (fonts != null && fonts.length > 0) {
            for (int index = 0; index < fonts.length; ++index) {
                JRReportFont font = fonts[index];
                if (font.getName() != null && font.getName().trim().length() != 0) continue;
                this.addBrokenRule("Report font name missing.", (Object)font);
            }
        }
    }

    protected void verifyReportTemplates() {
        JRReportTemplate[] templates = this.jasperDesign.getTemplates();
        if (templates != null) {
            for (int i = 0; i < templates.length; ++i) {
                JRReportTemplate template = templates[i];
                this.verifyTemplate(template);
            }
        }
    }

    protected void verifyTemplate(JRReportTemplate template) {
        JRExpression sourceExpression = template.getSourceExpression();
        if (sourceExpression == null) {
            this.addBrokenRule("Template source expression missing.", (Object)template);
        } else {
            try {
                Class valueClass = sourceExpression.getValueClass();
                if (valueClass == null) {
                    this.addBrokenRule("Template source expression value class not set.", (Object)sourceExpression);
                } else if (!this.verifyTemplateSourceType(valueClass)) {
                    this.addBrokenRule("Template source expression value class " + valueClass.getName() + "not supported.", (Object)sourceExpression);
                }
            }
            catch (JRRuntimeException e) {
                this.addBrokenRule(e, (Object)sourceExpression);
            }
        }
    }

    protected boolean verifyTemplateSourceType(Class valueClass) {
        boolean valid = false;
        for (int i = 0; i < templateTypes.length; ++i) {
            Class type = templateTypes[i];
            if (!type.isAssignableFrom(valueClass)) continue;
            valid = true;
            break;
        }
        return valid;
    }

    private void verifyStyles() {
        JRStyle[] styles = this.jasperDesign.getStyles();
        if (styles != null && styles.length > 0) {
            for (int index = 0; index < styles.length; ++index) {
                JRStyle style = styles[index];
                if (style.getName() != null && style.getName().trim().length() != 0) continue;
                this.addBrokenRule("Report style name missing.", (Object)style);
            }
        }
    }

    private void verifyParameters(JRDesignDataset dataset) {
        JRParameter[] parameters = dataset.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int index = 0; index < parameters.length; ++index) {
                JRParameter parameter;
                JRPropertiesHolder errorSource = parameter = parameters[index];
                if (parameter.isSystemDefined()) {
                    errorSource = this.jasperDesign;
                }
                if (parameter.getName() == null || parameter.getName().trim().length() == 0) {
                    this.addBrokenRule("Parameter name missing.", (Object)errorSource);
                }
                if (parameter.getValueClassName() == null) {
                    this.addBrokenRule("Class not set for parameter : " + parameter.getName(), (Object)errorSource);
                    continue;
                }
                try {
                    Class parameterType = parameter.getValueClass();
                    JRExpression expression = parameter.getDefaultValueExpression();
                    if (expression == null) continue;
                    try {
                        if (expression.getValueClass() == null) {
                            this.addBrokenRule("No value class defined for the expression in parameter: " + parameter.getName(), (Object)expression);
                            continue;
                        }
                        if (parameterType.isAssignableFrom(expression.getValueClass())) continue;
                        this.addBrokenRule("The parameter default value expression class is not compatible with the parameter's class : " + parameter.getName(), (Object)expression);
                    }
                    catch (JRRuntimeException e) {
                        this.addBrokenRule(e, (Object)expression);
                    }
                    continue;
                }
                catch (JRRuntimeException e) {
                    this.addBrokenRule(e, (Object)errorSource);
                }
            }
        }
    }

    private void verifyFields(JRDesignDataset dataset) {
        JRField[] fields = dataset.getFields();
        if (fields != null && fields.length > 0) {
            for (int index = 0; index < fields.length; ++index) {
                JRField field = fields[index];
                if (field.getName() == null || field.getName().trim().length() == 0) {
                    this.addBrokenRule("Field name missing.", (Object)field);
                }
                try {
                    Class fieldType = field.getValueClass();
                    if (fieldType != null) continue;
                    this.addBrokenRule("Class not set for field : " + field.getName(), (Object)field);
                    continue;
                }
                catch (JRRuntimeException e) {
                    this.addBrokenRule(e, (Object)field);
                }
            }
        }
    }

    private void verifySortFields(JRDesignDataset dataset) {
        JRField[] fields = dataset.getFields();
        JRSortField[] sortFields = dataset.getSortFields();
        if (sortFields != null && sortFields.length > 0) {
            for (int index = 0; index < sortFields.length; ++index) {
                JRSortField sortField = sortFields[index];
                String sortFieldName = sortField.getName();
                if (sortFieldName == null || sortFieldName.trim().length() == 0) {
                    this.addBrokenRule("Sort field name missing.", (Object)sortField);
                    continue;
                }
                boolean isFound = false;
                for (int j = 0; !isFound && j < fields.length; ++j) {
                    isFound = sortFieldName.equals(fields[j].getName());
                }
                if (isFound) continue;
                this.addBrokenRule("Sort field \"" + sortFieldName + "\" not declared.", (Object)sortField);
            }
        }
    }

    private void verifyVariables(JRDesignDataset dataset) throws JRRuntimeException {
        JRVariable[] variables = dataset.getVariables();
        if (variables != null && variables.length > 0) {
            boolean isMainDataset = dataset.isMainDataset();
            for (int index = 0; index < variables.length; ++index) {
                byte incrementType;
                JRVariable variable;
                block24: {
                    variable = variables[index];
                    if (variable.getName() == null || variable.getName().trim().length() == 0) {
                        this.addBrokenRule("Variable name missing.", (Object)variable);
                    }
                    try {
                        Class valueClass = variable.getValueClass();
                        if (valueClass == null) {
                            this.addBrokenRule("Class not set for variable : " + variable.getName(), (Object)variable);
                            break block24;
                        }
                        JRExpression expression = variable.getExpression();
                        if (expression != null) {
                            try {
                                if (expression.getValueClass() == null) {
                                    this.addBrokenRule("No value class for the expression has been set in variable: " + variable.getName(), (Object)expression);
                                } else if (variable.getCalculation() != 1 && variable.getCalculation() != 10 && variable.getCalculation() != 8 && !valueClass.isAssignableFrom(expression.getValueClass())) {
                                    this.addBrokenRule("The variable expression class is not compatible with the variable's class : " + variable.getName(), (Object)expression);
                                }
                            }
                            catch (JRRuntimeException e) {
                                this.addBrokenRule(e, (Object)expression);
                            }
                        }
                        if (variable.getInitialValueExpression() == null) break block24;
                        try {
                            if (!valueClass.isAssignableFrom(variable.getInitialValueExpression().getValueClass())) {
                                this.addBrokenRule("The initial value class is not compatible with the variable's class : " + variable.getName(), (Object)variable.getInitialValueExpression());
                            }
                        }
                        catch (JRRuntimeException e) {
                            this.addBrokenRule(e, (Object)variable.getInitialValueExpression());
                        }
                    }
                    catch (JRRuntimeException e) {
                        this.addBrokenRule(e, (Object)variable);
                    }
                }
                byte resetType = variable.getResetType();
                if (resetType == 4) {
                    if (variable.getResetGroup() == null) {
                        this.addBrokenRule("Reset group missing for variable : " + variable.getName(), (Object)variable);
                    } else {
                        Map groupsMap = dataset.getGroupsMap();
                        if (!groupsMap.containsKey(variable.getResetGroup().getName())) {
                            this.addBrokenRule("Reset group \"" + variable.getResetGroup().getName() + "\" not found for variable : " + variable.getName(), (Object)variable);
                        }
                    }
                }
                if ((incrementType = variable.getIncrementType()) == 4) {
                    if (variable.getIncrementGroup() == null) {
                        this.addBrokenRule("Increment group missing for variable : " + variable.getName(), (Object)variable);
                    } else {
                        Map groupsMap = dataset.getGroupsMap();
                        if (!groupsMap.containsKey(variable.getIncrementGroup().getName())) {
                            this.addBrokenRule("Increment group \"" + variable.getIncrementGroup().getName() + "\" not found for variable : " + variable.getName(), (Object)variable);
                        }
                    }
                }
                if (isMainDataset) continue;
                if (resetType == 3 || resetType == 2) {
                    this.addBrokenRule("Variable " + variable.getName() + " of dataset " + dataset.getName() + " cannot have Column or Page reset type.", (Object)variable);
                }
                if (incrementType != 3 && incrementType != 2) continue;
                this.addBrokenRule("Variable " + variable.getName() + " of dataset " + dataset.getName() + " cannot have Column or Page increment type.", (Object)variable);
            }
        }
    }

    private void verifyGroups(JRDesignDataset dataset) {
        JRGroup[] groups = dataset.getGroups();
        if (groups != null && groups.length > 0) {
            boolean isMainDataset = dataset.isMainDataset();
            for (int index = 0; index < groups.length; ++index) {
                JRGroup group = groups[index];
                if (group.getName() == null || group.getName().trim().length() == 0) {
                    this.addBrokenRule("Group name missing.", (Object)group);
                }
                if (isMainDataset) {
                    this.verifyGroupHeaderAndFooter(group);
                } else if (group.getGroupHeaderSection() != null && group.getGroupHeaderSection().getBands() != null && group.getGroupHeaderSection().getBands().length > 0 || group.getGroupFooterSection() != null && group.getGroupFooterSection().getBands() != null && group.getGroupFooterSection().getBands().length > 0) {
                    this.addBrokenRule("Group " + group.getName() + " cannot have header or footer sections.", (Object)group);
                }
                JRExpression expression = group.getExpression();
                if (expression != null) {
                    try {
                        Class clazz = expression.getValueClass();
                        if (clazz == null) {
                            this.addBrokenRule("Class not set for group expression : " + group.getName(), (Object)expression);
                        }
                    }
                    catch (JRRuntimeException e) {
                        this.addBrokenRule(e, (Object)expression);
                    }
                }
                if (!isMainDataset) continue;
                this.verifySection(group.getGroupHeaderSection());
                this.verifySection(group.getGroupFooterSection());
            }
        }
    }

    private void verifyGroupHeaderAndFooter(JRGroup group) {
        block8: {
            JRBand[] groupFooterBands;
            JRSection groupFooterSection;
            JRBand[] groupHeaderBands;
            block7: {
                JRBand[] groupFooterBands2;
                JRSection groupFooterSection2;
                JRBand[] groupHeaderBands2;
                if (!this.jasperDesign.isTitleNewPage()) break block7;
                JRSection groupHeaderSection = group.getGroupHeaderSection();
                if (groupHeaderSection != null && (groupHeaderBands2 = groupHeaderSection.getBands()) != null && groupHeaderBands2.length > 0) {
                    for (int i = 0; i < groupHeaderBands2.length; ++i) {
                        JRBand groupHeaderBand = groupHeaderBands2[i];
                        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + JRVerifier.getBreakHeight(groupHeaderBand) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() <= this.jasperDesign.getPageHeight()) continue;
                        this.addBrokenRule("The '" + group.getName() + "' group header section, the page and column headers and footers and the margins do not fit the page height.", (Object)groupHeaderBand);
                    }
                }
                if ((groupFooterSection2 = group.getGroupFooterSection()) == null || (groupFooterBands2 = groupFooterSection2.getBands()) == null || groupFooterBands2.length <= 0) break block8;
                for (int i = 0; i < groupFooterBands2.length; ++i) {
                    JRBand groupFooterBand = groupFooterBands2[i];
                    if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + JRVerifier.getBreakHeight(groupFooterBand) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() <= this.jasperDesign.getPageHeight()) continue;
                    this.addBrokenRule("The '" + group.getName() + "' group footer section, the page and column headers and footers and the margins do not fit the page height.", (Object)groupFooterBand);
                }
                break block8;
            }
            JRSection groupHeaderSection = group.getGroupHeaderSection();
            if (groupHeaderSection != null && (groupHeaderBands = groupHeaderSection.getBands()) != null && groupHeaderBands.length > 0) {
                for (int i = 0; i < groupHeaderBands.length; ++i) {
                    JRBand groupHeaderBand = groupHeaderBands[i];
                    if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + JRVerifier.getBreakHeight(groupHeaderBand) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() <= this.jasperDesign.getPageHeight()) continue;
                    this.addBrokenRule("The '" + group.getName() + "' group header section, the title, the page and column headers and footers and the margins do not fit the first page height.", (Object)groupHeaderBand);
                }
            }
            if ((groupFooterSection = group.getGroupFooterSection()) != null && (groupFooterBands = groupFooterSection.getBands()) != null && groupFooterBands.length > 0) {
                for (int i = 0; i < groupFooterBands.length; ++i) {
                    JRBand groupFooterBand = groupFooterBands[i];
                    if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + JRVerifier.getBreakHeight(groupFooterBand) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() <= this.jasperDesign.getPageHeight()) continue;
                    this.addBrokenRule("The '" + group.getName() + "' group footer section, the title, the page and column headers and footers and the margins do not fit the first page height.", (Object)groupFooterBand);
                }
            }
        }
    }

    protected boolean toVerifyElementOverlap() {
        return !JRProperties.getBooleanProperty(this.jasperDesign, PROPERTY_ALLOW_ELEMENT_OVERLAP, true);
    }

    protected boolean isAllowedToOverlap(JRElement element) {
        return element.hasProperties() && JRProperties.asBoolean(element.getPropertiesMap().getProperty(PROPERTY_ALLOW_ELEMENT_OVERLAP));
    }

    protected void verifyElementOverlap(JRElement element1, JRElement element2) {
        if (element1.getWidth() <= 0 || element1.getHeight() <= 0 || element2.getWidth() <= 0 || element2.getHeight() <= 0) {
            return;
        }
        if (element1.getX() < element2.getX() + element2.getWidth() && element2.getX() < element1.getX() + element1.getWidth() && element1.getY() < element2.getY() + element2.getHeight() && element2.getY() < element1.getY() + element1.getHeight()) {
            StringBuffer message = new StringBuffer();
            message.append("Element ");
            if (element2.getKey() != null) {
                message.append("\"");
                message.append(element2.getKey());
                message.append("\" ");
            }
            message.append("at ");
            message.append(this.getElementPositionText(element2));
            message.append(" overlaps element ");
            if (element1.getKey() != null) {
                message.append("\"");
                message.append(element1.getKey());
                message.append("\" ");
            }
            message.append("at ");
            message.append(this.getElementPositionText(element1));
            this.addBrokenRule(message.toString(), (Object)element2);
        }
    }

    protected String getElementPositionText(JRElement element) {
        return "[x = " + element.getX() + ", y = " + element.getY() + ", width = " + element.getWidth() + ", height = " + element.getHeight() + "]";
    }

    protected void verifyElementsOverlap(JRElement[] elements) {
        if (!this.toVerifyElementOverlap()) {
            return;
        }
        for (int index = 1; index < elements.length; ++index) {
            JRElement element = elements[index];
            if (this.isAllowedToOverlap(element)) continue;
            for (int overlapIndex = 0; overlapIndex < index; ++overlapIndex) {
                if (this.isAllowedToOverlap(elements[overlapIndex])) continue;
                this.verifyElementOverlap(elements[overlapIndex], element);
            }
        }
    }

    private void verifySection(JRSection section) {
        JRBand[] bands;
        if (section != null && (bands = section.getBands()) != null && bands.length > 0) {
            for (int i = 0; i < bands.length; ++i) {
                this.verifyBand(bands[i]);
            }
        }
    }

    private void verifyBand(JRBand band) {
        JRElement[] elements;
        if (band != null && (elements = band.getElements()) != null && elements.length > 0) {
            JRExpression expression = band.getPrintWhenExpression();
            if (expression != null) {
                try {
                    Class clazz = expression.getValueClass();
                    if (clazz == null) {
                        this.addBrokenRule("Class not set for band \"print when\" expression.", (Object)expression);
                    } else if (!Boolean.class.isAssignableFrom(clazz)) {
                        this.addBrokenRule("Class " + clazz + " not supported for band \"print when\" expression. Use java.lang.Boolean instead.", (Object)expression);
                    }
                }
                catch (JRRuntimeException e) {
                    this.addBrokenRule(e, (Object)expression);
                }
            }
            for (int index = 0; index < elements.length; ++index) {
                JRElement element = elements[index];
                this.verifyPrintWhenExpr(element);
                if (element.getY() + element.getHeight() > band.getHeight()) {
                    this.addBrokenRule("Warning : Element bottom reaches outside band area : y=" + element.getY() + " height=" + element.getHeight() + " band-height=" + band.getHeight(), (Object)element);
                }
                this.verifyElement(element);
            }
            this.verifyElementsOverlap(elements);
        }
    }

    public void verifyElement(JRElement element) {
        if (element instanceof JRStaticText) {
            this.verifyStaticText((JRStaticText)element);
        } else if (element instanceof JRTextField) {
            this.verifyTextField((JRTextField)element);
        } else if (element instanceof JRImage) {
            this.verifyImage((JRImage)element);
        } else if (element instanceof JRSubreport) {
            this.verifySubreport((JRSubreport)element);
        } else if (element instanceof JRCrosstab) {
            this.verifyCrosstab((JRDesignCrosstab)element);
        } else if (element instanceof JRChart) {
            this.verifyChart((JRChart)element);
        } else if (element instanceof JRFrame) {
            this.verifyFrame((JRFrame)element);
        } else if (element instanceof JRComponentElement) {
            this.verifyComponentElement((JRComponentElement)element);
        } else if (element instanceof JRGenericElement) {
            this.verifyGenericElement((JRGenericElement)element);
        }
    }

    private void verifyPrintWhenExpr(JRElement element) {
        JRExpression expression = element.getPrintWhenExpression();
        if (expression != null) {
            try {
                Class clazz = expression.getValueClass();
                if (clazz == null) {
                    this.addBrokenRule("Class not set for element \"print when\" expression.", (Object)expression);
                } else if (!Boolean.class.isAssignableFrom(clazz)) {
                    this.addBrokenRule("Class " + clazz + " not supported for element \"print when\" expression. Use java.lang.Boolean instead.", (Object)expression);
                }
            }
            catch (JRRuntimeException e) {
                this.addBrokenRule(e, (Object)expression);
            }
        }
    }

    private void verifyStaticText(JRStaticText staticText) {
        this.verifyReportElement(staticText);
        this.verifyFont(staticText);
    }

    private void verifyTextField(JRTextField textField) {
        JRExpression expression;
        this.verifyReportElement(textField);
        this.verifyFont(textField);
        this.verifyAnchor(textField);
        this.verifyHyperlink(textField);
        if (textField != null && (expression = textField.getExpression()) != null) {
            try {
                String className = expression.getValueClassName();
                if (className == null) {
                    this.addBrokenRule("Class not set for text field expression.", (Object)expression);
                } else if (Arrays.binarySearch(JRVerifier.getTextFieldClassNames(), className) < 0) {
                    this.addBrokenRule("Class \"" + className + "\" not supported for text field expression.", (Object)expression);
                }
            }
            catch (JRRuntimeException e) {
                this.addBrokenRule(e, (Object)expression);
            }
        }
    }

    private void verifyFont(JRFont font) {
        Map fontsMap;
        JRReportFont reportFont = font.getReportFont();
        if (reportFont != null && reportFont.getName() != null && !(fontsMap = this.jasperDesign.getFontsMap()).containsKey(reportFont.getName())) {
            this.addBrokenRule("Report font not found : " + reportFont.getName(), (Object)font);
        }
    }

    private void verifyAnchor(JRAnchor anchor) {
        if (anchor != null) {
            JRExpression expression = anchor.getAnchorNameExpression();
            if (expression != null) {
                try {
                    Class clazz = expression.getValueClass();
                    if (clazz == null) {
                        this.addBrokenRule("Class not set for anchor name expression.", (Object)expression);
                    } else if (!String.class.isAssignableFrom(clazz)) {
                        this.addBrokenRule("Class " + clazz + " not supported for anchor name expression. Use java.lang.String instead.", (Object)expression);
                    }
                }
                catch (JRRuntimeException e) {
                    this.addBrokenRule(e, (Object)expression);
                }
            }
            if (anchor.getBookmarkLevel() != 0 && anchor.getBookmarkLevel() < 1) {
                this.addBrokenRule("Bookmark level should be 0 or greater than 0", (Object)anchor);
            }
        }
    }

    public void verifyHyperlink(JRHyperlink hyperlink) {
        if (hyperlink != null) {
            JRHyperlinkParameter[] parameters;
            Class clazz;
            JRExpression expression = hyperlink.getHyperlinkReferenceExpression();
            if (expression != null) {
                try {
                    clazz = expression.getValueClass();
                    if (clazz == null) {
                        this.addBrokenRule("Class not set for hyperlink reference expression.", (Object)expression);
                    } else if (!String.class.isAssignableFrom(clazz)) {
                        this.addBrokenRule("Class " + clazz + " not supported for hyperlink reference expression. Use java.lang.String instead.", (Object)expression);
                    }
                }
                catch (JRRuntimeException e) {
                    this.addBrokenRule(e, (Object)expression);
                }
            }
            if ((expression = hyperlink.getHyperlinkAnchorExpression()) != null) {
                try {
                    clazz = expression.getValueClass();
                    if (clazz == null) {
                        this.addBrokenRule("Class not set for hyperlink anchor expression.", (Object)expression);
                    } else if (!String.class.isAssignableFrom(clazz)) {
                        this.addBrokenRule("Class " + clazz + " not supported for hyperlink anchor expression. Use java.lang.String instead.", (Object)expression);
                    }
                }
                catch (JRRuntimeException e) {
                    this.addBrokenRule(e, (Object)expression);
                }
            }
            if ((expression = hyperlink.getHyperlinkPageExpression()) != null) {
                try {
                    clazz = expression.getValueClass();
                    if (clazz == null) {
                        this.addBrokenRule("Class not set for hyperlink page expression.", (Object)expression);
                    } else if (!Integer.class.isAssignableFrom(clazz)) {
                        this.addBrokenRule("Class " + clazz + " not supported for hyperlink page expression. Use java.lang.Integer instead.", (Object)expression);
                    }
                }
                catch (JRRuntimeException e) {
                    this.addBrokenRule(e, (Object)expression);
                }
            }
            if ((expression = hyperlink.getHyperlinkTooltipExpression()) != null) {
                try {
                    clazz = expression.getValueClass();
                    if (clazz == null) {
                        this.addBrokenRule("Class not set for hyperlink tooltip expression.", (Object)expression);
                    } else if (!String.class.isAssignableFrom(clazz)) {
                        this.addBrokenRule("Class " + clazz + " not supported for hyperlink tooltip expression. Use java.lang.String instead.", (Object)expression);
                    }
                }
                catch (JRRuntimeException e) {
                    this.addBrokenRule(e, (Object)expression);
                }
            }
            if ((parameters = hyperlink.getHyperlinkParameters()) != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    JRHyperlinkParameter parameter = parameters[i];
                    this.verifyHyperlinkParameter(parameter);
                }
            }
        }
    }

    protected void verifyHyperlinkParameter(JRHyperlinkParameter parameter) {
        String name;
        if (parameter != null && ((name = parameter.getName()) == null || name.length() == 0)) {
            this.addBrokenRule("Hyperlink parameter name missing.", (Object)parameter);
        }
    }

    private void verifyImage(JRImage image) {
        JRExpression expression;
        this.verifyReportElement(image);
        this.verifyAnchor(image);
        this.verifyHyperlink(image);
        if (image != null && (expression = image.getExpression()) != null) {
            try {
                String className = expression.getValueClassName();
                if (className == null) {
                    this.addBrokenRule("Class not set for image expression.", (Object)expression);
                } else if (Arrays.binarySearch(JRVerifier.getImageClassNames(), className) < 0) {
                    this.addBrokenRule("Class \"" + className + "\" not supported for image expression.", (Object)expression);
                }
            }
            catch (JRRuntimeException e) {
                this.addBrokenRule(e, (Object)expression);
            }
        }
    }

    private void verifySubreport(JRSubreport subreport) {
        if (subreport != null) {
            JRSubreportReturnValue[] returnValues;
            JRSubreportParameter[] parameters;
            this.verifyReportElement(subreport);
            JRExpression expression = subreport.getExpression();
            if (expression != null) {
                try {
                    String className = expression.getValueClassName();
                    if (className == null) {
                        this.addBrokenRule("Class not set for subreport expression.", (Object)expression);
                    } else if (Arrays.binarySearch(JRVerifier.getSubreportClassNames(), className) < 0) {
                        this.addBrokenRule("Class \"" + className + "\" not supported for subreport expression.", (Object)expression);
                    }
                }
                catch (JRRuntimeException e) {
                    this.addBrokenRule(e, (Object)expression);
                }
            }
            if ((expression = subreport.getParametersMapExpression()) != null) {
                try {
                    Class clazz = expression.getValueClass();
                    if (clazz == null) {
                        this.addBrokenRule("Class not set for subreport parameters map expression.", (Object)expression);
                    } else if (!Map.class.isAssignableFrom(clazz)) {
                        this.addBrokenRule("Class " + clazz + " not supported for subreport parameters map expression. Use java.util.Map instead.", (Object)expression);
                    }
                }
                catch (JRRuntimeException e) {
                    this.addBrokenRule(e, (Object)expression);
                }
            }
            if ((parameters = subreport.getParameters()) != null && parameters.length > 0) {
                for (int index = 0; index < parameters.length; ++index) {
                    JRSubreportParameter parameter = parameters[index];
                    if (parameter.getName() == null || parameter.getName().trim().length() == 0) {
                        this.addBrokenRule("Subreport parameter name missing.", (Object)expression);
                    }
                    if ((expression = parameter.getExpression()) == null) continue;
                    try {
                        Class clazz = expression.getValueClass();
                        if (clazz != null) continue;
                        this.addBrokenRule("Class not set for subreport parameter expression : " + parameter.getName() + ". Use java.lang.Object class.", (Object)expression);
                        continue;
                    }
                    catch (JRRuntimeException e) {
                        this.addBrokenRule(e, (Object)expression);
                    }
                }
            }
            if (subreport.getConnectionExpression() != null && subreport.getDataSourceExpression() != null) {
                this.addBrokenRule("Subreport cannot have both connection expresion and data source expression.", (Object)subreport);
            }
            if ((expression = subreport.getConnectionExpression()) != null) {
                try {
                    Class clazz = expression.getValueClass();
                    if (clazz == null) {
                        this.addBrokenRule("Class not set for subreport connection expression.", (Object)expression);
                    } else if (!Connection.class.isAssignableFrom(clazz)) {
                        this.addBrokenRule("Class " + clazz + " not supported for subreport connection expression. Use java.sql.Connection instead.", (Object)expression);
                    }
                }
                catch (JRRuntimeException e) {
                    this.addBrokenRule(e, (Object)expression);
                }
            }
            if ((expression = subreport.getDataSourceExpression()) != null) {
                try {
                    Class clazz = expression.getValueClass();
                    if (clazz == null) {
                        this.addBrokenRule("Class not set for subreport data source expression.", (Object)expression);
                    } else if (!JRDataSource.class.isAssignableFrom(clazz)) {
                        this.addBrokenRule("Class " + clazz + " not supported for subreport data source expression. Use net.sf.jasperreports.engine.JRDataSource instead.", (Object)expression);
                    }
                }
                catch (JRRuntimeException e) {
                    this.addBrokenRule(e, (Object)expression);
                }
            }
            if ((returnValues = subreport.getReturnValues()) != null && returnValues.length > 0) {
                for (int i = 0; i < returnValues.length; ++i) {
                    JRSubreportReturnValue returnValue = returnValues[i];
                    if (returnValue.getSubreportVariable() == null || returnValue.getSubreportVariable().trim().length() == 0) {
                        this.addBrokenRule("Subreport return value variable name missing.", (Object)returnValue);
                    }
                    if (returnValue.getToVariable() == null || returnValue.getToVariable().trim().length() == 0) {
                        this.addBrokenRule("Subreport return value to variable name missing.", (Object)returnValue);
                    }
                    if (this.jasperDesign.getVariablesMap().containsKey(returnValue.getToVariable())) continue;
                    this.addBrokenRule("Subreport return value to variable not found.", (Object)returnValue);
                }
            }
        }
    }

    private static synchronized String[] getTextFieldClassNames() {
        if (textFieldClassNames == null) {
            textFieldClassNames = new String[]{Boolean.class.getName(), Byte.class.getName(), Date.class.getName(), Timestamp.class.getName(), Time.class.getName(), Double.class.getName(), Float.class.getName(), Integer.class.getName(), Long.class.getName(), Short.class.getName(), BigDecimal.class.getName(), Number.class.getName(), String.class.getName()};
            Arrays.sort(textFieldClassNames);
        }
        return textFieldClassNames;
    }

    private static synchronized String[] getImageClassNames() {
        if (imageClassNames == null) {
            imageClassNames = new String[]{String.class.getName(), File.class.getName(), URL.class.getName(), InputStream.class.getName(), Image.class.getName(), JRRenderable.class.getName()};
            Arrays.sort(imageClassNames);
        }
        return imageClassNames;
    }

    private static synchronized String[] getSubreportClassNames() {
        if (subreportClassNames == null) {
            subreportClassNames = new String[]{String.class.getName(), File.class.getName(), URL.class.getName(), InputStream.class.getName(), JasperReport.class.getName()};
            Arrays.sort(subreportClassNames);
        }
        return subreportClassNames;
    }

    private void verifyCrosstab(JRDesignCrosstab crosstab) {
        this.verifyReportElement(crosstab);
        this.verifyParameters(crosstab);
        JRCrosstabDataset dataset = crosstab.getDataset();
        if (dataset == null) {
            this.addBrokenRule("Crosstab dataset missing.", (Object)crosstab);
        } else {
            this.verifyElementDataset(dataset);
        }
        this.verifyCellContents(crosstab.getHeaderCell(), "crosstab cell");
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        if (rowGroups == null || rowGroups.length == 0) {
            this.addBrokenRule("Crosstab should have at least one row group.", (Object)crosstab);
        } else {
            for (int i = 0; i < rowGroups.length; ++i) {
                this.verifyCrosstabRowGroup(rowGroups[i]);
            }
        }
        JRCrosstabColumnGroup[] colGroups = crosstab.getColumnGroups();
        if (colGroups == null || colGroups.length == 0) {
            this.addBrokenRule("Crosstab should have at least one column group.", (Object)crosstab);
        } else {
            for (int i = 0; i < colGroups.length; ++i) {
                this.verifyCrosstabColumnGroup(colGroups[i]);
            }
        }
        JRCrosstabMeasure[] measures = crosstab.getMeasures();
        if (measures == null || measures.length == 0) {
            this.addBrokenRule("Crosstab should have at least one measure.", (Object)crosstab);
        } else {
            for (int i = 0; i < measures.length; ++i) {
                this.verifyCrosstabMeasure(measures[i]);
            }
        }
        this.verifyCrosstabCells(crosstab);
        this.verifyCellContents(crosstab.getWhenNoDataCell(), "when no data cell");
        this.verifyExpressions(crosstab);
    }

    private void verifyParameters(JRDesignCrosstab crosstab) {
        JRCrosstabParameter[] parameters;
        JRExpression paramMapExpression = crosstab.getParametersMapExpression();
        if (paramMapExpression != null) {
            try {
                Class clazz = paramMapExpression.getValueClass();
                if (clazz == null) {
                    this.addBrokenRule("Class not set for crosstab parameters map expression.", (Object)paramMapExpression);
                } else if (!Map.class.isAssignableFrom(clazz)) {
                    this.addBrokenRule("Class " + clazz + " not supported for crosstab parameters map expression. Use java.util.Map instead.", (Object)paramMapExpression);
                }
            }
            catch (JRRuntimeException e) {
                this.addBrokenRule(e, (Object)paramMapExpression);
            }
        }
        if ((parameters = crosstab.getParameters()) != null) {
            for (int i = 0; i < parameters.length; ++i) {
                JRCrosstabParameter parameter = parameters[i];
                String paramName = parameter.getName();
                if (paramName == null || paramName.length() == 0) {
                    this.addBrokenRule("Missing parameter name for crosstab.", (Object)parameter);
                }
                JRExpression expression = parameter.getExpression();
                Class expressionClass = null;
                if (expression != null) {
                    try {
                        expressionClass = expression.getValueClass();
                        if (expressionClass == null) {
                            this.addBrokenRule("Expression class not set for crosstab parameter " + paramName + ".", (Object)expression);
                        }
                    }
                    catch (JRRuntimeException e) {
                        this.addBrokenRule(e, (Object)expression);
                    }
                }
                try {
                    Class valueClass = parameter.getValueClass();
                    if (valueClass == null) {
                        this.addBrokenRule("Class not set for crosstab parameter " + paramName + ".", (Object)parameter);
                        continue;
                    }
                    if (expressionClass == null || valueClass.isAssignableFrom(expressionClass)) continue;
                    this.addBrokenRule("Incompatible expression class for crosstab parameter " + paramName + ".", (Object)parameter);
                    continue;
                }
                catch (Exception e) {
                    this.addBrokenRule(e, (Object)parameter);
                }
            }
        }
    }

    private void verifyCrosstabRowGroup(JRCrosstabRowGroup group) {
        this.verifyCrosstabGroup(group);
    }

    private void verifyCrosstabColumnGroup(JRCrosstabColumnGroup group) {
        this.verifyCrosstabGroup(group);
    }

    private void verifyCrosstabGroup(JRCrosstabGroup group) {
        String groupName = group.getName();
        if (groupName == null || groupName.length() == 0) {
            this.addBrokenRule("Crosstab group name missing.", (Object)group);
        }
        this.verifyCrosstabBucket(group);
        this.verifyCellContents(group.getHeader(), groupName + " header");
        if (group.hasTotal()) {
            this.verifyCellContents(group.getTotalHeader(), groupName + " total header");
        }
    }

    private void verifyCrosstabBucket(JRCrosstabGroup group) {
        block17: {
            JRCrosstabBucket bucket = group.getBucket();
            JRExpression expression = bucket.getExpression();
            Class expressionClass = null;
            if (expression == null) {
                this.addBrokenRule("Crosstab bucket expression missing for group " + group.getName() + ".", (Object)bucket);
            } else {
                try {
                    expressionClass = expression.getValueClass();
                    if (expressionClass == null) {
                        this.addBrokenRule("Crosstab bucket expression class missing for group " + group.getName() + ".", (Object)expression);
                    }
                }
                catch (JRRuntimeException e) {
                    this.addBrokenRule(e, (Object)expression);
                }
            }
            try {
                Class valueClass;
                Class clazz = valueClass = expression == null ? null : expression.getValueClass();
                if (valueClass == null) {
                    this.addBrokenRule("Crosstab bucket value class missing for group " + group.getName() + ".", (Object)bucket);
                } else if (expressionClass != null && !valueClass.isAssignableFrom(expressionClass)) {
                    this.addBrokenRule("The class of the expression is not compatible with the class of the crosstab bucket for group " + group.getName() + ".", (Object)expression);
                }
                JRExpression comparatorExpression = bucket.getComparatorExpression();
                if (comparatorExpression == null) {
                    if (valueClass != null && !Comparable.class.isAssignableFrom(valueClass)) {
                        this.addBrokenRule("No comparator expression specified and the value class is not comparable for crosstab group " + group.getName() + ".", (Object)bucket);
                    }
                    break block17;
                }
                try {
                    Class comparatorClass = comparatorExpression.getValueClass();
                    if (comparatorClass == null) {
                        this.addBrokenRule("Crosstab bucket comparator expression class missing for group " + group.getName() + ".", (Object)comparatorExpression);
                    } else if (!Comparator.class.isAssignableFrom(comparatorClass)) {
                        this.addBrokenRule("The comparator expression should be compatible with java.util.Comparator for crosstab group " + group.getName() + ".", (Object)comparatorExpression);
                    }
                }
                catch (JRRuntimeException e) {
                    this.addBrokenRule(e, (Object)comparatorExpression);
                }
            }
            catch (JRRuntimeException e) {
                this.addBrokenRule(e, (Object)expression);
            }
        }
    }

    private void verifyCrosstabCells(JRDesignCrosstab crosstab) {
        JRCrosstabColumnGroup[] columnGroups;
        JRCrosstabRowGroup[] rowGroups;
        JRCrosstabCell[][] cells = crosstab.getCells();
        JRCrosstabCell baseCell = cells[(rowGroups = crosstab.getRowGroups()).length][(columnGroups = crosstab.getColumnGroups()).length];
        if (baseCell == null || baseCell.getWidth() == null) {
            this.addBrokenRule("Crosstab base cell width not specified.", (Object)crosstab);
        }
        if (baseCell == null || baseCell.getHeight() == null) {
            this.addBrokenRule("Crosstab base cell height not specified.", (Object)crosstab);
        }
        for (int i = rowGroups.length; i >= 0; --i) {
            for (int j = columnGroups.length; j >= 0; --j) {
                JRCrosstabCell rowCell;
                JRCrosstabCell colCell;
                JRCrosstabCell cell = cells[i][j];
                String cellText = this.getCrosstabCellText(rowGroups, columnGroups, i, j);
                if (cell == null) continue;
                JRCellContents contents = cell.getContents();
                if (i < rowGroups.length && (colCell = cells[rowGroups.length][j]) != null && colCell.getContents().getWidth() != contents.getWidth()) {
                    this.addBrokenRule("Crosstab " + cellText + " width should be " + colCell.getContents().getWidth() + ".", (Object)cell);
                }
                if (j < columnGroups.length && (rowCell = cells[i][columnGroups.length]) != null && rowCell.getContents().getHeight() != contents.getHeight()) {
                    this.addBrokenRule("Crosstab " + cellText + " height should be " + rowCell.getContents().getHeight() + ".", (Object)cell);
                }
                this.verifyCellContents(contents, cellText);
            }
        }
    }

    private String getCrosstabCellText(JRCrosstabRowGroup[] rowGroups, JRCrosstabColumnGroup[] columnGroups, int rowIndex, int columnIndex) {
        String text = rowIndex == rowGroups.length ? (columnIndex == columnGroups.length ? "cell" : columnGroups[columnIndex].getName() + " total cell") : (columnIndex == columnGroups.length ? rowGroups[rowIndex].getName() + " total cell" : rowGroups[rowIndex].getName() + "," + columnGroups[columnIndex].getName() + " total cell");
        return text;
    }

    private void verifyCrosstabMeasure(JRCrosstabMeasure measure) {
        byte calculation;
        String measureName = measure.getName();
        if (measureName == null || measureName.trim().length() == 0) {
            this.addBrokenRule("Measure name missing.", (Object)measure);
        }
        if ((calculation = measure.getCalculation()) == 8) {
            this.addBrokenRule("Crosstab mesures cannot have system calculation", (Object)measure);
        }
        JRExpression valueExpression = measure.getValueExpression();
        Class expressionClass = null;
        if (valueExpression == null) {
            this.addBrokenRule("Missing expression for measure " + measureName, (Object)measure);
        } else {
            try {
                expressionClass = valueExpression.getValueClass();
                if (expressionClass == null) {
                    this.addBrokenRule("Crosstab measure expression class missing for " + measureName + ".", (Object)valueExpression);
                }
            }
            catch (JRRuntimeException e) {
                this.addBrokenRule(e, (Object)valueExpression);
            }
        }
        try {
            Class valueClass = measure.getValueClass();
            if (valueClass == null) {
                this.addBrokenRule("Measure value class missing.", (Object)measure);
            } else if (expressionClass != null && calculation != 1 && calculation != 10 && !valueClass.isAssignableFrom(expressionClass)) {
                this.addBrokenRule("The class of the expression is not compatible with the class of the measure " + measureName + ".", (Object)valueExpression);
            }
            if (measure.getPercentageOfType() != 0) {
                Class percentageCalculatorClass = measure.getPercentageCalculatorClass();
                if (percentageCalculatorClass == null) {
                    if (valueClass != null && !JRPercentageCalculatorFactory.hasBuiltInCalculator(valueClass)) {
                        this.addBrokenRule("Percentage calculator class needs to be specified for measure " + measureName + ".", (Object)measure);
                    }
                } else if (!JRPercentageCalculator.class.isAssignableFrom(percentageCalculatorClass)) {
                    this.addBrokenRule("Incompatible percentage calculator class for measure " + measureName + ".", (Object)measure);
                }
            }
        }
        catch (JRRuntimeException e) {
            this.addBrokenRule(e, (Object)measure);
        }
        try {
            Class incrementerFactoryClass = measure.getIncrementerFactoryClass();
            if (incrementerFactoryClass != null && !JRExtendedIncrementerFactory.class.isAssignableFrom(incrementerFactoryClass)) {
                this.addBrokenRule("Crosstab measures need extended incrementers (net.sf.jasperreports.engine.fill.JRExtendedIncrementerFactory).", (Object)measure);
            }
        }
        catch (JRRuntimeException e) {
            this.addBrokenRule(e, (Object)measure);
        }
    }

    private void verifyExpressions(JRDesignCrosstab crosstab) {
        this.verifyExpressions(this.expressionCollector.getExpressions(crosstab), crosstab.getParametersMap(), new HashMap(), crosstab.getVariablesMap());
    }

    private void verifyChart(JRChart chart) {
        JRChartDataset dataset;
        this.verifyReportElement(chart);
        if (chart.getEvaluationTime() == 7) {
            this.addBrokenRule("Charts do not support Auto evaluation time.", (Object)chart);
        }
        if ((dataset = chart.getDataset()) == null) {
            this.addBrokenRule("Chart dataset missing.", (Object)chart);
        } else {
            dataset.validate(this);
        }
    }

    private void verifyCellContents(JRCellContents contents, String cellText) {
        JRElement[] elements;
        if (contents != null && (elements = contents.getElements()) != null && elements.length > 0) {
            int cellWidth;
            int topPadding = 0;
            int leftPadding = 0;
            int bottomPadding = 0;
            int rightPadding = 0;
            JRLineBox box = contents.getLineBox();
            if (box != null) {
                topPadding = box.getTopPadding();
                leftPadding = box.getLeftPadding();
                bottomPadding = box.getBottomPadding();
                rightPadding = box.getRightPadding();
            }
            boolean widthCalculated = (cellWidth = contents.getWidth()) != Integer.MIN_VALUE;
            int avlblWidth = cellWidth - leftPadding - rightPadding;
            int cellHeight = contents.getHeight();
            boolean heightCalculated = cellHeight != Integer.MIN_VALUE;
            int avlblHeight = cellHeight - topPadding - bottomPadding;
            for (int i = 0; i < elements.length; ++i) {
                JRElement element = elements[i];
                this.verifyPrintWhenExpr(element);
                if (widthCalculated && element.getX() + element.getWidth() > avlblWidth) {
                    this.addBrokenRule("Element reaches outside " + cellText + " width: x=" + element.getX() + ", width=" + element.getWidth() + ", available width=" + avlblWidth + ".", (Object)element);
                }
                if (heightCalculated && element.getY() + element.getHeight() > avlblHeight) {
                    this.addBrokenRule("Element reaches outside " + cellText + " height: y=" + element.getY() + ", height=" + element.getHeight() + ", available height=" + avlblHeight + ".", (Object)element);
                }
                if (element instanceof JRStaticText) {
                    this.verifyStaticText((JRStaticText)element);
                    continue;
                }
                if (element instanceof JRTextField) {
                    JRTextField textField = (JRTextField)element;
                    if (textField.getEvaluationTime() != 1) {
                        this.addBrokenRule("Elements with delayed evaluation time are not supported inside crosstab cells.", (Object)textField);
                    }
                    this.verifyTextField(textField);
                    continue;
                }
                if (element instanceof JRImage) {
                    JRImage image = (JRImage)element;
                    if (image.getEvaluationTime() != 1) {
                        this.addBrokenRule("Elements with delayed evaluation time are not supported inside crosstab cells.", (Object)image);
                    }
                    this.verifyImage(image);
                    continue;
                }
                if (element instanceof JRFrame) {
                    this.verifyFrame((JRFrame)element);
                    continue;
                }
                if (element instanceof JRSubreport) {
                    this.addBrokenRule("Subreports are not allowed inside crosstab cells.", (Object)element);
                    continue;
                }
                if (element instanceof JRCrosstab) {
                    this.addBrokenRule("Crosstabs are not allowed inside crosstab cells.", (Object)element);
                    continue;
                }
                if (!(element instanceof JRChart)) continue;
                this.addBrokenRule("Charts are not allowed inside crosstab cells.", (Object)element);
            }
            this.verifyElementsOverlap(elements);
        }
    }

    public void verifyElementDataset(JRElementDataset dataset) {
        JRExpression incrementWhenExpression;
        JRDatasetRun datasetRun = dataset.getDatasetRun();
        if (datasetRun != null) {
            byte resetType;
            byte incrementType = dataset.getIncrementType();
            if (incrementType == 2 || incrementType == 3) {
                this.addBrokenRule("Chart datasets with dataset run cannont have Column or Page increment type.", (Object)dataset);
            }
            if ((resetType = dataset.getResetType()) == 2 || resetType == 3) {
                this.addBrokenRule("Chart datasets with dataset run cannont have Column or Page reset type.", (Object)dataset);
            } else if (resetType != 1) {
                // empty if block
            }
            this.verifyDatasetRun(datasetRun);
        }
        if ((incrementWhenExpression = dataset.getIncrementWhenExpression()) != null) {
            try {
                Class valueClass = incrementWhenExpression.getValueClass();
                if (valueClass == null) {
                    this.addBrokenRule("Class not set for data set \"increment when\" expression.", (Object)incrementWhenExpression);
                } else if (!Boolean.class.isAssignableFrom(valueClass)) {
                    this.addBrokenRule("Class " + valueClass + " not supported for dataset \"increment when\" expression. Use java.lang.Boolean instead.", (Object)incrementWhenExpression);
                }
            }
            catch (JRRuntimeException e) {
                this.addBrokenRule(e, (Object)incrementWhenExpression);
            }
        }
    }

    public void verifyDatasetRun(JRDatasetRun datasetRun) {
        Class clazz;
        JRDatasetParameter[] parameters;
        JRDesignDataset dataset = null;
        String datasetName = datasetRun.getDatasetName();
        if (datasetName == null || datasetName.length() == 0) {
            this.addBrokenRule("Dataset name is missing for dataset run.", (Object)datasetRun);
        } else {
            dataset = (JRDesignDataset)this.jasperDesign.getDatasetMap().get(datasetName);
            if (dataset == null) {
                this.addBrokenRule("Unknown dataset name " + datasetName + ".", (Object)datasetRun);
            }
        }
        JRExpression parametersMapExpression = datasetRun.getParametersMapExpression();
        if (parametersMapExpression != null) {
            try {
                Class clazz2 = parametersMapExpression.getValueClass();
                if (clazz2 == null) {
                    this.addBrokenRule("Class not set for dataset " + datasetName + " parameters map expression.", (Object)parametersMapExpression);
                } else if (!Map.class.isAssignableFrom(clazz2)) {
                    this.addBrokenRule("Class " + clazz2 + " not supported for dataset " + datasetName + " parameters map expression. Use java.util.Map instead.", (Object)parametersMapExpression);
                }
            }
            catch (JRRuntimeException e) {
                this.addBrokenRule(e, (Object)parametersMapExpression);
            }
        }
        if ((parameters = datasetRun.getParameters()) != null && parameters.length > 0) {
            for (int index = 0; index < parameters.length; ++index) {
                JRExpression expression;
                JRDatasetParameter parameter = parameters[index];
                String paramName = parameter.getName();
                if (paramName == null || paramName.trim().length() == 0) {
                    this.addBrokenRule("Dataset " + datasetName + " parameter name missing.", (Object)parameter);
                }
                JRParameter datasetParam = null;
                if (dataset != null && (datasetParam = (JRParameter)dataset.getParametersMap().get(paramName)) == null) {
                    this.addBrokenRule("Unknown parameter " + paramName + " in dataset " + datasetName + ".", (Object)parameter);
                }
                if ((expression = parameter.getExpression()) == null) continue;
                try {
                    Class clazz3 = expression.getValueClass();
                    if (clazz3 == null) {
                        this.addBrokenRule("Class not set for dataset " + datasetName + " parameter expression : " + paramName + ".", (Object)expression);
                        continue;
                    }
                    if (datasetParam == null || datasetParam.getValueClass().isAssignableFrom(clazz3)) continue;
                    this.addBrokenRule("Class " + clazz3 + " not supported for parameter " + paramName + " of dataset " + datasetName + ". Use " + datasetParam.getValueClass() + " instead.", (Object)expression);
                    continue;
                }
                catch (JRRuntimeException e) {
                    this.addBrokenRule(e, (Object)expression);
                }
            }
        }
        JRExpression connectionExpression = datasetRun.getConnectionExpression();
        JRExpression dataSourceExpression = datasetRun.getDataSourceExpression();
        if (connectionExpression != null && dataSourceExpression != null) {
            this.addBrokenRule("Dataset " + datasetName + " cannot have both connection expresion and data source expression.", (Object)datasetRun);
        }
        if (connectionExpression != null) {
            try {
                clazz = connectionExpression.getValueClass();
                if (clazz == null) {
                    this.addBrokenRule("Class not set for dataset " + datasetName + " connection expression.", (Object)connectionExpression);
                } else if (!Connection.class.isAssignableFrom(clazz)) {
                    this.addBrokenRule("Class " + clazz + " not supported for dataset " + datasetName + " connection expression. Use java.sql.Connection instead.", (Object)connectionExpression);
                }
            }
            catch (JRRuntimeException e) {
                this.addBrokenRule(e, (Object)connectionExpression);
            }
        }
        if (dataSourceExpression != null) {
            try {
                clazz = dataSourceExpression.getValueClass();
                if (clazz == null) {
                    this.addBrokenRule("Class not set for dataset " + datasetName + " data source expression.", (Object)dataSourceExpression);
                } else if (!JRDataSource.class.isAssignableFrom(clazz)) {
                    this.addBrokenRule("Class " + clazz + " not supported for dataset " + datasetName + " data source expression. Use net.sf.jasperreports.engine.JRDataSource instead.", (Object)dataSourceExpression);
                }
            }
            catch (JRRuntimeException e) {
                this.addBrokenRule(e, (Object)dataSourceExpression);
            }
        }
    }

    private void verifyDatasets() {
        JRDataset[] datasets = this.jasperDesign.getDatasets();
        if (datasets != null && datasets.length > 0) {
            for (int i = 0; i < datasets.length; ++i) {
                JRDesignDataset dataset = (JRDesignDataset)datasets[i];
                if (dataset.getName() == null || dataset.getName().trim().length() == 0) {
                    this.addBrokenRule("Dataset name is missing.", (Object)dataset);
                }
                this.verifyDataset(dataset);
            }
        }
    }

    private void verifyDataset(JRDesignDataset dataset) {
        this.verifyExpressions(dataset);
        this.verifyParameters(dataset);
        this.verifyQuery(dataset);
        this.verifyFields(dataset);
        this.verifySortFields(dataset);
        this.verifyVariables(dataset);
        this.verifyGroups(dataset);
        JRExpression filterExpression = dataset.getFilterExpression();
        if (filterExpression != null) {
            try {
                Class valueClass = filterExpression.getValueClass();
                if (valueClass == null) {
                    this.addBrokenRule("Class not set for filter expression.", (Object)filterExpression);
                } else if (!Boolean.class.isAssignableFrom(valueClass)) {
                    this.addBrokenRule("Class " + valueClass + " not supported for filter expression. Use java.lang.Boolean instead.", (Object)filterExpression);
                }
            }
            catch (JRRuntimeException e) {
                this.addBrokenRule(e, (Object)filterExpression);
            }
        }
    }

    private void verifyFrame(JRFrame frame) {
        this.verifyReportElement(frame);
        JRElement[] elements = frame.getElements();
        if (elements != null && elements.length > 0) {
            int topPadding = frame.getLineBox().getTopPadding();
            int leftPadding = frame.getLineBox().getLeftPadding();
            int bottomPadding = frame.getLineBox().getBottomPadding();
            int rightPadding = frame.getLineBox().getRightPadding();
            int avlblWidth = frame.getWidth() - leftPadding - rightPadding;
            int avlblHeight = frame.getHeight() - topPadding - bottomPadding;
            for (int i = 0; i < elements.length; ++i) {
                JRElement element = elements[i];
                if (element.getX() + element.getWidth() > avlblWidth) {
                    this.addBrokenRule("Element reaches outside frame width: x=" + element.getX() + ", width=" + element.getWidth() + ", available width=" + avlblWidth + ".", (Object)element);
                }
                if (element.getY() + element.getHeight() > avlblHeight) {
                    this.addBrokenRule("Element reaches outside frame height: y=" + element.getY() + ", height=" + element.getHeight() + ", available height=" + avlblHeight + ".", (Object)element);
                }
                this.verifyElement(element);
            }
            this.verifyElementsOverlap(elements);
        }
    }

    public void verify(JRCategoryDataset dataset) {
        this.verifyElementDataset(dataset);
        JRCategorySeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    protected void verify(JRCategorySeries series) {
        this.verifyHyperlink(series.getItemHyperlink());
    }

    public void verify(JRPieDataset dataset) {
        this.verifyElementDataset(dataset);
        JRPieSeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
        this.verifyHyperlink(dataset.getOtherSectionHyperlink());
    }

    protected void verify(JRPieSeries series) {
        this.verifyHyperlink(series.getSectionHyperlink());
    }

    public void verify(JRHighLowDataset dataset) {
        this.verifyElementDataset(dataset);
        this.verifyHyperlink(dataset.getItemHyperlink());
    }

    public void verify(JRTimePeriodDataset dataset) {
        this.verifyElementDataset(dataset);
        JRTimePeriodSeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    protected void verify(JRTimePeriodSeries series) {
        this.verifyHyperlink(series.getItemHyperlink());
    }

    public void verify(JRTimeSeriesDataset dataset) {
        this.verifyElementDataset(dataset);
        JRTimeSeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    protected void verify(JRTimeSeries series) {
        this.verifyHyperlink(series.getItemHyperlink());
    }

    public void verify(JRValueDataset dataset) {
    }

    public void verify(JRXyDataset dataset) {
        this.verifyElementDataset(dataset);
        JRXySeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    protected void verify(JRXySeries series) {
        this.verifyHyperlink(series.getItemHyperlink());
    }

    protected void verify(JRGanttSeries series) {
        this.verifyHyperlink(series.getItemHyperlink());
    }

    public void verify(JRXyzDataset dataset) {
        this.verifyElementDataset(dataset);
        JRXyzSeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    public void verify(JRGanttDataset dataset) {
        this.verifyElementDataset(dataset);
        JRGanttSeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    protected void verify(JRXyzSeries series) {
        this.verifyHyperlink(series.getItemHyperlink());
    }

    protected void verifyReportElement(JRElement element) {
        this.verifyProperyExpressions(element.getPropertyExpressions());
    }

    protected void verifyProperyExpressions(JRPropertyExpression[] propertyExpressions) {
        if (propertyExpressions != null) {
            for (int i = 0; i < propertyExpressions.length; ++i) {
                this.verifyPropertyExpression(propertyExpressions[i]);
            }
        }
    }

    protected void verifyPropertyExpression(JRPropertyExpression propertyExpression) {
        JRExpression expr;
        String name = propertyExpression.getName();
        if (name == null) {
            this.addBrokenRule("Property name missing.", (Object)propertyExpression);
        }
        if ((expr = propertyExpression.getValueExpression()) == null) {
            this.addBrokenRule("Property value expression missing.", (Object)propertyExpression);
        } else {
            String valueExprClassName = expr.getValueClassName();
            if (valueExprClassName == null) {
                this.addBrokenRule("Class not set for property value expression.", (Object)expr);
            } else if (!String.class.getName().equals(valueExprClassName)) {
                this.addBrokenRule("Class " + valueExprClassName + " not supported for anchor name expression. Use java.lang.String instead.", (Object)expr);
            }
        }
    }

    protected void verifyComponentElement(JRComponentElement element) {
        Component component;
        this.verifyReportElement(element);
        ComponentKey componentKey = element.getComponentKey();
        if (componentKey == null) {
            this.addBrokenRule("No component key set for component element", (Object)element);
        }
        if ((component = element.getComponent()) == null) {
            this.addBrokenRule("No component set for component element", (Object)element);
        }
        if (componentKey != null && component != null) {
            ComponentCompiler compiler = ComponentsEnvironment.getComponentManager(componentKey).getComponentCompiler();
            compiler.verify(component, this);
        }
    }

    protected void verifyGenericElement(JRGenericElement element) {
        JRGenericElementType type;
        this.verifyReportElement(element);
        if (element.getEvaluationTime() == 5) {
            String groupName = element.getEvaluationGroupName();
            if (groupName == null) {
                this.addBrokenRule("Evaluation group not set for generic element", (Object)element);
            } else if (!this.jasperDesign.getGroupsMap().containsKey(groupName)) {
                this.addBrokenRule("Generic element evaluation group " + groupName + " not found in report", (Object)element);
            }
        }
        if ((type = element.getGenericType()) == null) {
            this.addBrokenRule("No type set for generic element", (Object)element);
        } else {
            if (type.getNamespace() == null) {
                this.addBrokenRule("No namespace set for generic element type", (Object)type);
            }
            if (type.getName() == null) {
                this.addBrokenRule("No name set for generic element type", (Object)type);
            }
        }
        JRGenericElementParameter[] parameters = element.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            JRGenericElementParameter parameter = parameters[i];
            if (parameter.getName() != null) continue;
            this.addBrokenRule("No name set for generic element parameter", (Object)parameter);
        }
    }

    private static int getBreakHeight(JRBand band) {
        int breakHeight = 0;
        if (band != null) {
            breakHeight = band.getHeight();
            JRElement[] elements = band.getElements();
            if (JRBand.SPLIT_TYPE_IMMEDIATE.equals(band.getSplitType()) && elements != null && elements.length > 0) {
                for (int i = 0; i < elements.length; ++i) {
                    JRElement element = elements[i];
                    int bottom = element.getY() + element.getHeight();
                    breakHeight = bottom < breakHeight ? bottom : breakHeight;
                }
            }
        }
        return breakHeight;
    }

    public void verifyExpression(JRExpression expression, Object parent, String mandatoryMessage, String noTypeSetMessage, Class expectedType, String invalidTypeMessage) {
        if (expression == null) {
            if (mandatoryMessage != null) {
                this.addBrokenRule(mandatoryMessage, parent);
            }
        } else {
            try {
                Class type = expression.getValueClass();
                if (type == null) {
                    this.addBrokenRule(noTypeSetMessage, (Object)expression);
                } else if (expectedType != null && !expectedType.isAssignableFrom(type)) {
                    String message = MessageFormat.format(invalidTypeMessage, type.getName());
                    this.addBrokenRule(message, (Object)expression);
                }
            }
            catch (JRRuntimeException e) {
                this.addBrokenRule(e, (Object)expression);
            }
        }
    }
}

