/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * QuickStartPanel.java
 *
 * Created on 13-mar-2009, 0.28.42
 */

package com.jaspersoft.ireport.designer.welcome;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.gui.ConnectionDialog;
import com.jaspersoft.ireport.designer.templates.TemplatesFrame;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.wizards.CustomTemplateWizard;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.io.File;
import javax.swing.JOptionPane;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

/**
 *
 * @author gtoffoli
 */
public class QuickStartPanel extends javax.swing.JPanel {


    /** Creates new form QuickStartPanel */
    public QuickStartPanel() {
        initComponents();

        jLabel1.setText(I18n.getString("welcome.quickstart.msg"));

        jButton1.setCursor( Cursor.getPredefinedCursor(Cursor.HAND_CURSOR) );
        jButton2.setCursor( Cursor.getPredefinedCursor(Cursor.HAND_CURSOR) );
        jLabelStep1.setText(I18n.getString("welcome.quickstart.step1"));
        jLabelStep2.setText(I18n.getString("welcome.quickstart.step2"));
        jLabelStep3.setText(I18n.getString("welcome.quickstart.step3"));

        ((TextLabel)jLabelStep1).setMaxWidth(150);
        ((TextLabel)jLabelStep2).setMaxWidth(150);
        ((TextLabel)jLabelStep3).setMaxWidth(150);

        updateUI();
        doLayout();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();
        jLabelStep1 = new TextLabel();
        jButton2 = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        graySeparator1 = new com.jaspersoft.ireport.designer.welcome.GraySeparator();
        graySeparator2 = new com.jaspersoft.ireport.designer.welcome.GraySeparator();
        jLabelStep2 = new TextLabel();
        jLabelStep3 = new TextLabel();

        setBackground(new java.awt.Color(255, 255, 255));
        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText(org.openide.util.NbBundle.getMessage(QuickStartPanel.class, "QuickStartPanel.jLabel1.text")); // NOI18N
        jLabel1.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 0);
        add(jLabel1, gridBagConstraints);

        jButton1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/designer/resources/welcome/database1.png"))); // NOI18N
        jButton1.setText(org.openide.util.NbBundle.getMessage(QuickStartPanel.class, "QuickStartPanel.jButton1.text")); // NOI18N
        jButton1.setBorder(null);
        jButton1.setBorderPainted(false);
        jButton1.setFocusPainted(false);
        jButton1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButton1.setRequestFocusEnabled(false);
        jButton1.setRolloverIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/designer/resources/welcome/database2.png"))); // NOI18N
        jButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jButton1MouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jButton1MouseExited(evt);
            }
        });
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jButton1, gridBagConstraints);

        jLabelStep1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelStep1.setText(org.openide.util.NbBundle.getMessage(QuickStartPanel.class, "QuickStartPanel.jLabelStep2.text")); // NOI18N
        jLabelStep1.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jLabelStep1.setMaximumSize(new java.awt.Dimension(100, 20000));
        jLabelStep1.setMinimumSize(new java.awt.Dimension(100, 14));
        jLabelStep1.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(jLabelStep1, gridBagConstraints);

        jButton2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/designer/resources/welcome/design1.png"))); // NOI18N
        jButton2.setText(org.openide.util.NbBundle.getMessage(QuickStartPanel.class, "QuickStartPanel.jButton2.text")); // NOI18N
        jButton2.setBorder(null);
        jButton2.setBorderPainted(false);
        jButton2.setFocusPainted(false);
        jButton2.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButton2.setRequestFocusEnabled(false);
        jButton2.setRolloverIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/designer/resources/welcome/design2.png"))); // NOI18N
        jButton2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jButton2MouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jButton2MouseExited(evt);
            }
        });
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jButton2, gridBagConstraints);

        jButton3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/designer/resources/welcome/preview1.png"))); // NOI18N
        jButton3.setText(org.openide.util.NbBundle.getMessage(QuickStartPanel.class, "QuickStartPanel.jButton3.text")); // NOI18N
        jButton3.setBorder(null);
        jButton3.setBorderPainted(false);
        jButton3.setFocusPainted(false);
        jButton3.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButton3.setRequestFocusEnabled(false);
        jButton3.setRolloverIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/designer/resources/welcome/preview2.png"))); // NOI18N
        jButton3.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jButton3MouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jButton3MouseExited(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jButton3, gridBagConstraints);

        graySeparator1.setMinimumSize(new java.awt.Dimension(27, 27));
        graySeparator1.setPreferredSize(new java.awt.Dimension(27, 27));

        org.jdesktop.layout.GroupLayout graySeparator1Layout = new org.jdesktop.layout.GroupLayout(graySeparator1);
        graySeparator1.setLayout(graySeparator1Layout);
        graySeparator1Layout.setHorizontalGroup(
            graySeparator1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 27, Short.MAX_VALUE)
        );
        graySeparator1Layout.setVerticalGroup(
            graySeparator1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 121, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        add(graySeparator1, gridBagConstraints);

        graySeparator2.setMinimumSize(new java.awt.Dimension(27, 27));
        graySeparator2.setPreferredSize(new java.awt.Dimension(27, 27));

        org.jdesktop.layout.GroupLayout graySeparator2Layout = new org.jdesktop.layout.GroupLayout(graySeparator2);
        graySeparator2.setLayout(graySeparator2Layout);
        graySeparator2Layout.setHorizontalGroup(
            graySeparator2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 27, Short.MAX_VALUE)
        );
        graySeparator2Layout.setVerticalGroup(
            graySeparator2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 121, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        add(graySeparator2, gridBagConstraints);

        jLabelStep2.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelStep2.setText(org.openide.util.NbBundle.getMessage(QuickStartPanel.class, "QuickStartPanel.jLabelStep2.text")); // NOI18N
        jLabelStep2.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jLabelStep2.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(jLabelStep2, gridBagConstraints);

        jLabelStep3.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelStep3.setText(org.openide.util.NbBundle.getMessage(QuickStartPanel.class, "QuickStartPanel.jLabelStep2.text")); // NOI18N
        jLabelStep3.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jLabelStep3.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(jLabelStep3, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1MouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton1MouseEntered
        
    }//GEN-LAST:event_jButton1MouseEntered

    private void jButton1MouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton1MouseExited

    }//GEN-LAST:event_jButton1MouseExited

    private void jButton2MouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton2MouseEntered

    }//GEN-LAST:event_jButton2MouseEntered

    private void jButton2MouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton2MouseExited

    }//GEN-LAST:event_jButton2MouseExited

    private void jButton3MouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton3MouseEntered

    }//GEN-LAST:event_jButton3MouseEntered

    private void jButton3MouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton3MouseExited

    }//GEN-LAST:event_jButton3MouseExited

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        ConnectionDialog cd = new ConnectionDialog(Misc.getMainFrame(),true);
        cd.setVisible(true);

        if (cd.getDialogResult() == JOptionPane.OK_OPTION)
        {
            IReportConnection con = cd.getIReportConnection();
            IReportManager.getInstance().addConnection(con);
            IReportManager.getInstance().setDefaultConnection(con);
            IReportManager.getInstance().saveiReportConfiguration();
        }
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed

        /*

        CustomTemplateWizard wizardDescriptor = new CustomTemplateWizard();

            //wizardDescriptor.putProperty("useCustomChooserPanel", "true");
            File targetFolder = Misc.findStartingDirectory();
            DataFolder df = DataFolder.findFolder(FileUtil.toFileObject(targetFolder));
            wizardDescriptor.setTargetFolder(df);


            try {
            FileObject templateFileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("Templates/Report/Report");
            wizardDescriptor.setTemplate(DataObject.find(templateFileObject));
            } catch (DataObjectNotFoundException ex) {
            }

            wizardDescriptor.setTargetName("report.jrxml"); // NOI18N

            Dialog dialog = DialogDisplayer.getDefault().createDialog(wizardDescriptor);
            dialog.setVisible(true);
            dialog.toFront();
        */
        TemplatesFrame td = new TemplatesFrame(Misc.getMainFrame(), true);
        td.setVisible(true);
    }//GEN-LAST:event_jButton2ActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private com.jaspersoft.ireport.designer.welcome.GraySeparator graySeparator1;
    private com.jaspersoft.ireport.designer.welcome.GraySeparator graySeparator2;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabelStep1;
    private javax.swing.JLabel jLabelStep2;
    private javax.swing.JLabel jLabelStep3;
    // End of variables declaration//GEN-END:variables

}
