/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleListCalc;
import mondrian.calc.impl.AbstractCalc;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.type.SetType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTupleListCalc
extends AbstractCalc
implements TupleListCalc {
    private final Calc[] calcs;
    private final boolean mutable;

    protected AbstractTupleListCalc(Exp exp, Calc[] calcs) {
        this(exp, calcs, true);
    }

    protected AbstractTupleListCalc(Exp exp, Calc[] calcs, boolean mutable) {
        super(exp);
        this.calcs = calcs;
        this.mutable = mutable;
        assert (this.type instanceof SetType) : "expecting a set: " + this.getType();
        assert (this.getType().getArity() > 1);
    }

    @Override
    public SetType getType() {
        return (SetType)super.getType();
    }

    @Override
    public final Object evaluate(Evaluator evaluator) {
        List<Member[]> tupleList = this.evaluateTupleList(evaluator);
        assert (tupleList != null) : "null as empty tuple list is deprecated";
        return tupleList;
    }

    @Override
    public Calc[] getCalcs() {
        return this.calcs;
    }

    @Override
    public ResultStyle getResultStyle() {
        return this.mutable ? ResultStyle.MUTABLE_LIST : ResultStyle.LIST;
    }

    public String toString() {
        return "AbstractTupleListCalc object";
    }

    @Override
    public final List<Member[]> evaluateList(Evaluator evaluator) {
        return this.evaluateTupleList(evaluator);
    }

    public final List<Member> evaluateMemberList(Evaluator evaluator) {
        throw new UnsupportedOperationException();
    }
}

