/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.indent;

import java.awt.Toolkit;
import java.io.IOException;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.modules.editor.indent.FormatterWriterImpl;
import org.netbeans.modules.editor.indent.IndentImpl;
import org.netbeans.modules.editor.indent.TaskHandler;

public final class FormatterImpl
extends ExtFormatter {
    private Formatter defaultFormatter;
    private IndentImpl indentImpl;

    FormatterImpl(Formatter formatter, Document document) {
        super(formatter.getKitClass());
        this.indentImpl = IndentImpl.get(document);
        this.defaultFormatter = formatter;
        this.indentImpl.setDefaultFormatter(formatter);
    }

    public int[] getReformatBlock(JTextComponent jTextComponent, String string) {
        return this.defaultFormatter instanceof ExtFormatter ? ((ExtFormatter)this.defaultFormatter).getReformatBlock(jTextComponent, string) : null;
    }

    public void indentLock() {
        this.indentImpl.indentLock();
    }

    public void indentUnlock() {
        this.indentImpl.indentUnlock();
    }

    public void reformatLock() {
        this.indentImpl.reformatLock();
    }

    public void reformatUnlock() {
        this.indentImpl.reformatUnlock();
    }

    public int getTabSize() {
        return this.defaultFormatter.getTabSize();
    }

    public int getSpacesPerTab() {
        return this.defaultFormatter.getSpacesPerTab();
    }

    public int getShiftWidth() {
        return this.defaultFormatter.getShiftWidth();
    }

    public boolean expandTabs() {
        return this.defaultFormatter.expandTabs();
    }

    public int indentLine(Document document, int n) {
        return this.indentLine(document, n, false);
    }

    public int indentNewLine(Document document, int n) {
        return this.indentLine(document, n, true);
    }

    private int indentLine(Document document, int n, boolean bl) {
        try {
            return this.indentImpl.reindent(n, n, n, bl);
        }
        catch (GuardedException guardedException) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException);
        }
        return n;
    }

    public Writer reformat(BaseDocument baseDocument, int n, int n2, boolean bl) throws BadLocationException, IOException {
        return this.defaultFormatter instanceof ExtFormatter ? ((ExtFormatter)this.defaultFormatter).reformat(baseDocument, n, n2, bl) : null;
    }

    public int reformat(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        if (baseDocument != this.indentImpl.document()) {
            return n2 - n;
        }
        this.indentImpl.reformat(n, n2);
        TaskHandler taskHandler = this.indentImpl.reformatHandler();
        return taskHandler != null && taskHandler.hasItems() ? Math.max(taskHandler.endPos().getOffset() - n, 0) : n2 - n;
    }

    public Writer createWriter(Document document, int n, Writer writer) {
        if (document != this.indentImpl.document()) {
            throw new IllegalStateException("Unexpected document doc=" + document);
        }
        return new FormatterWriterImpl(this.indentImpl, n, writer);
    }
}

