/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

public class OutputDocument
implements Document,
Element,
ChangeListener,
ActionListener,
Runnable {
    private List<DocumentListener> dlisteners = new ArrayList<DocumentListener>();
    private volatile Timer timer = null;
    private OutWriter writer;
    private StringBuffer inBuffer;
    private boolean lastInput;
    private AbstractOutputPane pane;
    private char[] reusableSubrange = new char[256];
    private volatile DO lastEvent = null;
    private int lastPostedLine = -1;
    private int lastPostedLength = -1;
    private int lastFiredLine = -1;
    private int lastFiredlength = -1;
    private boolean updatingTimerState = false;
    private long lastFireTime = 0L;

    OutputDocument(OutWriter outWriter) {
        if (Controller.LOG) {
            Controller.log("Creating a Document for " + outWriter);
        }
        this.writer = outWriter;
        this.getLines().addChangeListener(this);
        this.inBuffer = new StringBuffer();
    }

    public int getOutputLength() {
        return this.getLines().getCharCount();
    }

    public void setPane(AbstractOutputPane abstractOutputPane) {
        this.pane = abstractOutputPane;
    }

    public void dispose() {
        if (Controller.LOG) {
            Controller.log("Disposing document and backing storage for " + this.getLines().readLock());
        }
        this.disposeQuietly();
        this.writer.dispose();
        this.writer = null;
    }

    public void disposeQuietly() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        this.dlisteners.clear();
        this.lastEvent = null;
        this.getLines().removeChangeListener(this);
    }

    public synchronized void addDocumentListener(DocumentListener documentListener) {
        this.dlisteners.add(documentListener);
        this.lastEvent = null;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
    }

    public Position createPosition(int n) throws BadLocationException {
        if (n < 0 || n > this.getLines().getCharCount() + this.inBuffer.length()) {
            throw new BadLocationException("Bad position", n);
        }
        return new ODPosition(n);
    }

    public Element getDefaultRootElement() {
        return this;
    }

    public Position getEndPosition() {
        return new ODEndPosition();
    }

    public int getLength() {
        return this.getLines().getCharCount() + this.inBuffer.length();
    }

    public Object getProperty(Object object) {
        return null;
    }

    public Element[] getRootElements() {
        return new Element[]{this};
    }

    public Position getStartPosition() {
        return new ODStartPosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(int n, int n2) throws BadLocationException {
        String string;
        if (n < 0 || n > this.getLines().getCharCount() + this.inBuffer.length() || n2 < 0) {
            throw new BadLocationException("Bad: " + n + "," + n2, n);
        }
        if (n2 == 0) {
            return "";
        }
        Object object = this.getLines().readLock();
        synchronized (object) {
            int n3 = Math.min(this.getLines().getCharCount(), n);
            int n4 = Math.min(this.getLines().getCharCount(), n + n2);
            string = this.getLines().getText(n3, n4);
            if (n + n2 > this.getLines().getCharCount()) {
                int n5 = n + n2 - this.getLines().getCharCount();
                string = string + this.inBuffer.substring(0, n5);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getText(int n, int n2, Segment segment) throws BadLocationException {
        if (n2 < 0) {
            segment.array = new char[0];
            segment.offset = 0;
            segment.count = 0;
            return;
        }
        if (n < 0) {
            throw new BadLocationException("Negative offset", n);
        }
        if (this.getLines().getLineCount() == 0) {
            segment.array = new char[]{'\n'};
            segment.offset = 0;
            segment.count = 1;
            return;
        }
        if (n2 > this.reusableSubrange.length) {
            this.reusableSubrange = new char[n2];
        }
        try {
            Object object = this.getLines().readLock();
            synchronized (object) {
                int n3 = this.getLines().getCharCount();
                int n4 = Math.min(n3, n);
                int n5 = Math.min(n3, n + n2);
                char[] cArray = this.getLines().getText(n4, n5, this.reusableSubrange);
                if (n + n2 >= n3) {
                    int n6 = n - n3 + n2;
                    int n7 = Math.max(0, n - n3);
                    this.inBuffer.getChars(Math.min(n7, this.inBuffer.length()), Math.min(n6, this.inBuffer.length()), cArray, n5 - n4);
                }
                segment.array = cArray;
                segment.offset = 0;
                segment.count = Math.min(n2, cArray.length);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutWriter.lowDiskSpace = true;
            this.writer.dispose();
            Logger.getAnonymousLogger().log(Level.WARNING, "OOME while reading output.  Cleaning up.", outOfMemoryError);
        }
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        final int n2 = Math.max(n, this.getLength() - this.inBuffer.length());
        final int n3 = string.length();
        this.inBuffer.insert(n2 - (this.getLength() - this.inBuffer.length()), string);
        DocumentEvent documentEvent = new DocumentEvent(){

            public int getOffset() {
                return n2;
            }

            public int getLength() {
                return n3;
            }

            public Document getDocument() {
                return OutputDocument.this;
            }

            public DocumentEvent.EventType getType() {
                return DocumentEvent.EventType.INSERT;
            }

            public DocumentEvent.ElementChange getChange(Element element) {
                return null;
            }
        };
        this.fireDocumentEvent(documentEvent);
    }

    public String sendLine() {
        final int n = this.getLength() - this.inBuffer.length();
        final int n2 = this.inBuffer.length();
        String string = this.inBuffer.toString();
        this.inBuffer = new StringBuffer();
        DocumentEvent documentEvent = new DocumentEvent(){

            public int getOffset() {
                return n;
            }

            public int getLength() {
                return n2;
            }

            public Document getDocument() {
                return OutputDocument.this;
            }

            public DocumentEvent.EventType getType() {
                return DocumentEvent.EventType.REMOVE;
            }

            public DocumentEvent.ElementChange getChange(Element element) {
                return null;
            }
        };
        this.fireDocumentEvent(documentEvent);
        return string;
    }

    public void putProperty(Object object, Object object2) {
    }

    public void remove(int n, int n2) throws BadLocationException {
        int n3;
        int n4 = this.getLength() - this.inBuffer.length();
        final int n5 = Math.max(n4, n);
        if (n5 - n4 + (n3 = Math.min(n2, this.inBuffer.length())) <= this.getLength()) {
            this.inBuffer.delete(n5 - n4, n5 - n4 + n3);
            DocumentEvent documentEvent = new DocumentEvent(){

                public int getOffset() {
                    return n5 - n3;
                }

                public int getLength() {
                    return n3;
                }

                public Document getDocument() {
                    return OutputDocument.this;
                }

                public DocumentEvent.EventType getType() {
                    return DocumentEvent.EventType.REMOVE;
                }

                public DocumentEvent.ElementChange getChange(Element element) {
                    return null;
                }
            };
            this.fireDocumentEvent(documentEvent);
        }
    }

    public synchronized void removeDocumentListener(DocumentListener documentListener) {
        this.dlisteners.remove(documentListener);
        this.lastEvent = null;
        if (this.dlisteners.isEmpty() && this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public Lines getLines() {
        return this.writer != null ? this.writer.getLines() : null;
    }

    public int getLineStart(int n) {
        return this.getLines().getLineCount() > 0 ? this.getLines().getLineStart(n) : 0;
    }

    public int getLineEnd(int n) {
        if (this.getLines().getLineCount() == 0) {
            return 0;
        }
        int n2 = n >= this.getLines().getLineCount() - 1 ? this.getLines().getCharCount() + this.inBuffer.length() : this.getLines().getLineStart(n + 1);
        return n2;
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
    }

    public void render(Runnable runnable) {
        this.getElementCount();
        runnable.run();
    }

    public AttributeSet getAttributes() {
        return SimpleAttributeSet.EMPTY;
    }

    public Document getDocument() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getElement(int n) {
        if (this.getLines().getLineCount() == 0) {
            return new EmptyElement(this);
        }
        Object object = this.getLines().readLock();
        synchronized (object) {
            if (n > this.lastPostedLine) {
                this.lastPostedLine = n;
            }
        }
        return new ODElement(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getElementCount() {
        int n;
        Object object = this.getLines().readLock();
        synchronized (object) {
            this.lastPostedLine = n = this.getLines().getLineCount();
        }
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public int getElementIndex(int n) {
        return this.getLines().getLineAt(n);
    }

    public int getEndOffset() {
        return this.getLength();
    }

    public String getName() {
        return "foo";
    }

    public Element getParentElement() {
        return null;
    }

    public int getStartOffset() {
        return 0;
    }

    public boolean isLeaf() {
        return this.getLines().getLineCount() == 0;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (Controller.VERBOSE) {
            Controller.log(changeEvent != null ? "Document got change event from writer" : "Document timer polling");
        }
        if (this.dlisteners.isEmpty()) {
            if (Controller.VERBOSE) {
                Controller.log("listeners empty, not firing");
            }
            return;
        }
        if (this.getLines().checkDirty(true)) {
            if (this.lastEvent != null && !this.lastEvent.isConsumed()) {
                if (Controller.VERBOSE) {
                    Controller.log("Last event not consumed, not firing");
                }
                return;
            }
            boolean bl = this.lastPostedLine == -1;
            int n = this.getLines().getLineCount();
            int n2 = this.getLines().getCharCount() + this.inBuffer.length();
            this.lastPostedLine = n;
            this.lastPostedLength = n2;
            if (Controller.VERBOSE) {
                Controller.log("Document may fire event - last fired getLine=" + this.lastFiredLine + " getLine count now " + n);
            }
            if (this.lastFiredLine != this.lastPostedLine || this.lastPostedLength != this.lastFiredlength || bl) {
                this.lastEvent = new DO(Math.max(0, this.lastFiredLine == this.lastPostedLine ? this.lastFiredLine - 1 : this.lastFiredLine), bl);
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        if (Controller.VERBOSE) {
                            Controller.log("Firing document event on EQ with start index " + OutputDocument.this.lastEvent.start);
                        }
                        OutputDocument.this.fireDocumentEvent(OutputDocument.this.lastEvent);
                    }
                });
                this.lastFiredLine = this.lastPostedLine;
                this.lastFiredlength = this.lastPostedLength;
            } else if (Controller.VERBOSE) {
                Controller.log("Line count is still " + n + " - not firing");
            }
        } else if (Controller.VERBOSE) {
            Controller.log("Writer says it is not dirty, firing no change");
        }
        this.updateTimerState();
    }

    private synchronized void updateTimerState() {
        if (this.updatingTimerState) {
            return;
        }
        this.updatingTimerState = true;
        long l = System.currentTimeMillis();
        if (this.timer == null && this.getLines().isGrowing()) {
            if (Controller.LOG) {
                Controller.log("Starting timer");
            }
            this.timer = new Timer(50, this);
            this.timer.setRepeats(true);
            this.timer.start();
        } else if (!this.getLines().isGrowing()) {
            if (this.timer != null) {
                this.timer.stop();
            }
            if (this.getLines().checkDirty(false) && this.timer != null) {
                Mutex.EVENT.readAccess((Runnable)this);
            }
            this.timer = null;
        } else if (this.lastFireTime != 0L && this.timer != null && l - this.lastFireTime > 15000L) {
            this.timer.setDelay(10000);
        }
        if (this.timer != null && this.timer.getDelay() < 350) {
            this.timer.setDelay(this.timer.getDelay() + 20);
            if (Controller.VERBOSE) {
                Controller.log("Decreased timer interval to " + this.timer.getDelay());
            }
        }
        this.lastFireTime = l;
        this.updatingTimerState = false;
    }

    public void run() {
        this.stateChanged(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.getLines().isGrowing()) {
            this.updateTimerState();
        }
        this.stateChanged(null);
    }

    private void fireDocumentEvent(DocumentEvent documentEvent) {
        for (DocumentListener documentListener : new ArrayList<DocumentListener>(this.dlisteners)) {
            if (!(documentEvent instanceof DO) && this.pane != null) {
                this.pane.doUpdateCaret();
            }
            if (documentEvent.getType() == DocumentEvent.EventType.REMOVE) {
                documentListener.removeUpdate(documentEvent);
            } else if (documentEvent.getType() == DocumentEvent.EventType.CHANGE) {
                documentListener.changedUpdate(documentEvent);
            } else {
                documentListener.insertUpdate(documentEvent);
            }
            if (documentEvent instanceof DO || this.pane == null) continue;
            this.pane.dontUpdateCaret();
        }
    }

    public String toString() {
        return "OD@" + System.identityHashCode(this) + " for " + this.getLines().readLock();
    }

    public class DO
    implements DocumentEvent,
    DocumentEvent.ElementChange {
        private int start;
        private int offset = -1;
        private int length = -1;
        private int lineCount = -1;
        private boolean consumed = false;
        private boolean initial = false;
        private int first = -1;

        DO(int n, boolean bl) {
            this.start = n;
            this.initial = bl;
            if (n < 0) {
                throw new IllegalArgumentException("Illogical start: " + n);
            }
        }

        private void calc() {
            assert (SwingUtilities.isEventDispatchThread()) : "Should be accessed from AWT only or we have a synchronization problem";
            if (!this.consumed) {
                this.consumed = true;
                if (Controller.VERBOSE) {
                    Controller.log("EVENT CONSUMED: " + this.start);
                }
                int n = OutputDocument.this.getLines().getCharCount() + OutputDocument.this.inBuffer.length();
                if (this.initial) {
                    this.first = 0;
                    this.offset = 0;
                    this.lineCount = OutputDocument.this.getLines().getLineCount();
                    this.length = n;
                } else {
                    this.first = this.start;
                    this.offset = OutputDocument.this.getLines().getLineStart(this.first);
                    this.lineCount = OutputDocument.this.getLines().getLineCount() - this.first;
                    this.length = n - this.offset;
                }
            }
        }

        public boolean isConsumed() {
            return this.consumed;
        }

        public String toString() {
            boolean bl = this.isConsumed();
            this.calc();
            return "Event: start=" + this.start + " first=" + this.first + " linecount=" + this.lineCount + " offset=" + this.offset + " length=" + this.length + " consumed=" + bl;
        }

        public DocumentEvent.ElementChange getChange(Element element) {
            if (element == OutputDocument.this) {
                return this;
            }
            return null;
        }

        public Document getDocument() {
            return OutputDocument.this;
        }

        public int getLength() {
            this.calc();
            return this.length;
        }

        public int getOffset() {
            this.calc();
            return this.offset;
        }

        public DocumentEvent.EventType getType() {
            return this.start == 0 ? DocumentEvent.EventType.CHANGE : DocumentEvent.EventType.INSERT;
        }

        public Element[] getChildrenAdded() {
            this.calc();
            Element[] elementArray = new Element[this.lineCount];
            if (elementArray.length == 0) {
                return new Element[]{new EmptyElement(OutputDocument.this)};
            }
            for (int i = 0; i < this.lineCount; ++i) {
                elementArray[i] = new ODElement(this.first + i);
                if (this.first + i < OutputDocument.this.getLines().getLineCount()) continue;
                throw new IllegalStateException("UGH!!!");
            }
            return elementArray;
        }

        public Element[] getChildrenRemoved() {
            if (this.start == 0) {
                return new Element[]{new EmptyElement(OutputDocument.this)};
            }
            return new Element[0];
        }

        public Element getElement() {
            return OutputDocument.this;
        }

        public int getIndex() {
            this.calc();
            return this.start;
        }
    }

    private static class EmptyElement
    implements Element {
        private final OutputDocument doc;

        EmptyElement(OutputDocument outputDocument) {
            this.doc = outputDocument;
        }

        public AttributeSet getAttributes() {
            return SimpleAttributeSet.EMPTY;
        }

        public Document getDocument() {
            return this.doc;
        }

        public Element getElement(int n) {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public int getElementIndex(int n) {
            return 0;
        }

        public int getEndOffset() {
            return 0;
        }

        public String getName() {
            return "empty";
        }

        public Element getParentElement() {
            return this.doc;
        }

        public int getStartOffset() {
            return 0;
        }

        public boolean isLeaf() {
            return true;
        }
    }

    final class ODElement
    implements Element {
        private int lineIndex;
        private int startOffset = -1;
        private int endOffset = -1;

        ODElement(int n) {
            this.lineIndex = n;
        }

        public int hashCode() {
            return this.lineIndex;
        }

        public boolean equals(Object object) {
            return object instanceof ODElement && ((ODElement)object).lineIndex == this.lineIndex && ((ODElement)object).getDocument() == this.getDocument();
        }

        public AttributeSet getAttributes() {
            return SimpleAttributeSet.EMPTY;
        }

        public Document getDocument() {
            return OutputDocument.this;
        }

        public Element getElement(int n) {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public int getElementIndex(int n) {
            return -1;
        }

        public int getEndOffset() {
            this.calc();
            return this.endOffset;
        }

        public String getName() {
            return null;
        }

        public Element getParentElement() {
            return OutputDocument.this;
        }

        public int getStartOffset() {
            this.calc();
            return this.startOffset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void calc() {
            Object object = OutputDocument.this.getLines().readLock();
            synchronized (object) {
                if (this.startOffset == -1) {
                    this.startOffset = OutputDocument.this.getLines().getLineCount() > 0 ? OutputDocument.this.getLines().getLineStart(this.lineIndex) : 0;
                    this.endOffset = this.lineIndex >= OutputDocument.this.getLines().getLineCount() - 1 ? OutputDocument.this.getLines().getCharCount() + OutputDocument.this.inBuffer.length() : OutputDocument.this.getLines().getLineStart(this.lineIndex + 1);
                    assert (this.endOffset >= this.getStartOffset()) : "Illogical getLine #" + this.lineIndex + " with lines " + OutputDocument.this.getLines() + " or writer has been reset";
                } else if (this.lineIndex >= OutputDocument.this.getLines().getLineCount() - 1) {
                    this.endOffset = OutputDocument.this.getLines().getCharCount() + OutputDocument.this.inBuffer.length();
                }
            }
        }

        public boolean isLeaf() {
            return true;
        }

        public String toString() {
            try {
                return OutputDocument.this.getText(this.getStartOffset(), this.getEndOffset() - this.getStartOffset());
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                return "";
            }
        }
    }

    final class ODStartPosition
    implements Position {
        ODStartPosition() {
        }

        public int getOffset() {
            return 0;
        }

        private Document doc() {
            return OutputDocument.this;
        }

        public boolean equals(Object object) {
            return object instanceof ODStartPosition && ((ODStartPosition)object).doc() == this.doc();
        }

        public int hashCode() {
            return 2190481;
        }
    }

    final class ODEndPosition
    implements Position {
        ODEndPosition() {
        }

        public int getOffset() {
            return OutputDocument.this.getLines().getCharCount() + OutputDocument.this.inBuffer.length();
        }

        private Document doc() {
            return OutputDocument.this;
        }

        public boolean equals(Object object) {
            return object instanceof ODEndPosition && ((ODEndPosition)object).doc() == this.doc();
        }

        public int hashCode() {
            return -2390481;
        }
    }

    static final class ODPosition
    implements Position {
        private int offset;

        ODPosition(int n) {
            this.offset = n;
        }

        public int getOffset() {
            return this.offset;
        }

        public int hashCode() {
            return this.offset * 11;
        }

        public boolean equals(Object object) {
            return object instanceof ODPosition && ((ODPosition)object).getOffset() == this.offset;
        }
    }
}

