/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.nodes;

import com.jaspersoft.ireport.jasperserver.RepositoryFile;
import com.jaspersoft.ireport.jasperserver.RepositoryFolder;
import com.jaspersoft.ireport.jasperserver.RepositoryReportUnit;
import com.jaspersoft.ireport.jasperserver.ui.nodes.FileNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.InputControlsChildren;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ReportUnitInputControlsNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ReportUnitNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ReportUnitResourcesNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ResourcesChildren;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;

public class ReportUnitChildren
extends Index.KeysChildren
implements PropertyChangeListener {
    private RepositoryReportUnit reportUnit = null;
    private Lookup doLkp = null;
    private ReportUnitInputControlsNode controlsNode = null;
    private ReportUnitResourcesNode resourcesNode = null;

    public ReportUnitChildren(RepositoryReportUnit reportUnit, Lookup doLkp) {
        super(new ArrayList());
        this.reportUnit = reportUnit;
        this.doLkp = doLkp;
        this.controlsNode = new ReportUnitInputControlsNode(this.getReportUnit(), doLkp);
        this.resourcesNode = new ReportUnitResourcesNode(this.getReportUnit(), doLkp);
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof RepositoryFile) {
            return new Node[]{new FileNode((RepositoryFile)key, this.doLkp)};
        }
        if (key instanceof Node) {
            return new Node[]{(Node)key};
        }
        return new Node[0];
    }

    protected void addNotify() {
        super.addNotify();
        this.recalculateKeys();
    }

    public void recalculateKeys() {
        this.recalculateKeys(false);
    }

    public void recalculateKeys(final boolean reload) {
        final List l = (List)this.lock();
        l.clear();
        Runnable run = new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((ReportUnitNode)ReportUnitChildren.this.getNode()).setLoading(true);
                    }
                });
                List children = ReportUnitChildren.this.getReportUnit().getChildren(reload);
                boolean mainReportFound = false;
                for (int i = 0; i < children.size(); ++i) {
                    RepositoryFolder item = (RepositoryFolder)children.get(i);
                    if (item.isDataSource() || !item.getDescriptor().isMainReport()) continue;
                    if (!mainReportFound) {
                        l.add(item);
                    }
                    mainReportFound = true;
                }
                l.add(ReportUnitChildren.this.controlsNode);
                l.add(ReportUnitChildren.this.resourcesNode);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ReportUnitChildren.this.update();
                        ((InputControlsChildren)ReportUnitChildren.this.controlsNode.getChildren()).recalculateKeys();
                        ((ResourcesChildren)ReportUnitChildren.this.resourcesNode.getChildren()).recalculateKeys();
                        ((ReportUnitNode)ReportUnitChildren.this.getNode()).setLoading(false);
                    }
                });
            }
        };
        Thread t = new Thread(run);
        t.start();
    }

    public void reorder() {
        Mutex.Action action = new Mutex.Action(){

            public Object run() {
                Index.Support.showIndexedCustomizer((Index)ReportUnitChildren.this.getIndex());
                return null;
            }
        };
        MUTEX.writeAccess(action);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public RepositoryReportUnit getReportUnit() {
        return this.reportUnit;
    }

    public void setReportUnit(RepositoryReportUnit reportUnit) {
        this.reportUnit = reportUnit;
    }
}

