/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.aggmatcher.AggGen;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.test.FoodMartTestCase;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;

public class AggGenTest
extends FoodMartTestCase {
    public AggGenTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCallingLoadColumnsInAddCollapsedColumnOrAddzSpecialCollapsedColumn() throws Exception {
        Logger logger = Logger.getLogger(AggGen.class);
        StringWriter writer = new StringWriter();
        WriterAppender myAppender = new WriterAppender((Layout)new SimpleLayout(), (Writer)writer);
        logger.addAppender((Appender)myAppender);
        logger.setLevel(Level.DEBUG);
        String trueValue = "true";
        MondrianProperties props = MondrianProperties.instance();
        props.AggregateRules.setString("DefaultRules.xml");
        props.UseAggregates.setString("true");
        props.ReadAggregates.setString("true");
        props.GenerateAggregateSql.setString("true");
        RolapConnection rolapConn = (RolapConnection)this.getConnection();
        Query query = rolapConn.parseQuery("select {[Measures].[Count]} on columns from [HR]");
        rolapConn.execute(query);
        logger.removeAppender((Appender)myAppender);
        DataSource dataSource = rolapConn.getDataSource();
        Connection sqlConnection = null;
        try {
            sqlConnection = dataSource.getConnection();
            DatabaseMetaData dbmeta = sqlConnection.getMetaData();
            JdbcSchema jdbcSchema = JdbcSchema.makeDB(dataSource);
            String catalogName = jdbcSchema.getCatalogName();
            String schemaName = jdbcSchema.getSchemaName();
            String log = writer.toString();
            Pattern p = Pattern.compile("DEBUG - Init: Column: [^:]+: `(\\w+)`.`(\\w+)`" + Util.nl + "WARN - Can not find column: \\2");
            Matcher m = p.matcher(log);
            while (m.find()) {
                ResultSet rs = dbmeta.getColumns(catalogName, schemaName, m.group(1), m.group(2));
                AggGenTest.assertTrue((!rs.next() ? 1 : 0) != 0);
            }
        }
        finally {
            if (sqlConnection != null) {
                try {
                    sqlConnection.close();
                }
                catch (SQLException e) {}
            }
        }
    }
}

